/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.mediaengine;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.mediaengine.MEProcessor;

public class METhread
extends Thread {
    private static METhread instance;
    private volatile boolean exit;
    private MEProcessor processor;
    private final Semaphore sync = new Semaphore(0);

    public static METhread getInstance() {
        if (instance == null) {
            instance = new METhread();
        }
        return instance;
    }

    public static boolean isMediaEngine(Thread thread) {
        return thread == instance;
    }

    public static void exit() {
        if (instance != null) {
            METhread.instance.exit = true;
            instance.sync();
        }
    }

    private METhread() {
        this.setName("Media Engine Thread");
        this.setDaemon(true);
        this.start();
    }

    public void setProcessor(MEProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void run() {
        RuntimeContext.setLog4jMDC();
        while (!this.exit) {
            if (!this.waitForSync(100)) continue;
            this.processor.run();
        }
    }

    private boolean waitForSync(int millis) {
        while (true) {
            try {
                int availablePermits = this.sync.drainPermits();
                if (availablePermits <= 0 && !this.sync.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                this.processor.getLogger().debug((Object)String.format("METhread.waitForSync %s", e));
                continue;
            }
            break;
        }
        return true;
    }

    public void sync() {
        if (this.sync != null) {
            this.sync.release();
        }
    }
}

