/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.aac;

import java.util.Arrays;
import jpcsp.media.codec.aac.AacDecoder;
import jpcsp.media.codec.aac.AacPs;
import jpcsp.media.codec.aac.AacSbrData;
import jpcsp.media.codec.aac.Context;
import jpcsp.media.codec.aac.SBRDSP;
import jpcsp.media.codec.aac.SBRData;
import jpcsp.media.codec.aac.SpectralBandReplication;
import jpcsp.media.codec.aac.SpectrumParameters;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.FFT;
import jpcsp.media.codec.util.FloatDSP;
import jpcsp.media.codec.util.IBitReader;
import jpcsp.media.codec.util.VLC;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class AacSbr {
    private static Logger log = AacDecoder.log;
    private static final int ENVELOPE_ADJUSTMENT_OFFSET = 2;
    private static final float NOISE_FLOOR_OFFSET = 6.0f;
    private static final int EXTENSION_ID_PS = 2;
    private static final int T_HUFFMAN_ENV_1_5DB = 0;
    private static final int F_HUFFMAN_ENV_1_5DB = 1;
    private static final int T_HUFFMAN_ENV_BAL_1_5DB = 2;
    private static final int F_HUFFMAN_ENV_BAL_1_5DB = 3;
    private static final int T_HUFFMAN_ENV_3_0DB = 4;
    private static final int F_HUFFMAN_ENV_3_0DB = 5;
    private static final int T_HUFFMAN_ENV_BAL_3_0DB = 6;
    private static final int F_HUFFMAN_ENV_BAL_3_0DB = 7;
    private static final int T_HUFFMAN_NOISE_3_0DB = 8;
    private static final int T_HUFFMAN_NOISE_BAL_3_0DB = 9;
    private static final VLC[] vlc_sbr = new VLC[10];
    private static final int[] vlc_sbr_lav = new int[]{60, 60, 24, 24, 31, 31, 12, 12, 31, 12};
    private static final int[] ceil_log2 = new int[]{0, 1, 2, 2, 3, 3};
    private static final int FIXFIX = 0;
    private static final int FIXVAR = 1;
    private static final int VARFIX = 2;
    private static final int VARVAR = 3;
    static final float[] bands_warped = new float[]{1.3271518f, 1.1850928f, 1.1198716f};
    private static final float[] bw_tab = new float[]{0.0f, 0.75f, 0.9f, 0.98f};
    private static final float[] limgain = new float[]{0.70795f, 1.0f, 1.41254f, 1.0E10f};
    private static final float[] h_smooth = new float[]{0.33333334f, 0.30150282f, 0.2181695f, 0.11516383f, 0.0318305f};

    public static void sbrInit() {
        for (int i = 0; i < vlc_sbr.length; ++i) {
            AacSbr.vlc_sbr[i] = new VLC();
        }
        vlc_sbr[0].initVLCSparse(9, AacSbrData.t_huffman_env_1_5dB_codes.length, AacSbrData.t_huffman_env_1_5dB_bits, AacSbrData.t_huffman_env_1_5dB_codes, null);
        vlc_sbr[1].initVLCSparse(9, AacSbrData.f_huffman_env_1_5dB_codes.length, AacSbrData.f_huffman_env_1_5dB_bits, AacSbrData.f_huffman_env_1_5dB_codes, null);
        vlc_sbr[2].initVLCSparse(9, AacSbrData.t_huffman_env_bal_1_5dB_codes.length, AacSbrData.t_huffman_env_bal_1_5dB_bits, AacSbrData.t_huffman_env_bal_1_5dB_codes, null);
        vlc_sbr[3].initVLCSparse(9, AacSbrData.f_huffman_env_bal_1_5dB_codes.length, AacSbrData.f_huffman_env_bal_1_5dB_bits, AacSbrData.f_huffman_env_bal_1_5dB_codes, null);
        vlc_sbr[4].initVLCSparse(9, AacSbrData.t_huffman_env_3_0dB_codes.length, AacSbrData.t_huffman_env_3_0dB_bits, AacSbrData.t_huffman_env_3_0dB_codes, null);
        vlc_sbr[5].initVLCSparse(9, AacSbrData.f_huffman_env_3_0dB_codes.length, AacSbrData.f_huffman_env_3_0dB_bits, AacSbrData.f_huffman_env_3_0dB_codes, null);
        vlc_sbr[6].initVLCSparse(9, AacSbrData.t_huffman_env_bal_3_0dB_codes.length, AacSbrData.t_huffman_env_bal_3_0dB_bits, AacSbrData.t_huffman_env_bal_3_0dB_codes, null);
        vlc_sbr[7].initVLCSparse(9, AacSbrData.f_huffman_env_bal_3_0dB_codes.length, AacSbrData.f_huffman_env_bal_3_0dB_bits, AacSbrData.f_huffman_env_bal_3_0dB_codes, null);
        vlc_sbr[8].initVLCSparse(9, AacSbrData.t_huffman_noise_3_0dB_codes.length, AacSbrData.t_huffman_noise_3_0dB_bits, AacSbrData.t_huffman_noise_3_0dB_codes, null);
        vlc_sbr[9].initVLCSparse(9, AacSbrData.t_huffman_noise_bal_3_0dB_codes.length, AacSbrData.t_huffman_noise_bal_3_0dB_bits, AacSbrData.t_huffman_noise_bal_3_0dB_codes, null);
    }

    private static void getBits1Vector(IBitReader br, int[] vec, int vecOffset, int elements) {
        for (int i = 0; i < elements; ++i) {
            vec[vecOffset + i] = br.read1();
        }
    }

    private static int readSbrGrid(Context ac, SpectralBandReplication sbr, SBRData chData) {
        int i;
        BitReader br = ac.br;
        int bsPointer = 0;
        int absBordTrail = 16;
        int bsNumEnvOld = chData.bsNumEnv;
        chData.bsFreqRes[0] = chData.bsFreqRes[chData.bsNumEnv];
        chData.bsAmpRes = sbr.bsAmpResHeader;
        chData.tEnvNumEnvOld = chData.tEnv[bsNumEnvOld];
        chData.bsFrameClass = br.read(2);
        switch (chData.bsFrameClass) {
            case 0: {
                chData.bsNumEnv = 1 << br.read(2);
                int numRelLead = chData.bsNumEnv - 1;
                if (chData.bsNumEnv == 1) {
                    chData.bsAmpRes = false;
                }
                if (chData.bsNumEnv > 4) {
                    log.error((Object)String.format("Invalid bitstream, too many SBR envelopes in FIXFIX type SBR frame: %d", chData.bsNumEnv));
                    return -1;
                }
                chData.tEnv[0] = 0;
                chData.tEnv[chData.bsNumEnv] = absBordTrail;
                absBordTrail = (absBordTrail + (chData.bsNumEnv >> 1)) / chData.bsNumEnv;
                for (i = 0; i < numRelLead; ++i) {
                    chData.tEnv[i + 1] = chData.tEnv[i] + absBordTrail;
                }
                chData.bsFreqRes[1] = br.read1();
                for (i = 1; i < chData.bsNumEnv; ++i) {
                    chData.bsFreqRes[i + 1] = chData.bsFreqRes[1];
                }
                break;
            }
            case 1: {
                int numRelTrail = br.read(2);
                chData.bsNumEnv = numRelTrail + 1;
                chData.tEnv[0] = 0;
                chData.tEnv[chData.bsNumEnv] = absBordTrail += br.read(2);
                for (i = 0; i < numRelTrail; ++i) {
                    chData.tEnv[chData.bsNumEnv - 1 - i] = chData.tEnv[chData.bsNumEnv - i] - 2 * br.read(2) - 2;
                }
                bsPointer = br.read(ceil_log2[chData.bsNumEnv]);
                for (i = 0; i < chData.bsNumEnv; ++i) {
                    chData.bsFreqRes[chData.bsNumEnv - i] = br.read1();
                }
                break;
            }
            case 2: {
                chData.tEnv[0] = br.read(2);
                int numRelLead = br.read(2);
                chData.bsNumEnv = numRelLead + 1;
                chData.tEnv[chData.bsNumEnv] = absBordTrail;
                for (i = 0; i < numRelLead; ++i) {
                    chData.tEnv[i + 1] = chData.tEnv[i] + 2 * br.read(2) + 2;
                }
                bsPointer = br.read(ceil_log2[chData.bsNumEnv]);
                AacSbr.getBits1Vector(br, chData.bsFreqRes, 1, chData.bsNumEnv);
                break;
            }
            case 3: {
                chData.tEnv[0] = br.read(2);
                absBordTrail += br.read(2);
                int numRelLead = br.read(2);
                int numRelTrail = br.read(2);
                chData.bsNumEnv = numRelLead + numRelTrail + 1;
                if (chData.bsNumEnv > 5) {
                    log.error((Object)String.format("Invalid bitstream, too many SBR envelopes in VARVAR type SBR frame: %d", chData.bsNumEnv));
                    return -1;
                }
                chData.tEnv[chData.bsNumEnv] = absBordTrail;
                for (i = 0; i < numRelLead; ++i) {
                    chData.tEnv[i + 1] = chData.tEnv[i] + 2 * br.read(2) + 2;
                }
                for (i = 0; i < numRelTrail; ++i) {
                    chData.tEnv[chData.bsNumEnv - 1 - i] = chData.tEnv[chData.bsNumEnv - i] - 2 * br.read(2) - 2;
                }
                bsPointer = br.read(ceil_log2[chData.bsNumEnv]);
                AacSbr.getBits1Vector(br, chData.bsFreqRes, 1, chData.bsNumEnv);
            }
        }
        if (bsPointer > chData.bsNumEnv + 1) {
            log.error((Object)String.format("Invalid bitstream, bs_pointer points to a middle noise border outside the time borders table: %d", bsPointer));
            return -1;
        }
        for (i = 1; i <= chData.bsNumEnv; ++i) {
            if (chData.tEnv[i - 1] <= chData.tEnv[i]) continue;
            log.error((Object)String.format("Non monotone time borders", new Object[0]));
            return -1;
        }
        chData.bsNumNoise = (chData.bsNumEnv > 1 ? 1 : 0) + 1;
        chData.tQ[0] = chData.tEnv[0];
        chData.tQ[chData.bsNumNoise] = chData.tEnv[chData.bsNumEnv];
        if (chData.bsNumNoise > 1) {
            int idx = chData.bsFrameClass == 0 ? chData.bsNumEnv >> 1 : ((chData.bsFrameClass & 1) != 0 ? chData.bsNumEnv - Math.max(bsPointer - 1, 1) : (bsPointer == 0 ? 1 : (bsPointer == 1 ? chData.bsNumEnv - 1 : bsPointer - 1)));
            chData.tQ[1] = chData.tEnv[idx];
        }
        chData.eA[0] = -(chData.eA[1] != bsNumEnvOld ? 1 : 0);
        chData.eA[1] = -1;
        if ((chData.bsFrameClass & 1) != 0 && bsPointer != 0) {
            chData.eA[1] = chData.bsNumEnv + 1 - bsPointer;
        } else if (chData.bsFrameClass == 2 && bsPointer > 1) {
            chData.eA[1] = bsPointer - 1;
        }
        return 0;
    }

    private static void readSbrDtdf(SpectralBandReplication sbr, IBitReader br, SBRData chData) {
        AacSbr.getBits1Vector(br, chData.bsDfEnv, 0, chData.bsNumEnv);
        AacSbr.getBits1Vector(br, chData.bsDfNoise, 0, chData.bsNumNoise);
    }

    private static void readSbrInvf(SpectralBandReplication sbr, IBitReader br, SBRData chData) {
        System.arraycopy(chData.bsInvfMode[0], 0, chData.bsInvfMode[1], 0, 5);
        for (int i = 0; i < sbr.nQ; ++i) {
            chData.bsInvfMode[0][i] = br.read(2);
        }
    }

    private static void readSbrEnvelope(SpectralBandReplication sbr, IBitReader br, SBRData chData, boolean ch) {
        int fLav;
        VLC fHuff;
        int tLav;
        VLC tHuff;
        int bits;
        int delta = (ch && sbr.bsCoupling ? 1 : 0) + 1;
        int odd = sbr.n[1] & 1;
        if (sbr.bsCoupling && ch) {
            if (chData.bsAmpRes) {
                bits = 5;
                tHuff = vlc_sbr[6];
                tLav = vlc_sbr_lav[6];
                fHuff = vlc_sbr[7];
                fLav = vlc_sbr_lav[7];
            } else {
                bits = 6;
                tHuff = vlc_sbr[2];
                tLav = vlc_sbr_lav[2];
                fHuff = vlc_sbr[3];
                fLav = vlc_sbr_lav[3];
            }
        } else if (chData.bsAmpRes) {
            bits = 6;
            tHuff = vlc_sbr[4];
            tLav = vlc_sbr_lav[4];
            fHuff = vlc_sbr[5];
            fLav = vlc_sbr_lav[5];
        } else {
            bits = 7;
            tHuff = vlc_sbr[0];
            tLav = vlc_sbr_lav[0];
            fHuff = vlc_sbr[1];
            fLav = vlc_sbr_lav[1];
        }
        for (int i = 0; i < chData.bsNumEnv; ++i) {
            int j;
            if (chData.bsDfEnv[i] != 0) {
                int k;
                if (chData.bsFreqRes[i + 1] == chData.bsFreqRes[i]) {
                    for (j = 0; j < sbr.n[chData.bsFreqRes[i + 1]]; ++j) {
                        chData.envFacs[i + 1][j] = chData.envFacs[i][j] + (float)(delta * (tHuff.getVLC2(br, 3) - tLav));
                    }
                    continue;
                }
                if (chData.bsFreqRes[i + 1] != 0) {
                    for (j = 0; j < sbr.n[chData.bsFreqRes[i + 1]]; ++j) {
                        k = j + odd >> 1;
                        chData.envFacs[i + 1][j] = chData.envFacs[i][k] + (float)(delta * (tHuff.getVLC2(br, 3) - tLav));
                    }
                    continue;
                }
                for (j = 0; j < sbr.n[chData.bsFreqRes[i + 1]]; ++j) {
                    k = j != 0 ? 2 * j - odd : 0;
                    chData.envFacs[i + 1][j] = chData.envFacs[i][k] + (float)(delta * (tHuff.getVLC2(br, 3) - tLav));
                }
                continue;
            }
            chData.envFacs[i + 1][0] = delta * br.read(bits);
            for (j = 1; j < sbr.n[chData.bsFreqRes[i + 1]]; ++j) {
                chData.envFacs[i + 1][j] = chData.envFacs[i + 1][j - 1] + (float)(delta * (fHuff.getVLC2(br, 3) - fLav));
            }
        }
        System.arraycopy(chData.envFacs[chData.bsNumEnv], 0, chData.envFacs[0], 0, chData.envFacs[0].length);
    }

    private static void readSbrNoise(SpectralBandReplication sbr, IBitReader br, SBRData chData, boolean ch) {
        int f_lav;
        VLC f_huff;
        int t_lav;
        VLC t_huff;
        int delta = (ch && sbr.bsCoupling ? 1 : 0) + 1;
        if (sbr.bsCoupling) {
            t_huff = vlc_sbr[9];
            t_lav = vlc_sbr_lav[9];
            f_huff = vlc_sbr[7];
            f_lav = vlc_sbr_lav[7];
        } else {
            t_huff = vlc_sbr[8];
            t_lav = vlc_sbr_lav[8];
            f_huff = vlc_sbr[5];
            f_lav = vlc_sbr_lav[5];
        }
        for (int i = 0; i < chData.bsNumNoise; ++i) {
            int j;
            if (chData.bsDfNoise[i] != 0) {
                for (j = 0; j < sbr.nQ; ++j) {
                    chData.noiseFacs[i + 1][j] = chData.noiseFacs[i][j] + (float)(delta * (t_huff.getVLC2(br, 2) - t_lav));
                }
                continue;
            }
            chData.noiseFacs[i + 1][0] = delta * br.read(5);
            for (j = 1; j < sbr.nQ; ++j) {
                chData.noiseFacs[i + 1][j] = chData.noiseFacs[i + 1][j - 1] + (float)(delta * (f_huff.getVLC2(br, 3) - f_lav));
            }
        }
        System.arraycopy(chData.noiseFacs[chData.bsNumNoise], 0, chData.noiseFacs[0], 0, chData.noiseFacs[0].length);
    }

    private static int readSbrSingleChannelElement(Context ac, SpectralBandReplication sbr) {
        if (ac.br.readBool()) {
            ac.br.skip(4);
        }
        if (AacSbr.readSbrGrid(ac, sbr, sbr.data[0]) != 0) {
            return -1;
        }
        AacSbr.readSbrDtdf(sbr, ac.br, sbr.data[0]);
        AacSbr.readSbrInvf(sbr, ac.br, sbr.data[0]);
        AacSbr.readSbrEnvelope(sbr, ac.br, sbr.data[0], false);
        AacSbr.readSbrNoise(sbr, ac.br, sbr.data[0], false);
        sbr.data[0].bsAddHarmonicFlag = ac.br.readBool();
        if (sbr.data[0].bsAddHarmonicFlag) {
            AacSbr.getBits1Vector(ac.br, sbr.data[0].bsAddHarmonic, 0, sbr.n[1]);
        }
        return 0;
    }

    private static int readSbrExtension(Context ac, SpectralBandReplication sbr, int bsExtensionId, int numBitsLeft) {
        switch (bsExtensionId) {
            case 2: {
                if (ac.oc[1].m4ac.ps == 0) {
                    log.error((Object)String.format("Parametric Stereo signaled to be not-present but was found in the bitstream", new Object[0]));
                    ac.br.skip(numBitsLeft);
                    numBitsLeft = 0;
                    break;
                }
                numBitsLeft -= AacPs.readData(ac, sbr.ps, numBitsLeft);
                break;
            }
            default: {
                if (bsExtensionId != 0 || numBitsLeft > 16 || ac.br.peek(numBitsLeft) != 0) {
                    log.error((Object)String.format("Reserved SBR extensions", new Object[0]));
                }
                ac.br.skip(numBitsLeft);
                numBitsLeft = 0;
            }
        }
        return numBitsLeft;
    }

    private static int readSbrData(Context ac, SpectralBandReplication sbr, int idAac) {
        int cnt = ac.br.getBitsRead();
        if (idAac == 0 || idAac == 2) {
            if (AacSbr.readSbrSingleChannelElement(ac, sbr) != 0) {
                AacSbr.sbrTurnoff(sbr);
                return ac.br.getBitsRead() - cnt;
            }
        } else {
            log.error((Object)String.format("Invalid bitstream - cannot apply SBR to element type %d", idAac));
            AacSbr.sbrTurnoff(sbr);
            return ac.br.getBitsRead() - cnt;
        }
        if (ac.br.readBool()) {
            int numBitsLeft = ac.br.read(4);
            if (numBitsLeft == 15) {
                numBitsLeft += ac.br.read(8);
            }
            numBitsLeft <<= 3;
            while (numBitsLeft > 7) {
                numBitsLeft -= 2;
                numBitsLeft = AacSbr.readSbrExtension(ac, sbr, ac.br.read(2), numBitsLeft);
            }
            if (numBitsLeft < 0) {
                log.error((Object)String.format("SBD Extension over read", new Object[0]));
            } else if (numBitsLeft > 0) {
                ac.br.skip(numBitsLeft);
            }
        }
        return ac.br.getBitsRead() - cnt;
    }

    private static void makeBands(int[] bands, int bandsOffset, int start, int stop, int numBands) {
        float base = (float)Math.pow((double)stop / (double)start, 1.0 / (double)numBands);
        float prod = start;
        int previous = start;
        for (int k = 0; k < numBands - 1; ++k) {
            int present = (int)Math.rint(prod *= base);
            bands[bandsOffset + k] = present - previous;
            previous = present;
        }
        bands[bandsOffset + numBands - 1] = stop - previous;
    }

    private static int checkNMaster(int nMaster, int bsXoverBand) {
        if (nMaster <= 0) {
            log.error((Object)String.format("Invalid n_master: %d", nMaster));
            return -1;
        }
        if (bsXoverBand >= nMaster) {
            log.error((Object)String.format("Invalid bitstream, crossover band index beyond array bounds: %d", bsXoverBand));
            return -1;
        }
        return 0;
    }

    private static int arrayMinInt(int[] array, int arrayOffset, int nel) {
        int min = array[arrayOffset];
        for (int i = 1; i < nel; ++i) {
            min = Math.min(array[arrayOffset + i], min);
        }
        return min;
    }

    private static boolean inTableInt(int[] table, int lastEl, int needle) {
        for (int i = 0; i <= lastEl; ++i) {
            if (table[i] != needle) continue;
            return true;
        }
        return false;
    }

    private static int sbrMakeFMaster(Context ac, SpectralBandReplication sbr, SpectrumParameters spectrum) {
        int maxQmfSubbands;
        int[] sbrOffsetPtr;
        int[] stopDk = new int[13];
        int temp = sbr.sampleRate < 32000 ? 3000 : (sbr.sampleRate < 64000 ? 4000 : 5000);
        switch (sbr.sampleRate) {
            case 16000: {
                sbrOffsetPtr = AacSbrData.sbr_offset[0];
                break;
            }
            case 22050: {
                sbrOffsetPtr = AacSbrData.sbr_offset[1];
                break;
            }
            case 24000: {
                sbrOffsetPtr = AacSbrData.sbr_offset[2];
                break;
            }
            case 32000: {
                sbrOffsetPtr = AacSbrData.sbr_offset[3];
                break;
            }
            case 44100: 
            case 48000: 
            case 64000: {
                sbrOffsetPtr = AacSbrData.sbr_offset[4];
                break;
            }
            case 88200: 
            case 96000: 
            case 128000: 
            case 176400: 
            case 192000: {
                sbrOffsetPtr = AacSbrData.sbr_offset[5];
                break;
            }
            default: {
                log.error((Object)String.format("Unsupported sample rate for SBR: %d", sbr.sampleRate));
                return -1;
            }
        }
        int startMin = ((temp << 7) + (sbr.sampleRate >> 1)) / sbr.sampleRate;
        int stopMin = ((temp << 8) + (sbr.sampleRate >> 1)) / sbr.sampleRate;
        sbr.k[0] = startMin + sbrOffsetPtr[spectrum.bsStartFreq];
        if (spectrum.bsStopFreq < 14) {
            sbr.k[2] = stopMin;
            AacSbr.makeBands(stopDk, 0, stopMin, 64, 13);
            Arrays.sort(stopDk);
            for (int k = 0; k < spectrum.bsStopFreq; ++k) {
                sbr.k[2] = sbr.k[2] + stopDk[k];
            }
        } else if (spectrum.bsStopFreq == 14) {
            sbr.k[2] = 2 * sbr.k[0];
        } else if (spectrum.bsStopFreq == 15) {
            sbr.k[2] = 3 * sbr.k[0];
        } else {
            log.error((Object)String.format("Invalid bsStopFreq: %d", spectrum.bsStopFreq));
            return -1;
        }
        sbr.k[2] = Math.min(64, sbr.k[2]);
        if (sbr.sampleRate <= 32000) {
            maxQmfSubbands = 48;
        } else if (sbr.sampleRate == 44100) {
            maxQmfSubbands = 35;
        } else if (sbr.sampleRate >= 48000) {
            maxQmfSubbands = 32;
        } else {
            log.error((Object)String.format("Unsupported sample rate %d", sbr.sampleRate));
            return -1;
        }
        if (sbr.k[2] - sbr.k[0] > maxQmfSubbands) {
            log.error((Object)String.format("Invalid bitstream, too many QMF subbands: %d", sbr.k[2] - sbr.k[0]));
            return -1;
        }
        if (spectrum.bsFreqScale == 0) {
            int k;
            int dk = spectrum.bsAlterScale + 1;
            sbr.nMaster = sbr.k[2] - sbr.k[0] + (dk & 2) >> dk << 1;
            if (AacSbr.checkNMaster(sbr.nMaster, sbr.spectrumParams.bsXoverBand) != 0) {
                return -1;
            }
            for (k = 1; k <= sbr.nMaster; ++k) {
                sbr.fMaster[k] = dk;
            }
            int k2diff = sbr.k[2] - sbr.k[0] - sbr.nMaster * dk;
            if (k2diff < 0) {
                sbr.fMaster[1] = sbr.fMaster[1] - 1;
                sbr.fMaster[2] = sbr.fMaster[2] - (k2diff < -1 ? 1 : 0);
            } else if (k2diff != 0) {
                int n = sbr.nMaster;
                sbr.fMaster[n] = sbr.fMaster[n] + 1;
            }
            sbr.fMaster[0] = sbr.k[0];
            for (k = 1; k <= sbr.nMaster; ++k) {
                int n = k;
                sbr.fMaster[n] = sbr.fMaster[n] + sbr.fMaster[k - 1];
            }
        } else {
            boolean two_regions;
            int half_bands = 7 - spectrum.bsFreqScale;
            int[] vk0 = new int[49];
            if (49 * sbr.k[2] > 110 * sbr.k[0]) {
                two_regions = true;
                sbr.k[1] = 2 * sbr.k[0];
            } else {
                two_regions = false;
                sbr.k[1] = sbr.k[2];
            }
            int num_bands_0 = CodecUtils.lrintf((float)half_bands * CodecUtils.log2f((float)sbr.k[1] / (float)sbr.k[0])) * 2;
            if (num_bands_0 <= 0) {
                log.error((Object)String.format("Invalid num_bands_0: %d", num_bands_0));
                return -1;
            }
            vk0[0] = 0;
            AacSbr.makeBands(vk0, 1, sbr.k[0], sbr.k[1], num_bands_0);
            Arrays.sort(vk0, 1, 1 + num_bands_0);
            int vdk0_max = vk0[num_bands_0];
            vk0[0] = sbr.k[0];
            for (int k = 1; k <= num_bands_0; ++k) {
                if (vk0[k] <= 0) {
                    log.error((Object)String.format("Invalid vDk0[%d]: %d", k, vk0[k]));
                    return -1;
                }
                int n = k;
                vk0[n] = vk0[n] + vk0[k - 1];
            }
            if (two_regions) {
                int[] vk1 = new int[49];
                float invwarp = spectrum.bsAlterScale != 0 ? 0.7692308f : 1.0f;
                int num_bands_1 = CodecUtils.lrintf((float)half_bands * invwarp * CodecUtils.log2f((float)sbr.k[2] / (float)sbr.k[1])) * 2;
                AacSbr.makeBands(vk1, 1, sbr.k[1], sbr.k[2], num_bands_1);
                int vdk1_min = AacSbr.arrayMinInt(vk1, 1, num_bands_1);
                if (vdk1_min < vdk0_max) {
                    Arrays.sort(vk1, 1, 1 + num_bands_1);
                    int change = Math.min(vdk0_max - vk1[1], vk1[num_bands_1] - vk1[1] >> 1);
                    vk1[1] = vk1[1] + change;
                    int n = num_bands_1;
                    vk1[n] = vk1[n] - change;
                }
                Arrays.sort(vk1, 1, 1 + num_bands_1);
                vk1[0] = sbr.k[1];
                for (int k = 1; k <= num_bands_1; ++k) {
                    if (vk1[k] <= 0) {
                        log.error((Object)String.format("Invalid vDk1[%d]: %d", k, vk1[k]));
                        return -1;
                    }
                    int n = k;
                    vk1[n] = vk1[n] + vk1[k - 1];
                }
                sbr.nMaster = num_bands_0 + num_bands_1;
                if (AacSbr.checkNMaster(sbr.nMaster, sbr.spectrumParams.bsXoverBand) != 0) {
                    return -1;
                }
                System.arraycopy(vk0, 0, sbr.fMaster, 0, num_bands_0 + 1);
                System.arraycopy(vk1, 1, sbr.fMaster, num_bands_0 + 1, num_bands_1);
            } else {
                sbr.nMaster = num_bands_0;
                if (AacSbr.checkNMaster(sbr.nMaster, sbr.spectrumParams.bsXoverBand) != 0) {
                    return -1;
                }
                System.arraycopy(vk0, 0, sbr.fMaster, 0, num_bands_0 + 1);
            }
        }
        return 0;
    }

    private static void sbrMakeFTablelim(SpectralBandReplication sbr) {
        if (sbr.bsLimiterBands > 0) {
            float limBandsPerOctaveWarped = bands_warped[sbr.bsLimiterBands - 1];
            int[] patchBorders = new int[7];
            int in = 1;
            int out = 0;
            patchBorders[0] = sbr.kx[1];
            for (int k = 1; k <= sbr.numPatches; ++k) {
                patchBorders[k] = patchBorders[k - 1] + sbr.patchNumSubbands[k - 1];
            }
            System.arraycopy(sbr.fTablelow, 0, sbr.fTablelim, 0, sbr.n[0] + 1);
            if (sbr.numPatches > 1) {
                System.arraycopy(sbr.fTablelim, sbr.n[0] + 1, patchBorders, 1, sbr.numPatches - 1);
            }
            Arrays.sort(sbr.fTablelim, 0, sbr.numPatches + sbr.n[0]);
            sbr.nLim = sbr.n[0] + sbr.numPatches - 1;
            while (out < sbr.nLim) {
                if ((float)sbr.fTablelim[in] >= (float)sbr.fTablelim[out] * limBandsPerOctaveWarped) {
                    sbr.fTablelim[++out] = sbr.fTablelim[in++];
                    continue;
                }
                if (sbr.fTablelim[in] == sbr.fTablelim[out] || !AacSbr.inTableInt(patchBorders, sbr.numPatches, sbr.fTablelim[in])) {
                    ++in;
                    --sbr.nLim;
                    continue;
                }
                if (!AacSbr.inTableInt(patchBorders, sbr.numPatches, sbr.fTablelim[out])) {
                    sbr.fTablelim[out] = sbr.fTablelim[in++];
                    --sbr.nLim;
                    continue;
                }
                sbr.fTablelim[++out] = sbr.fTablelim[in++];
            }
        } else {
            sbr.fTablelim[0] = sbr.fTablelow[0];
            sbr.fTablelim[1] = sbr.fTablelow[sbr.n[0]];
            sbr.nLim = 1;
        }
    }

    private static int sbrHfCalcNpatches(Context ac, SpectralBandReplication sbr) {
        int k;
        int msb = sbr.k[0];
        int usb = sbr.kx[1];
        int goal_sb = (2048000 + (sbr.sampleRate >> 1)) / sbr.sampleRate;
        sbr.numPatches = 0;
        if (goal_sb < sbr.kx[1] + sbr.m[1]) {
            k = 0;
            while (sbr.fMaster[k] < goal_sb) {
                ++k;
            }
        } else {
            k = sbr.nMaster;
        }
        int sb = 0;
        do {
            int odd = 0;
            for (int i = k; i == k || sb > sbr.k[0] - 1 + msb - odd; --i) {
                sb = sbr.fMaster[i];
                odd = sb + sbr.k[0] & 1;
            }
            if (sbr.numPatches > 5) {
                log.error((Object)String.format("Too many patches: %d", sbr.numPatches));
                return -1;
            }
            sbr.patchNumSubbands[sbr.numPatches] = Math.max(sb - usb, 0);
            sbr.patchStartSubband[sbr.numPatches] = sbr.k[0] - odd - sbr.patchNumSubbands[sbr.numPatches];
            if (sbr.patchNumSubbands[sbr.numPatches] > 0) {
                usb = sb;
                msb = sb;
                ++sbr.numPatches;
            } else {
                msb = sbr.kx[1];
            }
            if (sbr.fMaster[k] - sb >= 3) continue;
            k = sbr.nMaster;
        } while (sb != sbr.kx[1] + sbr.m[1]);
        if (sbr.numPatches > 1 && sbr.patchNumSubbands[sbr.numPatches - 1] < 3) {
            --sbr.numPatches;
        }
        return 0;
    }

    private static int sbrMakeFDerived(Context ac, SpectralBandReplication sbr) {
        int k;
        sbr.n[1] = sbr.nMaster - sbr.spectrumParams.bsXoverBand;
        sbr.n[0] = sbr.n[1] + 1 >> 1;
        System.arraycopy(sbr.fMaster, sbr.spectrumParams.bsXoverBand, sbr.fTablehigh, 0, sbr.n[1] + 1);
        sbr.m[1] = sbr.fTablehigh[sbr.n[1]] - sbr.fTablehigh[0];
        sbr.kx[1] = sbr.fTablehigh[0];
        if (sbr.kx[1] + sbr.m[1] > 64) {
            log.error((Object)String.format("Stop frequency border too high: %d", sbr.kx[1] + sbr.m[1]));
            return -1;
        }
        if (sbr.kx[1] > 32) {
            log.error((Object)String.format("Start frequency border too high: %d", sbr.kx[1]));
            return -1;
        }
        sbr.fTablelow[0] = sbr.fTablehigh[0];
        int temp = sbr.n[1] & 1;
        for (k = 1; k <= sbr.n[0]; ++k) {
            sbr.fTablelow[k] = sbr.fTablehigh[2 * k - temp];
        }
        sbr.nQ = Math.max(1, CodecUtils.lrintf((float)sbr.spectrumParams.bsNoiseBands * CodecUtils.log2f((float)sbr.k[2] / (float)sbr.kx[1])));
        if (sbr.nQ > 5) {
            log.error((Object)String.format("Too many noise floor scale factors: %d", sbr.nQ));
            return -1;
        }
        sbr.fTablenoise[0] = sbr.fTablelow[0];
        temp = 0;
        for (k = 1; k <= sbr.nQ; ++k) {
            temp += (sbr.n[0] - temp) / (sbr.nQ + 1 - k);
            sbr.fTablenoise[k] = sbr.fTablelow[temp];
        }
        if (AacSbr.sbrHfCalcNpatches(ac, sbr) < 0) {
            return -1;
        }
        AacSbr.sbrMakeFTablelim(sbr);
        sbr.data[0].fIndexnoise = 0;
        sbr.data[1].fIndexnoise = 0;
        return 0;
    }

    private static int readSbrHeader(SpectralBandReplication sbr, BitReader br) {
        int cnt = br.getBitsRead();
        int oldBsLimiterBands = sbr.bsLimiterBands;
        SpectrumParameters oldSpectrumParams = new SpectrumParameters();
        sbr.start = true;
        oldSpectrumParams.copy(sbr.spectrumParams);
        sbr.bsAmpResHeader = br.readBool();
        sbr.spectrumParams.bsStartFreq = br.read(4);
        sbr.spectrumParams.bsStopFreq = br.read(4);
        sbr.spectrumParams.bsXoverBand = br.read(3);
        br.skip(2);
        boolean bs_header_extra_1 = br.readBool();
        boolean bs_header_extra_2 = br.readBool();
        if (bs_header_extra_1) {
            sbr.spectrumParams.bsFreqScale = br.read(2);
            sbr.spectrumParams.bsAlterScale = br.read1();
            sbr.spectrumParams.bsNoiseBands = br.read(2);
        } else {
            sbr.spectrumParams.bsFreqScale = 2;
            sbr.spectrumParams.bsAlterScale = 1;
            sbr.spectrumParams.bsNoiseBands = 2;
        }
        if (!oldSpectrumParams.equals(sbr.spectrumParams)) {
            sbr.reset = true;
        }
        if (bs_header_extra_2) {
            sbr.bsLimiterBands = br.read(2);
            sbr.bsLimiterGains = br.read(2);
            sbr.bsInterpolFreq = br.readBool();
            sbr.bsSmoothingMode = br.readBool();
        } else {
            sbr.bsLimiterBands = 2;
            sbr.bsLimiterGains = 2;
            sbr.bsInterpolFreq = true;
            sbr.bsSmoothingMode = true;
        }
        if (sbr.bsLimiterBands != oldBsLimiterBands && !sbr.reset) {
            AacSbr.sbrMakeFTablelim(sbr);
        }
        return br.getBitsRead() - cnt;
    }

    private static void sbrReset(Context ac, SpectralBandReplication sbr) {
        int err = AacSbr.sbrMakeFMaster(ac, sbr, sbr.spectrumParams);
        if (err >= 0) {
            err = AacSbr.sbrMakeFDerived(ac, sbr);
        }
        if (err < 0) {
            log.error((Object)String.format("SBR reset failed. Switching SBR to pure upsampling mode", new Object[0]));
            AacSbr.sbrTurnoff(sbr);
        }
    }

    public static int decodeSbrExtension(Context ac, SpectralBandReplication sbr, boolean crc, int cnt, int idAac) {
        int numSbrBits = 0;
        sbr.reset = false;
        if (sbr.sampleRate == 0) {
            sbr.sampleRate = 2 * ac.oc[1].m4ac.sampleRate;
        }
        if (ac.oc[1].m4ac.extSampleRate == 0) {
            ac.oc[1].m4ac.extSampleRate = 2 * ac.oc[1].m4ac.sampleRate;
        }
        if (crc) {
            ac.br.skip(10);
            numSbrBits += 10;
        }
        sbr.kx[0] = sbr.kx[1];
        sbr.m[0] = sbr.m[1];
        sbr.kxAndMPushed = true;
        ++numSbrBits;
        if (ac.br.readBool()) {
            numSbrBits += AacSbr.readSbrHeader(sbr, ac.br);
        }
        if (sbr.reset) {
            AacSbr.sbrReset(ac, sbr);
        }
        if (sbr.start) {
            numSbrBits += AacSbr.readSbrData(ac, sbr, idAac);
        }
        int numSkipBits = cnt * 8 - 4 - numSbrBits;
        ac.br.skip(numSkipBits);
        int numAlignBits = numSkipBits & 7;
        int bytesRead = numSbrBits + numAlignBits + 4 >> 3;
        if (bytesRead > cnt) {
            log.error((Object)String.format("Expected to read %d SBR bytes actually read %d", cnt, bytesRead));
        }
        return cnt;
    }

    private static void sbrTurnoff(SpectralBandReplication sbr) {
        sbr.start = false;
        sbr.kx[1] = 32;
        sbr.m[1] = 0;
        sbr.data[0].eA[1] = -1;
        sbr.data[1].eA[1] = -1;
        sbr.spectrumParams.reset();
    }

    public static void ctxInit(SpectralBandReplication sbr) {
        if (sbr.mdct != null) {
            return;
        }
        sbr.kx[0] = sbr.kx[1];
        AacSbr.sbrTurnoff(sbr);
        sbr.data[0].synthesisFilterbankSamplesOffset = 1152;
        sbr.data[1].synthesisFilterbankSamplesOffset = 1152;
        sbr.mdct.mdctInit(7, true, 9.059906005859375E-7);
        sbr.mdctAna.mdctInit(7, true, -65536.0);
    }

    public static void ctxClose(SpectralBandReplication sbr) {
    }

    private static void sbrDequant(SpectralBandReplication sbr, int idAac) {
        if (idAac == 1 && sbr.bsCoupling) {
            float fac;
            float temp2;
            float temp1;
            int k;
            int e;
            float alpha = sbr.data[0].bsAmpRes ? 1.0f : 0.5f;
            float pan_offset = sbr.data[0].bsAmpRes ? 12.0f : 24.0f;
            for (e = 1; e <= sbr.data[0].bsNumEnv; ++e) {
                for (k = 0; k < sbr.n[sbr.data[0].bsFreqRes[e]]; ++k) {
                    temp1 = CodecUtils.exp2f(sbr.data[0].envFacs[e][k] * alpha + 7.0f);
                    temp2 = CodecUtils.exp2f((pan_offset - sbr.data[1].envFacs[e][k]) * alpha);
                    if ((double)temp1 > 1.0E20) {
                        log.error((Object)String.format("envelope scalefactor overflow in dequant", new Object[0]));
                        temp1 = 1.0f;
                    }
                    sbr.data[0].envFacs[e][k] = fac = temp1 / (1.0f + temp2);
                    sbr.data[1].envFacs[e][k] = fac * temp2;
                }
            }
            for (e = 1; e <= sbr.data[0].bsNumNoise; ++e) {
                for (k = 0; k < sbr.nQ; ++k) {
                    temp1 = CodecUtils.exp2f(6.0f - sbr.data[0].noiseFacs[e][k] + 1.0f);
                    temp2 = CodecUtils.exp2f(12.0f - sbr.data[1].noiseFacs[e][k]);
                    if ((double)temp1 > 1.0E20) {
                        log.error((Object)String.format("envelope scalefactor overflow in dequant", new Object[0]));
                        temp1 = 1.0f;
                    }
                    sbr.data[0].noiseFacs[e][k] = fac = temp1 / (1.0f + temp2);
                    sbr.data[1].noiseFacs[e][k] = fac * temp2;
                }
            }
        } else {
            for (int ch = 0; ch < (idAac == 1 ? 1 : 0) + 1; ++ch) {
                int k;
                int e;
                float alpha = sbr.data[ch].bsAmpRes ? 1.0f : 0.5f;
                for (e = 1; e <= sbr.data[ch].bsNumEnv; ++e) {
                    for (k = 0; k < sbr.n[sbr.data[ch].bsFreqRes[e]]; ++k) {
                        sbr.data[ch].envFacs[e][k] = CodecUtils.exp2f(alpha * sbr.data[ch].envFacs[e][k] + 6.0f);
                        if (!((double)sbr.data[ch].envFacs[e][k] > 1.0E20)) continue;
                        log.error((Object)String.format("envelope scalefactor overflow in dequant", new Object[0]));
                        sbr.data[ch].envFacs[e][k] = 1.0f;
                    }
                }
                for (e = 1; e <= sbr.data[ch].bsNumNoise; ++e) {
                    for (k = 0; k < sbr.nQ; ++k) {
                        sbr.data[ch].noiseFacs[e][k] = CodecUtils.exp2f(6.0f - sbr.data[ch].noiseFacs[e][k]);
                    }
                }
            }
        }
    }

    private static void sbrQmfAnalysis(FFT mdct, float[] in, float[] x, float[] z, float[][][][] W, int bufIdx) {
        System.arraycopy(x, 1024, x, 0, 288);
        System.arraycopy(in, 0, x, 288, 1024);
        int xOffset = 0;
        for (int i = 0; i < 32; ++i) {
            FloatDSP.vectorFmulReverse(z, 0, AacSbrData.sbr_qmf_window_ds, 0, x, xOffset, 320);
            SBRDSP.sum64x5(z, 0);
            SBRDSP.qmfPreShuffle(z, 0);
            mdct.imdctHalf(z, 0, z, 64);
            SBRDSP.qmfPostShuffle(W[bufIdx][i], z, 0);
            xOffset += 32;
        }
    }

    private static void sbrQmfSynthesis(FFT mdct, float[] out, float[][][] X, float[] mdctBuf, float[] v0, int[] vOff, int div) {
        float[] sbrQmfWindow = div != 0 ? AacSbrData.sbr_qmf_window_ds : AacSbrData.sbr_qmf_window_us;
        int step = 128 >> div;
        int outOffset = 0;
        for (int i = 0; i < 32; ++i) {
            if (vOff[0] < step) {
                int saved_samples = 1152 >> div;
                System.arraycopy(v0, 0, v0, 2304 - saved_samples, saved_samples);
                vOff[0] = 2304 - saved_samples - step;
            } else {
                vOff[0] = vOff[0] - step;
            }
            int v = vOff[0];
            if (div != 0) {
                for (int n = 0; n < 32; ++n) {
                    X[0][i][n] = -X[0][i][n];
                    X[0][i][32 + n] = X[1][i][31 - n];
                }
                mdct.imdctHalf(mdctBuf, 0, X[0][i], 0);
                SBRDSP.qmfDeintNeg(v0, v, mdctBuf, 0);
            } else {
                SBRDSP.negOdd64(X[1][i], 0);
                mdct.imdctHalf(mdctBuf, 0, X[0][i], 0);
                mdct.imdctHalf(mdctBuf, 64, X[1][i], 0);
                SBRDSP.qmfDeintBfly(v0, v, mdctBuf, 64, mdctBuf, 0);
            }
            FloatDSP.vectorFmul(out, outOffset, v0, v, sbrQmfWindow, 0, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (192 >> div), sbrQmfWindow, 64 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (256 >> div), sbrQmfWindow, 128 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (448 >> div), sbrQmfWindow, 192 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (512 >> div), sbrQmfWindow, 256 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (704 >> div), sbrQmfWindow, 320 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (768 >> div), sbrQmfWindow, 384 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (960 >> div), sbrQmfWindow, 448 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (1024 >> div), sbrQmfWindow, 512 >> div, out, outOffset, 64 >> div);
            FloatDSP.vectorFmulAdd(out, outOffset, v0, v + (1216 >> div), sbrQmfWindow, 576 >> div, out, outOffset, 64 >> div);
            outOffset += 64 >> div;
        }
    }

    private static void sbrChirp(SpectralBandReplication sbr, SBRData chData) {
        for (int i = 0; i < sbr.nQ; ++i) {
            float newBw = chData.bsInvfMode[0][i] + chData.bsInvfMode[1][i] == 1 ? 0.6f : bw_tab[chData.bsInvfMode[0][i]];
            newBw = newBw < chData.bwArray[i] ? 0.75f * newBw + 0.25f * chData.bwArray[i] : 0.90625f * newBw + 0.09375f * chData.bwArray[i];
            chData.bwArray[i] = newBw < 0.015625f ? 0.0f : newBw;
        }
    }

    private static int sbrHfGen(Context ac, SpectralBandReplication sbr, float[][][] Xhigh, float[][][] Xlow, float[][] alpha0, float[][] alpha1, float[] bwArray, int[] tEnv, int bsNumEnv) {
        int g = 0;
        int k = sbr.kx[1];
        for (int j = 0; j < sbr.numPatches; ++j) {
            int x = 0;
            while (x < sbr.patchNumSubbands[j]) {
                int p = sbr.patchStartSubband[j] + x;
                while (g <= sbr.nQ && k >= sbr.fTablenoise[g]) {
                    ++g;
                }
                if (--g < 0) {
                    log.error((Object)String.format("ERROR : no subband found for frequency %d", k));
                    return -1;
                }
                SBRDSP.hf_gen(Xhigh[k], 2, Xlow[p], 2, alpha0[p], alpha1[p], bwArray[g], 2 * tEnv[0], 2 * tEnv[bsNumEnv]);
                ++x;
                ++k;
            }
        }
        if (k < sbr.m[1] + sbr.kx[1]) {
            Arrays.fill((Object[])Xhigh, k, sbr.m[1] + sbr.kx[1], Float.valueOf(0.0f));
        }
        return 0;
    }

    private static int sbrMapping(Context ac, SpectralBandReplication sbr, SBRData chData, int[] eA) {
        for (int i = 1; i < 8; ++i) {
            Arrays.fill(chData.sIndexmapped[i], 0);
        }
        for (int e = 0; e < chData.bsNumEnv; ++e) {
            int i;
            int[] table;
            int ilim = sbr.n[chData.bsFreqRes[e + 1]];
            int[] nArray = table = chData.bsFreqRes[e + 1] != 0 ? sbr.fTablehigh : sbr.fTablelow;
            if (sbr.kx[1] != table[0]) {
                log.error((Object)String.format("kx != f_table{high,low}[0]. Derived frequency tables were not regenerated.", new Object[0]));
                AacSbr.sbrTurnoff(sbr);
                return -4;
            }
            for (int i2 = 0; i2 < ilim; ++i2) {
                for (int m = table[i2]; m < table[i2 + 1]; ++m) {
                    sbr.eOrigmapped[e][m - sbr.kx[1]] = chData.envFacs[e + 1][i2];
                }
            }
            int k = chData.bsNumNoise > 1 && chData.tEnv[e] >= chData.tQ[1] ? 1 : 0;
            for (i = 0; i < sbr.nQ; ++i) {
                for (int m = sbr.fTablenoise[i]; m < sbr.fTablenoise[i + 1]; ++m) {
                    sbr.qMapped[e][m - sbr.kx[1]] = chData.noiseFacs[k + 1][i];
                }
            }
            for (i = 0; i < sbr.n[1]; ++i) {
                if (!chData.bsAddHarmonicFlag) continue;
                int m_midpoint = sbr.fTablehigh[i] + sbr.fTablehigh[i + 1] >> 1;
                chData.sIndexmapped[e + 1][m_midpoint - sbr.kx[1]] = chData.bsAddHarmonic[i] * (e >= eA[1] || chData.sIndexmapped[0][m_midpoint - sbr.kx[1]] == 1 ? 1 : 0);
            }
            for (i = 0; i < ilim; ++i) {
                int additional_sinusoid_present = 0;
                for (int m = table[i]; m < table[i + 1]; ++m) {
                    if (chData.sIndexmapped[e + 1][m - sbr.kx[1]] == 0) continue;
                    additional_sinusoid_present = 1;
                    break;
                }
                Arrays.fill(sbr.sMapped[e], table[i] - sbr.kx[1], table[i + 1] - sbr.kx[1], additional_sinusoid_present);
            }
        }
        System.arraycopy(chData.sIndexmapped[chData.bsNumEnv], 0, chData.sIndexmapped[0], 0, chData.sIndexmapped[0].length);
        return 0;
    }

    private static void sbrEnvEstimate(float[][] eCurr, float[][][] Xhigh, SpectralBandReplication sbr, SBRData chData) {
        int kx1 = sbr.kx[1];
        if (sbr.bsInterpolFreq) {
            for (int e = 0; e < chData.bsNumEnv; ++e) {
                float recipEnvSize = 0.5f / (float)(chData.tEnv[e + 1] - chData.tEnv[e]);
                int ilb = chData.tEnv[e] * 2 + 2;
                int iub = chData.tEnv[e + 1] * 2 + 2;
                for (int m = 0; m < sbr.m[1]; ++m) {
                    float sum = SBRDSP.sum_square(Xhigh[m + kx1], ilb, iub - ilb);
                    eCurr[e][m] = sum * recipEnvSize;
                }
            }
        } else {
            for (int e = 0; e < chData.bsNumEnv; ++e) {
                int envSize = 2 * (chData.tEnv[e + 1] - chData.tEnv[e]);
                int ilb = chData.tEnv[e] * 2 + 2;
                int iub = chData.tEnv[e + 1] * 2 + 2;
                int[] table = chData.bsFreqRes[e + 1] != 0 ? sbr.fTablehigh : sbr.fTablelow;
                for (int p = 0; p < sbr.n[chData.bsFreqRes[e + 1]]; ++p) {
                    int k;
                    float sum = 0.0f;
                    int den = envSize * (table[p + 1] - table[p]);
                    for (k = table[p]; k < table[p + 1]; ++k) {
                        sum += SBRDSP.sum_square(Xhigh[k], ilb, iub - ilb);
                    }
                    sum /= (float)den;
                    for (k = table[p]; k < table[p + 1]; ++k) {
                        eCurr[e][k - kx1] = sum;
                    }
                }
            }
        }
    }

    private static void sbrGainCalc(SpectralBandReplication sbr, SBRData chData, int[] eA) {
        for (int e = 0; e < chData.bsNumEnv; ++e) {
            boolean delta = e != eA[1] || e == eA[0];
            for (int k = 0; k < sbr.nLim; ++k) {
                int m;
                float[] sum = new float[]{0.0f, 0.0f};
                for (m = sbr.fTablelim[k] - sbr.kx[1]; m < sbr.fTablelim[k + 1] - sbr.kx[1]; ++m) {
                    float temp = sbr.eOrigmapped[e][m] / (1.0f + sbr.qMapped[e][m]);
                    sbr.qM[e][m] = CodecUtils.sqrtf(temp * sbr.qMapped[e][m]);
                    sbr.sM[e][m] = CodecUtils.sqrtf(temp * (float)chData.sIndexmapped[e + 1][m]);
                    sbr.gain[e][m] = sbr.sMapped[e][m] == 0 ? CodecUtils.sqrtf(sbr.eOrigmapped[e][m] / ((1.0f + sbr.eCurr[e][m]) * (1.0f + sbr.qMapped[e][m] * (float)delta))) : CodecUtils.sqrtf(sbr.eOrigmapped[e][m] * sbr.qMapped[e][m] / ((1.0f + sbr.eCurr[e][m]) * (1.0f + sbr.qMapped[e][m])));
                }
                for (m = sbr.fTablelim[k] - sbr.kx[1]; m < sbr.fTablelim[k + 1] - sbr.kx[1]; ++m) {
                    sum[0] = sum[0] + sbr.eOrigmapped[e][m];
                    sum[1] = sum[1] + sbr.eCurr[e][m];
                }
                float gain_max = limgain[sbr.bsLimiterGains] * CodecUtils.sqrtf((1.1920929E-7f + sum[0]) / (1.1920929E-7f + sum[1]));
                gain_max = Math.min(100000.0f, gain_max);
                for (m = sbr.fTablelim[k] - sbr.kx[1]; m < sbr.fTablelim[k + 1] - sbr.kx[1]; ++m) {
                    float qM_max = sbr.qM[e][m] * gain_max / sbr.gain[e][m];
                    sbr.qM[e][m] = Math.min(sbr.qM[e][m], qM_max);
                    sbr.gain[e][m] = Math.min(sbr.gain[e][m], gain_max);
                }
                sum[1] = 0.0f;
                sum[0] = 0.0f;
                for (m = sbr.fTablelim[k] - sbr.kx[1]; m < sbr.fTablelim[k + 1] - sbr.kx[1]; ++m) {
                    sum[0] = sum[0] + sbr.eOrigmapped[e][m];
                    sum[1] = sum[1] + (sbr.eCurr[e][m] * sbr.gain[e][m] * sbr.gain[e][m] + sbr.sM[e][m] * sbr.sM[e][m] + (float)(delta && sbr.sM[e][m] == 0.0f ? 1 : 0) * sbr.qM[e][m] * sbr.qM[e][m]);
                }
                float gain_boost = CodecUtils.sqrtf((1.1920929E-7f + sum[0]) / (1.1920929E-7f + sum[1]));
                gain_boost = Math.min(1.5848932f, gain_boost);
                m = sbr.fTablelim[k] - sbr.kx[1];
                while (m < sbr.fTablelim[k + 1] - sbr.kx[1]) {
                    float[] fArray = sbr.gain[e];
                    int n = m;
                    fArray[n] = fArray[n] * gain_boost;
                    float[] fArray2 = sbr.qM[e];
                    int n2 = m;
                    fArray2[n2] = fArray2[n2] * gain_boost;
                    float[] fArray3 = sbr.sM[e];
                    int n3 = m++;
                    fArray3[n3] = fArray3[n3] * gain_boost;
                }
            }
        }
    }

    private static int sbrLfGen(SpectralBandReplication sbr, float[][][] Xlow, float[][][][] W, int bufIdx) {
        int i;
        int k;
        int tHFGen = 8;
        int iF = 32;
        Utilities.fill(Xlow, 0.0f);
        for (k = 0; k < sbr.kx[1]; ++k) {
            for (i = 8; i < 40; ++i) {
                Xlow[k][i][0] = W[bufIdx][i - 8][k][0];
                Xlow[k][i][1] = W[bufIdx][i - 8][k][1];
            }
        }
        bufIdx = 1 - bufIdx;
        for (k = 0; k < sbr.kx[0]; ++k) {
            for (i = 0; i < 8; ++i) {
                Xlow[k][i][0] = W[bufIdx][i + 32 - 8][k][0];
                Xlow[k][i][1] = W[bufIdx][i + 32 - 8][k][1];
            }
        }
        return 0;
    }

    private static void sbrHfInverseFilter(float[][] alpha0, float[][] alpha1, float[][][] Xlow, int k0) {
        float[][][] phi = new float[3][2][2];
        for (int k = 0; k < k0; ++k) {
            float tempIm;
            float tempReal;
            SBRDSP.autocorrelate(Xlow[k], phi);
            float dk = phi[2][1][0] * phi[1][0][0] - (phi[1][1][0] * phi[1][1][0] + phi[1][1][1] * phi[1][1][1]) / 1.000001f;
            if (dk == 0.0f) {
                alpha1[k][0] = 0.0f;
                alpha1[k][1] = 0.0f;
            } else {
                tempReal = phi[0][0][0] * phi[1][1][0] - phi[0][0][1] * phi[1][1][1] - phi[0][1][0] * phi[1][0][0];
                tempIm = phi[0][0][0] * phi[1][1][1] + phi[0][0][1] * phi[1][1][0] - phi[0][1][1] * phi[1][0][0];
                alpha1[k][0] = tempReal / dk;
                alpha1[k][1] = tempIm / dk;
            }
            if (phi[1][0][0] == 0.0f) {
                alpha0[k][0] = 0.0f;
                alpha0[k][1] = 0.0f;
            } else {
                tempReal = phi[0][0][0] + alpha1[k][0] * phi[1][1][0] + alpha1[k][1] * phi[1][1][1];
                tempIm = phi[0][0][1] + alpha1[k][1] * phi[1][1][0] - alpha1[k][0] * phi[1][1][1];
                alpha0[k][0] = -tempReal / phi[1][0][0];
                alpha0[k][1] = -tempIm / phi[1][0][0];
            }
            if (!(alpha1[k][0] * alpha1[k][0] + alpha1[k][1] * alpha1[k][1] >= 16.0f) && !(alpha0[k][0] * alpha0[k][0] + alpha0[k][1] * alpha0[k][1] >= 16.0f)) continue;
            alpha1[k][0] = 0.0f;
            alpha1[k][1] = 0.0f;
            alpha0[k][0] = 0.0f;
            alpha0[k][1] = 0.0f;
        }
    }

    private static void sbrHfAssemble(float[][][] Y1, float[][][] Xhigh, SpectralBandReplication sbr, SBRData chData, int[] eA) {
        int h_SL = 4 * (!sbr.bsSmoothingMode ? 1 : 0);
        int kx = sbr.kx[1];
        int m_max = sbr.m[1];
        float[][] gTemp = chData.gTemp;
        float[][] qTemp = chData.qTemp;
        int indexnoise = chData.fIndexnoise;
        int indexsine = chData.fIndexsine;
        if (sbr.reset) {
            for (int i = 0; i < h_SL; ++i) {
                System.arraycopy(sbr.gain[0], 0, gTemp[i + 2 * chData.tEnv[0]], 0, m_max);
                System.arraycopy(sbr.qM[0], 0, qTemp[i + 2 * chData.tEnv[0]], 0, m_max);
            }
        } else if (h_SL != 0) {
            System.arraycopy(gTemp[2 * chData.tEnvNumEnvOld], 0, gTemp[2 * chData.tEnv[0]], 0, 4);
            System.arraycopy(qTemp[2 * chData.tEnvNumEnvOld], 0, qTemp[2 * chData.tEnv[0]], 0, 4);
        }
        for (int e = 0; e < chData.bsNumEnv; ++e) {
            for (int i = 2 * chData.tEnv[e]; i < 2 * chData.tEnv[e + 1]; ++i) {
                System.arraycopy(sbr.gain[e], 0, gTemp[h_SL + i], 0, m_max);
                System.arraycopy(sbr.qM[e], 0, qTemp[h_SL + i], 0, m_max);
            }
        }
        float[] g_filt_tab = new float[48];
        float[] q_filt_tab = new float[48];
        for (int e = 0; e < chData.bsNumEnv; ++e) {
            for (int i = 2 * chData.tEnv[e]; i < 2 * chData.tEnv[e + 1]; ++i) {
                float[] qFilt;
                float[] gFilt;
                if (h_SL != 0 && e != eA[0] && e != eA[1]) {
                    gFilt = g_filt_tab;
                    qFilt = q_filt_tab;
                    for (int m = 0; m < m_max; ++m) {
                        int idx1 = i + h_SL;
                        gFilt[m] = 0.0f;
                        qFilt[m] = 0.0f;
                        for (int j = 0; j <= h_SL; ++j) {
                            int n = m;
                            gFilt[n] = gFilt[n] + gTemp[idx1 - j][m] * h_smooth[j];
                            int n2 = m;
                            qFilt[n2] = qFilt[n2] + qTemp[idx1 - j][m] * h_smooth[j];
                        }
                    }
                } else {
                    gFilt = gTemp[i + h_SL];
                    qFilt = qTemp[i];
                }
                SBRDSP.hfGFilt(Y1[i], kx, Xhigh, kx, gFilt, m_max, i + 2);
                if (e != eA[0] && e != eA[1]) {
                    SBRDSP.hf_apply_noise(Y1[i], kx, sbr.sM[e], qFilt, indexnoise, kx, m_max, indexsine);
                } else {
                    int idx = indexsine & 1;
                    int A = 1 - (indexsine + (kx & 1) & 2);
                    int B = (A ^ -idx) + idx;
                    float[] out = Y1[i][kx];
                    float[] in = sbr.sM[e];
                    int m = 0;
                    while (m + 1 < m_max) {
                        int n = idx + 2 * m;
                        out[n] = out[n] + in[m] * (float)A;
                        int n3 = idx + 2 * m + 2;
                        out[n3] = out[n3] + in[m + 1] * (float)B;
                        m += 2;
                    }
                    if ((m_max & 1) != 0) {
                        int n = idx + 2 * m;
                        out[n] = out[n] + in[m] * (float)A;
                    }
                }
                indexnoise = indexnoise + m_max & 0x1FF;
                indexsine = indexsine + 1 & 3;
            }
        }
        chData.fIndexnoise = indexnoise;
        chData.fIndexsine = indexsine;
    }

    private static int sbrXGen(SpectralBandReplication sbr, float[][][] X, float[][][] Y0, float[][][] Y1, float[][][] Xlow, int ch) {
        int i;
        int k;
        int i_f = 32;
        int i_Temp = Math.max(2 * sbr.data[ch].tEnvNumEnvOld - 32, 0);
        Utilities.fill(X, 0.0f);
        for (k = 0; k < sbr.kx[0]; ++k) {
            for (i = 0; i < i_Temp; ++i) {
                X[0][i][k] = Xlow[k][i + 2][0];
                X[1][i][k] = Xlow[k][i + 2][1];
            }
        }
        while (k < sbr.kx[0] + sbr.m[0]) {
            for (i = 0; i < i_Temp; ++i) {
                X[0][i][k] = Y0[i + 32][k][0];
                X[1][i][k] = Y0[i + 32][k][1];
            }
            ++k;
        }
        for (k = 0; k < sbr.kx[1]; ++k) {
            for (i = i_Temp; i < 38; ++i) {
                X[0][i][k] = Xlow[k][i + 2][0];
                X[1][i][k] = Xlow[k][i + 2][1];
            }
        }
        while (k < sbr.kx[1] + sbr.m[1]) {
            for (i = i_Temp; i < 32; ++i) {
                X[0][i][k] = Y1[i][k][0];
                X[1][i][k] = Y1[i][k][1];
            }
            ++k;
        }
        return 0;
    }

    public static void sbrApply(Context ac, SpectralBandReplication sbr, int idAac, float[] L, float[] R) {
        int nch;
        int downsampled = ac.oc[1].m4ac.extSampleRate < sbr.sampleRate ? 1 : 0;
        int n = nch = idAac == 1 ? 2 : 1;
        if (!sbr.kxAndMPushed) {
            sbr.kx[0] = sbr.kx[1];
            sbr.m[0] = sbr.m[1];
        } else {
            sbr.kxAndMPushed = false;
        }
        if (sbr.start) {
            AacSbr.sbrDequant(sbr, idAac);
        }
        for (int ch = 0; ch < nch; ++ch) {
            AacSbr.sbrQmfAnalysis(sbr.mdctAna, ch != 0 ? R : L, sbr.data[ch].analysisFilterbankSamples, sbr.qmfFilterScratch, sbr.data[ch].W, sbr.data[ch].Ypos);
            AacSbr.sbrLfGen(sbr, sbr.Xlow, sbr.data[ch].W, sbr.data[ch].Ypos);
            sbr.data[ch].Ypos ^= 1;
            if (sbr.start) {
                AacSbr.sbrHfInverseFilter(sbr.alpha0, sbr.alpha1, sbr.Xlow, sbr.k[0]);
                AacSbr.sbrChirp(sbr, sbr.data[ch]);
                AacSbr.sbrHfGen(ac, sbr, sbr.Xhigh, sbr.Xlow, sbr.alpha0, sbr.alpha1, sbr.data[ch].bwArray, sbr.data[ch].tEnv, sbr.data[ch].bsNumEnv);
                int err = AacSbr.sbrMapping(ac, sbr, sbr.data[ch], sbr.data[ch].eA);
                if (err == 0) {
                    AacSbr.sbrEnvEstimate(sbr.eCurr, sbr.Xhigh, sbr, sbr.data[ch]);
                    AacSbr.sbrGainCalc(sbr, sbr.data[ch], sbr.data[ch].eA);
                    AacSbr.sbrHfAssemble(sbr.data[ch].Y[sbr.data[ch].Ypos], sbr.Xhigh, sbr, sbr.data[ch], sbr.data[ch].eA);
                }
            }
            AacSbr.sbrXGen(sbr, sbr.X[ch], sbr.data[ch].Y[1 - sbr.data[ch].Ypos], sbr.data[ch].Y[sbr.data[ch].Ypos], sbr.Xlow, ch);
        }
        if (ac.oc[1].m4ac.ps == 1) {
            if (sbr.ps.start) {
                AacPs.psApply(sbr.ps, sbr.X[0], sbr.X[1], sbr.kx[1] + sbr.m[1]);
            } else {
                Utilities.copy(sbr.X[1], sbr.X[0]);
            }
            nch = 2;
        }
        int[] tmp = new int[]{sbr.data[0].synthesisFilterbankSamplesOffset};
        AacSbr.sbrQmfSynthesis(sbr.mdct, L, sbr.X[0], sbr.qmfFilterScratch, sbr.data[0].synthesisFilterbankSamples, tmp, downsampled);
        sbr.data[0].synthesisFilterbankSamplesOffset = tmp[0];
        if (nch == 2) {
            tmp[0] = sbr.data[1].synthesisFilterbankSamplesOffset;
            AacSbr.sbrQmfSynthesis(sbr.mdct, R, sbr.X[1], sbr.qmfFilterScratch, sbr.data[1].synthesisFilterbankSamples, tmp, downsampled);
            sbr.data[1].synthesisFilterbankSamplesOffset = tmp[0];
        }
    }
}

