/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import jpcsp.arm.ARMInstructions;
import jpcsp.arm.ARMMemory;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.wlan.BaseHLECall;
import jpcsp.util.Utilities;

public class HLENullCall
extends BaseHLECall {
    private int numberArguments;
    private boolean doReturnValue;
    private int returnValue;

    public HLENullCall(int numberArguments) {
        this.numberArguments = numberArguments;
    }

    public HLENullCall(int numberArguments, int returnValue) {
        this.numberArguments = numberArguments;
        this.doReturnValue = true;
        this.returnValue = returnValue;
    }

    @Override
    public void call(ARMProcessor processor, int imm) {
        if (log.isDebugEnabled()) {
            int i;
            StringBuilder args = new StringBuilder();
            int[] memoryDumps = null;
            String[] memoryDumpsPrefix = null;
            for (i = 0; i < this.numberArguments; ++i) {
                int value;
                String name;
                if (i <= 3) {
                    name = ARMInstructions.getRegisterName(i);
                    value = processor.getRegister(i);
                } else {
                    int sp = processor.getSp();
                    int offset = i - 4 << 2;
                    name = String.format("[%s, #0x%X]", ARMInstructions.getRegisterName(13), offset);
                    value = processor.mem.read32(sp + offset);
                }
                args.append(String.format(", %s=0x%08X", name, value));
                if (!log.isTraceEnabled() || !ARMMemory.isAddressGood(value) || value >= 0 && value < 512) continue;
                memoryDumpsPrefix = Utilities.add(memoryDumpsPrefix, name);
                memoryDumps = Utilities.add(memoryDumps, value);
            }
            log.debug((Object)String.format("HLENullCall imm=0x%X%s", imm, args));
            if (memoryDumps != null) {
                for (i = 0; i < memoryDumps.length; ++i) {
                    void addr = memoryDumps[i];
                    log.trace((Object)String.format("%s: %s", memoryDumpsPrefix[i], Utilities.getMemoryDump(processor.mem, (int)addr, 16)));
                }
            }
        }
        if (this.doReturnValue) {
            processor.setRegister(0, this.returnValue);
        }
        this.returnToLr(processor);
    }
}

