/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.DialogPageListCellRenderer;
import com.jidesoft.dialog.DialogPageTreeCellRenderer;
import com.jidesoft.dialog.MutableTreeNodeEx;
import com.jidesoft.dialog.PageList;
import com.jidesoft.dialog.ScrollableButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideScrollPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MultiplePageDialog
extends StandardDialog {
    public static final int TAB_STYLE = 0;
    public static final int TREE_STYLE = 1;
    public static final int LIST_STYLE = 2;
    public static final int ICON_STYLE = 3;
    private int _style;
    private PageList _pageList;
    private JComponent _indexPanel;
    private JComponent _pagesPanel;
    private CardLayout _cardLayout;
    private Map<String, MutableTreeNode> _titleNodeMap;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _applyButton;
    private TreeCellRenderer _treeCellRenderer;
    private ListCellRenderer _listCellRenderer;
    private JTabbedPane _tabbedPane;
    private String _initialPageTitle;
    public JTree _tree;

    public MultiplePageDialog() throws HeadlessException {
        this((Frame)null);
    }

    public MultiplePageDialog(Frame frame) throws HeadlessException {
        this(frame, false);
    }

    public MultiplePageDialog(Frame frame, boolean bl) throws HeadlessException {
        this(frame, "", bl);
    }

    public MultiplePageDialog(Frame frame, String string) throws HeadlessException {
        this(frame, string, true);
    }

    public MultiplePageDialog(Frame frame, String string, boolean bl) throws HeadlessException {
        this(frame, string, bl, 0);
    }

    public MultiplePageDialog(Frame frame, String string, boolean bl, int n) throws HeadlessException {
        super(frame, string, bl);
        this.setStyle(n);
    }

    public MultiplePageDialog(Dialog dialog) throws HeadlessException {
        this(dialog, false);
    }

    public MultiplePageDialog(Dialog dialog, boolean bl) throws HeadlessException {
        this(dialog, "", bl);
    }

    public MultiplePageDialog(Dialog dialog, String string) throws HeadlessException {
        this(dialog, string, true);
    }

    public MultiplePageDialog(Dialog dialog, String string, boolean bl) throws HeadlessException {
        this(dialog, string, bl, 0);
    }

    public MultiplePageDialog(Dialog dialog, String string, boolean bl, int n) throws HeadlessException {
        super(dialog, string, bl);
        this.setStyle(n);
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public JComponent createContentPanel() {
        this._indexPanel = this.createIndexPanel();
        this._pagesPanel = this.createPagesPanel();
        if (this._pageList.getPageCount() > 0) {
            if (this.getInitialPageTitle() != null) {
                this.setCurrentPage(this.getInitialPageTitle());
            } else {
                this.setCurrentPage(this._pageList.getPage(0));
            }
        }
        return this.setupContentPanel(this._indexPanel, this._pagesPanel);
    }

    protected JComponent setupContentPanel(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        if (jComponent != null) {
            jPanel.add((Component)jComponent, "Before");
        }
        if (jComponent2 != null) {
            jPanel.add((Component)jComponent2, "Center");
        }
        return jPanel;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this._okButton = new JButton();
        this._cancelButton = new JButton();
        this._applyButton = new JButton();
        this._okButton.setName("OK");
        this._cancelButton.setName("CANCEL");
        this._applyButton.setName("APPLY");
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        buttonPanel.addButton((AbstractButton)this._applyButton, "ALTERNATIVE");
        Locale locale = this.getLocale();
        this._okButton.setAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", locale)){
            private static final long serialVersionUID = 7761238902525319363L;

            public void actionPerformed(ActionEvent actionEvent) {
                MultiplePageDialog.this.setDialogResult(0);
                MultiplePageDialog.this.setVisible(false);
                MultiplePageDialog.this.dispose();
            }
        });
        this._cancelButton.setAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale)){
            private static final long serialVersionUID = 2671605366801733356L;

            public void actionPerformed(ActionEvent actionEvent) {
                MultiplePageDialog.this.setDialogResult(-1);
                MultiplePageDialog.this.setVisible(false);
                MultiplePageDialog.this.dispose();
            }
        });
        this._applyButton.setAction(new AbstractAction(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply")){
            private static final long serialVersionUID = -7553895212164069062L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (MultiplePageDialog.this.getCurrentPage() != null) {
                    MultiplePageDialog.this.getCurrentPage().fireButtonEvent(3302, "APPLY");
                }
            }
        });
        this._applyButton.setMnemonic(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply.mnemonic").charAt(0));
        this._applyButton.setEnabled(false);
        this.setDefaultCancelAction(this._cancelButton.getAction());
        this.setDefaultAction(this._okButton.getAction());
        this.getRootPane().setDefaultButton(this._okButton);
        return buttonPanel;
    }

    public JButton getOkButton() {
        return this._okButton;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JButton getApplyButton() {
        return this._applyButton;
    }

    protected JComponent createPagesPanel() {
        if (this._style == 0) {
            this._tabbedPane = this.createTabbedPane();
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Component component = MultiplePageDialog.this._tabbedPane.getSelectedComponent();
                    if (component instanceof AbstractDialogPage) {
                        MultiplePageDialog.this.setCurrentPage((AbstractDialogPage)component, MultiplePageDialog.this._tabbedPane);
                    }
                }
            });
            int n = 0;
            while (n < this._pageList.getPageCount()) {
                AbstractDialogPage abstractDialogPage = this._pageList.getPage(n);
                abstractDialogPage.addButtonListener(this.getButtonPanel());
                this._tabbedPane.addTab(abstractDialogPage.getTitle(), abstractDialogPage.getIcon(), abstractDialogPage, abstractDialogPage.getDescription());
                this._tabbedPane.setEnabledAt(n, abstractDialogPage.isPageEnabled());
                final int n2 = n++;
                abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialog.this._tabbedPane.setEnabledAt(n2, Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialog.this._tabbedPane.setIconAt(n2, (Icon)propertyChangeEvent.getNewValue());
                        } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialog.this._tabbedPane.setTitleAt(n2, (String)propertyChangeEvent.getNewValue());
                        } else if ("description".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialog.this._tabbedPane.setToolTipTextAt(n2, (String)propertyChangeEvent.getNewValue());
                        }
                    }
                });
            }
            this._pageList.addListDataListener(new ListDataListener(){

                public void intervalAdded(ListDataEvent listDataEvent) {
                    for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                        AbstractDialogPage abstractDialogPage = MultiplePageDialog.this._pageList.getPage(i);
                        MultiplePageDialog.this._tabbedPane.insertTab(abstractDialogPage.getTitle(), abstractDialogPage.getIcon(), abstractDialogPage, abstractDialogPage.getDescription(), i);
                    }
                }

                public void intervalRemoved(ListDataEvent listDataEvent) {
                    for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                        MultiplePageDialog.this._tabbedPane.removeTabAt(i);
                    }
                }

                public void contentsChanged(ListDataEvent listDataEvent) {
                }
            });
            return this._tabbedPane;
        }
        final JPanel jPanel = new JPanel();
        this._cardLayout = new CardLayout();
        jPanel.setLayout(this._cardLayout);
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            AbstractDialogPage abstractDialogPage = this._pageList.getPage(i);
            abstractDialogPage.addButtonListener(this.getButtonPanel());
            abstractDialogPage.setName(abstractDialogPage.getFullTitle());
            abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("title".equals(propertyChangeEvent.getPropertyName())) {
                        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                            Component component = jPanel.getComponent(i);
                            boolean bl = component.isVisible();
                            Object object = propertyChangeEvent.getSource();
                            if (!(object instanceof AbstractDialogPage) || component != object) continue;
                            jPanel.remove(i);
                            String string = ((AbstractDialogPage)object).getFullTitle();
                            jPanel.add((AbstractDialogPage)object, string, i);
                            ((AbstractDialogPage)object).setName(string);
                            MultiplePageDialog.this.getIndexPanel().repaint();
                            if (!bl) break;
                            MultiplePageDialog.this._cardLayout.show(jPanel, string);
                            break;
                        }
                    }
                }
            });
            jPanel.add((Component)abstractDialogPage, abstractDialogPage.getFullTitle());
        }
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    AbstractDialogPage abstractDialogPage = MultiplePageDialog.this._pageList.getPage(i);
                    abstractDialogPage.setName(abstractDialogPage.getFullTitle());
                    jPanel.add(abstractDialogPage, abstractDialogPage.getFullTitle(), i);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                    jPanel.remove(i);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                Object object;
                if (listDataEvent.getSource() instanceof PageList && (object = ((PageList)listDataEvent.getSource()).getSelectedItem()) instanceof AbstractDialogPage && ((AbstractDialogPage)object).isPageEnabled()) {
                    MultiplePageDialog.this.setCurrentPage((AbstractDialogPage)object);
                }
            }
        });
        return jPanel;
    }

    protected JTabbedPane createTabbedPane() {
        return new JTabbedPane(1);
    }

    public JComponent createIndexPanel() {
        switch (this._style) {
            case 3: {
                return this.createIconPanel();
            }
            case 2: {
                return this.createListPanel();
            }
            case 1: {
                return this.createTreePanel();
            }
        }
        return null;
    }

    public void setPageList(PageList pageList) {
        this._pageList = pageList;
    }

    public PageList getPageList() {
        return this._pageList;
    }

    public AbstractDialogPage getCurrentPage() {
        return this._pageList.getCurrentPage();
    }

    protected void setCurrentPage(String string) {
        if (this._pageList != null) {
            this.setCurrentPage(this._pageList.getPageByFullTitle(string));
        }
    }

    protected void setCurrentPage(AbstractDialogPage abstractDialogPage) {
        this.setCurrentPage(abstractDialogPage, null);
    }

    protected void setCurrentPage(AbstractDialogPage abstractDialogPage, Object object) {
        if (!this._pageList.setCurrentPage(abstractDialogPage, object)) {
            return;
        }
        if (abstractDialogPage != null) {
            this.showCurrentPage(abstractDialogPage);
        }
    }

    protected void showCurrentPage(AbstractDialogPage abstractDialogPage) {
        if (abstractDialogPage != null) {
            if (this.getStyle() == 0) {
                this._tabbedPane.setSelectedComponent(abstractDialogPage);
            } else {
                this._cardLayout.show(this._pagesPanel, abstractDialogPage.getFullTitle());
            }
            abstractDialogPage.focusDefaultFocusComponent();
        }
    }

    private JComponent createTreePanel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("", true);
        this._titleNodeMap = new HashMap<String, MutableTreeNode>((int)((double)this._pageList.getPageCount() * 0.75));
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            AbstractDialogPage abstractDialogPage = this._pageList.getPage(i);
            this.addPage(abstractDialogPage, defaultMutableTreeNode, false);
        }
        this._tree = this.createTree(defaultMutableTreeNode);
        this.configureTree(this._tree);
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    AbstractDialogPage abstractDialogPage = MultiplePageDialog.this._pageList.getPage(i);
                    MultiplePageDialog.this.addPage(abstractDialogPage, (DefaultMutableTreeNode)MultiplePageDialog.this._tree.getModel().getRoot(), true);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                Set set = MultiplePageDialog.this._titleNodeMap.keySet();
                Vector<String> vector = new Vector<String>();
                for (String string : set) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    if (MultiplePageDialog.this._pageList.getPageByFullTitle(string) != null || (defaultMutableTreeNode = (DefaultMutableTreeNode)MultiplePageDialog.this._titleNodeMap.get(string)) == null) continue;
                    vector.add(string);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2 == null) continue;
                    int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    ((DefaultTreeModel)MultiplePageDialog.this._tree.getModel()).nodesWereRemoved(defaultMutableTreeNode2, new int[]{n}, new Object[]{defaultMutableTreeNode});
                }
                for (String string : vector) {
                    MultiplePageDialog.this._titleNodeMap.remove(string);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                TreeNode treeNode;
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1 && listDataEvent.getType() == 0 && MultiplePageDialog.this._titleNodeMap != null && MultiplePageDialog.this._pageList.getCurrentPage() != null && (treeNode = (TreeNode)MultiplePageDialog.this._titleNodeMap.get(MultiplePageDialog.this._pageList.getCurrentPage().getFullTitle())) != null) {
                    ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
                    while (treeNode != null) {
                        arrayList.add(0, treeNode);
                        treeNode = treeNode.getParent();
                    }
                    TreePath treePath = new TreePath(arrayList.toArray(new TreeNode[arrayList.size()]));
                    MultiplePageDialog.this._tree.getSelectionModel().setSelectionPath(treePath);
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this._tree), "Center");
        return jPanel;
    }

    protected JTree createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        UIManager.put("Tree.hash", Color.white);
        return new JTree(defaultMutableTreeNode);
    }

    protected void configureTree(final JTree jTree) {
        jTree.setToggleClickCount(1);
        jTree.setCellRenderer(this.createTreeCellRenderer());
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(false);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                if (jTree.getSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getSelectionPath().getLastPathComponent();
                while (!defaultMutableTreeNode.isLeaf()) {
                    object = defaultMutableTreeNode;
                    Runnable runnable = new Runnable((DefaultMutableTreeNode)object){
                        final /* synthetic */ DefaultMutableTreeNode val$tn;
                        {
                            this.val$tn = defaultMutableTreeNode;
                        }

                        public void run() {
                            jTree.expandPath(new TreePath(this.val$tn.getPath()));
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                }
                object = defaultMutableTreeNode.getUserObject();
                if (object instanceof AbstractDialogPage && !object.equals(MultiplePageDialog.this.getCurrentPage()) && ((AbstractDialogPage)object).isPageEnabled()) {
                    MultiplePageDialog.this.setCurrentPage((AbstractDialogPage)object, jTree);
                    if (MultiplePageDialog.this.getCurrentPage() != object) {
                        // empty if block
                    }
                }
            }
        });
    }

    private void addPage(final AbstractDialogPage abstractDialogPage, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (abstractDialogPage == null) {
            return;
        }
        final MutableTreeNode mutableTreeNode = this.createTreeNode(abstractDialogPage);
        if (mutableTreeNode instanceof MutableTreeNodeEx) {
            ((MutableTreeNodeEx)mutableTreeNode).setEnabled(abstractDialogPage.isPageEnabled());
        }
        if (abstractDialogPage.getParentPage() == null) {
            this._titleNodeMap.put(abstractDialogPage.getFullTitle(), mutableTreeNode);
            defaultMutableTreeNode.add(mutableTreeNode);
            if (bl) {
                ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getIndex(mutableTreeNode)});
            }
        } else {
            this._titleNodeMap.put(abstractDialogPage.getFullTitle(), mutableTreeNode);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this._titleNodeMap.get(abstractDialogPage.getParentPage().getFullTitle());
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode2.add(mutableTreeNode);
                if (bl) {
                    ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(defaultMutableTreeNode2, new int[]{defaultMutableTreeNode2.getIndex(mutableTreeNode)});
                }
            }
        }
        abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("icon".equals(propertyChangeEvent.getPropertyName()) && mutableTreeNode instanceof MutableTreeNodeEx) {
                    ((MutableTreeNodeEx)mutableTreeNode).setEnabled(abstractDialogPage.isPageEnabled());
                }
            }
        });
    }

    protected MutableTreeNode createTreeNode(AbstractDialogPage abstractDialogPage) {
        return new MutableTreeNodeEx(abstractDialogPage);
    }

    private JComponent createListPanel() {
        JPanel jPanel;
        final DefaultListModel<AbstractDialogPage> defaultListModel = new DefaultListModel<AbstractDialogPage>();
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            jPanel = this._pageList.getPage(i);
            defaultListModel.addElement((AbstractDialogPage)jPanel);
        }
        final JList jList = this.createList(defaultListModel);
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(0);
        }
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList.getSelectedValue() == MultiplePageDialog.this.getCurrentPage()) {
                    return;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AbstractDialogPage abstractDialogPage = (AbstractDialogPage)jList.getSelectedValue();
                    if (abstractDialogPage != null) {
                        MultiplePageDialog.this.setCurrentPage(abstractDialogPage, jList);
                        if (MultiplePageDialog.this.getCurrentPage() != abstractDialogPage) {
                            jList.setSelectedValue(MultiplePageDialog.this.getCurrentPage(), true);
                        }
                    } else {
                        jList.setSelectedIndex(listSelectionEvent.getLastIndex());
                    }
                }
            }
        });
        jList.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 10));
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    AbstractDialogPage abstractDialogPage = MultiplePageDialog.this._pageList.getPage(i);
                    defaultListModel.add(i, abstractDialogPage);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                    defaultListModel.remove(i);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1 && listDataEvent.getType() == 0 && MultiplePageDialog.this._pageList.getCurrentPage() != null) {
                    int n = MultiplePageDialog.this._pageList.getPageIndexByFullTitle(MultiplePageDialog.this._pageList.getCurrentPage().getFullTitle());
                    jList.setSelectedIndex(n);
                }
            }
        });
        jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)new JideScrollPane(jList), "Center");
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected JList createList(DefaultListModel defaultListModel) {
        JList jList = new JList(defaultListModel);
        jList.setCellRenderer(this.createListCellRenderer());
        jList.setSelectionMode(0);
        return jList;
    }

    protected JComponent createIconPanel() {
        final ButtonPanel buttonPanel = this.createIconButtonPanel();
        buttonPanel.setGroupGap(0);
        buttonPanel.setButtonGap(0);
        final ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            final AbstractDialogPage abstractDialogPage = this._pageList.getPage(i);
            final JideButton jideButton = this.createIconButton(abstractDialogPage.getTitle(), abstractDialogPage.getIcon());
            jideButton.setToolTipText(abstractDialogPage.getDescription());
            jideButton.setEnabled(abstractDialogPage.isPageEnabled());
            jideButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 4451059166068761678L;

                public void actionPerformed(ActionEvent actionEvent) {
                    MultiplePageDialog.this.setCurrentPage(abstractDialogPage, buttonPanel);
                    if (MultiplePageDialog.this.getCurrentPage() == abstractDialogPage) {
                        buttonGroup.setSelected(jideButton.getModel(), true);
                    }
                }
            });
            abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setEnabled(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                    } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setIcon((Icon)propertyChangeEvent.getNewValue());
                    } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setText((String)propertyChangeEvent.getNewValue());
                    } else if ("description".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setToolTipText((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
            buttonPanel.addButton(jideButton);
            buttonGroup.add(jideButton);
            if (this._pageList.getPageCount() <= 0) continue;
            if (this.getInitialPageTitle() != null && this.getInitialPageTitle().equals(abstractDialogPage.getFullTitle())) {
                buttonGroup.setSelected(jideButton.getModel(), true);
                continue;
            }
            if (this.getInitialPageTitle() != null || i != 0) continue;
            buttonGroup.setSelected(jideButton.getModel(), true);
        }
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(buttonPanel){

            public Dimension getPreferredSize() {
                if (buttonPanel.getAlignment() == 1 || buttonPanel.getAlignment() == 3) {
                    return new Dimension(buttonPanel.getPreferredSize().width + this.getVerticalScrollBar().getPreferredSize().width, 5);
                }
                return new Dimension(5, buttonPanel.getPreferredSize().height + this.getHorizontalScrollBar().getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        if (buttonPanel.getAlignment() == 1 || buttonPanel.getAlignment() == 3) {
            jScrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            jScrollPane.setVerticalScrollBarPolicy(21);
        }
        buttonPanel.setOpaque(false);
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    MultiplePageDialog.this.addPage(i, buttonGroup, buttonPanel);
                }
                buttonPanel.invalidate();
                buttonPanel.doLayout();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                    AbstractButton abstractButton = (AbstractButton)buttonPanel.getComponent(i);
                    buttonPanel.remove(abstractButton);
                    buttonGroup.remove(abstractButton);
                }
                buttonPanel.invalidate();
                buttonPanel.doLayout();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                AbstractButton abstractButton;
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1 && listDataEvent.getType() == 0 && (abstractButton = (AbstractButton)buttonPanel.getButtonByName(MultiplePageDialog.this._pageList.getCurrentPage().getTitle())) != null) {
                    buttonGroup.setSelected(abstractButton.getModel(), true);
                }
            }
        });
        jScrollPane.getViewport().setOpaque(false);
        return jScrollPane;
    }

    protected ButtonPanel createIconButtonPanel() {
        return new ScrollableButtonPanel(1, 0);
    }

    private JideButton addPage(int n, final ButtonGroup buttonGroup, final ButtonPanel buttonPanel) {
        AbstractDialogPage abstractDialogPage = this._pageList.getPage(n);
        final JideButton jideButton = this.createIconButton(abstractDialogPage.getTitle(), abstractDialogPage.getIcon());
        jideButton.addActionListener(new AbstractAction(abstractDialogPage.getTitle(), abstractDialogPage.getIcon()){
            private static final long serialVersionUID = 5987367362274303556L;

            public void actionPerformed(ActionEvent actionEvent) {
                buttonGroup.setSelected(jideButton.getModel(), true);
                MultiplePageDialog.this.setCurrentPage(MultiplePageDialog.this._pageList.getPageByFullTitle(actionEvent.getActionCommand()), buttonPanel);
            }
        });
        buttonPanel.addButton((AbstractButton)jideButton, n);
        buttonGroup.add(jideButton);
        return jideButton;
    }

    protected JideButton createIconButton(String string, Icon icon) {
        JideButton jideButton = new JideButton(string, icon);
        jideButton.setName(string);
        jideButton.setHorizontalAlignment(0);
        jideButton.setVerticalTextPosition(3);
        jideButton.setHorizontalTextPosition(0);
        jideButton.setRequestFocusEnabled(false);
        jideButton.setFocusable(false);
        return jideButton;
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int n) {
        if (n != 0 && n != 2 && n != 3 && n != 1) {
            throw new IllegalArgumentException("The value of style must be one of the following - TAB_STYLE, ICON_STYLE, LIST_STYLE or TREE_STYLE");
        }
        this._style = n;
    }

    public JComponent getIndexPanel() {
        return this._indexPanel;
    }

    public JComponent getPagesPanel() {
        return this._pagesPanel;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        return this._treeCellRenderer;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this._treeCellRenderer = treeCellRenderer;
    }

    protected ListCellRenderer getListCellRenderer() {
        return this._listCellRenderer;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this._listCellRenderer = listCellRenderer;
    }

    protected ListCellRenderer createListCellRenderer() {
        if (this.getListCellRenderer() == null) {
            this.setListCellRenderer(new DialogPageListCellRenderer());
        }
        return this.getListCellRenderer();
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        if (this.getTreeCellRenderer() == null) {
            this.setTreeCellRenderer(new DialogPageTreeCellRenderer());
        }
        return this.getTreeCellRenderer();
    }

    public String getInitialPageTitle() {
        return this._initialPageTitle;
    }

    public void setInitialPageTitle(String string) {
        this._initialPageTitle = string;
    }
}

