/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;

public class Audio {
    public static final int PSP_AUDIO_VOLUME_MIN = 0;
    public static final int PSP_AUDIO_VOLUME_MAX = 32768;
    public static final int PSP_AUDIO_VOLUME_STEP = 256;
    private static int volume = 32768;
    private static boolean muted;
    private static AudioMutedSettingsListerner audioMutedSettingsListerner;

    public static int getVolume() {
        return volume;
    }

    public static void setVolume(int volume) {
        if (volume > 32768) {
            volume = 32768;
        } else if (volume < 0) {
            volume = 0;
        }
        Audio.volume = volume;
    }

    private static void init() {
        if (audioMutedSettingsListerner == null) {
            audioMutedSettingsListerner = new AudioMutedSettingsListerner();
            Settings.getInstance().registerSettingsListener("HardwareAudio", "emu.mutesound", audioMutedSettingsListerner);
        }
    }

    public static boolean isMuted() {
        Audio.init();
        return muted;
    }

    public static void setMuted(boolean muted) {
        Audio.init();
        Audio.muted = muted;
    }

    public static void setVolumeUp() {
        Audio.setVolume(volume + 256);
    }

    public static void setVolumeDown() {
        Audio.setVolume(volume - 256);
    }

    public static int getVolume(int volume) {
        if (Audio.isMuted()) {
            volume = 0;
        } else if ((volume = volume * Audio.getVolume() / 32768) < 0) {
            volume = 0;
        } else if (volume > 32768) {
            volume = 32768;
        }
        return volume;
    }

    private static class AudioMutedSettingsListerner
    extends AbstractBoolSettingsListener {
        private AudioMutedSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            Audio.setMuted(value);
        }
    }
}

