/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.SeekableDataInputVirtualFile;
import jpcsp.HLE.VFS.crypto.EDATVirtualFile;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.HLE.modules.ModuleMgrForUser;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.settings.AbstractBoolSettingsListener;
import org.apache.log4j.Logger;

public class scePspNpDrm_user
extends HLEModule {
    public static Logger log = Modules.getLogger("scePspNpDrm_user");
    public static final int PSP_NPDRM_KEY_LENGHT = 16;
    private byte[] npDrmKey = new byte[16];
    private boolean isNpDrmKeySet = false;
    private boolean disableDLCDecryption;

    @Override
    public void start() {
        this.setSettingsListener("emu.disableDLC", new DisableDLCSettingsListerner());
        super.start();
    }

    public void setDisableDLCStatus(boolean status) {
        this.disableDLCDecryption = status;
    }

    public boolean getDisableDLCStatus() {
        return this.disableDLCDecryption;
    }

    protected void setNpDrmKeyStatus(boolean status) {
        this.isNpDrmKeySet = status;
    }

    protected boolean getNpDrmKeyStatus() {
        return this.isNpDrmKeySet;
    }

    @HLEFunction(nid=-1590468463, version=150, checkInsideInterrupt=true)
    public int sceNpDrmSetLicenseeKey(TPointer npDrmKeyAddr) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            this.npDrmKey[i] = npDrmKeyAddr.getValue8(i);
            key.append(String.format("%02X", this.npDrmKey[i] & 0xFF));
        }
        this.setNpDrmKeyStatus(true);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("NPDRM Encryption key detected: 0x%s", key.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-1686874814, version=150, checkInsideInterrupt=true)
    public int sceNpDrmClearLicenseeKey() {
        Arrays.fill(this.npDrmKey, (byte)0);
        this.setNpDrmKeyStatus(false);
        return 0;
    }

    @HLEFunction(nid=660178897, version=150, checkInsideInterrupt=true)
    public int sceNpDrmRenameCheck(PspString fileName) {
        CryptoEngine crypto = new CryptoEngine();
        int result = 0;
        if (!this.getNpDrmKeyStatus()) {
            result = -2141910762;
        } else {
            try {
                String pcfilename = Modules.IoFileMgrForUserModule.getDeviceFilePath(fileName.getString());
                SeekableRandomFile file = new SeekableRandomFile(pcfilename, "r");
                String[] name = pcfilename.split("/");
                String fName = name[name.length - 1];
                for (int i = 0; i < name.length; ++i) {
                    if (!name[i].toUpperCase().contains("EDAT")) continue;
                    fName = name[i];
                }
                if (file.length() < 128L) {
                    if (!this.getDisableDLCStatus()) {
                        log.warn((Object)"sceNpDrmRenameCheck: invalid file size");
                        result = -2141910783;
                    }
                    file.close();
                } else {
                    byte[] inBuf = new byte[128];
                    byte[] srcData = new byte[48];
                    byte[] srcHash = new byte[16];
                    file.readFully(inBuf);
                    file.close();
                    System.arraycopy(inBuf, 16, srcData, 0, 48);
                    System.arraycopy(inBuf, 64, srcHash, 0, 16);
                    if (!crypto.getPGDEngine().CheckEDATRenameKey(fName.getBytes(), srcHash, srcData) && !this.getDisableDLCStatus()) {
                        result = -2141910761;
                        log.warn((Object)"sceNpDrmRenameCheck: the file has been renamed");
                    }
                }
            }
            catch (FileNotFoundException e) {
                result = -2141910783;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNpDrmRenameCheck: file '%s' not found: %s", fileName.getString(), e.toString()));
                }
            }
            catch (Exception e) {
                log.error((Object)"sceNpDrmRenameCheck", (Throwable)e);
            }
        }
        return result;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=148474004, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataSetupKey(int edataFd) {
        if (!this.getNpDrmKeyStatus()) {
            return -2141910762;
        }
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        if (info == null) {
            return -1;
        }
        int result = 0;
        if (!this.getDisableDLCStatus()) {
            EDATVirtualFile pgdFile;
            IVirtualFile vFile = info.vFile;
            if (vFile == null && info.readOnlyFile != null) {
                vFile = new SeekableDataInputVirtualFile(info.readOnlyFile);
            }
            if ((pgdFile = new EDATVirtualFile(vFile)).isValid()) {
                info.vFile = pgdFile;
            }
        }
        return result;
    }

    @HLEFunction(nid=564065740, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataGetDataSize(int edataFd) {
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        int size = 0;
        if (info != null) {
            if (info.vFile != null) {
                size = (int)info.vFile.length();
            } else if (info.readOnlyFile != null) {
                try {
                    size = (int)info.readOnlyFile.length();
                }
                catch (IOException e) {
                    log.error((Object)"sceNpDrmEdataGetDataSize", (Throwable)e);
                }
            }
        }
        return size;
    }

    @HLEUnimplemented
    @HLEFunction(nid=732578452, version=150, checkInsideInterrupt=true)
    public int sceNpDrmOpen(PspString name, int flags, int permissions) {
        if (!this.getNpDrmKeyStatus()) {
            return -2141910762;
        }
        int fd = Modules.IoFileMgrForUserModule.hleIoOpen(name, flags | 0x40000000, permissions, true);
        return this.sceNpDrmEdataSetupKey(fd);
    }

    @HLEFunction(nid=-971452239, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleNpDrm(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleNpDrm options: %s", lmOption));
            }
        }
        if (!this.getDisableDLCStatus()) {
            log.warn((Object)String.format("sceKernelLoadModuleNpDrm detected encrypted DLC module: %s", path.getString()));
            return -2141910766;
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.flags = flags;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunction(nid=-1436563365, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadExecNpDrm(PspString fileName, @CanBeNull TPointer optionAddr) {
        int result;
        Modules.SysMemUserForUserModule.reset();
        if (optionAddr.isNotNull()) {
            int optSize = optionAddr.getValue32(0);
            int argSize = optionAddr.getValue32(4);
            int argAddr = optionAddr.getValue32(8);
            int keyAddr = optionAddr.getValue32(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExecNpDrm (params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=0x%08X)", optSize, argSize, argAddr, keyAddr));
            }
        }
        if (!this.getDisableDLCStatus()) {
            log.warn((Object)String.format("sceKernelLoadModuleNpDrm detected encrypted DLC module: %s", fileName.getString()));
            return -2141910766;
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(fileName.getString(), 1);
            if (moduleInput != null) {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                SceModule module = Emulator.getInstance().load(fileName.getString(), moduleBuffer, true, Modules.ModuleMgrForUserModule.isSignChecked(fileName.getString()));
                Emulator.getClock().resume();
                if ((module.fileFormat & 1) == 1) {
                    result = 0;
                } else {
                    log.warn((Object)"sceKernelLoadExecNpDrm - failed, target is not an ELF");
                    result = -2147352244;
                }
            } else {
                result = -2147352249;
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)"sceKernelLoadExecNpDrm", (Throwable)e);
            result = -2147352249;
        }
        catch (IOException e) {
            log.error((Object)String.format("sceKernelLoadExecNpDrm - Error while loading module '%s'", fileName), (Throwable)e);
            result = -2147352249;
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-340682515, version=150)
    public int sceNpDrmDecActivation(TPointer unknown1, TPointer unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=400815291, version=150)
    public int sceNpDrmVerifyAct(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4152, usage=BufferInfo.Usage.in) TPointer actDatAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=934916365, version=150)
    public int sceNpDrmVerifyRif(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1707823969, version=150)
    public int sceNpDrm_9A34AC9F(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=261441510, version=150)
    public int sceNpDrmGetVersionKey(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer keyAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4152, usage=BufferInfo.Usage.in) TPointer actDatAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr, int type) {
        byte[] ebootKey = Modules.scePopsManModule.getEbootKey();
        if (ebootKey != null) {
            keyAddr.setArray(ebootKey);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1449637817, version=150)
    public int sceNpDrmGetContentKey(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer keyAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4152, usage=BufferInfo.Usage.in) TPointer actDatAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr) {
        return this.sceNpDrmGetVersionKey(keyAddr, actDatAddr, rifAddr, 0);
    }

    @HLEUnimplemented
    @HLEFunction(nid=763922330, version=150)
    public int sceNpDrm_2D88879A() {
        return 0;
    }

    private class DisableDLCSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableDLCSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            scePspNpDrm_user.this.setDisableDLCStatus(value);
        }
    }
}

