/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.mp3;

import jpcsp.media.codec.mp3.Context;
import jpcsp.media.codec.util.Dct32;

public class Mp3Dsp {
    public static final int MDCT_BUF_SIZE = 36;
    public static final float[][] mdct_win = new float[8][36];
    public static final float[] mpa_synth_window = new float[768];
    private static final float C1 = 0.49240386f;
    private static final float C2 = 0.4698463f;
    private static final float C3 = 0.4330127f;
    private static final float C4 = 0.38302222f;
    private static final float C5 = 0.32139382f;
    private static final float C7 = 0.17101008f;
    private static final float C8 = 0.08682409f;
    private static final float[] icos36 = new float[]{0.5019099f, 0.5176381f, 0.55168897f, 0.61038727f, 0.70710677f, 0.8717234f, 1.1831008f, 1.9318516f, 5.7368565f};
    private static final float[] icos36h = new float[]{0.25095496f, 0.25881904f, 0.27584448f, 0.30519363f, 0.35355338f, 0.4358617f, 0.2957752f, 0.4829629f};
    private static final int[] mpa_enwindow = new int[]{0, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -3, -3, -4, -4, -5, -5, -6, -7, -7, -8, -9, -10, -11, -13, -14, -16, -17, -19, -21, -24, -26, -29, -31, -35, -38, -41, -45, -49, -53, -58, -63, -68, -73, -79, -85, -91, -97, -104, -111, -117, -125, -132, -139, -147, -154, -161, -169, -176, -183, -190, -196, -202, -208, 213, 218, 222, 225, 227, 228, 228, 227, 224, 221, 215, 208, 200, 189, 177, 163, 146, 127, 106, 83, 57, 29, -2, -36, -72, -111, -153, -197, -244, -294, -347, -401, -459, -519, -581, -645, -711, -779, -848, -919, -991, -1064, -1137, -1210, -1283, -1356, -1428, -1498, -1567, -1634, -1698, -1759, -1817, -1870, -1919, -1962, -2001, -2032, -2057, -2075, -2085, -2087, -2080, -2063, 2037, 2000, 1952, 1893, 1822, 1739, 1644, 1535, 1414, 1280, 1131, 970, 794, 605, 402, 185, -45, -288, -545, -814, -1095, -1388, -1692, -2006, -2330, -2663, -3004, -3351, -3705, -4063, -4425, -4788, -5153, -5517, -5879, -6237, -6589, -6935, -7271, -7597, -7910, -8209, -8491, -8755, -8998, -9219, -9416, -9585, -9727, -9838, -9916, -9959, -9966, -9935, -9863, -9750, -9592, -9389, -9139, -8840, -8492, -8092, -7640, -7134, 6574, 5959, 5288, 4561, 3776, 2935, 2037, 1082, 70, -998, -2122, -3300, -4533, -5818, -7154, -8540, -9975, -11455, -12980, -14548, -16155, -17799, -19478, -21189, -22929, -24694, -26482, -28289, -30112, -31947, -33791, -35640, -37489, -39336, -41176, -43006, -44821, -46617, -48390, -50137, -51853, -53534, -55178, -56778, -58333, -59838, -61289, -62684, -64019, -65290, -66494, -67629, -68692, -69679, -70590, -71420, -72169, -72835, -73415, -73908, -74313, -74630, -74856, -74992, 75038};

    public static void initMpadspTabs() {
        for (int i = 0; i < 36; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j == 2 && i % 3 != 1) continue;
                double d = Math.sin(Math.PI * ((double)i + 0.5) / 36.0);
                if (j == 1) {
                    if (i >= 30) {
                        d = 0.0;
                    } else if (i >= 24) {
                        d = Math.sin(Math.PI * ((double)(i - 18) + 0.5) / 12.0);
                    } else if (i >= 18) {
                        d = 1.0;
                    }
                } else if (j == 3) {
                    if (i < 6) {
                        d = 0.0;
                    } else if (i < 12) {
                        d = Math.sin(Math.PI * ((double)(i - 6) + 0.5) / 12.0);
                    } else if (i < 18) {
                        d = 1.0;
                    }
                }
                d *= (double)0.8795f / Math.cos(Math.PI * (double)(2 * i + 19) / 72.0);
                if (j == 2) {
                    Mp3Dsp.mdct_win[j][i / 3] = (float)(d / 32.0);
                    continue;
                }
                int idx = i < 18 ? i : i + 0;
                Mp3Dsp.mdct_win[j][idx] = (float)(d / 32.0);
            }
        }
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 36; i += 2) {
                Mp3Dsp.mdct_win[j + 4][i] = mdct_win[j][i];
                Mp3Dsp.mdct_win[j + 4][i + 1] = -mdct_win[j][i + 1];
            }
        }
    }

    public static void synthInit(float[] window) {
        int i;
        for (i = 0; i < 257; ++i) {
            float v = mpa_enwindow[i];
            window[i] = v *= 1.8189894E-12f;
            if ((i & 0x3F) != 0) {
                v = -v;
            }
            if (i == 0) continue;
            window[512 - i] = v;
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 16; ++j) {
                window[512 + 16 * i + j] = window[64 * i + 32 - j];
            }
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 16; ++j) {
                window[640 + 16 * i + j] = window[64 * i + 48 - j];
            }
        }
    }

    private static void applyWindow(float[] synthBuf, int synthBufOffset, float[] window, int[] ditherState, float[] samples, int samplesOffset, int incr) {
        int i;
        System.arraycopy(synthBuf, synthBufOffset, synthBuf, synthBufOffset + 512, 32);
        int samples2 = samplesOffset + 31 * incr;
        int w = 0;
        int w2 = 31;
        float sum = ditherState[0];
        int p = synthBufOffset + 16;
        for (i = 0; i < 8; ++i) {
            sum += window[w + i * 64] * synthBuf[p + i * 64];
        }
        p = synthBufOffset + 48;
        for (i = 0; i < 8; ++i) {
            sum -= window[w + 32 + i * 64] * synthBuf[p + i * 64];
        }
        samples[samplesOffset] = sum;
        sum = 0.0f;
        samplesOffset += incr;
        ++w;
        for (int j = 1; j < 16; ++j) {
            float tmp;
            int i2;
            float sum2 = 0.0f;
            sum = 0.0f;
            p = synthBufOffset + 16 + j;
            for (i2 = 0; i2 < 8; ++i2) {
                tmp = synthBuf[p + i2 * 64];
                sum += window[w + i2 * 64] * tmp;
                sum2 -= window[w2 + i2 * 64] * tmp;
            }
            p = synthBufOffset + 48 - j;
            for (i2 = 0; i2 < 8; ++i2) {
                tmp = synthBuf[p + i2 * 64];
                sum -= window[w + 32 + i2 * 64] * tmp;
                sum2 -= window[w2 + 32 + i2 * 64] * tmp;
            }
            samples[samplesOffset] = sum;
            samplesOffset += incr;
            samples[samples2] = sum2;
            samples2 -= incr;
            ++w;
            --w2;
        }
        p = synthBufOffset + 32;
        sum = 0.0f;
        for (i = 0; i < 8; ++i) {
            sum -= window[w + 32 + i * 64] * synthBuf[p + i * 64];
        }
        samples[samplesOffset] = sum;
        sum = 0.0f;
        ditherState[0] = (int)sum;
    }

    public static void synthFilter(Context ctx, int ch, float[] samples, int samplesOffset, int incr, float[] sbSamples, int sbSamplesOffset) {
        int offset = ctx.synthBufOffset[ch];
        Dct32.dct32(ctx.synthBuf[ch], offset, sbSamples, sbSamplesOffset);
        Mp3Dsp.applyWindow(ctx.synthBuf[ch], offset, mpa_synth_window, ctx.ditherState, samples, samplesOffset, incr);
        ctx.synthBufOffset[ch] = offset = offset - 32 & 0x1FF;
    }

    private static void imdct36(float[] out, int outOffset, float[] buf, int bufOffset, float[] in, int inOffset, float[] win) {
        int i;
        float[] tmp = new float[18];
        for (i = 17; i >= 1; --i) {
            int n = inOffset + i;
            in[n] = in[n] + in[inOffset + i - 1];
        }
        for (i = 17; i >= 3; i -= 2) {
            int n = inOffset + i;
            in[n] = in[n] + in[inOffset + i - 2];
        }
        for (int j = 0; j < 2; ++j) {
            int tmp1 = j;
            int in1 = inOffset + j;
            float t2 = in[in1 + 8] + in[in1 + 16] - in[in1 + 4];
            float t3 = in[in1 + 0] + in[in1 + 12] * 0.5f;
            float t1 = in[in1 + 0] - in[in1 + 12];
            tmp[tmp1 + 6] = t1 - t2 * 0.5f;
            tmp[tmp1 + 16] = t1 + t2;
            float t0 = (in[in1 + 4] + in[in1 + 8]) * 0.4698463f * 2.0f;
            t1 = (in[in1 + 8] - in[in1 + 16]) * 0.08682409f * -2.0f;
            t2 = (in[in1 + 4] + in[in1 + 16]) * 0.38302222f * -2.0f;
            tmp[tmp1 + 10] = t3 - t0 - t2;
            tmp[tmp1 + 2] = t3 + t0 + t1;
            tmp[tmp1 + 14] = t3 + t2 - t1;
            tmp[tmp1 + 4] = (in[in1 + 10] + in[in1 + 14] - in[in1 + 2]) * 0.4330127f * -2.0f;
            t2 = (in[in1 + 2] + in[in1 + 10]) * 0.49240386f * 2.0f;
            t3 = (in[in1 + 10] - in[in1 + 14]) * 0.17101008f * -2.0f;
            t0 = in[in1 + 6] * 0.4330127f * 2.0f;
            t1 = (in[in1 + 2] + in[in1 + 14]) * 0.32139382f * -2.0f;
            tmp[tmp1 + 0] = t2 + t3 + t0;
            tmp[tmp1 + 12] = t2 + t1 - t0;
            tmp[tmp1 + 8] = t3 - t1 - t0;
        }
        i = 0;
        for (int j = 0; j < 4; ++j) {
            float t0 = tmp[i];
            float t1 = tmp[i + 2];
            float s0 = t1 + t0;
            float s2 = t1 - t0;
            float t2 = tmp[i + 1];
            float t3 = tmp[i + 3];
            float s1 = (t3 + t2) * icos36h[j] * 2.0f;
            float s3 = (t3 - t2) * icos36[8 - j];
            t0 = s0 + s1;
            t1 = s0 - s1;
            out[outOffset + (9 + j) * 32] = t1 * win[9 + j] + buf[bufOffset + 4 * (9 + j)];
            out[outOffset + (8 - j) * 32] = t1 * win[8 - j] + buf[bufOffset + 4 * (8 - j)];
            buf[bufOffset + 4 * (9 + j)] = t0 * win[27 + j];
            buf[bufOffset + 4 * (8 - j)] = t0 * win[26 - j];
            t0 = s2 + s3;
            t1 = s2 - s3;
            out[outOffset + (17 - j) * 32] = t1 * win[17 - j] + buf[bufOffset + 4 * (17 - j)];
            out[outOffset + j * 32] = t1 * win[j] + buf[bufOffset + 4 * j];
            buf[bufOffset + 4 * (17 - j)] = t0 * win[35 - j];
            buf[bufOffset + 4 * j] = t0 * win[18 + j];
            i += 4;
        }
        float s0 = tmp[16];
        float s1 = tmp[17] * icos36h[4] * 2.0f;
        float t0 = s0 + s1;
        float t1 = s0 - s1;
        out[outOffset + 416] = t1 * win[13] + buf[bufOffset + 52];
        out[outOffset + 128] = t1 * win[4] + buf[bufOffset + 16];
        buf[bufOffset + 52] = t0 * win[31];
        buf[bufOffset + 16] = t0 * win[22];
    }

    public static void imdct36Blocks(float[] out, int outOffset, float[] buf, int bufOffset, float[] in, int inOffset, int count, int switchPoint, int blockType) {
        for (int j = 0; j < count; ++j) {
            int winIdx = switchPoint != 0 && j < 2 ? 0 : blockType;
            float[] win = mdct_win[winIdx + (4 & -(j & 1))];
            Mp3Dsp.imdct36(out, outOffset, buf, bufOffset, in, inOffset, win);
            inOffset += 18;
            bufOffset += (j & 3) != 3 ? 1 : 69;
            ++outOffset;
        }
    }
}

