/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.object;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import jpcsp.Emulator;
import jpcsp.format.RCO;
import jpcsp.format.rco.Display;
import jpcsp.format.rco.ObjectField;
import jpcsp.format.rco.RCOContext;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.type.BaseType;
import jpcsp.format.rco.type.EventType;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXString;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import jpcsp.format.rco.vsmx.objects.Controller;
import jpcsp.scheduler.Scheduler;
import org.apache.log4j.Logger;

public abstract class BaseObject
extends BaseNativeObject {
    protected Logger log = VSMX.log;
    protected Display display;
    protected Controller controller;
    private String name;

    private Field[] getFields() {
        return this.getClass().getFields();
    }

    private Field[] getSortedFields() {
        Field[] fields = this.getFields();
        Arrays.sort(fields, new FieldComparator());
        return fields;
    }

    public void read(RCOContext context) {
        Field[] fields;
        for (Field field : fields = this.getSortedFields()) {
            if (!BaseType.class.isAssignableFrom(field.getType())) continue;
            try {
                BaseType baseType = (BaseType)field.get(this);
                if (baseType == null) {
                    baseType = (BaseType)field.getType().newInstance();
                    field.set(this, baseType);
                }
                baseType.read(context);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public int size() {
        Field[] fields;
        int size = 0;
        for (Field field : fields = this.getSortedFields()) {
            if (!BaseType.class.isAssignableFrom(field.getType())) continue;
            try {
                BaseType baseType = (BaseType)field.get(this);
                if (baseType == null) {
                    baseType = (BaseType)field.getType().newInstance();
                }
                size += baseType.size();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return size;
    }

    public VSMXBaseObject createVSMXObject(VSMXInterpreter interpreter, VSMXBaseObject parent, RCO.RCOEntry entry) {
        VSMXNativeObject object = new VSMXNativeObject(interpreter, this);
        this.setObject(object);
        entry.vsmxBaseObject = object;
        if (entry.label != null) {
            this.name = entry.label;
            object.setPropertyValue("name", (VSMXBaseObject)new VSMXString(interpreter, entry.label));
            parent.setPropertyValue(entry.label, (VSMXBaseObject)object);
        }
        if (entry.parent != null && entry.parent.vsmxBaseObject instanceof VSMXNativeObject) {
            this.setParent(((VSMXNativeObject)entry.parent.vsmxBaseObject).getObject());
        }
        return object;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void onDisplayUpdated() {
        this.display.repaint();
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    protected static Scheduler getScheduler() {
        return Emulator.getScheduler();
    }

    public String getName() {
        return this.name;
    }

    protected void trigger(EventType event) {
        if (event.getEvent() != null) {
            this.controller.getInterpreter().interpretScript(this.getObject(), event.getEvent());
        } else if (event.getObject() != null && event.getObject() instanceof BasePositionObject) {
            ((BasePositionObject)event.getObject()).setFocus();
        }
    }

    public void init(RCOContext context) {
        Field[] fields;
        for (Field field : fields = this.getFields()) {
            if (!BaseType.class.isAssignableFrom(field.getType())) continue;
            try {
                BaseType baseType = (BaseType)field.get(this);
                if (baseType == null) continue;
                baseType.init(context);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    protected void toString(StringBuilder s) {
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        Field[] fields = this.getSortedFields();
        s.append(String.format("%s[name=%s", this.getClass().getSimpleName(), this.name));
        boolean firstField = false;
        for (Field field : fields) {
            if (!BaseType.class.isAssignableFrom(field.getType())) continue;
            try {
                BaseType baseType = (BaseType)field.get(this);
                if (firstField) {
                    firstField = false;
                } else {
                    s.append(", ");
                }
                s.append(String.format("%s=(%s)", field.getName(), baseType));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.toString(s);
        s.append("]");
        return s.toString();
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f1, Field f2) {
            ObjectField o1 = f1.getAnnotation(ObjectField.class);
            ObjectField o2 = f2.getAnnotation(ObjectField.class);
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.order() - o2.order();
        }
    }
}

