/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspFileBuffer;
import jpcsp.HLE.modules.sceAudiocodec;
import jpcsp.Memory;
import jpcsp.media.codec.mp3.Mp3Decoder;
import jpcsp.media.codec.mp3.Mp3Header;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMp3
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMp3");
    private Mp3Info[] ids;
    private static final int ID3 = 0x334449;
    private static final int TAG_Xing = 1735289176;
    private static final int TAG_Info = 1868983881;
    private static final int TAG_VBRI = 1230127702;
    private static final int[][] infoTagOffsets = new int[][]{{17, 32}, {9, 17}};
    private static final int mp3DecodeDelay = 4000;
    private static final int maxSamplesBytesStereo = 4608;

    @Override
    public void start() {
        this.ids = new Mp3Info[2];
        for (int i = 0; i < this.ids.length; ++i) {
            this.ids[i] = new Mp3Info(i);
        }
        super.start();
    }

    public int checkId(int id) {
        if (this.ids == null || this.ids.length == 0) {
            throw new SceKernelErrorException(-2140729343);
        }
        if (id < 0 || id >= this.ids.length) {
            throw new SceKernelErrorException(-2140729343);
        }
        return id;
    }

    public int checkInitId(int id) {
        if (!this.ids[id = this.checkId(id)].isReserved()) {
            throw new SceKernelErrorException(-2140729085);
        }
        return id;
    }

    public Mp3Info getMp3Info(int id) {
        return this.ids[id];
    }

    public static boolean isMp3Magic(int magic) {
        return (magic & 0xE0FF) == 57599;
    }

    public int getFreeMp3Id() {
        int id = -1;
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i].isReserved()) continue;
            id = i;
            break;
        }
        if (id < 0) {
            return -1;
        }
        return id;
    }

    @HLEFunction(nid=132919834, version=150, checkInsideInterrupt=true)
    public int sceMp3ReserveMp3Handle(@CanBeNull TPointer parameters) {
        int id;
        long startPos = 0L;
        long endPos = 0L;
        int bufferAddr = 0;
        int bufferSize = 0;
        int outputAddr = 0;
        int outputSize = 0;
        if (parameters.isNotNull()) {
            startPos = parameters.getValue64(0);
            endPos = parameters.getValue64(8);
            bufferAddr = parameters.getValue32(16);
            bufferSize = parameters.getValue32(20);
            outputAddr = parameters.getValue32(24);
            outputSize = parameters.getValue32(28);
            if (bufferAddr == 0 || outputAddr == 0) {
                return -2140729342;
            }
            if (startPos < 0L || startPos > endPos) {
                return -2140729341;
            }
            if (bufferSize < 8192 || outputSize < 9216) {
                return -2140729341;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3ReserveMp3Handle parameters: startPos=0x%X, endPos=0x%X, bufferAddr=0x%08X, bufferSize=0x%X, outputAddr=0x%08X, outputSize=0x%X", startPos, endPos, bufferAddr, bufferSize, outputAddr, outputSize));
        }
        if ((id = this.getFreeMp3Id()) < 0) {
            return id;
        }
        this.ids[id].reserve(bufferAddr, bufferSize, outputAddr, outputSize, startPos, endPos);
        return id;
    }

    @HLEFunction(nid=229722612, version=150, checkInsideInterrupt=true)
    public int sceMp3NotifyAddStreamData(@CheckArgument(value="checkInitId") int id, int bytesToAdd) {
        return this.getMp3Info(id).notifyAddStream(bytesToAdd);
    }

    @HLEFunction(nid=708216417, version=150, checkInsideInterrupt=true)
    public int sceMp3ResetPlayPosition(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).resetPlayPosition(0);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=896860272, version=150, checkInsideInterrupt=true)
    public int sceMp3InitResource() {
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1009754200, version=150, checkInsideInterrupt=true)
    public int sceMp3TermResource() {
        return 0;
    }

    @HLEFunction(nid=1022314575, version=150, checkInsideInterrupt=true)
    public int sceMp3SetLoopNum(@CheckArgument(value="checkInitId") int id, int loopNum) {
        this.getMp3Info(id).setLoopNum(loopNum);
        return 0;
    }

    @HLEFunction(nid=1155559721, version=150, checkInsideInterrupt=true)
    public int sceMp3Init(@CheckArgument(value="checkId") int id) {
        Mp3Info mp3Info = this.getMp3Info(id);
        mp3Info.init();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Initializing Mp3 data: channels=%d, samplerate=%dkHz, bitrate=%dkbps.", mp3Info.getChannelNum(), mp3Info.getSampleRate(), mp3Info.getBitRate()));
        }
        return 0;
    }

    @HLEFunction(nid=2137614210, version=150, checkInsideInterrupt=true)
    public int sceMp3GetMp3ChannelNum(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).getChannelNum();
    }

    @HLEFunction(nid=-1891300968, version=150, checkInsideInterrupt=true)
    public int sceMp3GetSamplingRate(@CheckArgument(value="checkInitId") int id) {
        Mp3Info mp3Info = this.getMp3Info(id);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetSamplingRate returning 0x%X", mp3Info.getSampleRate()));
        }
        return mp3Info.getSampleRate();
    }

    @HLEFunction(nid=-1492910577, version=150, checkInsideInterrupt=true)
    public int sceMp3GetInfoToAddStreamData(@CheckArgument(value="checkInitId") int id, @CanBeNull TPointer32 writeAddr, @CanBeNull TPointer32 writableBytesAddr, @CanBeNull TPointer32 readOffsetAddr) {
        Mp3Info info = this.getMp3Info(id);
        writeAddr.setValue(info.getInputBuffer().getWriteAddr());
        writableBytesAddr.setValue(info.getWritableBytes());
        readOffsetAddr.setValue(info.getInputBuffer().getFilePosition());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetInfoToAddStreamData returning writeAddr=0x%08X, writableBytes=0x%X, readOffset=0x%X", writeAddr.getValue(), writableBytesAddr.getValue(), readOffsetAddr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=-803094277, version=150, checkInsideInterrupt=true)
    public int sceMp3Decode(@CheckArgument(value="checkInitId") int id, TPointer32 bufferAddress) {
        int result = this.getMp3Info(id).decode(bufferAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3Decode bufferAddress=%s(0x%08X) returning 0x%X", bufferAddress, bufferAddress.getValue(), result));
        }
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(4000, false);
        }
        return result;
    }

    @HLEFunction(nid=-794467690, version=150, checkInsideInterrupt=true)
    public boolean sceMp3CheckStreamDataNeeded(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).isStreamDataNeeded();
    }

    @HLEFunction(nid=-179862989, version=150, checkInsideInterrupt=true)
    public int sceMp3ReleaseMp3Handle(@CheckArgument(value="checkInitId") int id) {
        this.getMp3Info(id).release();
        return 0;
    }

    @HLEFunction(nid=894248938, version=150)
    public int sceMp3GetSumDecodedSample(@CheckArgument(value="checkInitId") int id) {
        int sumDecodedSamples = this.getMp3Info(id).getSumDecodedSamples();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetSumDecodedSample returning 0x%X", sumDecodedSamples));
        }
        return sumDecodedSamples;
    }

    @HLEFunction(nid=-2023260608, version=150, checkInsideInterrupt=true)
    public int sceMp3GetBitRate(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).getBitRate();
    }

    @HLEFunction(nid=-2017303599, version=150, checkInsideInterrupt=true)
    public int sceMp3GetMaxOutputSample(@CheckArgument(value="checkInitId") int id) {
        Mp3Info mp3Info = this.getMp3Info(id);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetMaxOutputSample returning 0x%X", mp3Info.getMaxSamples()));
        }
        return mp3Info.getMaxSamples();
    }

    @HLEFunction(nid=-655013295, version=150, checkInsideInterrupt=true)
    public int sceMp3GetLoopNum(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).getLoopNum();
    }

    @HLEFunction(nid=893955784, version=150)
    public int sceMp3GetFrameNum(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).getNumberOfFrames();
    }

    @HLEFunction(nid=-1368580057, version=150)
    public int sceMp3GetVersion(@CheckArgument(value="checkInitId") int id) {
        return this.getMp3Info(id).getVersion();
    }

    @HLEFunction(nid=138471432, version=150, checkInsideInterrupt=true)
    public int sceMp3ResetPlayPosition2(@CheckArgument(value="checkInitId") int id, int position) {
        return this.getMp3Info(id).resetPlayPosition(position);
    }

    @HLEFunction(nid=461609859, version=620)
    public int sceMp3LowLevelInit(@CheckArgument(value="checkInitId") int id, int unknown) {
        Mp3Info mp3Info = this.getMp3Info(id);
        mp3Info.getCodec().init(0, 2, 2, 0);
        return 0;
    }

    @HLEFunction(nid=-470930303, version=620)
    public int sceMp3LowLevelDecode(@CheckArgument(value="checkInitId") int id, TPointer sourceAddr, TPointer32 sourceBytesConsumedAddr, TPointer samplesAddr, TPointer32 sampleBytesAddr) {
        Mp3Info mp3Info = this.getMp3Info(id);
        int result = mp3Info.getCodec().decode(sourceAddr.getMemory(), sourceAddr.getAddress(), 10000, samplesAddr.getMemory(), samplesAddr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3LowLevelDecode result=0x%08X, samples=0x%X", result, mp3Info.getCodec().getNumberOfSamples()));
        }
        if (result < 0) {
            return -2140725247;
        }
        sourceBytesConsumedAddr.setValue(result);
        sampleBytesAddr.setValue(mp3Info.getCodec().getNumberOfSamples() * 4);
        return 0;
    }

    public static class Mp3Info
    extends sceAudiocodec.AudiocodecInfo {
        private static final int reservedBufferSize = 1472;
        private static final int minimumInputBufferSize = 1472;
        private boolean reserved;
        private pspFileBuffer inputBuffer;
        private int bufferAddr;
        private int outputAddr;
        private int outputSize;
        private int sumDecodedSamples;
        private int halfBufferSize;
        private int outputIndex;
        private int loopNum;
        private int startPos;
        private long endPos;
        private int sampleRate;
        private int bitRate;
        private int maxSamples;
        private int channels;
        private int version;
        private int numberOfFrames;

        public Mp3Info(int id) {
            super(id);
        }

        public boolean isReserved() {
            return this.reserved;
        }

        public void reserve(int bufferAddr, int bufferSize, int outputAddr, int outputSize, long startPos, long endPos) {
            this.reserved = true;
            this.bufferAddr = bufferAddr;
            this.outputAddr = outputAddr;
            this.outputSize = outputSize;
            this.startPos = (int)startPos;
            this.endPos = endPos;
            this.inputBuffer = new pspFileBuffer(bufferAddr + 1472, bufferSize - 1472, 0, this.startPos);
            this.inputBuffer.setFileMaxSize((int)endPos);
            this.loopNum = -1;
            this.initCodec();
            this.halfBufferSize = bufferSize - 1472 >> 1;
        }

        @Override
        public void release() {
            super.release();
            this.reserved = false;
        }

        public void initCodec() {
            this.initCodec(4098);
        }

        public int notifyAddStream(int bytesToAdd) {
            bytesToAdd = Math.min(bytesToAdd, this.getWritableBytes());
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("notifyAddStream inputBuffer %s: %s", this.inputBuffer, Utilities.getMemoryDump(this.inputBuffer.getWriteAddr(), bytesToAdd)));
            }
            this.inputBuffer.notifyWrite(bytesToAdd);
            return 0;
        }

        public pspFileBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public boolean isStreamDataNeeded() {
            boolean isDataNeeded = this.inputBuffer.isFileEnd() ? false : this.getWritableBytes() > 0;
            return isDataNeeded;
        }

        public int getSumDecodedSamples() {
            return this.sumDecodedSamples;
        }

        public int decode(TPointer32 outputBufferAddress) {
            int result;
            int decodeOutputAddr = this.outputAddr + this.outputIndex;
            if (this.inputBuffer.isFileEnd() && this.inputBuffer.getCurrentSize() <= 0) {
                int outputBytes = this.codec.getNumberOfSamples() * 4;
                Memory mem = Memory.getInstance();
                mem.memset(decodeOutputAddr, (byte)0, outputBytes);
                result = outputBytes;
            } else {
                int decodeInputAddr = this.inputBuffer.getReadAddr();
                int decodeInputLength = this.inputBuffer.getReadSize();
                if (decodeInputLength < 1472 && decodeInputLength < this.inputBuffer.getCurrentSize()) {
                    Memory mem = Memory.getInstance();
                    mem.memcpy(this.bufferAddr, decodeInputAddr, decodeInputLength);
                    int wrapLength = Math.min(this.inputBuffer.getCurrentSize(), 1472) - decodeInputLength;
                    mem.memcpy(this.bufferAddr + decodeInputLength, this.inputBuffer.getAddr(), wrapLength);
                    decodeInputAddr = this.bufferAddr;
                    decodeInputLength += wrapLength;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Decoding from 0x%08X, length=0x%X to 0x%08X, inputBuffer %s", decodeInputAddr, decodeInputLength, decodeOutputAddr, this.inputBuffer));
                }
                if ((result = this.codec.decode(outputBufferAddress.getMemory(), decodeInputAddr, decodeInputLength, outputBufferAddress.getMemory(), decodeOutputAddr)) < 0) {
                    result = -2140728318;
                } else {
                    int readSize = result;
                    int samples = this.codec.getNumberOfSamples();
                    int outputBytes = samples * this.outputChannels * 2;
                    this.inputBuffer.notifyRead(readSize);
                    this.sumDecodedSamples += samples;
                    this.outputIndex += outputBytes;
                    if (this.outputIndex + outputBytes > this.outputSize) {
                        this.outputIndex = 0;
                    }
                    result = outputBytes;
                }
                if (this.inputBuffer.isFileEnd() && this.loopNum != 0 && (this.inputBuffer.getCurrentSize() < 1472 || (long)(this.inputBuffer.getFilePosition() - this.inputBuffer.getCurrentSize()) > this.endPos)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Looping loopNum=%d", this.loopNum));
                    }
                    if (this.loopNum > 0) {
                        --this.loopNum;
                    }
                    this.resetPlayPosition(0);
                }
            }
            outputBufferAddress.setValue(decodeOutputAddr);
            return result;
        }

        public int getWritableBytes() {
            int writeSize = this.inputBuffer.getNoFileWriteSize();
            if (writeSize >= this.halfBufferSize) {
                return this.halfBufferSize;
            }
            return 0;
        }

        public int getLoopNum() {
            return this.loopNum;
        }

        public void setLoopNum(int loopNum) {
            this.loopNum = loopNum;
        }

        public int resetPlayPosition(int position) {
            this.inputBuffer.reset(0, this.startPos);
            this.sumDecodedSamples = 0;
            return 0;
        }

        private void parseMp3FrameHeader() {
            int startAddr;
            int headerAddr;
            Memory mem = Memory.getInstance();
            int header = Utilities.readUnaligned32(mem, headerAddr = (startAddr = this.inputBuffer.getAddr()));
            if ((header & 0xFFFFFF) == 0x334449) {
                int size = Utilities.endianSwap32(Utilities.readUnaligned32(mem, startAddr + 6));
                size = size & 0x7F | (size & 0x7F00) >> 1 | (size & 0x7F0000) >> 2 | (size & 0x7F000000) >> 3;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Skipping ID3 of size 0x%X", size));
                }
                this.inputBuffer.notifyRead(10 + size);
                headerAddr = startAddr + 10 + size;
                header = Utilities.readUnaligned32(mem, headerAddr);
            }
            if (!sceMp3.isMp3Magic(header)) {
                log.error((Object)String.format("Invalid MP3 header 0x%08X", header));
                return;
            }
            header = Utilities.endianSwap32(header);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Mp3 header: 0x%08X", header));
            }
            Mp3Header mp3Header = new Mp3Header();
            Mp3Decoder.decodeHeader(mp3Header, header);
            this.version = mp3Header.version;
            this.channels = mp3Header.nbChannels;
            this.sampleRate = mp3Header.sampleRate;
            this.bitRate = mp3Header.bitRate;
            this.maxSamples = mp3Header.maxSamples;
            this.parseInfoTag(headerAddr + 4 + infoTagOffsets[mp3Header.lsf][mp3Header.nbChannels - 1]);
            this.parseVbriTag(headerAddr + 4 + 32);
        }

        private void parseInfoTag(int addr) {
            Memory mem = Memory.getInstance();
            int tag = Utilities.readUnaligned32(mem, addr);
            if (tag == 1735289176 || tag == 1868983881) {
                int numberOfBytes = 0;
                int flags = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 4));
                addr += 8;
                if ((flags & 1) != 0) {
                    this.numberOfFrames = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr));
                    addr += 4;
                }
                if ((flags & 2) != 0) {
                    numberOfBytes = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr));
                    addr += 4;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found TAG 0x%08X, numberOfFrames=%d, numberOfBytes=0x%X", tag, this.numberOfFrames, numberOfBytes));
                }
            }
        }

        private void parseVbriTag(int addr) {
            int version;
            Memory mem = Memory.getInstance();
            int tag = Utilities.readUnaligned32(mem, addr);
            if (tag == 1230127702 && (version = Utilities.readUnaligned16(mem, addr + 4)) == 1) {
                int numberOfBytes = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 10));
                this.numberOfFrames = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 14));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found TAG 0x%08X, numberOfFrames=%d, numberOfBytes=0x%X", tag, this.numberOfFrames, numberOfBytes));
                }
            }
        }

        public void init() {
            this.parseMp3FrameHeader();
            this.codec.init(0, this.channels, this.outputChannels, 0);
            this.sumDecodedSamples = 0;
        }

        public int getChannelNum() {
            return this.channels;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public int getBitRate() {
            return this.bitRate;
        }

        public int getMaxSamples() {
            return this.maxSamples;
        }

        public int getVersion() {
            return this.version;
        }

        public int getNumberOfFrames() {
            return this.numberOfFrames;
        }
    }
}

