/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspNetMacAddress;

public class SceNetWlanMessage
extends pspAbstractMemoryMappedStructure {
    public static final int[] contentLengthFromMessageType = new int[]{-1, 0, 128, 288, 272, 256, 96, 32, 48};
    public static final int maxContentLength = 288;
    public static final int WLAN_PROTOCOL_TYPE_SONY = 35016;
    public static final int WLAN_PROTOCOL_SUBTYPE_GAMEMODE = 0;
    public static final int WLAN_PROTOCOL_SUBTYPE_CONTROL = 1;
    public static final int WLAN_PROTOCOL_SUBTYPE_DATA = 2;
    public pspNetMacAddress dstMacAddress;
    public pspNetMacAddress srcMacAddress;
    public int protocolType;
    public int protocolSubType;
    public int unknown16;
    public int controlType;
    public int contentLength;
    private static final String[] protocolSubTypeNames = new String[]{"GAMEMODE", "CONTROL", "DATA"};

    @Override
    protected void read() {
        this.dstMacAddress = new pspNetMacAddress();
        this.read(this.dstMacAddress);
        this.srcMacAddress = new pspNetMacAddress();
        this.read(this.srcMacAddress);
        this.protocolType = this.endianSwap16((short)this.read16());
        this.protocolSubType = this.endianSwap16((short)this.read16());
        if (this.protocolSubType == 1) {
            this.unknown16 = this.read8();
            this.controlType = this.read8();
            this.contentLength = this.endianSwap16((short)this.read16());
        }
    }

    @Override
    protected void write() {
        this.write(this.dstMacAddress);
        this.write(this.srcMacAddress);
        this.write16((short)this.endianSwap16((short)this.protocolType));
        this.write16((short)this.endianSwap16((short)this.protocolSubType));
        if (this.protocolSubType == 1) {
            this.write8((byte)this.unknown16);
            this.write8((byte)this.controlType);
            this.write16((short)this.endianSwap16((short)this.contentLength));
        }
    }

    @Override
    public int sizeof() {
        return 20;
    }

    private static String getProtocolSubTypeName(int protocolSubType) {
        if (protocolSubType < 0 || protocolSubType >= protocolSubTypeNames.length) {
            return String.format("UNKNOWN_0x%04X", protocolSubType);
        }
        return protocolSubTypeNames[protocolSubType];
    }

    @Override
    public String toString() {
        if (this.protocolSubType == 1) {
            return String.format("dstMac=%s, srcMac=%s, protocolType=0x%X, protocolSubType=0x%X(%s), unknown16=0x%X, controlType=0x%X, contentLength=0x%X", this.dstMacAddress, this.srcMacAddress, this.protocolType, this.protocolSubType, SceNetWlanMessage.getProtocolSubTypeName(this.protocolSubType), this.unknown16, this.controlType, this.contentLength);
        }
        return String.format("dstMac=%s, srcMac=%s, protocolType=0x%X, protocolSubType=0x%X(%s)", this.dstMacAddress, this.srcMacAddress, this.protocolType, this.protocolSubType, SceNetWlanMessage.getProtocolSubTypeName(this.protocolSubType));
    }
}

