/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceParseHttp
extends HLEModule {
    public static Logger log = Modules.getLogger("sceParseHttp");

    private String getHeaderString(IMemoryReader memoryReader) {
        int c;
        StringBuilder line = new StringBuilder();
        while ((c = memoryReader.readNext()) != 10 && c != 13) {
            line.append((char)c);
        }
        return line.toString();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1384382993, version=150)
    public int sceParseHttpResponseHeader(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer header, int headerLength, PspString fieldName, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 valueAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 valueLength) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(header.getAddress(), headerLength, 1);
        int endAddress = header.getAddress() + headerLength;
        boolean found = false;
        while (memoryReader.getCurrentAddress() < endAddress) {
            int c;
            int addr = memoryReader.getCurrentAddress();
            String headerString = this.getHeaderString(memoryReader);
            String[] fields = headerString.split(" *: *", 2);
            if (fields == null || fields.length != 2 || !fields[0].equalsIgnoreCase(fieldName.getString())) continue;
            addr += fields[0].length();
            Memory mem = header.getMemory();
            while ((c = mem.read8(addr)) == 32) {
                ++addr;
            }
            if ((c = mem.read8(addr++)) != 58) continue;
            while ((c = mem.read8(addr)) == 32) {
                ++addr;
            }
            valueLength.setValue(memoryReader.getCurrentAddress() - addr - 1);
            valueAddr.setValue(addr);
            found = true;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)String.format("sceParseHttpResponseHeader returning valueLength=0x%X: %s", valueLength.getValue(), Utilities.getMemoryDump(valueAddr.getValue(), valueLength.getValue())));
            break;
        }
        if (!found) {
            valueAddr.setValue(0);
            valueLength.setValue(0);
            return -2143084507;
        }
        return memoryReader.getCurrentAddress() - 1 - header.getAddress();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2139642829, version=150)
    public int sceParseHttpStatusLine(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer header, int headerLength, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 httpVersionMajorAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 httpVersionMinorAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 httpStatusCodeAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 httpStatusCommentAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 httpStatusCommentLengthAddr) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(header.getAddress(), headerLength, 1);
        String headerString = this.getHeaderString(memoryReader);
        Pattern pattern = Pattern.compile("HTTP/(\\d)\\.(\\d)\\s+(\\d+)(.*)");
        Matcher matcher = pattern.matcher(headerString);
        if (!matcher.matches()) {
            return -1;
        }
        int httpVersionMajor = Integer.parseInt(matcher.group(1));
        int httpVersionMinor = Integer.parseInt(matcher.group(2));
        int httpStatusCode = Integer.parseInt(matcher.group(3));
        String httpStatusComment = matcher.group(4);
        httpVersionMajorAddr.setValue(httpVersionMajor);
        httpVersionMinorAddr.setValue(httpVersionMinor);
        httpStatusCodeAddr.setValue(httpStatusCode);
        httpStatusCommentAddr.setValue(header.getAddress() + headerString.indexOf(httpStatusComment));
        httpStatusCommentLengthAddr.setValue(httpStatusComment.length());
        return 0;
    }
}

