/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.util.Utilities;

public class Rasterizer {
    public static final int MINIMUM_WIDTH = 4;
    public static final int MINIMUM_HEIGHT = 4;
    private Edge[] edges = new Edge[3];
    private int longEdge;
    private int shortEdge1;
    private int shortEdge2;
    private int currentEdge;
    float xdiff1;
    float xdiff2;
    float factor1;
    float factorStep1;
    float factor2;
    float factorStep2;
    float y2;

    public Rasterizer(float x1, float y1, float x2, float y2, float x3, float y3, int yMin, int yMax) {
        this.edges[0] = new Edge(x1, y1, x2, y2);
        this.edges[1] = new Edge(x2, y2, x3, y3);
        this.edges[2] = new Edge(x3, y3, x1, y1);
        this.longEdge = 0;
        float maxLength = this.edges[this.longEdge].getLengthY();
        for (int i = 1; i < this.edges.length; ++i) {
            float length = this.edges[i].getLengthY();
            if (!(length > maxLength)) continue;
            maxLength = length;
            this.longEdge = i;
        }
        this.shortEdge1 = (this.longEdge + 1) % this.edges.length;
        this.shortEdge2 = (this.longEdge + 2) % this.edges.length;
        if (this.edges[this.shortEdge1].y1 > this.edges[this.shortEdge2].y1) {
            int tmp = this.shortEdge1;
            this.shortEdge1 = this.shortEdge2;
            this.shortEdge2 = tmp;
        }
        this.currentEdge = this.shortEdge1;
        if (!this.init(this.longEdge, this.currentEdge)) {
            this.currentEdge = this.shortEdge2;
            this.init(this.longEdge, this.currentEdge);
        }
    }

    public void setY(float y) {
        if (y == this.y2) {
            return;
        }
        if (this.currentEdge == this.shortEdge1 && y > this.edges[this.currentEdge].y2) {
            this.currentEdge = this.shortEdge2;
            this.init(this.longEdge, this.currentEdge);
            if (this.y2 >= y) {
                return;
            }
        }
        float diff = y - this.y2;
        this.factor1 += diff * this.factorStep1;
        this.factor2 += diff * this.factorStep2;
        this.y2 = y;
    }

    private boolean init(int edge1, int edge2) {
        if (this.edges[edge2].getLengthY() <= 0.0f) {
            this.y2 = this.edges[edge2].y2;
            return false;
        }
        float ydiff1 = this.edges[edge1].y2 - this.edges[edge1].y1;
        float ydiff2 = this.edges[edge2].y2 - this.edges[edge2].y1;
        this.xdiff1 = this.edges[edge1].x2 - this.edges[edge1].x1;
        this.xdiff2 = this.edges[edge2].x2 - this.edges[edge2].x1;
        this.factor1 = (this.edges[edge2].y1 - this.edges[edge1].y1) / ydiff1;
        this.factorStep1 = 1.0f / ydiff1;
        this.factor2 = 0.0f;
        this.factorStep2 = 1.0f / ydiff2;
        this.y2 = this.edges[edge2].y1;
        return true;
    }

    public void getNextRange(Range range) {
        if (this.y2 >= this.edges[this.currentEdge].y2) {
            if (this.currentEdge == this.shortEdge2) {
                range.clear();
                return;
            }
            this.currentEdge = this.shortEdge2;
            if (!this.init(this.longEdge, this.currentEdge)) {
                range.clear();
                return;
            }
        }
        int edge1 = this.longEdge;
        int edge2 = this.currentEdge;
        float x1 = this.edges[edge1].x1 + this.xdiff1 * this.factor1;
        float x2 = this.edges[edge2].x1 + this.xdiff2 * this.factor2;
        this.factor1 += this.factorStep1;
        this.factor2 += this.factorStep2;
        range.setRange(x1, x2);
        this.y2 += 1.0f;
    }

    private static class Edge {
        protected float x1;
        protected float y1;
        protected float x2;
        protected float y2;

        public Edge(float x1, float y1, float x2, float y2) {
            if (y1 <= y2) {
                this.x1 = x1;
                this.y1 = y1;
                this.x2 = x2;
                this.y2 = y2;
            } else {
                this.x1 = x2;
                this.y1 = y2;
                this.x2 = x1;
                this.y2 = y1;
            }
        }

        public float getLengthY() {
            return this.y2 - this.y1;
        }

        public String toString() {
            return String.format("(%d,%d)-(%d,%d)", Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2));
        }
    }

    public static class Range {
        public int xMin;
        public int xMax;

        public void clear() {
            this.xMin = 0;
            this.xMax = 0;
        }

        public void setRange(float x1, float x2) {
            this.xMin = Utilities.minInt(x1, x2);
            this.xMax = Utilities.maxInt(x1, x2);
        }

        public String toString() {
            return String.format("[%d-%d]", this.xMin, this.xMax);
        }
    }
}

