/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jpcsp.util.LWJGLFixer;

public class ExtractMemoryStickIPL {
    public static void main(String[] args) {
        String fileName = "ipl.bin";
        if (args != null && args.length >= 1) {
            fileName = args[0];
        }
        new ExtractMemoryStickIPL().extractMemoryStickIPL(fileName);
    }

    private static boolean isEmpty(byte[] buffer, int length) {
        for (int i = 0; i < length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private void extractMemoryStickIPL(String fileName) {
        try {
            int length;
            RandomAccessFile msIpl = new RandomAccessFile("ms.ipl.bin", "r");
            msIpl.seek(8192L);
            FileOutputStream os = new FileOutputStream(fileName);
            byte[] buffer = new byte[512];
            while ((length = msIpl.read(buffer)) > 0 && !ExtractMemoryStickIPL.isEmpty(buffer, length)) {
                ((OutputStream)os).write(buffer, 0, length);
            }
            msIpl.close();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LWJGLFixer.fixOnce();
    }
}

