/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.util;

import jpcsp.Memory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;

public class CodecUtils {
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final float M_SQRT1_2 = 0.70710677f;
    public static final float M_PI = (float)Math.PI;
    public static final float M_SQRT2 = 1.4142135f;
    public static final int[] ff_log2_tab = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final float log2 = (float)Math.log(2.0);

    private static int convertSampleFloatToInt16(float sample) {
        return Math.min(Math.max((int)(sample * 32768.0f + 0.5f), Short.MIN_VALUE), Short.MAX_VALUE) & 0xFFFF;
    }

    public static void writeOutput(float[][] samples, Memory outputMemory, int outputAddr, int numberOfSamples, int decodedChannels, int outputChannels) {
        IMemoryWriter writer = MemoryWriter.getMemoryWriter(outputMemory, outputAddr, numberOfSamples * 2 * outputChannels, 2);
        switch (outputChannels) {
            case 1: {
                for (int i = 0; i < numberOfSamples; ++i) {
                    int sample = CodecUtils.convertSampleFloatToInt16(samples[0][i]);
                    writer.writeNext(sample);
                }
                break;
            }
            case 2: {
                if (decodedChannels == 1) {
                    for (int i = 0; i < numberOfSamples; ++i) {
                        int sample = CodecUtils.convertSampleFloatToInt16(samples[0][i]);
                        writer.writeNext(sample);
                        writer.writeNext(sample);
                    }
                } else {
                    for (int i = 0; i < numberOfSamples; ++i) {
                        int lsample = CodecUtils.convertSampleFloatToInt16(samples[0][i]);
                        int rsample = CodecUtils.convertSampleFloatToInt16(samples[1][i]);
                        writer.writeNext(lsample);
                        writer.writeNext(rsample);
                    }
                }
                break;
            }
        }
        writer.flush();
    }

    public static int avLog2(int n) {
        if (n == 0) {
            return 0;
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static float log2f(float n) {
        return (float)Math.log(n) / log2;
    }

    public static int lrintf(float n) {
        return (int)Math.rint(n);
    }

    public static float exp2f(float n) {
        return (float)Math.pow(2.0, n);
    }

    public static float sqrtf(float n) {
        return (float)Math.sqrt(n);
    }

    public static float cosf(float n) {
        return (float)Math.cos(n);
    }

    public static float sinf(float n) {
        return (float)Math.sin(n);
    }

    public static float atanf(float n) {
        return (float)Math.atan(n);
    }

    public static float atan2f(float y, float x) {
        return (float)Math.atan2(y, x);
    }
}

