/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceDmac;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.dmac.DmacProcessor;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerDmac
extends MMIOHandlerBase {
    public static Logger log = sceDmac.log;
    private static final int STATE_VERSION = 0;
    private final DmacProcessor[] dmacProcessors = new DmacProcessor[8];
    private int flagsCompleted;
    private int flagsError;

    public MMIOHandlerDmac(int baseAddress) {
        super(baseAddress);
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i] = new DmacProcessor(this.getMemory(), this.getMemory(), baseAddress + 256 + i * 32, new DmacCompletedAction(1 << i));
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.flagsCompleted = stream.readInt();
        this.flagsError = stream.readInt();
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i].read(stream);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.flagsCompleted);
        stream.writeInt(this.flagsError);
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i].write(stream);
        }
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.flagsCompleted = 0;
        this.flagsError = 0;
        for (int i = 0; i < this.dmacProcessors.length; ++i) {
            this.dmacProcessors[i].reset();
        }
    }

    private void memcpyCompleted(int flagCompleted) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("memcpyCompleted 0x%X", flagCompleted));
        }
        this.flagsCompleted |= flagCompleted;
        this.checkInterrupt();
    }

    private void checkInterrupt() {
        if (this.flagsCompleted != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 22);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 22);
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 4: {
                value = this.flagsCompleted;
                break;
            }
            case 12: {
                value = this.flagsError;
                break;
            }
            case 48: {
                value = 0;
                break;
            }
            case 256: 
            case 260: 
            case 264: 
            case 268: 
            case 272: {
                value = this.dmacProcessors[0].read32(address - this.baseAddress - 256);
                break;
            }
            case 288: 
            case 292: 
            case 296: 
            case 300: 
            case 304: {
                value = this.dmacProcessors[1].read32(address - this.baseAddress - 288);
                break;
            }
            case 320: 
            case 324: 
            case 328: 
            case 332: 
            case 336: {
                value = this.dmacProcessors[2].read32(address - this.baseAddress - 320);
                break;
            }
            case 352: 
            case 356: 
            case 360: 
            case 364: 
            case 368: {
                value = this.dmacProcessors[3].read32(address - this.baseAddress - 352);
                break;
            }
            case 384: 
            case 388: 
            case 392: 
            case 396: 
            case 400: {
                value = this.dmacProcessors[4].read32(address - this.baseAddress - 384);
                break;
            }
            case 416: 
            case 420: 
            case 424: 
            case 428: 
            case 432: {
                value = this.dmacProcessors[5].read32(address - this.baseAddress - 416);
                break;
            }
            case 448: 
            case 452: 
            case 456: 
            case 460: 
            case 464: {
                value = this.dmacProcessors[6].read32(address - this.baseAddress - 448);
                break;
            }
            case 480: 
            case 484: 
            case 488: 
            case 492: 
            case 496: {
                value = this.dmacProcessors[7].read32(address - this.baseAddress - 480);
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 8: {
                this.flagsCompleted &= ~value;
                this.checkInterrupt();
                break;
            }
            case 16: {
                this.flagsError &= ~value;
                break;
            }
            case 48: {
                if (value == 0 || value == 1) break;
                super.write32(address, value);
                break;
            }
            case 52: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 256: 
            case 260: 
            case 264: 
            case 268: 
            case 272: {
                this.dmacProcessors[0].write32(address - this.baseAddress - 256, value);
                break;
            }
            case 288: 
            case 292: 
            case 296: 
            case 300: 
            case 304: {
                this.dmacProcessors[1].write32(address - this.baseAddress - 288, value);
                break;
            }
            case 320: 
            case 324: 
            case 328: 
            case 332: 
            case 336: {
                this.dmacProcessors[2].write32(address - this.baseAddress - 320, value);
                break;
            }
            case 352: 
            case 356: 
            case 360: 
            case 364: 
            case 368: {
                this.dmacProcessors[3].write32(address - this.baseAddress - 352, value);
                break;
            }
            case 384: 
            case 388: 
            case 392: 
            case 396: 
            case 400: {
                this.dmacProcessors[4].write32(address - this.baseAddress - 384, value);
                break;
            }
            case 416: 
            case 420: 
            case 424: 
            case 428: 
            case 432: {
                this.dmacProcessors[5].write32(address - this.baseAddress - 416, value);
                break;
            }
            case 448: 
            case 452: 
            case 456: 
            case 460: 
            case 464: {
                this.dmacProcessors[6].write32(address - this.baseAddress - 448, value);
                break;
            }
            case 480: 
            case 484: 
            case 488: 
            case 492: 
            case 496: {
                this.dmacProcessors[7].write32(address - this.baseAddress - 480, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    private class DmacCompletedAction
    implements IAction {
        private int flagCompleted;

        public DmacCompletedAction(int flagCompleted) {
            this.flagCompleted = flagCompleted;
        }

        @Override
        public void execute() {
            MMIOHandlerDmac.this.memcpyCompleted(this.flagCompleted);
        }
    }
}

