/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.anim;

import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.scheduler.Scheduler;
import org.apache.log4j.Logger;

public abstract class AbstractAnimAction
implements IAction {
    protected static final Logger log = VSMX.log;
    private int duration;
    private long start;

    protected AbstractAnimAction(int duration) {
        this.duration = duration * 1000;
        this.start = Scheduler.getNow();
    }

    private long getNextSchedule(long now) {
        return now + (long)Math.max(this.duration / 10000, 1000);
    }

    @Override
    public void execute() {
        long now = Scheduler.getNow();
        int currentDuration = (int)(now - this.start);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("BaseAnimAction duration=%d/%d", currentDuration, this.duration));
        }
        float step = (currentDuration = Math.min(currentDuration, this.duration)) == this.duration ? 1.0f : (float)currentDuration / (float)this.duration;
        this.anim(step);
        if (currentDuration < this.duration) {
            Emulator.getScheduler().addAction(this.getNextSchedule(now), this);
        }
    }

    protected static float interpolate(float start, float end, float step) {
        return start + (end - start) * step;
    }

    protected abstract void anim(float var1);
}

