/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerGe;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerGeEdram
extends MMIOHandlerBase {
    public static Logger log = MMIOHandlerGe.log;
    private static final int STATE_VERSION = 0;
    private int unknown00;
    private int unknown20;
    private int unknown30;
    private int unknown40;
    private int unknown70;
    private int unknown80;
    private int unknown90;

    public MMIOHandlerGeEdram(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.unknown00 = stream.readInt();
        this.unknown20 = stream.readInt();
        this.unknown30 = stream.readInt();
        this.unknown40 = stream.readInt();
        this.unknown70 = stream.readInt();
        this.unknown80 = stream.readInt();
        this.unknown90 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.unknown00);
        stream.writeInt(this.unknown20);
        stream.writeInt(this.unknown30);
        stream.writeInt(this.unknown40);
        stream.writeInt(this.unknown70);
        stream.writeInt(this.unknown80);
        stream.writeInt(this.unknown90);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.unknown00 = 74275;
        this.unknown20 = 0;
        this.unknown30 = 0;
        this.unknown40 = 0;
        this.unknown70 = 0;
        this.unknown80 = 0;
        this.unknown90 = 0;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.unknown00;
                break;
            }
            case 16: {
                value = 0;
                break;
            }
            case 32: {
                value = this.unknown20;
                break;
            }
            case 48: {
                value = this.unknown30;
                break;
            }
            case 64: {
                value = this.unknown40;
                break;
            }
            case 112: {
                value = this.unknown70;
                break;
            }
            case 128: {
                value = this.unknown80;
                break;
            }
            case 144: {
                value = this.unknown90;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.unknown00 = value;
                break;
            }
            case 16: {
                if (value == 0 || value == 1 || value == 2) break;
                super.write32(address, value);
                break;
            }
            case 32: {
                this.unknown20 = value;
                break;
            }
            case 48: {
                this.unknown30 = value;
                break;
            }
            case 64: {
                this.unknown40 = value;
                break;
            }
            case 112: {
                this.unknown70 = value;
                break;
            }
            case 128: {
                this.unknown80 = value;
                break;
            }
            case 144: {
                this.unknown90 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

