/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.hardware.Wlan;
import jpcsp.network.proonline.PacketFactory;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ProOnlineServer {
    protected static Logger log = ProOnlineNetworkAdapter.log;
    private static ProOnlineServer instance;
    private ProOnlineServerThread serverThread;
    private static final int port = 27312;
    private ServerSocket serverSocket;
    private List<User> users;
    private PacketFactory packetFactory;
    private User currentUser;
    private List<Game> games;

    public static ProOnlineServer getInstance() {
        if (instance == null) {
            instance = new ProOnlineServer();
        }
        return instance;
    }

    private ProOnlineServer() {
    }

    public void start() {
        this.packetFactory = new PacketFactory();
        try {
            this.serverSocket = new ServerSocket(27312, 50, Wlan.getLocalInetAddress());
            this.serverSocket.setSoTimeout(1);
        }
        catch (IOException e) {
            log.error((Object)String.format("Server socket at port %d not available: %s", 27312, e));
            return;
        }
        this.users = new LinkedList<User>();
        this.games = new LinkedList<Game>();
        this.serverThread = new ProOnlineServerThread();
        this.serverThread.setName("ProOnline Server Thread");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    public void exit() {
        if (this.serverThread != null) {
            this.serverThread.exit();
            this.serverThread = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                log.debug((Object)"Closing server socket", (Throwable)e);
            }
            this.serverSocket = null;
        }
    }

    private static int convertIp(byte[] bytes) {
        int ip = 0;
        for (int i = 0; i < bytes.length; ++i) {
            ip |= bytes[i] << i * 8;
        }
        return ip;
    }

    private void sendToUser(User user, PacketFactory.SceNetAdhocctlPacketBaseS2C packet) throws IOException {
        OutputStream os = user.socket.getOutputStream();
        os.write(packet.getBytes());
        os.flush();
    }

    private void loginUserStream(Socket socket) throws IOException {
        String ip = socket.getInetAddress().getHostAddress();
        User user = new User();
        user.ip = ProOnlineServer.convertIp(socket.getInetAddress().getAddress());
        user.ipString = ip;
        user.socket = socket;
        user.lastReceiveTimestamp = System.currentTimeMillis();
        this.users.add(user);
        log.info((Object)String.format("New Connection from %s", user.ipString));
    }

    private void logoutUser(User user) {
        if (user.group != null) {
            this.disconnectUser(user);
        }
        try {
            user.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (user.game != null) {
            log.info((Object)String.format("%s stopped playing %s.", user, user.game.name));
            --user.game.playerCount;
            if (user.game.playerCount <= 0) {
                this.games.remove(user.game);
            }
            user.game = null;
        } else {
            log.info((Object)String.format("Dropped Connection %s.", user));
        }
        this.users.remove(user);
    }

    private void processUserStream(User user) {
        if (user.bufferLength <= 0) {
            return;
        }
        int consumed = 0;
        PacketFactory.SceNetAdhocctlPacketBaseC2S packet = this.packetFactory.createPacketC2S(null, this, user.buffer, user.bufferLength);
        if (packet == null) {
            consumed = 1;
        } else if (user.bufferLength >= packet.getLength()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Incoming client packet %s", packet));
            }
            this.currentUser = user;
            packet.process();
            this.currentUser = null;
            consumed = packet.getLength();
        }
        if (consumed >= user.bufferLength) {
            user.bufferLength = 0;
        } else {
            user.bufferLength -= consumed;
            System.arraycopy(user.buffer, consumed, user.buffer, 0, user.bufferLength);
        }
    }

    public void processLogin(pspNetMacAddress mac, String nickName, String gameName) {
        if (gameName.matches("[A-Z0-9]{9}")) {
            this.currentUser.game = null;
            for (Game game : this.games) {
                if (!game.name.equals(gameName)) continue;
                this.currentUser.game = game;
                break;
            }
            if (this.currentUser.game == null) {
                this.currentUser.game = new Game(gameName);
                this.games.add(this.currentUser.game);
            }
            ++this.currentUser.game.playerCount;
            this.currentUser.mac = mac;
            this.currentUser.nickName = nickName;
            log.info((Object)String.format("%s started playing %s.", this.currentUser, this.currentUser.game.name));
        } else {
            log.info((Object)String.format("Invalid login for game '%s'", gameName));
        }
    }

    private void disconnectUser(User user) {
        if (user.group != null) {
            Group group = user.group;
            group.players.remove(user);
            for (User groupUser : group.players) {
                PacketFactory.SceNetAdhocctlDisconnectPacketS2C packet = new PacketFactory.SceNetAdhocctlDisconnectPacketS2C(user.ip);
                try {
                    this.sendToUser(groupUser, packet);
                }
                catch (IOException e) {
                    log.debug((Object)"disconnectUser", (Throwable)e);
                }
            }
            log.info((Object)String.format("%s left %s group %s.", user, user.game.name, group.name));
            user.group = null;
            if (group.players.isEmpty()) {
                group.game.groups.remove(group);
            }
        } else {
            log.info((Object)String.format("%s attempted to leave %s without joining one first.", user, user.game.name));
            this.logoutUser(user);
        }
    }

    public void processDisconnect() {
        this.disconnectUser(this.currentUser);
    }

    public void processScan() {
        if (this.currentUser.group == null) {
            for (Group group : this.currentUser.game.groups) {
                pspNetMacAddress mac = new pspNetMacAddress();
                if (!group.players.isEmpty()) {
                    mac = group.players.get((int)0).mac;
                }
                try {
                    this.sendToUser(this.currentUser, new PacketFactory.SceNetAdhocctlScanPacketS2C(group.name, mac));
                }
                catch (IOException e) {
                    log.debug((Object)"processScan", (Throwable)e);
                }
            }
        } else {
            log.info((Object)String.format("%s attempted to scan for %s groups without disconnecting from %s first.", this.currentUser, this.currentUser.game.name, this.currentUser.group.name));
            this.logoutUser(this.currentUser);
        }
    }

    private void spreadMessage(User fromUser, String message) {
        if (fromUser == null) {
            for (User user : this.users) {
                if (user.group == null) continue;
                try {
                    this.sendToUser(user, new PacketFactory.SceNetAdhocctlChatPacketS2C(message, ""));
                }
                catch (IOException e) {
                    log.debug((Object)"spreadMessage global notice", (Throwable)e);
                }
            }
        } else if (fromUser.group != null) {
            int messageCount = 0;
            for (User user : fromUser.group.players) {
                if (user == fromUser) continue;
                try {
                    this.sendToUser(user, new PacketFactory.SceNetAdhocctlChatPacketS2C(message, fromUser.nickName));
                    ++messageCount;
                }
                catch (IOException e) {
                    log.debug((Object)"spreadMessage", (Throwable)e);
                }
            }
            if (messageCount > 0) {
                log.info((Object)String.format("%s sent '%s' to %d players in %s group %s", fromUser, message, messageCount, fromUser.game.name, fromUser.group.name));
            }
        } else {
            log.info((Object)String.format("%s attempted to send a text message without joining a %s group first", fromUser, fromUser.game.name));
        }
    }

    public void processChat(String message) {
        this.spreadMessage(this.currentUser, message);
    }

    public void processConnect(String groupName) {
        if (groupName.matches("[A-Za-z0-9]*")) {
            if (this.currentUser.group == null) {
                for (Group group : this.currentUser.game.groups) {
                    if (!group.name.equals(groupName)) continue;
                    this.currentUser.group = group;
                    break;
                }
                if (this.currentUser.group == null) {
                    this.currentUser.group = new Group(groupName, this.currentUser.game);
                }
                for (User user : this.currentUser.group.players) {
                    PacketFactory.SceNetAdhocctlConnectPacketS2C packet = new PacketFactory.SceNetAdhocctlConnectPacketS2C(this.currentUser.nickName, this.currentUser.mac, this.currentUser.ip);
                    try {
                        this.sendToUser(user, packet);
                    }
                    catch (IOException e) {
                        log.debug((Object)"processConnect", (Throwable)e);
                    }
                    packet = new PacketFactory.SceNetAdhocctlConnectPacketS2C(user.nickName, user.mac, user.ip);
                    try {
                        this.sendToUser(this.currentUser, packet);
                    }
                    catch (IOException e) {
                        log.debug((Object)"processConnect", (Throwable)e);
                    }
                }
                this.currentUser.group.players.add(this.currentUser);
                try {
                    this.sendToUser(this.currentUser, new PacketFactory.SceNetAdhocctlConnectBSSIDPacketS2C(this.currentUser.group.players.get((int)0).mac));
                }
                catch (IOException e) {
                    log.debug((Object)"processConnect", (Throwable)e);
                }
                log.info((Object)String.format("%s joined %s group '%s'.", this.currentUser, this.currentUser.game == null ? "" : this.currentUser.game.name, this.currentUser.group.name));
            } else {
                log.info((Object)String.format("%s attempted to join %s group '%s' without disconnecting from %s first.", this.currentUser, this.currentUser.game == null ? "" : this.currentUser.game.name, groupName, this.currentUser.group.name));
                this.logoutUser(this.currentUser);
            }
        } else {
            log.info((Object)String.format("%s attempted to join invalid %s group '%s'.", this.currentUser, this.currentUser.game == null ? "" : this.currentUser.game.name, groupName));
            this.logoutUser(this.currentUser);
        }
    }

    private class ProOnlineServerThread
    extends Thread {
        private boolean exit;

        private ProOnlineServerThread() {
        }

        @Override
        public void run() {
            log.debug((Object)String.format("Starting ProOnlineServerThread", new Object[0]));
            while (!this.exit) {
                try {
                    Socket socket = ProOnlineServer.this.serverSocket.accept();
                    socket.setSoTimeout(1);
                    ProOnlineServer.this.loginUserStream(socket);
                }
                catch (SocketTimeoutException socket) {
                }
                catch (IOException e) {
                    log.debug((Object)"Accept server socket", (Throwable)e);
                }
                LinkedList copyUsers = new LinkedList(ProOnlineServer.this.users);
                for (User user : copyUsers) {
                    int length = 0;
                    try {
                        InputStream is = user.socket.getInputStream();
                        length = is.read(user.buffer, user.bufferLength, user.buffer.length - user.bufferLength);
                    }
                    catch (SocketTimeoutException is) {
                    }
                    catch (IOException e) {
                        log.debug((Object)"Receive user socket", (Throwable)e);
                    }
                    if (length > 0) {
                        user.bufferLength += length;
                        user.lastReceiveTimestamp = System.currentTimeMillis();
                        ProOnlineServer.this.processUserStream(user);
                        continue;
                    }
                    if (length >= 0 && !user.isTimeout()) continue;
                    ProOnlineServer.this.logoutUser(user);
                }
                Utilities.sleep(10);
            }
        }

        public void exit() {
            this.exit = true;
        }
    }

    private static class Group {
        public String name;
        public Game game;
        public List<User> players;

        public Group(String name, Game game) {
            this.name = name;
            this.game = game;
            this.players = new LinkedList<User>();
            if (game != null) {
                game.groups.add(this);
            }
        }
    }

    private static class Game {
        public String name;
        public int playerCount;
        public List<Group> groups;

        public Game(String name) {
            this.name = name;
            this.groups = new LinkedList<Group>();
        }
    }

    private static class User {
        public Socket socket;
        public long lastReceiveTimestamp;
        public byte[] buffer = new byte[1000];
        public int bufferLength = 0;
        public pspNetMacAddress mac;
        public String nickName;
        public Game game;
        public Group group;
        public int ip;
        public String ipString;

        private User() {
        }

        public boolean isTimeout() {
            boolean isTimeout;
            boolean bl = isTimeout = System.currentTimeMillis() - this.lastReceiveTimestamp > 15000L;
            if (isTimeout) {
                log.debug((Object)String.format("User timed out now=%d, lastReceiveTimestamp=%d", System.currentTimeMillis(), this.lastReceiveTimestamp));
            }
            return isTimeout;
        }

        public String toString() {
            return String.format("%s (MAC: %s - IP: %s)", this.nickName, this.mac, this.ipString);
        }
    }
}

