/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.patch;

import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.VFS.AbstractProxyVirtualFileSystem;
import jpcsp.HLE.VFS.ByteArrayVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;

public class PatchFileVirtualFileSystem
extends AbstractProxyVirtualFileSystem {
    private static final PatchInfo[] allPatches = new PatchInfo[]{new PrxPatchInfo("kd/loadcore.prx", 18076, 364969888, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 17736, 2081382980, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 17744, 350224428, 268435500), new PrxPatchInfo("kd/loadcore.prx", 15704, 281083838, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 23836, 1346436753, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 23840, 1007779842, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 22416, 1415774196, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 22420, 1007779842, HLEUtilities.NOP()), new PrxPatchInfo("kd/loadcore.prx", 17272, 1361117147, HLEUtilities.NOP()), new PrxPatchInfo("kd/semawm.prx", 22048, 666763216, HLEUtilities.JR()), new PrxPatchInfo("kd/semawm.prx", 22052, -1346437084, HLEUtilities.MOVE(2, 0)), new PatchInfo("XXX dummy XXX", 0, 0, 0)};

    public PatchFileVirtualFileSystem(IVirtualFileSystem vfs) {
        super(vfs);
    }

    private List<PatchInfo> getPatches(String fileName) {
        LinkedList<PatchInfo> filePatches = new LinkedList<PatchInfo>();
        for (PatchInfo patch : allPatches) {
            if (!patch.matches(fileName)) continue;
            filePatches.add(patch);
        }
        if (filePatches.isEmpty()) {
            return null;
        }
        return filePatches;
    }

    private IVirtualFile ioOpenPatchedFile(String fileName, int flags, int mode, List<PatchInfo> patches) {
        IVirtualFile vFile = super.ioOpen(fileName, flags, mode);
        if (vFile == null) {
            return null;
        }
        byte[] buffer = Utilities.readCompleteFile(vFile);
        vFile.ioClose();
        if (buffer == null) {
            return null;
        }
        for (PatchInfo patch : patches) {
            patch.apply(buffer);
        }
        return new ByteArrayVirtualFile(buffer);
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        List<PatchInfo> patches = this.getPatches(fileName);
        if (patches != null) {
            return this.ioOpenPatchedFile(fileName, flags, mode, patches);
        }
        return super.ioOpen(fileName, flags, mode);
    }

    protected static class PrxSyscallPatchInfo
    extends PrxPatchInfo {
        private PrxPatchInfo patchInfo2;
        private String functionName;

        public PrxSyscallPatchInfo(String fileName, HLEModule hleModule, String functionName, int offset, int oldValue1, int oldValue2) {
            super(fileName, offset, oldValue1, HLEUtilities.JR(), 8);
            this.functionName = functionName;
            this.patchInfo2 = new PrxPatchInfo(fileName, offset + 4, oldValue2, HLEUtilities.SYSCALL(hleModule, functionName));
        }

        @Override
        public void apply(byte[] buffer) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Patching file '%s' at PRX offset 0x%08X: %s", this.fileName, this.offset, this.functionName));
            }
            super.apply(buffer);
            this.patchInfo2.apply(buffer);
        }
    }

    private static class PrxPatchInfo
    extends PatchInfo {
        private int removeLocationOffset = 4;

        public PrxPatchInfo(String fileName, int offset, int oldValue, int newValue) {
            super(fileName, offset, oldValue, newValue);
        }

        public PrxPatchInfo(String fileName, int offset, int oldValue, int newValue, int removeLocationOffset) {
            super(fileName, offset, oldValue, newValue);
            this.removeLocationOffset = removeLocationOffset;
        }

        private int getFileOffset(byte[] buffer) {
            int elfMagic = Utilities.readUnaligned32(buffer, 0);
            if (elfMagic != 1179403647) {
                return this.offset;
            }
            int phOffset = Utilities.readUnaligned32(buffer, 28);
            int phEntSize = Utilities.readUnaligned16(buffer, 42);
            int phNum = Utilities.readUnaligned16(buffer, 44);
            int segmentOffset = this.offset;
            for (int i = 0; i < phNum; ++i) {
                int offset = phOffset + i * phEntSize;
                int phEntFileSize = Utilities.readUnaligned32(buffer, offset + 16);
                if (segmentOffset < phEntFileSize) {
                    int phFileOffset = Utilities.readUnaligned32(buffer, offset + 4);
                    return phFileOffset + segmentOffset;
                }
                int phEntMemSize = Utilities.readUnaligned32(buffer, offset + 20);
                if ((segmentOffset -= phEntMemSize) >= 0) continue;
                log.error((Object)String.format("Patching of file '%s' failed: incorrect offset 0x%08X outside of program header segment #%d", this.fileName, offset, i));
                return -1;
            }
            log.error((Object)String.format("Patching of file '%s' failed: incorrect offset 0x%08X outside of all program header segments", this.fileName, this.offset));
            return -1;
        }

        private int getRelocationSegmentNumber(byte[] buffer) {
            int phOffset = Utilities.readUnaligned32(buffer, 28);
            int phEntSize = Utilities.readUnaligned16(buffer, 42);
            int phNum = Utilities.readUnaligned16(buffer, 44);
            for (int i = 0; i < phNum; ++i) {
                int offset = phOffset + i * phEntSize;
                int phType = Utilities.readUnaligned32(buffer, offset + 0);
                if (phType != 1879048353) continue;
                return i;
            }
            return -1;
        }

        private void removeRelocation(byte[] buffer) {
            int relocationSegmentNumber = this.getRelocationSegmentNumber(buffer);
            if (relocationSegmentNumber < 0) {
                return;
            }
            int phOffset = Utilities.readUnaligned32(buffer, 28);
            int phEntSize = Utilities.readUnaligned16(buffer, 42);
            int o = Utilities.readUnaligned32(buffer, phOffset + relocationSegmentNumber * phEntSize + 4);
            o += 2;
            int fbits = Utilities.read8(buffer, o++);
            int flagShift = 0;
            int flagMask = (1 << fbits) - 1;
            int sbits = relocationSegmentNumber < 3 ? 1 : 2;
            int segmentShift = fbits;
            int segmentMask = (1 << sbits) - 1;
            int tbits = Utilities.read8(buffer, o++);
            int typeShift = fbits + sbits;
            int typeMask = (1 << tbits) - 1;
            int nflags = Utilities.read8(buffer, o++);
            int[] flags = new int[nflags];
            flags[0] = nflags;
            for (int i = 1; i < nflags; ++i) {
                flags[i] = Utilities.read8(buffer, o++);
            }
            int ntypes = Utilities.read8(buffer, o++);
            int[] types = new int[ntypes];
            types[0] = ntypes;
            for (int i = 1; i < ntypes; ++i) {
                types[i] = Utilities.read8(buffer, o++);
            }
            int offsetShift = fbits + tbits + sbits;
            int OFS_BASE = 0;
            int R_BASE = 0;
            block15: while (o < buffer.length) {
                int cmdOffset = o;
                int R_CMD = Utilities.readUnaligned16(buffer, o);
                o += 2;
                int flagIndex = R_CMD >> flagShift & flagMask;
                int R_FLAG = flags[flagIndex];
                int S = R_CMD >> segmentShift & segmentMask;
                int typeIndex = R_CMD >> typeShift & typeMask;
                if ((R_FLAG & 1) == 0) {
                    OFS_BASE = S;
                    switch (R_FLAG & 6) {
                        case 0: {
                            R_BASE = R_CMD >> fbits + sbits;
                            continue block15;
                        }
                        case 4: {
                            R_BASE = Utilities.readUnaligned32(buffer, o);
                            o += 4;
                            continue block15;
                        }
                    }
                    return;
                }
                switch (R_FLAG & 6) {
                    case 0: {
                        int R_OFFSET = R_CMD;
                        R_BASE += (R_OFFSET >>= offsetShift);
                        break;
                    }
                    case 2: {
                        int R_OFFSET = R_CMD << 16 >> offsetShift;
                        R_OFFSET &= 0xFFFF0000;
                        R_OFFSET |= Utilities.read8(buffer, o++);
                        R_BASE += (R_OFFSET |= Utilities.read8(buffer, o++) << 8);
                        break;
                    }
                    case 4: {
                        R_BASE = Utilities.readUnaligned32(buffer, o);
                        o += 4;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (R_FLAG & 0x38) {
                    case 0: 
                    case 8: {
                        break;
                    }
                    case 16: {
                        o += 2;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Relocation R_BASE=0x%08X", R_BASE));
                }
                if (R_BASE != this.offset) continue;
                int newOffset = (short)R_CMD >> offsetShift;
                if ((R_FLAG & 7) != 1) {
                    log.error((Object)String.format("Unsupported relocation patch at 0x%08X, R_FLAG=0x%X", R_BASE, R_FLAG));
                    return;
                }
                int newCmd = flagIndex << flagShift | OFS_BASE << segmentShift | typeIndex << typeShift | (newOffset += this.removeLocationOffset) << offsetShift;
                this.patch16(buffer, cmdOffset, R_CMD, newCmd &= 0xFFFF);
                int nextCmd = Utilities.readUnaligned16(buffer, o);
                int nextFlagIndex = nextCmd >> flagShift & flagMask;
                int nextFlag = flags[nextFlagIndex];
                int nextSegment = nextCmd >> segmentShift & segmentMask;
                int nextTypeIndex = nextCmd >> typeShift & typeMask;
                int newNextOffset = (short)nextCmd >> offsetShift;
                if ((nextFlag & 7) != 1) {
                    log.error((Object)String.format("Unsupported relocation patch at 0x%08X, R_CMD=0x%04X, nextCmd=0x%04X", R_BASE, R_CMD, nextCmd));
                    return;
                }
                int newNextCmd = nextFlagIndex << flagShift | nextSegment << segmentShift | nextTypeIndex << typeShift | (newNextOffset -= this.removeLocationOffset) << offsetShift;
                this.patch16(buffer, o, nextCmd, newNextCmd);
                return;
            }
        }

        @Override
        public void apply(byte[] buffer) {
            int headerMagic = Utilities.readUnaligned32(buffer, 0);
            if (headerMagic != 1179403647) {
                return;
            }
            int fileOffset = this.getFileOffset(buffer);
            if (fileOffset >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Patching file '%s' at PRX offset 0x%08X: 0x%08X -> 0x%08X", this.fileName, this.offset, this.oldValue, this.newValue));
                }
                super.apply(buffer, fileOffset);
                this.removeRelocation(buffer);
            }
        }
    }

    private static class PatchInfo {
        protected String fileName;
        protected int offset;
        protected int oldValue;
        protected int newValue;

        public PatchInfo(String fileName, int offset, int oldValue, int newValue) {
            this.fileName = fileName;
            this.offset = offset;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public boolean matches(String fileName) {
            return this.fileName.equalsIgnoreCase(fileName);
        }

        protected void apply(byte[] buffer, int offset) {
            if (offset >= 0 && offset < buffer.length) {
                int checkValue = Utilities.readUnaligned32(buffer, offset);
                if (checkValue != this.oldValue) {
                    log.error((Object)String.format("Patching of file '%s' failed at offset 0x%08X, 0x%08X found instead of 0x%08X", this.fileName, offset, checkValue, this.oldValue));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Patching file '%s' at offset 0x%08X: 0x%08X -> 0x%08X", this.fileName, offset, this.oldValue, this.newValue));
                    }
                    Utilities.writeUnaligned32(buffer, offset, this.newValue);
                }
            }
        }

        public void apply(byte[] buffer) {
            this.apply(buffer, this.offset);
        }

        protected void patch16(byte[] buffer, int offset, int oldValue, int newValue) {
            if (offset >= 0 && offset < buffer.length) {
                int checkValue = Utilities.readUnaligned16(buffer, offset);
                if (checkValue != oldValue) {
                    log.error((Object)String.format("Patching of file '%s' failed at offset 0x%08X, 0x%04X found instead of 0x%04X", this.fileName, offset, checkValue, oldValue));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Patching file '%s' at offset 0x%08X: 0x%04X -> 0x%04X", this.fileName, offset, oldValue, newValue));
                    }
                    Utilities.writeUnaligned16(buffer, offset, newValue);
                }
            }
        }

        public String toString() {
            return String.format("Patch '%s' at offset 0x%08X: 0x%08X -> 0x%08X", this.fileName, this.offset, this.oldValue, this.newValue);
        }
    }
}

