/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import org.bolet.jgz.CRC;
import org.bolet.jgz.GZipDecoder;
import org.bolet.jgz.Inflater;
import org.bolet.jgz.JGZException;

public class GZipInputStream
extends InputStream {
    private GZipDecoder gd;
    private boolean needMember;
    private Inflater inflater;
    private byte[] oneByte;
    private int uncompressedSize;
    private int uncompressedCRC;

    public GZipInputStream(InputStream inputStream) {
        this.gd = new GZipDecoder(inputStream);
        this.oneByte = new byte[1];
        this.needMember = true;
        this.inflater = new Inflater();
    }

    public void close() throws IOException {
        this.gd.getSubStream().close();
    }

    public int read() throws IOException {
        int n = this.read(this.oneByte, 0, 1);
        if (n < 0) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            if (this.needMember) {
                InputStream inputStream = this.gd.nextMember();
                if (inputStream == null) {
                    return n3 == 0 ? -1 : n3;
                }
                if (this.gd.getCompressionMethod() != 8) {
                    throw new JGZException("unknown compression method");
                }
                this.inflater.reset(inputStream);
                this.uncompressedSize = 0;
                this.uncompressedCRC = -1;
                this.needMember = false;
            }
            if ((n4 = this.inflater.readAll(byArray, n, n2)) > 0) {
                this.uncompressedSize += n4;
                this.uncompressedCRC = CRC.updateCRC(this.uncompressedCRC, byArray, n, n4);
                return n4;
            }
            this.gd.closeMember();
            if (this.uncompressedSize != this.gd.getUncompressedSize()) {
                throw new JGZException("decompressed size mismatch");
            }
            if (~this.uncompressedCRC != this.gd.getUncompressedCRC()) {
                throw new JGZException("CRC value mismatch");
            }
            this.needMember = true;
        }
        return n3 > 0 ? n3 : -1;
    }
}

