/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import org.bolet.jgz.Adler32;
import org.bolet.jgz.Inflater;
import org.bolet.jgz.JGZException;

public class ZlibInputStream
extends InputStream {
    public static final int DEFLATE = 8;
    private InputStream sub;
    private boolean partial;
    private Inflater inflater;
    private byte[] oneByte;
    private int compressionMethod;
    private int compressionInfo;
    private int compressionLevel;
    private boolean hasDictionary;
    private int dictID;
    private Adler32 adler;
    private boolean eofReached;

    public ZlibInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public ZlibInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.sub = inputStream;
        this.partial = bl;
        int n = this.read1();
        int n2 = this.read1();
        if (((n << 8) + n2) % 31 != 0) {
            throw new JGZException("invalid Zlib stream header");
        }
        this.compressionMethod = n & 0xF;
        if (this.compressionMethod != 8) {
            throw new JGZException("unknown compression method: " + this.compressionMethod);
        }
        this.compressionInfo = n >>> 4;
        if (this.compressionInfo > 7) {
            throw new JGZException("invalid deflate window size: " + this.compressionInfo);
        }
        this.compressionLevel = n2 >>> 6;
        this.hasDictionary = (n2 & 0x20) != 0;
        this.adler = new Adler32();
        if (this.hasDictionary) {
            this.dictID = this.reads4();
        }
        this.inflater = new Inflater();
        this.inflater.reset(inputStream);
        this.oneByte = new byte[1];
        this.eofReached = false;
    }

    private int read1() throws IOException {
        int n = this.sub.read();
        if (n < 0) {
            throw new JGZException("unexpected EOF");
        }
        return n;
    }

    private int reads4() throws IOException {
        int n = this.read1();
        int n2 = this.read1();
        int n3 = this.read1();
        int n4 = this.read1();
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public int getCompressionInfo() {
        return this.compressionInfo;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean hasDictionary() {
        return this.hasDictionary;
    }

    public int getDictionaryId() {
        return this.dictID;
    }

    public void processDictionary(InputStream inputStream) throws IOException {
        this.inflater.processDictionary(inputStream);
    }

    public void processDictionary(byte[] byArray) {
        this.inflater.processDictionary(byArray);
    }

    public void processDictionary(byte[] byArray, int n, int n2) {
        this.inflater.processDictionary(byArray, n, n2);
    }

    public void setRawStream(InputStream inputStream) {
        this.sub = inputStream;
        this.inflater.setRawStream(inputStream);
    }

    private void checkEnd() throws IOException {
        if (!this.eofReached) {
            int n;
            int n2 = this.adler.getSum();
            if (n2 != (n = this.reads4())) {
                throw new JGZException("incorrect checksum");
            }
            this.eofReached = true;
        }
    }

    public void close() throws IOException {
        if (!this.eofReached && this.read() != -1) {
            throw new JGZException("trailing garbage in zlib stream");
        }
        this.sub.close();
    }

    public int read() throws IOException {
        if (this.read(this.oneByte, 0, 1) != 1) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.partial) {
            boolean bl = true;
            do {
                int n3;
                if ((n3 = this.inflater.readBlock(byArray, n, n2)) > 0) {
                    this.adler.update(byArray, n, n3);
                    return n3;
                }
                if (!bl) {
                    return 0;
                }
                bl = false;
            } while (this.inflater.nextBlock());
            this.checkEnd();
            return -1;
        }
        int n4 = this.inflater.readAll(byArray, n, n2);
        if (n4 > 0) {
            this.adler.update(byArray, n, n4);
        } else {
            n4 = -1;
        }
        if (n4 < n2) {
            this.checkEnd();
        }
        return n4;
    }
}

