/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.CAVLCContext;
import com.twilight.h264.decoder.VLC;
import com.twilight.h264.decoder.VLCcode;

public class GetBitContext {
    public static final int MIN_CACHE_BITS = 25;
    public static final int INIT_VLC_LE = 2;
    public static final int INIT_VLC_USE_NEW_STATIC = 4;
    public static final int[] av_reverse = new int[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    public static final int[] ff_golomb_vlc_len = new int[]{19, 17, 15, 15, 13, 13, 13, 13, 11, 11, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final int[] ff_ue_golomb_vlc_code = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 31, 32, 32, 32, 32, 32, 32, 32, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] ff_se_golomb_vlc_code = new int[]{17, 17, 17, 17, 17, 17, 17, 17, 16, 17, 17, 17, 17, 17, 17, 17, 8, -8, 9, -9, 10, -10, 11, -11, 12, -12, 13, -13, 14, -14, 15, -15, 4, 4, 4, 4, -4, -4, -4, -4, 5, 5, 5, 5, -5, -5, -5, -5, 6, 6, 6, 6, -6, -6, -6, -6, 7, 7, 7, 7, -7, -7, -7, -7, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] ff_ue_golomb_len = new int[]{1, 3, 3, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 17};
    public int[] buffer;
    public int buffer_offset;
    public int buffer_end;
    public int index;
    public long cache;
    public long cache0;
    public long cache1;
    public int size_in_bits;

    public static final long bitswap_32(long x) {
        return av_reverse[(int)(x & 0xFFL)] << 24 | av_reverse[(int)(x >>> 8 & 0xFFL)] << 16 | av_reverse[(int)(x >>> 16 & 0xFFL)] << 8 | av_reverse[(int)(x >>> 24)];
    }

    public GetBitContext makeCopy() {
        GetBitContext ret = new GetBitContext();
        ret.buffer = this.buffer;
        ret.buffer_offset = this.buffer_offset;
        ret.buffer_end = this.buffer_end;
        ret.index = this.index;
        ret.cache = this.cache;
        ret.cache0 = this.cache0;
        ret.cache1 = this.cache1;
        ret.size_in_bits = this.size_in_bits;
        return ret;
    }

    public int get_bits_count() {
        return this.index;
    }

    public void skip_bits_long(int n) {
        this.index += n;
    }

    public int get_xbits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long cache = re_cache &= 0xFFFFFFFFL;
        int sign = (int)((cache ^ 0xFFFFFFFFFFFFFFFFL) >> 63);
        this.index = re_index += n;
        return ((int)((long)sign ^ cache) >> 32 - n ^ sign) - sign;
    }

    public int get_sbits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        int tmp = (int)(re_cache &= 0xFFFFFFFFL) >> 32 - n;
        this.index = re_index += n;
        return tmp;
    }

    public long get_bits(int n, String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long tmp = (re_cache &= 0xFFFFFFFFL) >> 32 - n;
        this.index = re_index += n;
        return tmp;
    }

    public long show_bits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long tmp = (re_cache &= 0xFFFFFFFFL) >> 32 - n;
        return tmp;
    }

    public void skip_bits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        re_cache &= 0xFFFFFFFFL;
        this.index = re_index += n;
    }

    public long get_bits1(String message) {
        int index = this.index;
        int result = this.buffer[this.buffer_offset + (index >> 3)];
        result <<= (index & 7) + 24;
        this.index = ++index;
        return (result >>= 31) != 0 ? 1L : 0L;
    }

    public long show_bits1() {
        return this.show_bits(1);
    }

    public void skip_bits1() {
        this.skip_bits(1);
    }

    public long get_bits_long(int n, String message) {
        if (n <= 25) {
            return this.get_bits(n, message);
        }
        long ret = this.get_bits(16, message) << n - 16;
        long ret2 = this.get_bits(n - 16, message);
        return ret | ret2;
    }

    public int get_sbits_long(int n, String message) {
        return (int)this.get_bits_long(n, message) << 32 - n >> 32 - n;
    }

    public long show_bits_long(int n) {
        if (n <= 25) {
            return this.show_bits(n);
        }
        GetBitContext gb = this.makeCopy();
        return gb.get_bits_long(n, "");
    }

    public long check_marker(String msg) {
        long bit = this.get_bits1(msg);
        if (bit == 0L) {
            System.err.println("Marker bit missing: " + msg);
        }
        return bit;
    }

    public void init_get_bits(int[] buffer, int buffer_offset, int bit_size) {
        int buffer_size = bit_size + 7 >> 3;
        if (buffer_size < 0 || bit_size < 0) {
            bit_size = 0;
            buffer_size = 0;
            buffer = null;
        }
        this.buffer = buffer;
        this.buffer_offset = buffer_offset;
        this.size_in_bits = bit_size;
        this.buffer_end = buffer_offset + buffer_size;
        this.index = 0;
    }

    public void align_get_bits() {
        int n = -this.get_bits_count() & 7;
        if (n != 0) {
            this.skip_bits(n);
        }
    }

    public long decode012() {
        long n = this.get_bits1("");
        if (n == 0L) {
            return 0L;
        }
        return this.get_bits1("") + 1L;
    }

    public long decode210() {
        if (this.get_bits1("") != 0L) {
            return 0L;
        }
        return 2L - this.get_bits1("");
    }

    public int get_bits_left() {
        return this.size_in_bits - this.get_bits_count();
    }

    public static int alloc_table(VLC vlc, int size, int use_static) {
        int index = vlc.table_size;
        vlc.table_size += size;
        if (vlc.table_size > vlc.table_allocated) {
            if (use_static != 0) {
                return 0;
            }
            vlc.table_allocated += 1 << vlc.bits;
            short[][] newTab = new short[2 * vlc.table_allocated][2];
            for (int i = 0; i < vlc.table_base.length; ++i) {
                newTab[i][0] = vlc.table_base[i][0];
                newTab[i][1] = vlc.table_base[i][1];
            }
            vlc.table_base = newTab;
            if (null == vlc.table_base) {
                return -1;
            }
        }
        return index;
    }

    public static int build_table(VLC vlc, int table_nb_bits, int nb_codes, VLCcode[] codes_base, int codes_offset, int flags) {
        int i;
        int table_size = 1 << table_nb_bits;
        int table_index = GetBitContext.alloc_table(vlc, table_size, flags & 4);
        if (table_index < 0) {
            return -1;
        }
        short[][] table_base = vlc.table_base;
        int table_offset = vlc.table_offset + table_index;
        for (i = 0; i < table_size; ++i) {
            table_base[table_offset + i][1] = 0;
            table_base[table_offset + i][0] = -1;
        }
        for (i = 0; i < nb_codes; ++i) {
            int k;
            long j;
            long tmp;
            int n = codes_base[codes_offset + i].bits;
            long code = codes_base[codes_offset + i].code;
            int symbol = codes_base[codes_offset + i].symbol;
            if (n <= table_nb_bits) {
                tmp = code & 0xFFFFFFFFL;
                j = (int)(tmp >> 32 - table_nb_bits);
                int nb = 1 << table_nb_bits - n;
                int inc = 1;
                if ((flags & 2) != 0) {
                    j = GetBitContext.bitswap_32(code);
                    inc = 1 << n;
                }
                for (k = 0; k < nb; ++k) {
                    if (table_base[(int)((long)table_offset + j)][1] != 0) {
                        return -1;
                    }
                    table_base[(int)((long)table_offset + j)][1] = (short)n;
                    table_base[(int)((long)table_offset + j)][0] = (short)symbol;
                    j += (long)inc;
                }
                continue;
            }
            tmp = code & 0xFFFFFFFFL;
            int code_prefix = (int)(tmp >> 32 - table_nb_bits);
            int subtable_bits = n -= table_nb_bits;
            codes_base[codes_offset + i].bits = n;
            codes_base[codes_offset + i].code = code << table_nb_bits;
            for (k = i + 1; k < nb_codes && (n = codes_base[codes_offset + k].bits - table_nb_bits) > 0 && (code = codes_base[codes_offset + k].code) >> 32 - table_nb_bits == (long)code_prefix; ++k) {
                codes_base[codes_offset + k].bits = n;
                codes_base[codes_offset + k].code = code << table_nb_bits;
                subtable_bits = Math.max(subtable_bits, n);
            }
            subtable_bits = Math.min(subtable_bits, table_nb_bits);
            j = (flags & 2) != 0 ? GetBitContext.bitswap_32(code_prefix) >> 32 - table_nb_bits : (long)code_prefix;
            table_base[(int)((long)table_offset + j)][1] = (short)(-subtable_bits);
            int index = GetBitContext.build_table(vlc, subtable_bits, k - i, codes_base, codes_offset + i, flags);
            if (index < 0) {
                return -1;
            }
            table_base = vlc.table_base;
            table_offset = vlc.table_offset + table_index;
            table_base[(int)((long)table_offset + j)][0] = (short)index;
            i = k - 1;
        }
        return table_index;
    }

    public int get_vlc2(short[][] table_base, int table_offset, int bits, int max_depth, String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        int index = (int)((re_cache &= 0xFFFFFFFFL) >> 32 - bits);
        short code = table_base[table_offset + index][0];
        short n = table_base[table_offset + index][1];
        if (max_depth > 1 && n < 0) {
            pos = this.buffer_offset + ((re_index += bits) >> 3);
            re_cache = this.buffer[pos + 0];
            re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
            re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
            re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
            re_cache <<= re_index & 7;
            short nb_bits = -n;
            index = (int)((re_cache &= 0xFFFFFFFFL) >> 32 - nb_bits) + code;
            code = table_base[table_offset + index][0];
            n = table_base[table_offset + index][1];
            if (max_depth > 2 && n < 0) {
                pos = this.buffer_offset + ((re_index += nb_bits) >> 3);
                re_cache = this.buffer[pos + 0];
                re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
                re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
                re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
                re_cache <<= re_index & 7;
                nb_bits = -n;
                index = (int)((re_cache &= 0xFFFFFFFFL) >> 32 - nb_bits) + code;
                code = table_base[table_offset + index][0];
                n = table_base[table_offset + index][1];
            }
        }
        re_cache >>= n;
        this.index = re_index += n;
        return code;
    }

    public int get_ue_golomb(String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = re_cache &= 0xFFFFFFFFL;
        if (buf >= 0x8000000L) {
            this.index = re_index += ff_golomb_vlc_len[(int)(buf >>= 23)];
            return ff_ue_golomb_vlc_code[(int)buf];
        }
        int log = 2 * CAVLCContext.av_log2(buf) - 31;
        buf >>= log;
        this.index = re_index += 32 - log;
        return (int)(--buf);
    }

    public int get_ue_golomb_31(String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = (re_cache &= 0xFFFFFFFFL) >> 23;
        this.index = re_index += ff_golomb_vlc_len[(int)buf];
        return ff_ue_golomb_vlc_code[(int)buf];
    }

    public int get_se_golomb(String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = re_cache &= 0xFFFFFFFFL;
        if (buf >= 0x8000000L) {
            this.index = re_index += ff_golomb_vlc_len[(int)(buf >>= 23)];
            return ff_se_golomb_vlc_code[(int)buf];
        }
        int log = 2 * CAVLCContext.av_log2(buf) - 31;
        this.index = re_index += 32 - log;
        buf = ((buf >>= log) & 1L) != 0L ? -(buf >> 1) : (buf >>= 1);
        return (int)buf;
    }
}

