/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types.interrupts;

import java.util.Vector;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.interrupts.AbstractInterruptHandler;
import jpcsp.HLE.kernel.types.interrupts.SubIntrHandler;

public class IntrHandler
extends AbstractInterruptHandler {
    private Vector<SubIntrHandler> subInterrupts = new Vector();
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = Integer.MIN_VALUE;
    private boolean enabled;

    public IntrHandler() {
        this.enabled = true;
    }

    public IntrHandler(boolean enabled) {
        this.enabled = enabled;
    }

    public void addSubIntrHandler(int id, SubIntrHandler subIntrHandler) {
        if (id >= this.subInterrupts.size()) {
            this.subInterrupts.setSize(id + 1);
        }
        if (id < this.minIndex) {
            this.minIndex = id;
        }
        if (id > this.maxIndex) {
            this.maxIndex = id;
        }
        this.subInterrupts.set(id, subIntrHandler);
    }

    public boolean removeSubIntrHandler(int id) {
        int i;
        if (id < 0 || id >= this.subInterrupts.size()) {
            return false;
        }
        boolean removed = this.subInterrupts.get(id) != null;
        this.subInterrupts.set(id, null);
        this.minIndex = Integer.MAX_VALUE;
        for (i = 0; i < this.subInterrupts.size(); ++i) {
            if (this.subInterrupts.get(i) == null) continue;
            this.minIndex = i;
            break;
        }
        this.maxIndex = Integer.MIN_VALUE;
        for (i = this.subInterrupts.size() - 1; i >= this.minIndex; --i) {
            if (this.subInterrupts.get(i) == null) continue;
            this.maxIndex = i;
            break;
        }
        return removed;
    }

    public SubIntrHandler getSubIntrHandler(int id) {
        if (id < 0 || id >= this.subInterrupts.size()) {
            return null;
        }
        return this.subInterrupts.get(id);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void execute() {
        if (this.isEnabled()) {
            super.execute();
        }
    }

    @Override
    protected void executeInterrupt() {
        if (this.isEnabled()) {
            for (int id = this.minIndex; id <= this.maxIndex; ++id) {
                SubIntrHandler subIntrHandler = this.getSubIntrHandler(id);
                if (subIntrHandler == null || !subIntrHandler.isEnabled()) continue;
                IntrManager.getInstance().pushAllegrexInterruptHandler(subIntrHandler);
            }
        }
    }
}

