/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashSet;
import java.util.Set;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceMp4AvcCscStruct;
import jpcsp.HLE.kernel.types.SceMpegYCrCbBuffer;
import jpcsp.HLE.kernel.types.SceMpegYCrCbBufferSrc;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import jpcsp.media.codec.h264.H264Utils;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMpegbase
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMpegbase");
    private int pixelMode;
    private int defaultBufferWidth;
    private static Set<int[]> intBuffers;
    private static final int MAX_INT_BUFFERS_SIZE = 12;

    @Override
    public void start() {
        this.pixelMode = 3;
        this.defaultBufferWidth = 0;
        intBuffers = new HashSet<int[]>();
        super.start();
    }

    @Override
    public void stop() {
        intBuffers.clear();
        super.stop();
    }

    public static int getPixelMode(int internalPixelMode) {
        switch (internalPixelMode) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        log.error((Object)String.format("getPixelMode unknown internalPixelMode=0x%X", internalPixelMode));
        return -1;
    }

    public int getPixelMode() {
        return this.pixelMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getIntBuffer(int length) {
        Set<int[]> set = intBuffers;
        synchronized (set) {
            for (int[] intBuffer : intBuffers) {
                if (intBuffer.length < length) continue;
                intBuffers.remove(intBuffer);
                return intBuffer;
            }
        }
        return new int[length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseIntBuffer(int[] intBuffer) {
        if (intBuffer == null) {
            return;
        }
        Set<int[]> set = intBuffers;
        synchronized (set) {
            intBuffers.add(intBuffer);
            if (intBuffers.size() > 12) {
                int[] smallestIntBuffer = null;
                for (int[] buffer : intBuffers) {
                    if (smallestIntBuffer != null && buffer.length >= smallestIntBuffer.length) continue;
                    smallestIntBuffer = buffer;
                }
                intBuffers.remove(smallestIntBuffer);
            }
        }
    }

    public static void read(Memory mem, int addr, int length, int[] buffer, int offset) {
        if (mem == Emulator.getMemory()) {
            addr |= 0x8000000;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("read addr=0x%08X, length=0x%X", addr, length));
        }
        if (mem.hasMemoryInt(addr)) {
            int length4 = length >> 2;
            int addrOffset = mem.getMemoryIntOffset(addr);
            int[] memoryInt = mem.getMemoryInt(addr);
            int j = offset;
            for (int i = 0; i < length4; ++i) {
                int value = memoryInt[addrOffset++];
                buffer[j++] = value & 0xFF;
                buffer[j++] = value >> 8 & 0xFF;
                buffer[j++] = value >> 16 & 0xFF;
                buffer[j++] = value >> 24 & 0xFF;
            }
        } else {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(mem, addr, length, 1);
            int j = offset;
            for (int i = 0; i < length; ++i) {
                buffer[j++] = memoryReader.readNext();
            }
        }
    }

    public static void read(TPointer addr, int length, int[] buffer, int offset) {
        sceMpegbase.read(addr.getMemory(), addr.getAddress(), length, buffer, offset);
    }

    public static void write(Memory mem, int addr, int length, int[] buffer, int offset) {
        if (mem.hasMemoryInt(addr)) {
            int length4 = length >> 2;
            int addrOffset = mem.getMemoryIntOffset(addr);
            int[] memoryInt = mem.getMemoryInt(addr);
            int j = offset;
            for (int i = 0; i < length4; ++i) {
                int value = buffer[j++] & 0xFF;
                value |= (buffer[j++] & 0xFF) << 8;
                value |= (buffer[j++] & 0xFF) << 16;
                memoryInt[addrOffset++] = value |= buffer[j++] << 24;
            }
        } else {
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(mem, addr, length, 1);
            int j = offset;
            for (int i = 0; i < length; ++i) {
                memoryWriter.writeNext(buffer[j++]);
            }
            memoryWriter.flush();
        }
    }

    public static void write(TPointer addr, int length, int[] buffer, int offset) {
        sceMpegbase.write(addr.getMemory(), addr.getAddress(), length, buffer, offset);
    }

    private static void copy(Memory mem, int dst, int src, int length) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("copy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, length));
        }
        mem.memcpy(dst | 0x8000000, src | 0x8000000, length);
    }

    private static void copyBlocks(Memory mem, int dst, int src, int blocks) {
        sceMpegbase.copy(mem, dst, src, blocks << 4);
    }

    public static void read(YCbCrImageState imageState, int width, int height, Memory mem, int buffer0, int buffer1, int buffer2, int buffer3, int buffer4, int buffer5, int buffer6, int buffer7) {
        int i;
        int xx;
        int i2;
        int y;
        int x;
        int width2 = width >> 1;
        int height2 = height >> 1;
        int length = width * height;
        int length2 = width2 * height2;
        int[] luma = sceMpegbase.getIntBuffer(length);
        int[] cb = sceMpegbase.getIntBuffer(length2);
        int[] cr = sceMpegbase.getIntBuffer(length2);
        int sizeY1 = (width + 16 >> 5) * (height >> 1) * 16;
        int sizeY2 = (width >> 5) * (height >> 1) * 16;
        int sizeCrCb1 = sizeY1 >> 1;
        int sizeCrCb2 = sizeY1 >> 1;
        int[] bufferY1 = sceMpegbase.getIntBuffer(sizeY1);
        int[] bufferY2 = sceMpegbase.getIntBuffer(sizeY2);
        int[] bufferCrCb1 = sceMpegbase.getIntBuffer(sizeCrCb1);
        int[] bufferCrCb2 = sceMpegbase.getIntBuffer(sizeCrCb2);
        sceMpegbase.read(mem, buffer0, sizeY1, bufferY1, 0);
        sceMpegbase.read(mem, buffer1, sizeY2, bufferY2, 0);
        sceMpegbase.read(mem, buffer4, sizeCrCb1, bufferCrCb1, 0);
        sceMpegbase.read(mem, buffer5, sizeCrCb2, bufferCrCb2, 0);
        int j = 0;
        for (x = 0; x < width; x += 32) {
            y = 0;
            i2 = x;
            while (y < height) {
                System.arraycopy(bufferY1, j, luma, i2, 16);
                y += 2;
                i2 += 2 * width;
                j += 16;
            }
        }
        j = 0;
        for (x = 16; x < width; x += 32) {
            y = 0;
            i2 = x;
            while (y < height) {
                System.arraycopy(bufferY2, j, luma, i2, 16);
                y += 2;
                i2 += 2 * width;
                j += 16;
            }
        }
        j = 0;
        for (x = 0; x < width2; x += 16) {
            for (y = 0; y < height2; y += 2) {
                xx = 0;
                i = y * width2 + x;
                while (xx < 8) {
                    cb[i] = bufferCrCb1[j++];
                    cr[i] = bufferCrCb1[j++];
                    ++xx;
                    ++i;
                }
            }
        }
        j = 0;
        for (x = 0; x < width2; x += 16) {
            for (y = 1; y < height2; y += 2) {
                xx = 0;
                i = y * width2 + x;
                while (xx < 8) {
                    cb[i] = bufferCrCb2[j++];
                    cr[i] = bufferCrCb2[j++];
                    ++xx;
                    ++i;
                }
            }
        }
        sceMpegbase.read(mem, buffer2, sizeY1, bufferY1, 0);
        sceMpegbase.read(mem, buffer3, sizeY2, bufferY2, 0);
        sceMpegbase.read(mem, buffer6, sizeCrCb1, bufferCrCb1, 0);
        sceMpegbase.read(mem, buffer7, sizeCrCb2, bufferCrCb2, 0);
        j = 0;
        for (x = 0; x < width; x += 32) {
            y = 1;
            i2 = x + width;
            while (y < height) {
                System.arraycopy(bufferY1, j, luma, i2, 16);
                y += 2;
                i2 += 2 * width;
                j += 16;
            }
        }
        j = 0;
        for (x = 16; x < width; x += 32) {
            y = 1;
            i2 = x + width;
            while (y < height) {
                System.arraycopy(bufferY2, j, luma, i2, 16);
                y += 2;
                i2 += 2 * width;
                j += 16;
            }
        }
        j = 0;
        for (x = 8; x < width2; x += 16) {
            for (y = 0; y < height2; y += 2) {
                xx = 0;
                i = y * width2 + x;
                while (xx < 8) {
                    cb[i] = bufferCrCb1[j++];
                    cr[i] = bufferCrCb1[j++];
                    ++xx;
                    ++i;
                }
            }
        }
        j = 0;
        for (x = 8; x < width2; x += 16) {
            for (y = 1; y < height2; y += 2) {
                xx = 0;
                i = y * width2 + x;
                while (xx < 8) {
                    cb[i] = bufferCrCb2[j++];
                    cr[i] = bufferCrCb2[j++];
                    ++xx;
                    ++i;
                }
            }
        }
        sceMpegbase.releaseIntBuffer(bufferY1);
        sceMpegbase.releaseIntBuffer(bufferY2);
        sceMpegbase.releaseIntBuffer(bufferCrCb1);
        sceMpegbase.releaseIntBuffer(bufferCrCb2);
        imageState.width = width;
        imageState.height = height;
        imageState.lengthLuma = length;
        imageState.luma = luma;
        imageState.cb = cb;
        imageState.cr = cr;
    }

    public int hleMpegBaseCscAvc(TPointer bufferRGB, TPointer unknown, int bufferWidth, int videoPixelMode, SceMp4AvcCscStruct mp4AvcCscStruct) {
        int rangeX = 0;
        int rangeY = 0;
        int rangeWidth = mp4AvcCscStruct.width << 4;
        int rangeHeight = mp4AvcCscStruct.height << 4;
        return this.hleMpegBaseCscAvcRange(bufferRGB, unknown, bufferWidth, videoPixelMode, mp4AvcCscStruct, rangeX, rangeY, rangeWidth, rangeHeight);
    }

    private int hleMpegBaseCscAvcRange(TPointer bufferRGB, TPointer unknown, int bufferWidth, int videoPixelMode, SceMp4AvcCscStruct mp4AvcCscStruct, int rangeX, int rangeY, int rangeWidth, int rangeHeight) {
        if (bufferWidth == 0) {
            bufferWidth = this.defaultBufferWidth;
        }
        int width = mp4AvcCscStruct.width << 4;
        int height = mp4AvcCscStruct.height << 4;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(videoPixelMode);
        int destAddr = bufferRGB.getAddress();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleMpegBaseCscAvcRange bufferWidth=%d, width=%d, height=%d, pixelMode=%d, destAddr=%s", bufferWidth, width, height, videoPixelMode, bufferRGB));
        }
        YCbCrImageState imageState = new YCbCrImageState();
        sceMpegbase.read(imageState, width, height, mp4AvcCscStruct.bufferMemory, mp4AvcCscStruct.buffer0, mp4AvcCscStruct.buffer1, mp4AvcCscStruct.buffer2, mp4AvcCscStruct.buffer3, mp4AvcCscStruct.buffer4, mp4AvcCscStruct.buffer5, mp4AvcCscStruct.buffer6, mp4AvcCscStruct.buffer7);
        int[] abgr = sceMpegbase.getIntBuffer(imageState.lengthLuma);
        H264Utils.YUV2ABGR(width, height, imageState.luma, imageState.cb, imageState.cr, abgr);
        imageState.releaseIntBuffers();
        VideoEngine.getInstance().addVideoTexture(destAddr, destAddr + (rangeY + rangeHeight) * bufferWidth * bytesPerPixel);
        int shiftedDestAddr = destAddr & 0xFFFFF800;
        if (destAddr != shiftedDestAddr) {
            VideoEngine.getInstance().addVideoTexture(shiftedDestAddr, shiftedDestAddr + (rangeY + rangeHeight) * bufferWidth * bytesPerPixel);
        }
        if (videoPixelMode == 3 && RuntimeContext.hasMemoryInt(bufferRGB)) {
            int pixelIndex = rangeY * width + rangeX;
            Memory mem = bufferRGB.getMemory();
            int[] memoryInt = mem.getMemoryInt(destAddr);
            int addrOffset = mem.getMemoryIntOffset(destAddr);
            for (int i = 0; i < rangeHeight; ++i) {
                System.arraycopy(abgr, pixelIndex, memoryInt, addrOffset, rangeWidth);
                pixelIndex += width;
                addrOffset += bufferWidth;
            }
        } else {
            TPointer addr = new TPointer(bufferRGB);
            for (int i = 0; i < rangeHeight; ++i) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, rangeWidth * bytesPerPixel, bytesPerPixel);
                int pixelIndex = (i + rangeY) * width + rangeX;
                int j = 0;
                while (j < rangeWidth) {
                    int abgr8888 = abgr[pixelIndex];
                    int pixelColor = Debug.getPixelColor(abgr8888, videoPixelMode);
                    memoryWriter.writeNext(pixelColor);
                    ++j;
                    ++pixelIndex;
                }
                memoryWriter.flush();
                addr.add(bufferWidth * bytesPerPixel);
            }
        }
        sceMpegbase.releaseIntBuffer(abgr);
        return 0;
    }

    @HLEFunction(nid=-1096708207, version=150)
    public int sceMpegBasePESpacketCopy(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer packetInfo) {
        Memory mem = packetInfo.getMemory();
        while (packetInfo.isNotNull()) {
            int bufferAddr = packetInfo.getValue32(0);
            int destinationAddr = packetInfo.getValue32(4) | 0x8000000;
            TPointer nextPacketInfo = packetInfo.getPointer(8);
            int bufferLength = packetInfo.getValue32(12) & 0xFFF;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegBasePESpacketCopy packet at %s: bufferAddr=0x%08X, destinationAddr=0x%08X, nextInfoAddr=%s, bufferLength=0x%X", packetInfo, bufferAddr, destinationAddr, nextPacketInfo, bufferLength));
                if (log.isTraceEnabled()) {
                    log.debug((Object)String.format("sceMpegBasePESpacketCopy %s", Utilities.getMemoryDump(bufferAddr, bufferLength)));
                }
            }
            if (bufferLength == 0) {
                return -2147483388;
            }
            mem.memcpy(destinationAddr, bufferAddr, bufferLength);
            packetInfo = nextPacketInfo;
        }
        return 0;
    }

    @HLEFunction(nid=-1102724476, version=150)
    public int sceMpegBaseYCrCbCopyVme(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.in) TPointer destBufferYCrCb, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer32 srcBufferYCrCb, int type) {
        SceMpegYCrCbBuffer destMpegYCrCbBuffer = new SceMpegYCrCbBuffer();
        destMpegYCrCbBuffer.read(destBufferYCrCb);
        SceMpegYCrCbBufferSrc srcMpegYCrCbBuffer = new SceMpegYCrCbBufferSrc();
        srcMpegYCrCbBuffer.read(srcBufferYCrCb);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegBaseYCrCbCopyVme destMpegYCrCbBuffer: %s", destMpegYCrCbBuffer));
            log.debug((Object)String.format("sceMpegBaseYCrCbCopyVme srcMpegYCrCbBuffer: %s", srcMpegYCrCbBuffer));
        }
        Memory mem = destBufferYCrCb.getMemory();
        int sizeY = srcMpegYCrCbBuffer.frameWidth * srcMpegYCrCbBuffer.frameHeight;
        int sizeCrCb = sizeY >> 2;
        sceMpegbase.copy(mem, destMpegYCrCbBuffer.bufferY, srcMpegYCrCbBuffer.bufferY, sizeY);
        sceMpegbase.copy(mem, destMpegYCrCbBuffer.bufferY2, srcMpegYCrCbBuffer.bufferY2, sizeY);
        sceMpegbase.copy(mem, destMpegYCrCbBuffer.bufferCr, srcMpegYCrCbBuffer.bufferCr, sizeCrCb);
        sceMpegbase.copy(mem, destMpegYCrCbBuffer.bufferCb, srcMpegYCrCbBuffer.bufferCb, sizeCrCb);
        sceMpegbase.copy(mem, destMpegYCrCbBuffer.bufferCr2, srcMpegYCrCbBuffer.bufferCr2, sizeCrCb);
        sceMpegbase.copy(mem, destMpegYCrCbBuffer.bufferCb2, srcMpegYCrCbBuffer.bufferCb2, sizeCrCb);
        return 0;
    }

    @HLEFunction(nid=2059416090, version=150)
    public int sceMpegBaseYCrCbCopy(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.in) TPointer dst, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.in) TPointer src, int flags) {
        SceMp4AvcCscStruct dstStruct = new SceMp4AvcCscStruct();
        dstStruct.read(dst);
        SceMp4AvcCscStruct srcStruct = new SceMp4AvcCscStruct();
        srcStruct.read(src);
        int size1 = (srcStruct.width + 16 >> 5) * (srcStruct.height >> 1);
        int size2 = (srcStruct.width >> 5) * (srcStruct.height >> 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegBaseYCrCbCopy dstStruct: %s", dstStruct));
            log.debug((Object)String.format("sceMpegBaseYCrCbCopy srcStruct: %s", srcStruct));
            log.debug((Object)String.format("sceMpegBaseYCrCbCopy size1=0x%X, size2=0x%X", size1, size2));
        }
        Memory mem = Memory.getInstance();
        if ((flags & 1) != 0) {
            sceMpegbase.copyBlocks(mem, dstStruct.buffer0, srcStruct.buffer0, size1);
            sceMpegbase.copyBlocks(mem, dstStruct.buffer1, srcStruct.buffer1, size2);
            sceMpegbase.copyBlocks(mem, dstStruct.buffer4, srcStruct.buffer4, size1 >> 1);
            sceMpegbase.copyBlocks(mem, dstStruct.buffer5, srcStruct.buffer5, size2 >> 1);
        }
        if ((flags & 2) != 0) {
            sceMpegbase.copyBlocks(mem, dstStruct.buffer2, srcStruct.buffer2, size1);
            sceMpegbase.copyBlocks(mem, dstStruct.buffer3, srcStruct.buffer3, size2);
            sceMpegbase.copyBlocks(mem, dstStruct.buffer6, srcStruct.buffer6, size1 >> 1);
            sceMpegbase.copyBlocks(mem, dstStruct.buffer7, srcStruct.buffer7, size2 >> 1);
        }
        return 0;
    }

    @HLEFunction(nid=-829507529, version=150)
    public int sceMpegBaseCscVme(TPointer bufferRGB, TPointer bufferRGB2, int bufferWidth, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.in) TPointer32 bufferYCrCb) {
        SceMpegYCrCbBuffer sceMpegYCrCbBuffer = new SceMpegYCrCbBuffer();
        sceMpegYCrCbBuffer.read(bufferYCrCb);
        int width = sceMpegYCrCbBuffer.frameBufferWidth16 << 4;
        int height = sceMpegYCrCbBuffer.frameBufferHeight16 << 4;
        int videoPixelMode = 3;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(videoPixelMode);
        int rangeX = 0;
        int rangeY = 0;
        int rangeWidth = width;
        int rangeHeight = height;
        int destAddr = bufferRGB.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegBaseCscVme sceMpegYCrCbBuffer: %s", sceMpegYCrCbBuffer));
        }
        int width2 = width >> 1;
        int height2 = height >> 1;
        int length = width * height;
        int length2 = width2 * height2;
        int[] luma = sceMpegbase.getIntBuffer(length);
        int[] cb = sceMpegbase.getIntBuffer(length2);
        int[] cr = sceMpegbase.getIntBuffer(length2);
        sceMpegbase.read(sceMpegYCrCbBuffer.bufferMemory, sceMpegYCrCbBuffer.bufferY, length, luma, 0);
        sceMpegbase.read(sceMpegYCrCbBuffer.bufferMemory, sceMpegYCrCbBuffer.bufferCb, length2, cb, 0);
        sceMpegbase.read(sceMpegYCrCbBuffer.bufferMemory, sceMpegYCrCbBuffer.bufferCr, length2, cr, 0);
        int[] abgr = sceMpegbase.getIntBuffer(length);
        H264Utils.YUV2ABGR(width, height, luma, cb, cr, abgr);
        sceMpegbase.releaseIntBuffer(luma);
        sceMpegbase.releaseIntBuffer(cb);
        sceMpegbase.releaseIntBuffer(cr);
        VideoEngine.getInstance().addVideoTexture(destAddr, destAddr + (rangeY + rangeHeight) * bufferWidth * bytesPerPixel);
        if (videoPixelMode == 3 && RuntimeContext.hasMemoryInt()) {
            int pixelIndex = rangeY * width + rangeX;
            for (int i = 0; i < rangeHeight; ++i) {
                int addr = destAddr + i * bufferWidth * bytesPerPixel;
                System.arraycopy(abgr, pixelIndex, RuntimeContext.getMemoryInt(), addr >> 2, rangeWidth);
                pixelIndex += width;
            }
        } else {
            int addr = destAddr;
            for (int i = 0; i < rangeHeight; ++i) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, rangeWidth * bytesPerPixel, bytesPerPixel);
                int pixelIndex = (i + rangeY) * width + rangeX;
                int j = 0;
                while (j < rangeWidth) {
                    int abgr8888 = abgr[pixelIndex];
                    int pixelColor = Debug.getPixelColor(abgr8888, videoPixelMode);
                    memoryWriter.writeNext(pixelColor);
                    ++j;
                    ++pixelIndex;
                }
                memoryWriter.flush();
                addr += bufferWidth * bytesPerPixel;
            }
        }
        sceMpegbase.releaseIntBuffer(abgr);
        return 0;
    }

    @HLEFunction(nid=1227578955, version=150)
    public int sceMpegBaseCscInit(int bufferWidth) {
        H264Utils.setAlpha(0);
        TPointer unknown = Utilities.allocatePointer(22);
        unknown.setValue32(0, 149);
        unknown.setValue32(4, 9765068);
        unknown.setValue32(8, 60294094);
        unknown.setValue32(12, 16908437);
        unknown.setValue32(16, 0x100000);
        unknown.setValue16(20, (short)1);
        return this.sceMpegbase_AC9E717E(bufferWidth, unknown);
    }

    @HLEFunction(nid=-1852663263, version=150)
    public int sceMpegBaseCscAvc(TPointer bufferRGB, @CanBeNull TPointer unknown, int bufferWidth, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.in) TPointer mp4AvcCscStructAddr) {
        SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
        mp4AvcCscStruct.read(mp4AvcCscStructAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegBaseCscAvc %s", mp4AvcCscStruct));
        }
        return this.hleMpegBaseCscAvc(bufferRGB, unknown, bufferWidth, this.pixelMode, mp4AvcCscStruct);
    }

    @HLEFunction(nid=810058465, version=150)
    public int sceMpegBaseCscAvcRange(TPointer bufferRGB, @CanBeNull TPointer unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer32 rangeAddr, int bufferWidth, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.in) TPointer mp4AvcCscStructAddr) {
        SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
        mp4AvcCscStruct.read(mp4AvcCscStructAddr);
        int rangeX = rangeAddr.getValue(0) << 4;
        int rangeY = rangeAddr.getValue(4) << 4;
        int rangeWidth = rangeAddr.getValue(8) << 4;
        int rangeHeight = rangeAddr.getValue(12) << 4;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegBaseCscAvcRange range x=%d, y=%d, width=%d, height=%d, %s", rangeX, rangeY, rangeWidth, rangeHeight, mp4AvcCscStruct));
        }
        return this.hleMpegBaseCscAvcRange(bufferRGB, unknown, bufferWidth, this.pixelMode, mp4AvcCscStruct, rangeX, rangeY, rangeWidth, rangeHeight);
    }

    @HLEFunction(nid=87080526, version=150)
    public int sceMpegbase_0530BE4E(int internalPixelMode) {
        int pixelMode = sceMpegbase.getPixelMode(internalPixelMode);
        if (pixelMode < 0) {
            return -1;
        }
        this.pixelMode = pixelMode;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1398902402, version=150)
    public int sceMpegbase_AC9E717E(int defaultBufferWidth, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=22, usage=BufferInfo.Usage.in) TPointer unknown) {
        this.defaultBufferWidth = defaultBufferWidth;
        return 0;
    }

    public static class YCbCrImageState {
        public int width;
        public int height;
        public int lengthLuma;
        public int[] luma;
        public int[] cb;
        public int[] cr;

        public void releaseIntBuffers() {
            sceMpegbase.releaseIntBuffer(this.luma);
            this.luma = null;
            sceMpegbase.releaseIntBuffer(this.cb);
            this.cb = null;
            sceMpegbase.releaseIntBuffer(this.cr);
            this.cr = null;
        }
    }
}

