/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import com.savarese.rocksaw.net.RawSocket;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceNetInetTcpcbstat;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspNetSockAddrInternet;
import jpcsp.HLE.modules.sceNetAdhocctl;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.network.RawChannel;
import jpcsp.network.RawSelector;
import jpcsp.remote.HTTPConfiguration;
import jpcsp.remote.HTTPServer;
import jpcsp.settings.AbstractStringSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetInet
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetInet");
    public static final int AF_INET = 2;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    public static final int SOCK_STREAM_UNKNOWN_10 = 10;
    public static final int SOCK_DGRAM_UNKNOWN_6 = 6;
    private static final String[] socketTypeNames = new String[]{"Unknown0", "SOCK_STREAM", "SOCK_DGRAM", "SOCK_RAW", "Unknown4", "Unknown5", "SOCK_DGRAM_UNKNOWN_6", "Unknown7", "Unknown8", "Unknown9", "SOCK_STREAM_UNKNOWN_10"};
    public static final int SOL_SOCKET = 65535;
    public static final int INADDR_ANY = 0;
    public static final int INADDR_BROADCAST = -1;
    public static final int EAGAIN = 11;
    public static final int EWOULDBLOCK = 11;
    public static final int EINPROGRESS = 119;
    public static final int ENOTCONN = 128;
    public static final int ECLOSED = 32;
    public static final int EIO = 5;
    public static final int EISCONN = 127;
    public static final int EALREADY = 120;
    public static final int EADDRNOTAVAIL = 125;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;
    public static final int SO_DEBUG = 1;
    public static final int SO_ACCEPTCONN = 2;
    public static final int SO_REUSEADDR = 4;
    public static final int SO_KEEPALIVE = 8;
    public static final int SO_DONTROUTE = 16;
    public static final int SO_BROADCAST = 32;
    public static final int SO_USELOOPBACK = 64;
    public static final int SO_LINGER = 128;
    public static final int SO_OOBINLINE = 256;
    public static final int SO_REUSEPORT = 512;
    public static final int SO_TIMESTAMP = 1024;
    public static final int SO_ONESBCAST = 2048;
    public static final int SO_SNDBUF = 4097;
    public static final int SO_RCVBUF = 4098;
    public static final int SO_SNDLOWAT = 4099;
    public static final int SO_RCVLOWAT = 4100;
    public static final int SO_SNDTIMEO = 4101;
    public static final int SO_RCVTIMEO = 4102;
    public static final int SO_ERROR = 4103;
    public static final int SO_TYPE = 4104;
    public static final int SO_OVERFLOWED = 4105;
    public static final int SO_NONBLOCK = 4105;
    public static final int POLLIN = 1;
    public static final int POLLPRI = 2;
    public static final int POLLOUT = 4;
    public static final int POLLERR = 8;
    public static final int POLLHUP = 16;
    public static final int POLLNVAL = 32;
    public static final int POLLRDNORM = 64;
    public static final int POLLRDBAND = 128;
    public static final int POLLWRBAND = 256;
    public static final int POLL_INFTIM = -1;
    protected static final int BLOCKED_OPERATION_POLLING_MICROS = 10000;
    protected static final int readSelectionKeyOperations = 17;
    protected static final int writeSelectionKeyOperations = 4;
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    public static final int MSG_EOR = 8;
    public static final int MSG_TRUNC = 16;
    public static final int MSG_CTRUNC = 32;
    public static final int MSG_WAITALL = 64;
    public static final int MSG_DONTWAIT = 128;
    public static final int MSG_BCAST = 256;
    public static final int MSG_MCAST = 512;
    public static final int TCPS_CLOSED = 0;
    public static final int TCPS_LISTEN = 1;
    public static final int TCPS_SYN_SENT = 2;
    public static final int TCPS_SYN_RECEIVED = 3;
    public static final int TCPS_ESTABLISHED = 4;
    public static final int TCPS_CLOSE_WAIT = 5;
    public static final int TCPS_FIN_WAIT_1 = 6;
    public static final int TCPS_CLOSING = 7;
    public static final int TCPS_LAST_ACK = 8;
    public static final int TCPS_FIN_WAIT_2 = 9;
    public static final int TCPS_TIME_WAIT = 10;
    private static InetAddress[] broadcastAddresses;
    protected HashMap<Integer, pspInetSocket> sockets;
    protected static final String idPurpose = "sceNetInet-socket";
    private InetAddress[] doProxyInetAddresses;
    private final byte[] unknown1 = new byte[4];
    private final byte[] unknown2 = new byte[4];

    public void addProxyInetAddress(String serverName, InetAddress inetAddress) {
        if (inetAddress == null || serverName == null) {
            return;
        }
        boolean doProxy = false;
        for (HTTPConfiguration.HttpServerConfiguration doProxyServer : HTTPConfiguration.doProxyServers) {
            if (!doProxyServer.serverName.equals(serverName)) continue;
            doProxy = true;
            break;
        }
        if (!doProxy) {
            return;
        }
        if (this.doProxyInetAddresses != null) {
            for (InetAddress proxyInetAddress : this.doProxyInetAddresses) {
                if (!proxyInetAddress.equals(inetAddress)) continue;
                return;
            }
        }
        this.doProxyInetAddresses = Utilities.add(this.doProxyInetAddresses, inetAddress);
    }

    public static InetSocketAddress[] getBroadcastInetSocketAddress(int port) throws UnknownHostException {
        if (broadcastAddresses == null) {
            String broadcastAddressNames = Settings.getInstance().readString("network.broadcastAddress");
            if (broadcastAddressNames != null && broadcastAddressNames.length() > 0) {
                String[] addressNames = broadcastAddressNames.split(" *[,;] *");
                ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
                for (int i = 0; i < addressNames.length; ++i) {
                    try {
                        InetAddress address = InetAddress.getByName(addressNames[i]);
                        addresses.add(address);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("Error resolving the broadcast address '%s' from the Settings file", addressNames[i]), (Throwable)e);
                    }
                }
                if (addresses.size() > 0) {
                    broadcastAddresses = addresses.toArray(new InetAddress[addresses.size()]);
                }
            }
            if (broadcastAddresses == null) {
                InetAddress localInetAddress = InetAddress.getByName(sceNetApctl.getLocalHostIP());
                int localAddress = sceNetInet.bytesToInternetAddress(localInetAddress.getAddress());
                int subnetMask = Integer.reverseBytes(sceNetApctl.getSubnetMaskInt());
                int localBroadcastAddressInt = localAddress & subnetMask;
                localBroadcastAddressInt |= 0xFFFFFFFF & ~subnetMask;
                InetAddress loopbackInetAddress = InetAddress.getLoopbackAddress();
                int loopbackAddress = sceNetInet.bytesToInternetAddress(loopbackInetAddress.getAddress());
                int loopbackSubnetMask = Integer.reverseBytes(-16777216);
                int loopbackBroadcastAddressInt = loopbackAddress & loopbackSubnetMask;
                broadcastAddresses = new InetAddress[2];
                sceNetInet.broadcastAddresses[0] = InetAddress.getByAddress(sceNetInet.internetAddressToBytes(localBroadcastAddressInt));
                sceNetInet.broadcastAddresses[1] = InetAddress.getByAddress(sceNetInet.internetAddressToBytes(loopbackBroadcastAddressInt |= 0xFFFFFFFF & ~loopbackSubnetMask));
            }
            if (log.isDebugEnabled()) {
                for (int i = 0; i < broadcastAddresses.length; ++i) {
                    log.debug((Object)String.format("Using the following broadcast address#%d: %s", i + 1, broadcastAddresses[i].getHostAddress()));
                }
            }
        }
        InetSocketAddress[] socketAddresses = new InetSocketAddress[broadcastAddresses.length];
        for (int i = 0; i < socketAddresses.length; ++i) {
            socketAddresses[i] = new InetSocketAddress(broadcastAddresses[i], port);
        }
        return socketAddresses;
    }

    @Override
    public void start() {
        this.setSettingsListener("network.broadcastAddress", new BroadcastAddressSettingsListener());
        this.sockets = new HashMap();
        this.doProxyInetAddresses = null;
        AsyncStartThread asyncStartThread = new AsyncStartThread();
        asyncStartThread.setName("sceNetInet Async Start Thread");
        asyncStartThread.start();
        super.start();
    }

    @Override
    public void stop() {
        for (pspInetSocket inetSocket : this.sockets.values()) {
            inetSocket.close();
        }
        this.sockets.clear();
        super.stop();
    }

    public static void setErrnoToSelf(int errno) {
        sceNetInet.setErrno(errno, Modules.ThreadManForUserModule.getCurrentThread());
    }

    private static void setErrno(int errno, SceKernelThreadInfo thread) {
        thread.errno = errno;
    }

    private static void setErrno(int errno, BlockingState blockingState) {
        if (blockingState == null) {
            sceNetInet.setErrnoToSelf(errno);
        } else {
            sceNetInet.setErrno(errno, Modules.ThreadManForUserModule.getThreadById(blockingState.threadId));
        }
    }

    public static int getErrno() {
        return Modules.ThreadManForUserModule.getCurrentThread().errno;
    }

    protected int createSocketId() {
        return SceUidManager.getNewId(idPurpose, 1, 255);
    }

    protected pspInetSocket createSocket(int type, int protocol) {
        int uid = this.createSocketId();
        pspInetSocket inetSocket = null;
        if (type == 1) {
            inetSocket = new pspInetStreamSocket(uid);
        } else if (type == 2) {
            inetSocket = new pspInetDatagramSocket(uid);
        } else if (type == 3) {
            inetSocket = new pspInetRawSocket(uid, protocol);
        } else if (type == 6) {
            inetSocket = new pspInetDatagramSocket(uid);
        } else if (type == 10) {
            inetSocket = new pspInetStreamSocket(uid);
        }
        this.sockets.put(uid, inetSocket);
        return inetSocket;
    }

    protected void releaseSocketId(int id) {
        SceUidManager.releaseId(id, idPurpose);
    }

    protected int readSocketList(Selector selector, RawSelector rawSelector, TPointer address, int n, int selectorOperation, String comment) {
        int closedSocketsCount = 0;
        if (address.isNotNull()) {
            LinkedList<Integer> closedChannels = new LinkedList<Integer>();
            int length = (n + 7) / 8;
            if (selectorOperation != 0) {
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(address.getAddress(), length, 4);
                int value = 0;
                for (int socket = 0; socket < n; ++socket) {
                    int registeredOperation;
                    SelectableChannel selectableChannel;
                    pspInetSocket inetSocket;
                    if (socket % 32 == 0) {
                        value = memoryReader.readNext();
                    }
                    int bit = value & 1;
                    value >>>= 1;
                    if (bit == 0 || (inetSocket = this.sockets.get(socket)) == null || (selectableChannel = inetSocket.getSelectableChannel()) == null || (registeredOperation = selectorOperation & selectableChannel.validOps()) == 0) continue;
                    Selector socketSelector = inetSocket.getSelector(selector, rawSelector);
                    if (selectableChannel.isRegistered()) {
                        SelectionKey selectionKey = selectableChannel.keyFor(socketSelector);
                        selectionKey.interestOps(selectionKey.interestOps() | registeredOperation);
                        continue;
                    }
                    try {
                        selectableChannel.register(socketSelector, registeredOperation, new Integer(socket));
                        continue;
                    }
                    catch (ClosedChannelException e) {
                        closedChannels.add(socket);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("%s: %s", inetSocket.toString(), e.toString()));
                    }
                }
            }
            address.clear(length);
            for (Integer socket : closedChannels) {
                this.setSelectBit(address, socket);
                ++closedSocketsCount;
            }
        }
        return closedSocketsCount;
    }

    protected String dumpSelectBits(TPointer addr, int n) {
        if (addr.isNull() || n <= 0) {
            return "";
        }
        StringBuilder dump = new StringBuilder();
        for (int socket = 0; socket < n; ++socket) {
            int bit = 1 << socket % 8;
            byte value = addr.getValue8(socket / 8);
            if ((value & bit) == 0) continue;
            if (dump.length() > 0) {
                dump.append(", ");
            }
            dump.append(String.format("%d", socket));
        }
        return dump.toString();
    }

    protected void setSelectBit(TPointer addr, int socket) {
        if (addr.isNotNull()) {
            int offset = socket / 8;
            int value = 1 << socket % 8;
            addr.setValue8(offset, (byte)(addr.getValue8(offset) | value));
        }
    }

    protected void blockThread(BlockingState blockingState) {
        if (!blockingState.threadBlocked) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Blocking the current thread %s", Modules.ThreadManForUserModule.getCurrentThread().toString()));
            }
            Modules.ThreadManForUserModule.hleBlockCurrentThread(259, blockingState);
            blockingState.threadBlocked = true;
        }
        long schedule = Emulator.getClock().microTime() + 10000L;
        Emulator.getScheduler().addAction(schedule, blockingState);
    }

    protected void unblockThread(BlockingState blockingState, int returnValue) {
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getThreadById(blockingState.threadId);
        if (thread != null) {
            thread.cpuContext._v0 = returnValue;
        }
        if (blockingState.threadBlocked) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unblocking the thread %s", thread.toString()));
            }
            Modules.ThreadManForUserModule.hleUnblockThread(blockingState.threadId);
            blockingState.threadBlocked = false;
        }
    }

    protected int checkInvalidSelectedSockets(BlockingSelectState blockingState) {
        int countInvalidSocket = 0;
        for (SelectionKey selectionKey : blockingState.selector.keys()) {
            int interestOps;
            int socket;
            pspInetSocket inetSocket;
            if (!selectionKey.isValid() || (inetSocket = this.sockets.get(socket = ((Integer)selectionKey.attachment()).intValue())) != null && inetSocket.isValid()) continue;
            ++countInvalidSocket;
            try {
                interestOps = selectionKey.interestOps();
            }
            catch (CancelledKeyException e) {
                interestOps = 29;
            }
            if ((interestOps & 0x11) != 0) {
                this.setSelectBit(blockingState.readSocketsAddr, socket);
            }
            if ((interestOps & 4) == 0) continue;
            this.setSelectBit(blockingState.writeSocketsAddr, socket);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("checkInvalidSelectedSockets returns %d", countInvalidSocket));
        }
        return countInvalidSocket;
    }

    protected void setPollResult(pspInetPollFd[] pollFds, int socket, int revents) {
        for (int i = 0; i < pollFds.length; ++i) {
            if (pollFds[i].fd != socket) continue;
            pollFds[i].revents |= revents;
            break;
        }
    }

    protected void blockedPoll(BlockingPollState blockingState) {
        try {
            boolean threadBlocked;
            for (int i = 0; i < blockingState.pollFds.length; ++i) {
                pspInetSocket inetSocket = this.sockets.get(blockingState.pollFds[i].fd);
                if (inetSocket == null) continue;
                inetSocket.finishConnect();
            }
            int count = blockingState.selector.selectNow();
            if (count <= 0) {
                if (blockingState.isTimeout()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceNetInetPoll returns %d sockets (timeout)", count));
                    }
                    threadBlocked = false;
                } else {
                    threadBlocked = true;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetPoll returns %d sockets", count));
                }
                Iterator<SelectionKey> it = blockingState.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    int socket;
                    SelectionKey selectionKey = it.next();
                    it.remove();
                    if (selectionKey.isReadable()) {
                        socket = (Integer)selectionKey.attachment();
                        this.setPollResult(blockingState.pollFds, socket, 65);
                    }
                    if (!selectionKey.isWritable()) continue;
                    socket = (Integer)selectionKey.attachment();
                    this.setPollResult(blockingState.pollFds, socket, 4);
                }
                threadBlocked = false;
            }
            if (threadBlocked) {
                this.blockThread(blockingState);
            } else {
                blockingState.selector.close();
                Memory mem = Memory.getInstance();
                for (int i = 0; i < blockingState.pollFds.length; ++i) {
                    blockingState.pollFds[i].write(mem);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("sceNetInetPoll returning pollFd[%d]=%s", i, blockingState.pollFds[i].toString()));
                }
                this.unblockThread(blockingState, count);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected void processSelectedKey(Selector selector, BlockingSelectState blockingState) {
        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
        while (it.hasNext()) {
            int socket;
            SelectionKey selectionKey = it.next();
            it.remove();
            if ((selectionKey.readyOps() & 0x11) != 0) {
                socket = (Integer)selectionKey.attachment();
                this.setSelectBit(blockingState.readSocketsAddr, socket);
            }
            if ((selectionKey.readyOps() & 4) == 0) continue;
            socket = (Integer)selectionKey.attachment();
            this.setSelectBit(blockingState.writeSocketsAddr, socket);
        }
    }

    protected void blockedSelect(BlockingSelectState blockingState) {
        try {
            boolean threadBlocked;
            for (SelectionKey selectionKey : blockingState.selector.keys()) {
                Integer socket = (Integer)selectionKey.attachment();
                pspInetSocket inetSocket = this.sockets.get(socket);
                if (inetSocket == null) continue;
                inetSocket.finishConnect();
            }
            int count = blockingState.count;
            count += blockingState.selector.selectNow();
            count += blockingState.rawSelector.selectNow();
            if ((count += this.checkInvalidSelectedSockets(blockingState)) <= 0) {
                if (blockingState.isTimeout()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceNetInetSelect returns %d sockets (timeout)", count));
                    }
                    threadBlocked = false;
                } else {
                    threadBlocked = true;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetSelect returns %d sockets", count));
                }
                this.processSelectedKey(blockingState.selector, blockingState);
                this.processSelectedKey(blockingState.rawSelector, blockingState);
                threadBlocked = false;
            }
            if (threadBlocked) {
                this.blockThread(blockingState);
            } else {
                blockingState.selector.close();
                blockingState.rawSelector.close();
                if (log.isDebugEnabled() && count > 0) {
                    if (blockingState.readSocketsAddr.isNotNull()) {
                        log.debug((Object)String.format("sceNetInetSelect returning Read Sockets       : %s", this.dumpSelectBits(blockingState.readSocketsAddr, blockingState.numberSockets)));
                    }
                    if (blockingState.writeSocketsAddr.isNotNull()) {
                        log.debug((Object)String.format("sceNetInetSelect returning Write Sockets      : %s", this.dumpSelectBits(blockingState.writeSocketsAddr, blockingState.numberSockets)));
                    }
                    if (blockingState.outOfBandSocketsAddr.isNotNull()) {
                        log.debug((Object)String.format("sceNetInetSelect returning Out-of-band Sockets: %s", this.dumpSelectBits(blockingState.outOfBandSocketsAddr, blockingState.numberSockets)));
                    }
                }
                this.unblockThread(blockingState, count);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static String internetAddressToString(int address) {
        int n4 = address >> 24 & 0xFF;
        int n3 = address >> 16 & 0xFF;
        int n2 = address >> 8 & 0xFF;
        int n1 = address & 0xFF;
        return String.format("%d.%d.%d.%d", n1, n2, n3, n4);
    }

    public static String internetAddressToString(byte[] bytes) {
        return sceNetInet.internetAddressToString(sceNetInet.bytesToInternetAddress(bytes));
    }

    public static int bytesToInternetAddress(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int inetAddress = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            inetAddress = inetAddress << 8 | bytes[i] & 0xFF;
        }
        return inetAddress;
    }

    public static byte[] internetAddressToBytes(int address) {
        byte[] bytes = new byte[4];
        int n4 = address >> 24 & 0xFF;
        int n3 = address >> 16 & 0xFF;
        int n2 = address >> 8 & 0xFF;
        int n1 = address & 0xFF;
        bytes[3] = (byte)n4;
        bytes[2] = (byte)n3;
        bytes[1] = (byte)n2;
        bytes[0] = (byte)n1;
        return bytes;
    }

    protected static String getSocketTypeNameString(int type) {
        if (type < 0 || type >= socketTypeNames.length) {
            return String.format("Unknown type %d", type);
        }
        return socketTypeNames[type];
    }

    protected static String getPollEventName(int event) {
        StringBuilder name = new StringBuilder();
        if ((event & 1) != 0) {
            name.append("|POLLIN");
        }
        if ((event & 2) != 0) {
            name.append("|POLLPRI");
        }
        if ((event & 4) != 0) {
            name.append("|POLLOUT");
        }
        if ((event & 8) != 0) {
            name.append("|POLLERR");
        }
        if ((event & 0x10) != 0) {
            name.append("|POLLHUP");
        }
        if ((event & 0x20) != 0) {
            name.append("|POLLNVAL");
        }
        if ((event & 0x40) != 0) {
            name.append("|POLLRDNORM");
        }
        if ((event & 0x80) != 0) {
            name.append("|POLLRDBAND");
        }
        if ((event & 0x100) != 0) {
            name.append("|POLLWRBAND");
        }
        if (name.length() > 0 && name.charAt(0) == '|') {
            name.deleteCharAt(0);
        }
        return name.toString();
    }

    protected static String getOptionNameString(int optionName) {
        switch (optionName) {
            case 1: {
                return "SO_DEBUG";
            }
            case 2: {
                return "SO_ACCEPTCONN";
            }
            case 4: {
                return "SO_REUSEADDR";
            }
            case 8: {
                return "SO_KEEPALIVE";
            }
            case 16: {
                return "SO_DONTROUTE";
            }
            case 32: {
                return "SO_BROADCAST";
            }
            case 64: {
                return "SO_USELOOPBACK";
            }
            case 128: {
                return "SO_LINGER";
            }
            case 256: {
                return "SO_OOBINLINE";
            }
            case 512: {
                return "SO_REUSEPORT";
            }
            case 1024: {
                return "SO_TIMESTAMP";
            }
            case 2048: {
                return "SO_ONESBCAST";
            }
            case 4097: {
                return "SO_SNDBUF";
            }
            case 4098: {
                return "SO_RCVBUF";
            }
            case 4099: {
                return "SO_SNDLOWAT";
            }
            case 4100: {
                return "SO_RCVLOWAT";
            }
            case 4101: {
                return "SO_SNDTIMEO";
            }
            case 4102: {
                return "SO_RCVTIMEO";
            }
            case 4103: {
                return "SO_ERROR";
            }
            case 4104: {
                return "SO_TYPE";
            }
            case 4105: {
                return "SO_NONBLOCK";
            }
        }
        return String.format("Unknown option 0x%X", optionName);
    }

    public int checkSocket(int socket) {
        if (!this.sockets.containsKey(socket)) {
            log.warn((Object)String.format("checkSocket invalid socket=0x%X", socket));
            throw new SceKernelErrorException(-1);
        }
        return socket;
    }

    public int checkAddressLength(int addressLength) {
        if (addressLength < 16) {
            log.warn((Object)String.format("checkAddressLength invalid addressLength=%d", addressLength));
            throw new SceKernelErrorException(-1);
        }
        return addressLength;
    }

    private void getProxyForSockAddrInternet(pspNetSockAddrInternet sockAddrInternet) {
        for (InetAddress inetAddress : this.doProxyInetAddresses) {
            if (!sockAddrInternet.equals(inetAddress)) continue;
            sockAddrInternet.sin_addr = HTTPServer.getInstance().getProxyAddress();
            sockAddrInternet.sin_port = HTTPServer.getInstance().getProxyPort();
            break;
        }
    }

    @HLEFunction(nid=395588505, version=150)
    public int sceNetInetInit() {
        return 0;
    }

    @HLEFunction(nid=-1444059463, version=150)
    public int sceNetInetTerm() {
        return 0;
    }

    @HLEFunction(nid=-620147173, version=150)
    public int sceNetInetAccept(@CheckArgument(value="checkSocket") int socket, TPointer address, TPointer32 addressLengthAddr) {
        pspInetSocket inetSocket = this.sockets.get(socket);
        pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
        int addressLength = addressLengthAddr.getValue();
        if (addressLength < 0) {
            addressLength = Integer.MAX_VALUE;
        }
        sockAddrInternet.setMaxSize(addressLength);
        sockAddrInternet.write(address);
        if (sockAddrInternet.sizeof() < addressLength) {
            addressLengthAddr.setValue(sockAddrInternet.sizeof());
        }
        return inetSocket.accept(sockAddrInternet);
    }

    @HLEFunction(nid=439613870, version=150)
    public int sceNetInetBind(@CheckArgument(value="checkSocket") int socket, pspNetSockAddrInternet sockAddrInternet, @CheckArgument(value="checkAddressLength") int addressLength) {
        if (sockAddrInternet.sin_family != 2) {
            log.warn((Object)String.format("sceNetInetBind invalid socket address family=%d", sockAddrInternet.sin_family));
            return -1;
        }
        pspInetSocket inetSocket = this.sockets.get(socket);
        int result = inetSocket.bind(sockAddrInternet);
        if (result == 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceNetInetBind binding to %s", sockAddrInternet.toString()));
            }
        } else {
            log.warn((Object)String.format("sceNetInetBind failed binding to %s", sockAddrInternet.toString()));
        }
        return result;
    }

    @HLEFunction(nid=-1921874710, version=150)
    public int sceNetInetClose(@CheckArgument(value="checkSocket") int socket) {
        pspInetSocket inetSocket = this.sockets.get(socket);
        int result = inetSocket.close();
        this.releaseSocketId(socket);
        this.sockets.remove(socket);
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2141912355, version=150)
    public int sceNetInetCloseWithRST() {
        return 0;
    }

    @HLEFunction(nid=1091253418, version=150)
    public int sceNetInetConnect(@CheckArgument(value="checkSocket") int socket, pspNetSockAddrInternet sockAddrInternet, @CheckArgument(value="checkAddressLength") int addressLength) {
        if (sockAddrInternet.sin_family != 2) {
            log.warn((Object)String.format("sceNetInetConnect invalid socket address family=%d", sockAddrInternet.sin_family));
            return -1;
        }
        this.getProxyForSockAddrInternet(sockAddrInternet);
        pspInetSocket inetSocket = this.sockets.get(socket);
        int result = inetSocket.connect(sockAddrInternet);
        if (result == 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceNetInetConnect connected to %s", sockAddrInternet.toString()));
            }
        } else if (sceNetInet.getErrno() == 119) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceNetInetConnect connecting to %s", sockAddrInternet.toString()));
            }
        } else {
            log.warn((Object)String.format("sceNetInetConnect failed connecting to %s (errno=%d)", sockAddrInternet.toString(), sceNetInet.getErrno()));
        }
        return result;
    }

    @HLEFunction(nid=-498616618, version=150)
    public int sceNetInetGetpeername(@CheckArgument(value="checkSocket") int socket, TPointer address, TPointer32 addressLengthAddr) {
        pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
        pspInetSocket inetSocket = this.sockets.get(socket);
        int result = inetSocket.getSockname(sockAddrInternet);
        sockAddrInternet.setMaxSize(addressLengthAddr.getValue());
        sockAddrInternet.write(address);
        addressLengthAddr.setValue(sockAddrInternet.sizeof());
        return result;
    }

    @HLEFunction(nid=372142037, version=150)
    public int sceNetInetGetsockname(@CheckArgument(value="checkSocket") int socket, TPointer address, TPointer32 addressLengthAddr) {
        pspNetSockAddrInternet sockAddrInternet = new pspNetSockAddrInternet();
        pspInetSocket inetSocket = this.sockets.get(socket);
        int result = inetSocket.getSockname(sockAddrInternet);
        sockAddrInternet.setMaxSize(addressLengthAddr.getValue());
        sockAddrInternet.write(address);
        addressLengthAddr.setValue(sockAddrInternet.sizeof());
        return result;
    }

    @HLEFunction(nid=1242647676, version=150)
    public int sceNetInetGetsockopt(@CheckArgument(value="checkSocket") int socket, int level, int optionName, TPointer optionValue, @CanBeNull TPointer32 optionLengthAddr) {
        int optionLength;
        int n = optionLength = optionLengthAddr.isNull() ? 0 : optionLengthAddr.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetGetsockopt optionName=%s, optionLength=%d", sceNetInet.getOptionNameString(optionName), optionLength));
        }
        pspInetSocket inetSocket = this.sockets.get(socket);
        if (optionName == 4103 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.getErrorAndClearToSelf());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetInetGetsockopt SO_ERROR returning %d", optionValue.getValue32()));
            }
            optionLengthAddr.setValue(4);
        } else if (optionName == 4105 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.isBlocking());
            optionLengthAddr.setValue(4);
        } else if (optionName == 32 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.isBroadcast());
            optionLengthAddr.setValue(4);
        } else if (optionName == 4100 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.getReceiveLowWaterMark());
            optionLengthAddr.setValue(4);
        } else if (optionName == 4099 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.getSendLowWaterMark());
            optionLengthAddr.setValue(4);
        } else if (optionName == 4102 && optionLength >= 4) {
            int timeout = inetSocket.getReceiveTimeout();
            optionValue.setValue32(timeout == Integer.MAX_VALUE ? 0 : timeout);
            optionLengthAddr.setValue(4);
        } else if (optionName == 4101 && optionLength >= 4) {
            int timeout = inetSocket.getSendTimeout();
            optionValue.setValue32(timeout == Integer.MAX_VALUE ? 0 : timeout);
            optionLengthAddr.setValue(4);
        } else if (optionName == 4098 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.getReceiveBufferSize());
            optionLengthAddr.setValue(4);
        } else if (optionName == 4097 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.getSendBufferSize());
            optionLengthAddr.setValue(4);
        } else if (optionName == 8 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.isKeepAlive());
            optionLengthAddr.setValue(4);
        } else if (optionName == 128 && optionLength >= 8) {
            optionValue.setValue32(0, inetSocket.isLingerEnabled());
            optionValue.setValue32(4, inetSocket.getLinger());
            optionLengthAddr.setValue(8);
        } else if (optionName == 4 && optionLength >= 4) {
            optionValue.setValue32(inetSocket.isReuseAddress());
            optionLengthAddr.setValue(4);
        } else {
            log.warn((Object)String.format("Unimplemented sceNetInetGetsockopt socket=0x%X, level=0x%X, optionName=0x%X, optionValue=%s, optionLength=%s(0x%X)", socket, level, optionName, optionValue, optionLengthAddr, optionLength));
            return -1;
        }
        return 0;
    }

    @HLEFunction(nid=-787867014, version=150)
    public int sceNetInetListen(@CheckArgument(value="checkSocket") int socket, int backlog) {
        pspInetSocket inetSocket = this.sockets.get(socket);
        return inetSocket.listen(backlog);
    }

    @HLEFunction(nid=-89411107, version=150)
    public int sceNetInetPoll(TPointer fds, int nfds, int timeout) {
        int result = 0;
        long timeoutUsec = timeout == -1 ? 2147483647000000L : (long)timeout * 1000L;
        try {
            Selector selector = Selector.open();
            pspInetPollFd[] pollFds = new pspInetPollFd[nfds];
            for (int i = 0; i < nfds; ++i) {
                pspInetPollFd pollFd = new pspInetPollFd();
                pollFd.read(fds, i * pollFd.sizeof());
                pollFds[i] = pollFd;
                if (pollFd.fd == -1) {
                    pollFd.revents = 0;
                } else {
                    pspInetSocket inetSocket = this.sockets.get(pollFd.fd);
                    if (inetSocket == null) {
                        pollFd.revents = 32;
                    } else {
                        SelectableChannel selectableChannel = inetSocket.getSelectableChannel();
                        if (selectableChannel == null) {
                            pollFd.revents = 16;
                        } else {
                            int registeredOperations = 0;
                            if ((pollFd.events & 0xC3) != 0) {
                                registeredOperations |= 1;
                            }
                            if ((pollFd.events & 0x104) != 0) {
                                registeredOperations |= 4;
                            }
                            registeredOperations &= selectableChannel.validOps();
                            if (selectableChannel.isRegistered()) {
                                log.warn((Object)String.format("sceNetInetPoll channel already registered pollFd[%d]=%s", i, pollFd));
                            } else {
                                try {
                                    selectableChannel.register(selector, registeredOperations, new Integer(pollFd.fd));
                                    pollFd.revents = 0;
                                }
                                catch (ClosedChannelException e) {
                                    pollFd.revents = 16;
                                }
                            }
                        }
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("sceNetInetPoll pollFd[%d]=%s", i, pollFd));
            }
            BlockingPollState blockingState = new BlockingPollState(selector, pollFds, timeoutUsec);
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            thread.cpuContext._v0 = 0;
            sceNetInet.setErrno(0, blockingState);
            blockingState.execute();
            result = thread.cpuContext._v0;
        }
        catch (IOException e) {
            log.error((Object)"sceNetInetPoll", (Throwable)e);
            sceNetInet.setErrnoToSelf(-1);
            return -1;
        }
        return result;
    }

    @HLEFunction(nid=-844604263, version=150)
    public int sceNetInetRecv(@CheckArgument(value="checkSocket") int socket, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.returnValue, usage=BufferInfo.Usage.out) TPointer buffer, int bufferLength, int flags) {
        pspInetSocket inetSocket = this.sockets.get(socket);
        return inetSocket.recv(buffer.getAddress(), bufferLength, flags);
    }

    @HLEFunction(nid=-921615644, version=150)
    public int sceNetInetRecvfrom(@CheckArgument(value="checkSocket") int socket, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.returnValue, usage=BufferInfo.Usage.out) TPointer buffer, int bufferLength, int flags, TPointer from, TPointer32 fromLengthAddr) {
        pspInetSocket inetSocket = this.sockets.get(socket);
        pspNetSockAddrInternet fromAddrInternet = new pspNetSockAddrInternet();
        int fromLength = fromLengthAddr.getValue();
        fromAddrInternet.setMaxSize(fromLength);
        fromAddrInternet.write(from);
        if (fromAddrInternet.sizeof() < fromLength) {
            fromLengthAddr.setValue(fromAddrInternet.sizeof());
        }
        return inetSocket.recvfrom(buffer.getAddress(), bufferLength, flags, fromAddrInternet);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-288464430, version=150)
    public int sceNetInetRecvmsg() {
        return 0;
    }

    @HLEFunction(nid=1541985685, version=150)
    public int sceNetInetSelect(int numberSockets, @CanBeNull TPointer readSocketsAddr, @CanBeNull TPointer writeSocketsAddr, @CanBeNull TPointer outOfBandSocketsAddr, @CanBeNull TPointer32 timeoutAddr) {
        long timeoutUsec;
        int result = 0;
        numberSockets = Math.min(numberSockets, 256);
        if (timeoutAddr.isNotNull()) {
            timeoutUsec = (long)timeoutAddr.getValue(0) * 1000000L;
            timeoutUsec += (long)timeoutAddr.getValue(4);
        } else {
            timeoutUsec = 2147483647000000L;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetSelect timeout=%d us", timeoutUsec));
            if (readSocketsAddr.isNotNull()) {
                log.debug((Object)String.format("sceNetInetSelect Read Sockets       : %s", this.dumpSelectBits(readSocketsAddr, numberSockets)));
            }
            if (writeSocketsAddr.isNotNull()) {
                log.debug((Object)String.format("sceNetInetSelect Write Sockets      : %s", this.dumpSelectBits(writeSocketsAddr, numberSockets)));
            }
            if (outOfBandSocketsAddr.isNotNull()) {
                log.debug((Object)String.format("sceNetInetSelect Out-of-band Sockets: %s", this.dumpSelectBits(outOfBandSocketsAddr, numberSockets)));
            }
        }
        try {
            Selector selector = Selector.open();
            RawSelector rawSelector = RawSelector.open();
            int count = 0;
            count += this.readSocketList(selector, rawSelector, readSocketsAddr, numberSockets, 17, "readSockets");
            count += this.readSocketList(selector, rawSelector, writeSocketsAddr, numberSockets, 4, "writeSockets");
            BlockingSelectState blockingState = new BlockingSelectState(selector, rawSelector, numberSockets, readSocketsAddr, writeSocketsAddr, outOfBandSocketsAddr, timeoutUsec, count += this.readSocketList(selector, rawSelector, outOfBandSocketsAddr, numberSockets, 0, "outOfBandSockets"));
            sceNetInet.setErrno(0, blockingState);
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            thread.cpuContext._v0 = 0;
            blockingState.execute();
            result = thread.cpuContext._v0;
        }
        catch (IOException e) {
            log.error((Object)e);
            sceNetInet.setErrnoToSelf(-1);
            return -1;
        }
        return result;
    }

    @HLEFunction(nid=2057728444, version=150)
    public int sceNetInetSend(@CheckArgument(value="checkSocket") int socket, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer buffer, int bufferLength, int flags) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(buffer.getAddress(), bufferLength)));
        }
        pspInetSocket inetSocket = this.sockets.get(socket);
        return inetSocket.send(buffer.getAddress(), bufferLength, flags);
    }

    @HLEFunction(nid=84119495, version=150)
    public int sceNetInetSendto(@CheckArgument(value="checkSocket") int socket, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer buffer, int bufferLength, int flags, pspNetSockAddrInternet toSockAddress, @CheckArgument(value="checkAddressLength") int toLength) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Sendto data: %s", Utilities.getMemoryDump(buffer.getAddress(), bufferLength)));
        }
        if (toSockAddress.sin_family != 2) {
            log.warn((Object)String.format("sceNetInetSendto invalid socket address familiy sin_family=%d", toSockAddress.sin_family));
            return -1;
        }
        pspInetSocket inetSocket = this.sockets.get(socket);
        return inetSocket.sendto(buffer.getAddress(), bufferLength, flags, toSockAddress);
    }

    @HLEUnimplemented
    @HLEFunction(nid=2001614580, version=150)
    public int sceNetInetSendmsg() {
        return 0;
    }

    @HLEFunction(nid=803676135, version=150)
    public int sceNetInetSetsockopt(@CheckArgument(value="checkSocket") int socket, int level, int optionName, @CanBeNull TPointer optionValueAddr, int optionLength) {
        int result = 0;
        int optionValue = 0;
        if (optionValueAddr.isNotNull() && optionLength >= 4) {
            optionValue = optionValueAddr.getValue32();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetSetsockopt optionName=%s", sceNetInet.getOptionNameString(optionName)));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Option value: %s", Utilities.getMemoryDump(optionValueAddr.getAddress(), optionLength)));
            }
        }
        pspInetSocket inetSocket = this.sockets.get(socket);
        if (level == 65535) {
            if (optionName == 4105 && optionLength == 4) {
                result = inetSocket.setBlocking(optionValue == 0);
            } else if (optionName == 32 && optionLength == 4) {
                result = inetSocket.setBroadcast(optionValue != 0);
            } else if (optionName == 4100 && optionLength == 4) {
                inetSocket.setReceiveLowWaterMark(optionValue);
                result = 0;
            } else if (optionName == 4099 && optionLength == 4) {
                inetSocket.setSendLowWaterMark(optionValue);
                result = 0;
            } else if (optionName == 4102 && optionLength == 4) {
                inetSocket.setReceiveTimeout(optionValue == 0 ? Integer.MAX_VALUE : optionValue);
                result = 0;
            } else if (optionName == 4101 && optionLength == 4) {
                inetSocket.setSendTimeout(optionValue == 0 ? Integer.MAX_VALUE : optionValue);
                result = 0;
            } else if (optionName == 4098 && optionLength == 4) {
                result = inetSocket.setReceiveBufferSize(optionValue);
            } else if (optionName == 4097 && optionLength == 4) {
                result = inetSocket.setSendBufferSize(optionValue);
            } else if (optionName == 8 && optionLength == 4) {
                result = inetSocket.setKeepAlive(optionValue != 0);
            } else if (optionName == 128 && optionLength == 8) {
                result = inetSocket.setLinger(optionValue != 0, optionValueAddr.getValue32(4));
            } else if (optionName == 4 && optionLength == 4) {
                result = inetSocket.setReuseAddress(optionValue != 0);
            } else {
                log.warn((Object)String.format("Unimplemented sceNetInetSetsockopt optionName=%s", sceNetInet.getOptionNameString(optionName)));
                result = 0;
            }
        } else {
            log.warn((Object)String.format("Unimplemented sceNetInetSetsockopt unknown level=0x%X, optionName=%s", level, sceNetInet.getOptionNameString(optionName)));
            result = 0;
        }
        return result;
    }

    @HLEFunction(nid=1291734614, version=150)
    public int sceNetInetShutdown(@CheckArgument(value="checkSocket") int socket, int how) {
        if (how < 0 || how > 2) {
            log.warn((Object)String.format("sceNetInetShutdown invalid how=%d", how));
            return -1;
        }
        pspInetSocket inetSocket = this.sockets.get(socket);
        return inetSocket.shutdown(how);
    }

    @HLEFunction(nid=-1954864625, version=150)
    public int sceNetInetSocket(int domain, int type, int protocol) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetSocket domain=0x%X, type=0x%X(%s), protocol=0x%X", domain, type, sceNetInet.getSocketTypeNameString(type), protocol));
        }
        if (domain != 2) {
            log.warn((Object)String.format("sceNetInetSocket unsupported domain=0x%X, type=0x%X(%s), protocol=0x%X", domain, type, sceNetInet.getSocketTypeNameString(type), protocol));
            return -1;
        }
        if (type != 2 && type != 1 && type != 3 && type != 6 && type != 10) {
            log.warn((Object)String.format("sceNetInetSocket unsupported type=0x%X(%s), domain=0x%X, protocol=0x%X", type, sceNetInet.getSocketTypeNameString(type), domain, protocol));
            return -1;
        }
        pspInetSocket inetSocket = this.createSocket(type, protocol);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetSocket created socket=0x%X", inetSocket.getUid()));
        }
        return inetSocket.getUid();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2136859971, version=150)
    public int sceNetInetSocketAbort(@CheckArgument(value="checkSocket") int socket) {
        return 0;
    }

    @HLEFunction(nid=-72621039, version=150)
    public int sceNetInetGetErrno() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetGetErrno returning 0x%08X(%1$d)", sceNetInet.getErrno()));
        }
        return sceNetInet.getErrno();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1282897196, version=150)
    public int sceNetInetGetTcpcbstat(TPointer32 sizeAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=26, usage=BufferInfo.Usage.out) TPointer buf) {
        int tcpCount = 0;
        for (pspInetSocket socket : this.sockets.values()) {
            if (!(socket instanceof pspInetStreamSocket)) continue;
            ++tcpCount;
        }
        int size = sizeAddr.getValue();
        SceNetInetTcpcbstat stat = new SceNetInetTcpcbstat();
        sizeAddr.setValue(stat.sizeof() * tcpCount);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetGetTcpcbstat returning size=%d", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            for (pspInetSocket socket : this.sockets.values()) {
                if (!(socket instanceof pspInetStreamSocket)) continue;
                if (offset + stat.sizeof() > size || socket == null) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetGetTcpcbstat returning %s at 0x%08X", socket, buf.getAddress() + offset));
                }
                stat.ts_so_snd_sb_cc = 0;
                stat.ts_so_rcv_sb_cc = 0;
                pspNetSockAddrInternet localAddr = socket.getLocalAddr();
                if (localAddr == null) {
                    stat.ts_inp_laddr = 0;
                    stat.ts_inp_lport = 0;
                } else {
                    stat.ts_inp_laddr = localAddr.sin_addr;
                    stat.ts_inp_lport = localAddr.sin_port;
                }
                pspNetSockAddrInternet remoteAddr = socket.getRemoteAddr();
                if (remoteAddr == null) {
                    stat.ts_inp_faddr = 0;
                    stat.ts_inp_fport = 0;
                } else {
                    stat.ts_inp_faddr = remoteAddr.sin_addr;
                    stat.ts_inp_fport = remoteAddr.sin_port;
                }
                stat.ts_t_state = 4;
                stat.write(buf, offset);
                offset += stat.sizeof();
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, stat.sizeof());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetInetGetTcpcbstat returning %s", Utilities.getMemoryDump(buf.getAddress(), offset)));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=967886803, version=150)
    public int sceNetInetGetUdpcbstat() {
        return 0;
    }

    @HLEFunction(nid=-1218618614, version=150)
    public int sceNetInetInetAddr(PspString name) {
        byte[] inetAddressBytes;
        try {
            inetAddressBytes = InetAddress.getByName(name.getString()).getAddress();
        }
        catch (UnknownHostException e) {
            log.error((Object)"sceNetInetInetAddr", (Throwable)e);
            return -1;
        }
        int inetAddress = sceNetInet.bytesToInternetAddress(inetAddressBytes);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetInetAddr %s returning 0x%08X", name, inetAddress));
        }
        return inetAddress;
    }

    @HLEFunction(nid=467623187, version=150)
    public int sceNetInetInetAton(PspString hostname, TPointer32 addr) {
        int result;
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname.getString());
            int resolvedAddress = sceNetInet.bytesToInternetAddress(inetAddress.getAddress());
            addr.setValue(resolvedAddress);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetInetInetAton returning address 0x%08X('%s')", resolvedAddress, sceNetInet.internetAddressToString(resolvedAddress)));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceNetInetInetAton resolved '%s' into '%s'", hostname.getString(), sceNetInet.internetAddressToString(resolvedAddress)));
            }
            result = 1;
        }
        catch (UnknownHostException e) {
            log.error((Object)"sceNetInetInetAton", (Throwable)e);
            result = 0;
        }
        return result;
    }

    @HLEFunction(nid=-797366682, version=150)
    public int sceNetInetInetNtop(int family, TPointer32 srcAddr, TPointer buffer, int bufferLength) {
        if (family != 2) {
            log.warn((Object)String.format("sceNetInetInetNtop unsupported family 0x%X", family));
            return 0;
        }
        int addr = srcAddr.getValue();
        String ip = sceNetInet.internetAddressToString(addr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetInetNtop returning %s for 0x%08X", ip, addr));
        }
        buffer.setStringNZ(bufferLength, ip);
        return buffer.getAddress();
    }

    @HLEFunction(nid=-485782503, version=150)
    public int sceNetInetInetPton(int family, String src, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 buffer) {
        int result;
        if (family != 2) {
            log.warn((Object)String.format("sceNetInetInetPton unsupported family 0x%X", family));
            return -1;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(src);
            byte[] inetAddressBytes = inetAddress.getAddress();
            int address = sceNetInet.bytesToInternetAddress(inetAddressBytes);
            buffer.setValue(address);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetInetInetPton returning 0x%08X(%s) for '%s'", address, sceNetInet.internetAddressToString(address), src));
            }
            result = 1;
            this.addProxyInetAddress(src, inetAddress);
        }
        catch (UnknownHostException e) {
            log.warn((Object)String.format("sceNetInetInetPton returned error '%s' for '%s'", e.toString(), src));
            result = 0;
        }
        return result;
    }

    @HLEFunction(nid=-1935431298, version=150)
    public int sceNetInetGetPspError() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetInetGetPspError returning 0x%08X(%1$d)", sceNetInet.getErrno()));
        }
        return 0x80010000 | sceNetInet.getErrno() & 0xFFFF;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1360654460, version=150)
    public int sceNetInet_lib_AEE60F84(@CheckArgument(value="checkSocket") int socket, int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1426814630, version=150)
    public int sceNetInet_lib_AAF4895A(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) @CanBeNull TPointer unknown1, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) @CanBeNull TPointer unknown2) {
        unknown1.getArray8(this.unknown1);
        unknown2.getArray8(this.unknown2);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1398959963, version=150)
    public int sceNetInet_lib_AC9D90A5(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.out) @CanBeNull TPointer unknown1, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.out) @CanBeNull TPointer unknown2) {
        unknown1.setArray(this.unknown1);
        unknown2.setArray(this.unknown2);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-420053740, version=150)
    public int sceNetInet_lib_E6F67D14(String interfaceName) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1778672471, version=150)
    public int sceNetInet_lib_6A046357(String interfaceName) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1364585610, version=150)
    public int sceNetInet_lib_5155EC8A(String interfaceName, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.out) @CanBeNull TPointer unknown1, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.out) @CanBeNull TPointer unknown2, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.out) @CanBeNull TPointer unknown3) {
        unknown1.clear(4);
        unknown2.clear(4);
        unknown3.clear(4);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1454737945, version=150)
    public int sceNetInet_lib_A94A75E7(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) TPointer ipAddress) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2004264082, version=150)
    public int sceNetInet_lib_7776A492(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) TPointer unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1332271886, version=150)
    public int sceNetInet_lib_4F68DB0E(String interfaceName, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) @CanBeNull TPointer ipAddress, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) @CanBeNull TPointer unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) @CanBeNull TPointer subnetMask) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1498813793, version=150)
    public int sceNetInet_lib_59561561(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.in) TPointer unknown1, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) TPointer unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1881038908, version=150)
    public int sceNetInet_lib_8FE19FC4(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.out) TPointer unknown) {
        unknown.clear(4);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=37271263, version=150)
    public int sceNetInet_lib_0238B6DF(int unknown1, int unknown2, int unknown3, int unknown4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1276362256, version=150)
    public int sceNetInet_lib_4C13BE10() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-704008906, version=150)
    public int sceNetInet_lib_D609AD36(int unknown1, int unknown2, int unknown3, int unknown4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-600244503, version=150)
    public int sceNetInet_lib_DC38FEE9() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2092030435, version=150)
    public int sceNetInet_lib_7CB1D9E3(int unknown) {
        return 0;
    }

    static /* synthetic */ InetAddress[] access$002(InetAddress[] x0) {
        broadcastAddresses = x0;
        return x0;
    }

    static /* synthetic */ InetAddress[] access$102(sceNetInet x0, InetAddress[] x1) {
        x0.doProxyInetAddresses = x1;
        return x1;
    }

    protected static class pspInetPollFd
    extends pspAbstractMemoryMappedStructure {
        public int fd;
        public int events;
        public int revents;

        protected pspInetPollFd() {
        }

        @Override
        protected void read() {
            this.fd = this.read32();
            this.events = this.read16();
            this.revents = this.read16();
        }

        @Override
        protected void write() {
            this.write32(this.fd);
            this.write16((short)this.events);
            this.write16((short)this.revents);
        }

        @Override
        public int sizeof() {
            return 8;
        }

        @Override
        public String toString() {
            return String.format("PollFd[fd=%d, events=0x%04X(%s), revents=0x%04X(%s)]", this.fd, this.events, sceNetInet.getPollEventName(this.events), this.revents, sceNetInet.getPollEventName(this.revents));
        }
    }

    protected class pspInetRawSocket
    extends pspInetSocket {
        private RawChannel rawChannel;
        private int protocol;
        private boolean isAvailable;

        public pspInetRawSocket(int uid, int protocol) {
            super(uid);
            this.protocol = protocol;
            this.isAvailable = true;
        }

        protected boolean openChannel() throws IllegalStateException {
            if (!this.isAvailable) {
                return false;
            }
            if (this.rawChannel == null) {
                try {
                    this.rawChannel = new RawChannel();
                }
                catch (UnsatisfiedLinkError e) {
                    log.error((Object)String.format("The rocksaw library is not available on your system (%s). This library is required to implement RAW sockets. Disabling this feature.", e.toString()));
                    this.isAvailable = false;
                    return false;
                }
                try {
                    this.rawChannel.socket().open(RawSocket.PF_INET, this.protocol);
                    this.rawChannel.configureBlocking(false);
                }
                catch (IOException e) {
                    log.error((Object)String.format("You need to start Jpcsp with administator right to be able to open RAW sockets (%s). Disabling this feature.", e.toString()));
                    this.isAvailable = false;
                    return false;
                }
            }
            return this.rawChannel.socket().isOpen();
        }

        @Override
        public int bind(pspNetSockAddrInternet addr) {
            if (!this.openChannel()) {
                return -1;
            }
            try {
                this.rawChannel.socket().bind(this.getInetAddress(addr));
            }
            catch (IllegalStateException e) {
                log.error((Object)e);
                return -1;
            }
            catch (UnknownHostException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            return 0;
        }

        @Override
        public int close() {
            if (this.rawChannel != null) {
                try {
                    this.rawChannel.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    int n = -1;
                    return n;
                }
                finally {
                    this.rawChannel = null;
                }
            }
            return 0;
        }

        @Override
        public int connect(pspNetSockAddrInternet addr) {
            log.error((Object)String.format("sceNetInetConnect is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public boolean finishConnect() {
            return this.openChannel();
        }

        @Override
        public int getPeername(pspNetSockAddrInternet sockAddrInternet) {
            log.error((Object)String.format("sceNetInetGetpeername is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public SelectableChannel getSelectableChannel() {
            if (!this.openChannel()) {
                return null;
            }
            return this.rawChannel;
        }

        @Override
        public int getSockname(pspNetSockAddrInternet sockAddrInternet) {
            log.error((Object)String.format("sceNetInetGetsockname is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public boolean isValid() {
            return this.openChannel();
        }

        @Override
        public int listen(int backlog) {
            log.error((Object)String.format("sceNetInetListen is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public int recv(int buffer, int bufferLength, int flags, BlockingReceiveState blockingState) {
            log.error((Object)String.format("sceNetInetRecv is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, BlockingReceiveFromState blockingState) {
            try {
                if (!this.openChannel()) {
                    return -1;
                }
                if (!this.rawChannel.socket().isSelectedForRead()) {
                    if (!this.isBlocking(flags)) {
                        sceNetInet.setErrno(11, blockingState);
                        return -1;
                    }
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveFromState(this, buffer, bufferLength, flags, fromAddr, 0);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                byte[] bytes = new byte[bufferLength];
                byte[] address = new byte[4];
                int length = this.rawChannel.socket().read(bytes, address);
                this.storeBytes(buffer, length, bytes);
                if (blockingState != null) {
                    blockingState.receivedLength += length;
                }
                fromAddr.sin_family = 2;
                fromAddr.sin_addr = sceNetInet.bytesToInternetAddress(address);
                fromAddr.write(Memory.getInstance());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetRecvfrom socket=0x%X received 0x%X bytes from %s", this.getUid(), length, fromAddr));
                    if (log.isTraceEnabled() && length > 0) {
                        log.trace((Object)String.format("Received data: %s", Utilities.getMemoryDump(buffer, length)));
                    }
                }
                return length;
            }
            catch (InterruptedIOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int send(int buffer, int bufferLength, int flags, BlockingSendState blockignState) {
            log.error((Object)String.format("sceNetInetSend is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }

        @Override
        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, BlockingSendToState blockingState) {
            try {
                if (!this.openChannel()) {
                    return -1;
                }
                if (!this.rawChannel.socket().isSelectedForWrite()) {
                    if (!this.isBlocking(flags)) {
                        sceNetInet.setErrno(11, blockingState);
                        return -1;
                    }
                    if (blockingState == null) {
                        blockingState = new BlockingSendToState(this, buffer, bufferLength, flags, toAddr, 0);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                InetAddress inetAddress = this.getInetAddress(toAddr);
                byte[] data = this.getByteArray(buffer, bufferLength);
                int length = this.rawChannel.socket().write(inetAddress, data);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetSendto socket=0x%X successfully sent 0x%X bytes", this.getUid(), length));
                }
                if (blockingState != null) {
                    blockingState.sentLength += length;
                }
                return length;
            }
            catch (IllegalStateException e) {
                log.error((Object)e);
                return -1;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int shutdown(int how) {
            log.warn((Object)String.format("sceNetInetShutdown is not supported on Raw sockets: %s", this.toString()));
            return 0;
        }

        @Override
        public Selector getSelector(Selector selector, RawSelector rawSelector) {
            return rawSelector;
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet, BlockingAcceptState blockingState) {
            log.error((Object)String.format("sceNetInetAccept is not supported on Raw sockets: %s", this.toString()));
            return -1;
        }
    }

    protected class pspInetDatagramSocket
    extends pspInetSocket {
        private DatagramChannel datagramChannel;

        public pspInetDatagramSocket(int uid) {
            super(uid);
            this.receiveBufferSize = 41600;
            this.sendBufferSize = 9216;
        }

        private void openChannel() throws IOException {
            if (this.datagramChannel == null) {
                this.datagramChannel = DatagramChannel.open();
                this.datagramChannel.configureBlocking(false);
                this.datagramChannel.socket().setReceiveBufferSize(this.receiveBufferSize);
                this.datagramChannel.socket().setSendBufferSize(this.sendBufferSize);
            }
        }

        @Override
        public int connect(pspNetSockAddrInternet addr) {
            try {
                this.openChannel();
                this.datagramChannel.connect(this.getSocketAddress(addr));
                this.setRemoteAddr(addr);
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            this.clearErrorToSelf();
            return 0;
        }

        @Override
        public int bind(pspNetSockAddrInternet addr) {
            try {
                this.openChannel();
                this.datagramChannel.socket().bind(this.getSocketAddress(addr));
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            this.clearErrorToSelf();
            return 0;
        }

        @Override
        public int close() {
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.close();
                    this.datagramChannel = null;
                }
                catch (IOException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            this.clearErrorToSelf();
            return 0;
        }

        @Override
        public int recv(int buffer, int bufferLength, int flags, BlockingReceiveState blockingState) {
            try {
                byte[] bytes = new byte[bufferLength];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                SocketAddress socketAddress = this.datagramChannel.receive(byteBuffer);
                int length = byteBuffer.position();
                this.storeBytes(buffer, length, bytes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetRecv socket=0x%X received 0x%X bytes from %s", this.getUid(), length, socketAddress));
                    if (log.isTraceEnabled() && length > 0) {
                        log.trace((Object)String.format("Received data: %s", Utilities.getMemoryDump(buffer, length)));
                    }
                }
                if (length < 0) {
                    this.clearError(blockingState);
                    return 0;
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    if (bufferLength == 0) {
                        this.clearError(blockingState);
                        return 0;
                    }
                    sceNetInet.setErrno(11, blockingState);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.receivedLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveState(this, buffer, bufferLength, flags, length);
                    }
                    if (blockingState.receivedLength < this.getReceiveLowWaterMark() && length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError(blockingState);
                return length;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int send(int buffer, int bufferLength, int flags, BlockingSendState blockingState) {
            log.warn((Object)"sceNetInetSend not supported on datagram socket");
            this.setError(-1, (BlockingState)blockingState);
            return -1;
        }

        @Override
        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, BlockingReceiveFromState blockingState) {
            try {
                byte[] bytes = new byte[bufferLength];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                SocketAddress socketAddress = this.datagramChannel.receive(byteBuffer);
                int length = byteBuffer.position();
                this.storeBytes(buffer, length, bytes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetRecvfrom socket=0x%X received 0x%X bytes from %s", this.getUid(), length, socketAddress));
                    if (log.isTraceEnabled() && length > 0) {
                        log.trace((Object)String.format("Received data: %s", Utilities.getMemoryDump(buffer, length)));
                    }
                }
                if (socketAddress == null) {
                    if (!this.isBlocking(flags)) {
                        sceNetInet.setErrno(11, blockingState);
                        return -1;
                    }
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveFromState(this, buffer, bufferLength, flags, fromAddr, length);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    fromAddr.readFromInetSocketAddress(inetSocketAddress);
                    fromAddr.write(Memory.getInstance());
                }
                this.clearError(blockingState);
                return length;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, BlockingSendToState blockingState) {
            try {
                this.openChannel();
                ByteBuffer byteBuffer = this.getByteBuffer(buffer, bufferLength);
                SocketAddress socketAddress = this.getSocketAddress(toAddr);
                int length = this.datagramChannel.send(byteBuffer, socketAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetSendto socket=0x%X successfully sent 0x%X bytes", this.getUid(), length));
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    sceNetInet.setErrno(11, blockingState);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.sentLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingSendToState(this, buffer, bufferLength, flags, toAddr, length);
                    }
                    if (length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError(blockingState);
                return length;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int setBroadcast(boolean broadcast) {
            super.setBroadcast(broadcast);
            try {
                this.openChannel();
                this.datagramChannel.socket().setBroadcast(broadcast);
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            this.clearErrorToSelf();
            return 0;
        }

        @Override
        public SelectableChannel getSelectableChannel() {
            return this.datagramChannel;
        }

        @Override
        public boolean isValid() {
            return this.datagramChannel != null && !this.datagramChannel.socket().isClosed();
        }

        @Override
        public int setReceiveBufferSize(int receiveBufferSize) {
            super.setReceiveBufferSize(receiveBufferSize);
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.socket().setReceiveBufferSize(receiveBufferSize);
                }
                catch (SocketException e) {
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setSendBufferSize(int sendBufferSize) {
            super.setSendBufferSize(sendBufferSize);
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int getPeername(pspNetSockAddrInternet sockAddrInternet) {
            if (this.datagramChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.datagramChannel.socket().getInetAddress();
            sockAddrInternet.readFromInetAddress(inetAddress, this.getRemoteAddr());
            return 0;
        }

        @Override
        public int getSockname(pspNetSockAddrInternet sockAddrInternet) {
            if (this.datagramChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.datagramChannel.socket().getLocalAddress();
            sockAddrInternet.readFromInetAddress(inetAddress, this.getLocalAddr());
            return 0;
        }

        @Override
        public int setReuseAddress(boolean reuseAddress) {
            super.setReuseAddress(reuseAddress);
            if (this.datagramChannel != null) {
                try {
                    this.datagramChannel.socket().setReuseAddress(reuseAddress);
                }
                catch (SocketException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int shutdown(int how) {
            log.error((Object)String.format("Shutdown not supported on datagram socket: how=%d, %s", how, this.toString()));
            return -1;
        }

        @Override
        public boolean finishConnect() {
            return true;
        }

        @Override
        public int listen(int backlog) {
            log.error((Object)String.format("Listen not supported on datagram socket: backlog=%d, %s", backlog, this.toString()));
            return -1;
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet, BlockingAcceptState blockingState) {
            log.error((Object)String.format("Accept not supported on datagram socket: sockAddrInternet=%s, %s", sockAddrInternet.toString(), this.toString()));
            return -1;
        }
    }

    protected class pspInetStreamSocket
    extends pspInetSocket {
        private SocketChannel socketChannel;
        private ServerSocketChannel serverSocketChannel;
        private boolean isServerSocket;
        private SocketAddress pendingBindAddress;
        private int backlog;

        public pspInetStreamSocket(int uid) {
            super(uid);
        }

        private void configureSocketChannel() throws IOException {
            this.socketChannel.configureBlocking(false);
            this.socketChannel.socket().setReceiveBufferSize(this.receiveBufferSize);
            this.socketChannel.socket().setSendBufferSize(this.sendBufferSize);
            this.socketChannel.socket().setKeepAlive(this.keepAlive);
            this.socketChannel.socket().setReuseAddress(this.reuseAddress);
            this.socketChannel.socket().setSoLinger(this.lingerEnabled, this.linger);
            this.socketChannel.socket().setTcpNoDelay(this.tcpNoDelay);
            this.socketChannel.socket().setSoTimeout(0);
        }

        private void openChannel() throws IOException {
            if (this.isServerSocket) {
                if (this.serverSocketChannel == null) {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocketChannel.configureBlocking(false);
                    if (this.socketChannel != null) {
                        if (this.socketChannel.socket().getLocalSocketAddress() != null) {
                            this.pendingBindAddress = this.socketChannel.socket().getLocalSocketAddress();
                        }
                        this.socketChannel.close();
                        this.socketChannel = null;
                    }
                }
            } else if (this.socketChannel == null) {
                this.socketChannel = SocketChannel.open();
                this.configureSocketChannel();
            }
        }

        private void bindChannel() throws IOException {
            if (this.pendingBindAddress != null) {
                if (this.isServerSocket) {
                    this.serverSocketChannel.socket().bind(this.pendingBindAddress, this.backlog);
                } else {
                    this.socketChannel.socket().bind(this.pendingBindAddress);
                }
                this.pendingBindAddress = null;
            }
        }

        @Override
        public boolean finishConnect() {
            if (!this.isBlocking() && this.socketChannel.isConnectionPending()) {
                try {
                    boolean connected = this.socketChannel.finishConnect();
                    if (connected) {
                        this.setLocalAddr(this.getNetSockAddrInternet(this.socketChannel.getLocalAddress()));
                    }
                    return connected;
                }
                catch (IOException e) {
                    log.error((Object)e);
                    this.setSocketError(e);
                    return false;
                }
            }
            return true;
        }

        @Override
        public int connect(pspNetSockAddrInternet addr) {
            if (this.isServerSocket) {
                log.error((Object)String.format("connect not supported on server socket stream addr=%s, %s", addr.toString(), this.toString()));
                return -1;
            }
            try {
                this.openChannel();
                this.bindChannel();
                if (!this.finishConnect()) {
                    sceNetInet.setErrnoToSelf(120);
                    return -1;
                }
                if (this.socketChannel.isConnected()) {
                    sceNetInet.setErrnoToSelf(127);
                    return -1;
                }
                boolean connected = this.socketChannel.connect(this.getSocketAddress(addr));
                this.setRemoteAddr(addr);
                if (this.isBlocking()) {
                    while (!this.socketChannel.finishConnect()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if (!connected) {
                    sceNetInet.setErrnoToSelf(119);
                    return -1;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            this.clearErrorToSelf();
            return 0;
        }

        @Override
        public int bind(pspNetSockAddrInternet addr) {
            BlockingState blockingState = null;
            try {
                this.openChannel();
                if (this.isServerSocket) {
                    this.pendingBindAddress = this.getSocketAddress(addr);
                } else {
                    this.pendingBindAddress = null;
                    this.socketChannel.socket().bind(this.getSocketAddress(addr));
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, blockingState);
                return -1;
            }
            this.clearError(blockingState);
            return 0;
        }

        @Override
        public int recv(int buffer, int bufferLength, int flags, BlockingReceiveState blockingState) {
            try {
                if (!this.finishConnect()) {
                    sceNetInet.setErrno(11, blockingState);
                    return -1;
                }
                byte[] bytes = new byte[bufferLength];
                int length = this.socketChannel.read(ByteBuffer.wrap(bytes));
                this.storeBytes(buffer, length, bytes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetRecv socket=0x%X received 0x%X bytes", this.getUid(), length));
                    if (log.isTraceEnabled() && length > 0) {
                        log.trace((Object)String.format("Received data: %s", Utilities.getMemoryDump(buffer, length)));
                    }
                }
                if (length < 0) {
                    this.clearError(blockingState);
                    return 0;
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    if (bufferLength == 0) {
                        this.clearError(blockingState);
                        return 0;
                    }
                    sceNetInet.setErrno(11, blockingState);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.receivedLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingReceiveState(this, buffer, bufferLength, flags, length);
                    }
                    if (blockingState.receivedLength < this.getReceiveLowWaterMark() && length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError(blockingState);
                return length;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int send(int buffer, int bufferLength, int flags, BlockingSendState blockingState) {
            try {
                if (!this.finishConnect()) {
                    this.setError(128, (BlockingState)blockingState);
                    return -1;
                }
                ByteBuffer byteBuffer = this.getByteBuffer(buffer, bufferLength);
                int length = this.socketChannel.write(byteBuffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetSend socket=0x%X successfully sent 0x%X bytes", this.getUid(), length));
                }
                if (length == 0 && !this.isBlocking(flags)) {
                    sceNetInet.setErrno(11, blockingState);
                    return -1;
                }
                if (blockingState != null) {
                    blockingState.sentLength += length;
                }
                if (this.isBlocking(flags)) {
                    if (blockingState == null) {
                        blockingState = new BlockingSendState(this, buffer, bufferLength, flags, length);
                    }
                    if (length < bufferLength) {
                        sceNetInet.this.blockThread(blockingState);
                        return -1;
                    }
                }
                this.clearError(blockingState);
                return length;
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
        }

        @Override
        public int close() {
            BlockingState blockingState = null;
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.close();
                    this.socketChannel = null;
                }
                catch (IOException e) {
                    log.error((Object)e);
                    this.setError(e, blockingState);
                    return -1;
                }
            }
            if (this.serverSocketChannel != null) {
                try {
                    this.serverSocketChannel.close();
                    this.serverSocketChannel = null;
                }
                catch (IOException e) {
                    log.error((Object)e);
                    this.setError(e, blockingState);
                    return -1;
                }
            }
            this.clearError(blockingState);
            return 0;
        }

        @Override
        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, BlockingReceiveFromState blockingState) {
            log.warn((Object)"sceNetInetRecvfrom not supported on stream socket");
            this.setError(-1, (BlockingState)blockingState);
            return -1;
        }

        @Override
        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, BlockingSendToState blockingState) {
            log.warn((Object)"sceNetInetSendto not supported on stream socket");
            this.setError(-1, (BlockingState)blockingState);
            return -1;
        }

        @Override
        public SelectableChannel getSelectableChannel() {
            if (this.isServerSocket) {
                return this.serverSocketChannel;
            }
            return this.socketChannel;
        }

        @Override
        public boolean isValid() {
            if (this.isServerSocket) {
                return this.serverSocketChannel != null;
            }
            if (this.socketChannel == null) {
                return false;
            }
            if (this.socketChannel.isConnectionPending()) {
                try {
                    this.socketChannel.finishConnect();
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("%s: %s", this.toString(), e.toString()));
                    }
                    return false;
                }
            } else if (!this.socketChannel.isConnected()) {
                return false;
            }
            return !this.socketChannel.socket().isClosed();
        }

        @Override
        public int setReceiveBufferSize(int receiveBufferSize) {
            super.setReceiveBufferSize(receiveBufferSize);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setReceiveBufferSize(receiveBufferSize);
                }
                catch (SocketException e) {
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setSendBufferSize(int sendBufferSize) {
            super.setSendBufferSize(sendBufferSize);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int getPeername(pspNetSockAddrInternet sockAddrInternet) {
            if (this.socketChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.socketChannel.socket().getInetAddress();
            sockAddrInternet.readFromInetAddress(inetAddress, this.getRemoteAddr());
            return 0;
        }

        @Override
        public int getSockname(pspNetSockAddrInternet sockAddrInternet) {
            if (this.socketChannel == null) {
                return -1;
            }
            InetAddress inetAddress = this.socketChannel.socket().getLocalAddress();
            sockAddrInternet.readFromInetAddress(inetAddress, this.getLocalAddr());
            return 0;
        }

        @Override
        public int setKeepAlive(boolean keepAlive) {
            super.setKeepAlive(keepAlive);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setKeepAlive(keepAlive);
                }
                catch (SocketException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setLinger(boolean enabled, int linger) {
            super.setLinger(enabled, linger);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setSoLinger(enabled, linger);
                }
                catch (SocketException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setReuseAddress(boolean reuseAddress) {
            super.setReuseAddress(reuseAddress);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setReuseAddress(reuseAddress);
                }
                catch (SocketException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int setTcpNoDelay(boolean tcpNoDelay) {
            super.setTcpNoDelay(tcpNoDelay);
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.socket().setTcpNoDelay(tcpNoDelay);
                }
                catch (SocketException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int shutdown(int how) {
            if (this.socketChannel != null) {
                try {
                    switch (how) {
                        case 0: {
                            this.socketChannel.socket().shutdownInput();
                            break;
                        }
                        case 1: {
                            this.socketChannel.socket().shutdownOutput();
                            break;
                        }
                        case 2: {
                            this.socketChannel.socket().shutdownInput();
                            this.socketChannel.socket().shutdownOutput();
                        }
                    }
                }
                catch (IOException e) {
                    log.error((Object)e);
                    this.setErrorToSelf(e);
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public int listen(int backlog) {
            this.isServerSocket = true;
            this.backlog = backlog;
            try {
                this.openChannel();
                this.bindChannel();
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setErrorToSelf(e);
                return -1;
            }
            return 0;
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet) {
            if (!this.isServerSocket) {
                log.error((Object)String.format("sceNetInetAccept on non-server socket stream not allowed addr=%s, %s", sockAddrInternet.toString(), this.toString()));
                return -1;
            }
            return super.accept(sockAddrInternet);
        }

        @Override
        public int accept(pspNetSockAddrInternet sockAddrInternet, BlockingAcceptState blockingState) {
            SocketChannel socketChannel;
            try {
                this.openChannel();
                this.bindChannel();
                socketChannel = this.serverSocketChannel.accept();
            }
            catch (IOException e) {
                log.error((Object)e);
                this.setError(e, (BlockingState)blockingState);
                return -1;
            }
            if (socketChannel == null) {
                if (this.isBlocking()) {
                    if (blockingState == null) {
                        blockingState = new BlockingAcceptState((pspInetSocket)this, sockAddrInternet);
                    }
                    sceNetInet.this.blockThread(blockingState);
                    return -1;
                }
                sceNetInet.setErrno(11, blockingState);
                return -1;
            }
            pspInetStreamSocket inetSocket = (pspInetStreamSocket)sceNetInet.this.createSocket(1, 0);
            inetSocket.socketChannel = socketChannel;
            inetSocket.copySocketAttributes(this);
            try {
                inetSocket.configureSocketChannel();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            sockAddrInternet.readFromInetSocketAddress((InetSocketAddress)socketChannel.socket().getRemoteSocketAddress());
            sockAddrInternet.write(Memory.getInstance());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetInetAccept accepted connection from %s on socket %s", sockAddrInternet.toString(), inetSocket.toString()));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceNetInetAccept accepted connection from %s", sockAddrInternet.toString()));
            }
            return inetSocket.getUid();
        }
    }

    protected abstract class pspInetSocket {
        public static final long NO_TIMEOUT = 2147483647000000L;
        public static final int NO_TIMEOUT_INT = Integer.MAX_VALUE;
        private int uid;
        protected boolean blocking = true;
        protected boolean broadcast;
        protected boolean onesBroadcast;
        protected int receiveLowWaterMark = 1;
        protected int sendLowWaterMark = 2048;
        protected int receiveTimeout = Integer.MAX_VALUE;
        protected int sendTimeout = Integer.MAX_VALUE;
        protected int receiveBufferSize = 16384;
        protected int sendBufferSize = 16384;
        protected int error;
        protected boolean reuseAddress;
        protected boolean keepAlive;
        protected boolean lingerEnabled;
        protected int linger;
        protected boolean tcpNoDelay;
        private pspNetSockAddrInternet localAddr;
        private pspNetSockAddrInternet remoteAddr;

        public pspInetSocket(int uid) {
            this.uid = uid;
        }

        public int getUid() {
            return this.uid;
        }

        public abstract int connect(pspNetSockAddrInternet var1);

        public abstract int bind(pspNetSockAddrInternet var1);

        public abstract int recv(int var1, int var2, int var3, BlockingReceiveState var4);

        public abstract int send(int var1, int var2, int var3, BlockingSendState var4);

        public abstract int recvfrom(int var1, int var2, int var3, pspNetSockAddrInternet var4, BlockingReceiveFromState var5);

        public abstract int sendto(int var1, int var2, int var3, pspNetSockAddrInternet var4, BlockingSendToState var5);

        public abstract int close();

        public abstract SelectableChannel getSelectableChannel();

        public abstract boolean isValid();

        public abstract int getSockname(pspNetSockAddrInternet var1);

        public abstract int getPeername(pspNetSockAddrInternet var1);

        public abstract int shutdown(int var1);

        public abstract int listen(int var1);

        public abstract int accept(pspNetSockAddrInternet var1, BlockingAcceptState var2);

        public abstract boolean finishConnect();

        public int setBlocking(boolean blocking) {
            this.blocking = blocking;
            return 0;
        }

        public boolean isBlocking() {
            return this.blocking;
        }

        public boolean isBlocking(int flags) {
            boolean blocking = (flags & 0x80) != 0 ? false : this.isBlocking();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("isBlocking(0x%X)=%b", flags, blocking));
            }
            return blocking;
        }

        protected SocketAddress getSocketAddress(int address, int port) throws UnknownHostException {
            InetSocketAddress socketAddress = address == 0 ? new InetSocketAddress(port) : (address == -1 && !this.isOnesBroadcast() ? sceNetInet.getBroadcastInetSocketAddress(port)[0] : new InetSocketAddress(InetAddress.getByAddress(sceNetInet.internetAddressToBytes(address)), port));
            return socketAddress;
        }

        protected SocketAddress[] getMultiSocketAddress(int address, int port) throws UnknownHostException {
            SocketAddress[] socketAddress = address == 0 ? new SocketAddress[]{new InetSocketAddress(port)} : (address == -1 && !this.isOnesBroadcast() ? sceNetInet.getBroadcastInetSocketAddress(port) : new SocketAddress[]{new InetSocketAddress(InetAddress.getByAddress(sceNetInet.internetAddressToBytes(address)), port)});
            return socketAddress;
        }

        protected SocketAddress getSocketAddress(pspNetSockAddrInternet addr) throws UnknownHostException {
            return this.getSocketAddress(addr.sin_addr, addr.sin_port);
        }

        protected pspNetSockAddrInternet getNetSockAddrInternet(SocketAddress socketAddress) {
            pspNetSockAddrInternet addr = null;
            if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
                addr = new pspNetSockAddrInternet();
                addr.readFromInetSocketAddress((InetSocketAddress)socketAddress);
            }
            return addr;
        }

        protected SocketAddress[] getMultiSocketAddress(pspNetSockAddrInternet addr) throws UnknownHostException {
            return this.getMultiSocketAddress(addr.sin_addr, addr.sin_port);
        }

        protected InetAddress getInetAddress(int address) throws UnknownHostException {
            InetAddress inetAddress = InetAddress.getByAddress(sceNetInet.internetAddressToBytes(address));
            return inetAddress;
        }

        protected InetAddress getInetAddress(pspNetSockAddrInternet addr) throws UnknownHostException {
            return this.getInetAddress(addr.sin_addr);
        }

        protected void copySocketAttributes(pspInetSocket from) {
            this.setBlocking(from.isBlocking());
            this.setBroadcast(from.isBroadcast());
            this.setOnesBroadcast(from.isOnesBroadcast());
            this.setReceiveLowWaterMark(from.getReceiveLowWaterMark());
            this.setSendLowWaterMark(from.getSendLowWaterMark());
            this.setReceiveTimeout(from.getReceiveTimeout());
            this.setSendTimeout(from.getSendTimeout());
            this.setReceiveBufferSize(from.getReceiveBufferSize());
            this.setSendBufferSize(from.getSendBufferSize());
            this.setReuseAddress(from.isReuseAddress());
            this.setKeepAlive(from.isKeepAlive());
            this.setLinger(from.isLingerEnabled(), from.getLinger());
            this.setTcpNoDelay(from.isTcpNoDelay());
        }

        public boolean isBroadcast() {
            return this.broadcast;
        }

        public int setBroadcast(boolean broadcast) {
            this.broadcast = broadcast;
            return 0;
        }

        public int getReceiveLowWaterMark() {
            return this.receiveLowWaterMark;
        }

        public void setReceiveLowWaterMark(int receiveLowWaterMark) {
            this.receiveLowWaterMark = receiveLowWaterMark;
        }

        public int getSendLowWaterMark() {
            return this.sendLowWaterMark;
        }

        public void setSendLowWaterMark(int sendLowWaterMark) {
            this.sendLowWaterMark = sendLowWaterMark;
        }

        protected byte[] getByteArray(int address, int length) {
            byte[] bytes = new byte[length];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)memoryReader.readNext();
            }
            return bytes;
        }

        protected ByteBuffer getByteBuffer(int address, int length) {
            return ByteBuffer.wrap(this.getByteArray(address, length));
        }

        public String toString() {
            return String.format("pspInetSocket[uid=%d]", this.uid);
        }

        public boolean isOnesBroadcast() {
            return this.onesBroadcast;
        }

        public void setOnesBroadcast(boolean onesBroadcast) {
            this.onesBroadcast = onesBroadcast;
        }

        public int getReceiveTimeout() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("receiveTimeout=%d", this.receiveTimeout));
            }
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(int receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public int getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(int sendTimeout) {
            this.sendTimeout = sendTimeout;
        }

        public int getErrorAndClearToSelf() {
            int value = this.error;
            this.clearErrorToSelf();
            return value;
        }

        protected void setSocketError(int error) {
            this.error = error;
        }

        protected void setSocketError(Exception e) {
            if (e instanceof NotYetConnectedException) {
                this.setSocketError(128);
            } else if (e instanceof ClosedChannelException) {
                this.setSocketError(32);
            } else if (e instanceof AsynchronousCloseException) {
                this.setSocketError(32);
            } else if (e instanceof ClosedByInterruptException) {
                this.setSocketError(32);
            } else if (e instanceof BindException) {
                this.setSocketError(125);
            } else if (e instanceof IOException) {
                this.setSocketError(5);
            } else {
                this.setSocketError(-1);
            }
        }

        protected void setError(IOException e, BlockingState blockingState) {
            this.setSocketError(e);
            sceNetInet.setErrno(this.error, blockingState);
        }

        protected void setErrorToSelf(IOException e) {
            this.setError(e, null);
        }

        protected void setError(int error, BlockingState blockingState) {
            this.setSocketError(error);
            sceNetInet.setErrno(this.error, blockingState);
        }

        protected void setErrorToSelf(int error) {
            this.setError(error, null);
        }

        protected void clearErrorToSelf() {
            this.clearError(null);
        }

        protected void clearError(BlockingState blockingState) {
            this.error = 0;
            sceNetInet.setErrno(0, blockingState);
        }

        public int getReceiveBufferSize() {
            return this.receiveBufferSize;
        }

        public int setReceiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return 0;
        }

        public int getSendBufferSize() {
            return this.sendBufferSize;
        }

        public int setSendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return 0;
        }

        public boolean isReuseAddress() {
            return this.reuseAddress;
        }

        public int setReuseAddress(boolean reuseAddress) {
            this.reuseAddress = reuseAddress;
            return 0;
        }

        public boolean isKeepAlive() {
            return this.keepAlive;
        }

        public int setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return 0;
        }

        public boolean isLingerEnabled() {
            return this.lingerEnabled;
        }

        public int getLinger() {
            return this.linger;
        }

        public int setLinger(boolean enabled, int linger) {
            this.lingerEnabled = enabled;
            this.linger = linger;
            return 0;
        }

        public boolean isTcpNoDelay() {
            return this.tcpNoDelay;
        }

        public int setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return 0;
        }

        protected void storeBytes(int address, int length, byte[] bytes) {
            if (length > 0) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, length, 1);
                for (int i = 0; i < length; ++i) {
                    memoryWriter.writeNext(bytes[i]);
                }
                memoryWriter.flush();
            }
        }

        public Selector getSelector(Selector selector, RawSelector rawSelector) {
            return selector;
        }

        public int recv(int buffer, int bufferLength, int flags) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn((Object)String.format("sceNetInetRecv unsupported flag 0x%X on socket", flags));
            }
            return this.recv(buffer, bufferLength, flags, null);
        }

        public void blockedRecv(BlockingReceiveState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetRecv socket=0x%X returning %d (timeout)", this.getUid(), blockingState.receivedLength));
                }
                sceNetInet.setErrno(11, blockingState);
                sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
            } else {
                int length = this.recv(blockingState.buffer + blockingState.receivedLength, blockingState.bufferLength - blockingState.receivedLength, blockingState.flags, blockingState);
                if (length >= 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
                }
            }
        }

        public int send(int buffer, int bufferLength, int flags) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn((Object)String.format("sceNetInetSend unsupported flag 0x%X on socket", flags));
            }
            return this.send(buffer, bufferLength, flags, null);
        }

        public void blockedSend(BlockingSendState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetSend socket=0x%X returning %d (timeout)", this.getUid(), blockingState.sentLength));
                }
                sceNetInet.setErrno(11, blockingState);
                sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
            } else {
                int length = this.send(blockingState.buffer + blockingState.sentLength, blockingState.bufferLength - blockingState.sentLength, blockingState.flags, blockingState);
                if (length > 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
                }
            }
        }

        public int sendto(int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn((Object)String.format("sceNetInetSendto unsupported flag 0x%X on socket", flags));
            }
            return this.sendto(buffer, bufferLength, flags, toAddr, null);
        }

        public void blockedSendto(BlockingSendToState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetSendto socket=0x%X returning %d (timeout)", this.getUid(), blockingState.sentLength));
                }
                sceNetInet.setErrno(11, blockingState);
                sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
            } else {
                int length = this.sendto(blockingState.buffer + blockingState.sentLength, blockingState.bufferLength - blockingState.sentLength, blockingState.flags, blockingState.toAddr, blockingState);
                if (length > 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.sentLength);
                }
            }
        }

        public int recvfrom(int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr) {
            if ((flags & 0xFFFFFF7F) != 0) {
                log.warn((Object)String.format("sceNetInetRecvfrom unsupported flag 0x%X on socket", flags));
            }
            return this.recvfrom(buffer, bufferLength, flags, fromAddr, null);
        }

        public void blockedRecvfrom(BlockingReceiveFromState blockingState) {
            if (blockingState.isTimeout()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetInetRecvfrom socket=0x%X returning %d (timeout)", this.getUid(), blockingState.receivedLength));
                }
                sceNetInet.setErrno(11, blockingState);
                sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
            } else {
                int length = this.recvfrom(blockingState.buffer + blockingState.receivedLength, blockingState.bufferLength - blockingState.receivedLength, blockingState.flags, blockingState.fromAddr, blockingState);
                if (length >= 0) {
                    sceNetInet.this.unblockThread(blockingState, blockingState.receivedLength);
                }
            }
        }

        public int accept(pspNetSockAddrInternet sockAddrInternet) {
            return this.accept(sockAddrInternet, null);
        }

        public void blockedAccept(BlockingAcceptState blockingState) {
            int socketUid = this.accept(blockingState.acceptAddr, blockingState);
            if (socketUid >= 0) {
                sceNetInet.this.unblockThread(blockingState, socketUid);
            }
        }

        pspNetSockAddrInternet getLocalAddr() {
            return this.localAddr;
        }

        public void setLocalAddr(pspNetSockAddrInternet localAddr) {
            this.localAddr = localAddr;
        }

        pspNetSockAddrInternet getRemoteAddr() {
            return this.remoteAddr;
        }

        public void setRemoteAddr(pspNetSockAddrInternet remoteAddr) {
            this.remoteAddr = remoteAddr;
        }
    }

    protected static class BlockingSendToState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public pspNetSockAddrInternet toAddr;
        public int sentLength;

        public BlockingSendToState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, pspNetSockAddrInternet toAddr, int sentLength) {
            super(inetSocket, inetSocket.getSendTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.toAddr = toAddr;
            this.sentLength = sentLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedSendto(this);
        }
    }

    protected static class BlockingSendState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public int sentLength;

        public BlockingSendState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, int sentLength) {
            super(inetSocket, inetSocket.getSendTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.sentLength = sentLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedSend(this);
        }
    }

    protected static class BlockingReceiveFromState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public pspNetSockAddrInternet fromAddr;
        public int receivedLength;

        public BlockingReceiveFromState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, pspNetSockAddrInternet fromAddr, int receivedLength) {
            super(inetSocket, inetSocket.getReceiveTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.fromAddr = fromAddr;
            this.receivedLength = receivedLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedRecvfrom(this);
        }
    }

    protected static class BlockingReceiveState
    extends BlockingState {
        public int buffer;
        public int bufferLength;
        public int flags;
        public int receivedLength;

        public BlockingReceiveState(pspInetSocket inetSocket, int buffer, int bufferLength, int flags, int receivedLength) {
            super(inetSocket, inetSocket.getReceiveTimeout());
            this.buffer = buffer;
            this.bufferLength = bufferLength;
            this.flags = flags;
            this.receivedLength = receivedLength;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedRecv(this);
        }
    }

    protected static class BlockingSelectState
    extends BlockingState {
        public Selector selector;
        public RawSelector rawSelector;
        public int numberSockets;
        public TPointer readSocketsAddr;
        public TPointer writeSocketsAddr;
        public TPointer outOfBandSocketsAddr;
        public int count;

        public BlockingSelectState(Selector selector, RawSelector rawSelector, int numberSockets, TPointer readSocketsAddr, TPointer writeSocketsAddr, TPointer outOfBandSocketsAddr, long timeout, int count) {
            super(null, timeout);
            this.selector = selector;
            this.rawSelector = rawSelector;
            this.numberSockets = numberSockets;
            this.readSocketsAddr = readSocketsAddr;
            this.writeSocketsAddr = writeSocketsAddr;
            this.outOfBandSocketsAddr = outOfBandSocketsAddr;
            this.count = count;
        }

        @Override
        protected void executeBlockingState() {
            Modules.sceNetInetModule.blockedSelect(this);
        }
    }

    protected static class BlockingPollState
    extends BlockingState {
        public Selector selector;
        public pspInetPollFd[] pollFds;

        public BlockingPollState(Selector selector, pspInetPollFd[] pollFds, long timeout) {
            super(null, timeout);
            this.selector = selector;
            this.pollFds = pollFds;
        }

        @Override
        protected void executeBlockingState() {
            Modules.sceNetInetModule.blockedPoll(this);
        }
    }

    protected static class BlockingAcceptState
    extends BlockingState {
        public pspNetSockAddrInternet acceptAddr;

        public BlockingAcceptState(pspInetSocket inetSocket, pspNetSockAddrInternet acceptAddr) {
            super(inetSocket, 2147483647000000L);
            this.acceptAddr = acceptAddr;
        }

        @Override
        protected void executeBlockingState() {
            this.inetSocket.blockedAccept(this);
        }
    }

    protected static abstract class BlockingState
    implements IAction {
        public pspInetSocket inetSocket;
        public int threadId;
        public boolean threadBlocked;
        public long timeout;
        public long start;
        private boolean insideExecute;

        public BlockingState(pspInetSocket inetSocket, long timeout) {
            this.inetSocket = inetSocket;
            this.threadId = Modules.ThreadManForUserModule.getCurrentThreadID();
            this.threadBlocked = false;
            this.start = Emulator.getClock().microTime();
            this.timeout = timeout;
        }

        public boolean isTimeout() {
            long now = Emulator.getClock().microTime();
            return now >= this.start + this.timeout;
        }

        @Override
        public void execute() {
            if (!this.insideExecute) {
                this.insideExecute = true;
                this.executeBlockingState();
                this.insideExecute = false;
            }
        }

        protected abstract void executeBlockingState();
    }

    private class AsyncStartThread
    extends Thread {
        private AsyncStartThread() {
        }

        @Override
        public void run() {
            for (HTTPConfiguration.HttpServerConfiguration doProxyServer : HTTPConfiguration.doProxyServers) {
                try {
                    InetAddress[] inetAddresses = InetAddress.getAllByName(doProxyServer.serverName);
                    sceNetInet.access$102(sceNetInet.this, Utilities.merge(sceNetInet.this.doProxyInetAddresses, inetAddresses));
                    if (!log.isDebugEnabled()) continue;
                    if (inetAddresses == null) {
                        log.debug((Object)String.format("doProxyInetAddress %s: IP address cannot be resolved", doProxyServer.serverName));
                        continue;
                    }
                    for (InetAddress inetAddress : inetAddresses) {
                        log.debug((Object)String.format("doProxyInetAddress %s: %s", doProxyServer.serverName, inetAddress));
                    }
                }
                catch (UnknownHostException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("sceNetInet cannot resolve '%s': %s", doProxyServer, e.toString()));
                }
            }
        }
    }

    private static class BroadcastAddressSettingsListener
    extends AbstractStringSettingsListener {
        private BroadcastAddressSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(String value) {
            sceNetInet.access$002(null);
        }
    }
}

