/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.arm;

import jpcsp.arm.ARMInstruction;
import jpcsp.arm.ARMInstructions;
import jpcsp.util.Utilities;

public class ARMDecoder {
    private static final ARMInstruction MCR_CDP = new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return Utilities.hasFlag(insn, 16) ? ARMInstructions.MCR : ARMInstructions.CDP;
        }
    };
    private static final ARMInstruction MRC_CDP = new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return Utilities.hasFlag(insn, 16) ? ARMInstructions.MRC : ARMInstructions.CDP;
        }
    };
    private static final ARMInstruction DP_Thumb = new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return dp_Thumb[insn >> 6 & 0xF];
        }
    };
    private static final ARMInstruction[] dp_Thumb = new ARMInstruction[]{ARMInstructions.AND_Thumb, ARMInstructions.EOR_Thumb, ARMInstructions.LSL_Thumb, ARMInstructions.LSR_Thumb, ARMInstructions.ASR_Thumb, ARMInstructions.ADC_Thumb, ARMInstructions.SBC_Thumb, ARMInstructions.ROR_Thumb, ARMInstructions.TST_Thumb, ARMInstructions.NEG_Thumb, ARMInstructions.CMP_Thumb, ARMInstructions.CMN_Thumb, ARMInstructions.ORR_Thumb, ARMInstructions.MUL_Thumb, ARMInstructions.BIC_Thumb, ARMInstructions.MVN_Thumb};
    private static final ARMInstruction[] table10 = new ARMInstruction[]{ARMInstructions.MRS, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK};
    private static final ARMInstruction[] table12 = new ARMInstruction[]{ARMInstructions.MSR, ARMInstructions.BX, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.BKPT, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK};
    private static final ARMInstruction[] table14 = new ARMInstruction[]{ARMInstructions.MRS, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK};
    private static final ARMInstruction[] table16 = new ARMInstruction[]{ARMInstructions.MSR, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK};
    private static final ARMInstruction[] table_opcode = new ARMInstruction[]{ARMInstructions.AND, ARMInstructions.AND, ARMInstructions.EOR, ARMInstructions.EOR, ARMInstructions.SUB, ARMInstructions.SUB, ARMInstructions.RSB, ARMInstructions.RSB, ARMInstructions.ADD, ARMInstructions.ADD, ARMInstructions.ADC, ARMInstructions.ADC, ARMInstructions.SBC, ARMInstructions.SBC, ARMInstructions.RSC, ARMInstructions.RSC, new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return table10[insn >> 4 & 0xF];
        }
    }, ARMInstructions.TST, new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return table12[insn >> 4 & 0xF];
        }
    }, ARMInstructions.TEQ, new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return table14[insn >> 4 & 0xF];
        }
    }, ARMInstructions.CMP, new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return table16[insn >> 4 & 0xF];
        }
    }, ARMInstructions.CMN, ARMInstructions.ORR, ARMInstructions.ORR, ARMInstructions.MOV, ARMInstructions.MOV, ARMInstructions.BIC, ARMInstructions.BIC, ARMInstructions.MVN, ARMInstructions.MVN, ARMInstructions.AND, ARMInstructions.AND, ARMInstructions.EOR, ARMInstructions.EOR, ARMInstructions.SUB, ARMInstructions.SUB, ARMInstructions.RSB, ARMInstructions.RSB, ARMInstructions.ADD, ARMInstructions.ADD, ARMInstructions.ADC, ARMInstructions.ADC, ARMInstructions.SBC, ARMInstructions.SBC, ARMInstructions.RSC, ARMInstructions.RSC, ARMInstructions.UNK, ARMInstructions.TST, ARMInstructions.MSR, ARMInstructions.TEQ, ARMInstructions.UNK, ARMInstructions.CMP, ARMInstructions.MSR, ARMInstructions.CMN, ARMInstructions.ORR, ARMInstructions.ORR, ARMInstructions.MOV, ARMInstructions.MOV, ARMInstructions.BIC, ARMInstructions.BIC, ARMInstructions.MVN, ARMInstructions.UNK, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STR, ARMInstructions.LDR, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.STM, ARMInstructions.LDM, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.B, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.BL, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, MCR_CDP, MRC_CDP, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI, ARMInstructions.SWI};
    private static final ARMInstruction[] table_opcode_unconditional = new ARMInstruction[]{ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.BLX_uncond, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK, ARMInstructions.UNK};
    private static final ARMInstruction[] table_thumb = new ARMInstruction[]{ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSL_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.LSR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ASR_Imm_Thumb, ARMInstructions.ADD_Reg_Thumb, ARMInstructions.ADD_Reg_Thumb, ARMInstructions.SUB_Reg_Thumb, ARMInstructions.SUB_Reg_Thumb, ARMInstructions.ADD_Reg_Imm_Thumb, ARMInstructions.ADD_Reg_Imm_Thumb, ARMInstructions.SUB_Reg_Imm_Thumb, ARMInstructions.SUB_Reg_Imm_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.MOV_Immediate_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.CMP_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.ADD_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, ARMInstructions.SUB_Imm_Thumb, DP_Thumb, DP_Thumb, DP_Thumb, DP_Thumb, ARMInstructions.ADD_High_Thumb, ARMInstructions.CMP_High_Thumb, ARMInstructions.MOV_High_Thumb, new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return Utilities.hasFlag(insn, 128) ? ARMInstructions.BLX_Thumb : ARMInstructions.BX_Thumb;
        }
    }, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.LDR_Pc_Thumb, ARMInstructions.STR_Reg_Thumb, ARMInstructions.STR_Reg_Thumb, ARMInstructions.STRH_Reg_Thumb, ARMInstructions.STRH_Reg_Thumb, ARMInstructions.STRB_Reg_Thumb, ARMInstructions.STRB_Reg_Thumb, ARMInstructions.LDRSB_Thumb, ARMInstructions.LDRSB_Thumb, ARMInstructions.LDR_Reg_Thumb, ARMInstructions.LDR_Reg_Thumb, ARMInstructions.LDRH_Reg_Thumb, ARMInstructions.LDRH_Reg_Thumb, ARMInstructions.LDRB_Reg_Thumb, ARMInstructions.LDRB_Reg_Thumb, ARMInstructions.LDRSH_Thumb, ARMInstructions.LDRSH_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.STR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.LDR_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.STRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.LDRB_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.STRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.LDRH_Imm_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.STR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.LDR_Stack_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Pc_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, ARMInstructions.ADD_Rd_Sp_Thumb, new ARMInstructions.STUB(){

        @Override
        public ARMInstruction instance(int insn) {
            return Utilities.hasFlag(insn, 128) ? ARMInstructions.SUB_Sp_Thumb : ARMInstructions.ADD_Sp_Thumb;
        }
    }, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.PUSH_Thumb, ARMInstructions.PUSH_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.POP_Thumb, ARMInstructions.POP_Thumb, ARMInstructions.BKPT_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.STM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.LDM_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.B_Cond_Thumb, ARMInstructions.UNK_Thumb, ARMInstructions.SWI_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.B_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BLX_01_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_10_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb, ARMInstructions.BL_11_Thumb};

    public static ARMInstruction instruction(int insn32) {
        if (insn32 >> 28 == -1) {
            return table_opcode_unconditional[insn32 >> 20 & 0xFF].instance(insn32);
        }
        return table_opcode[insn32 >> 20 & 0xFF].instance(insn32);
    }

    public static ARMInstruction thumbInstruction(int insn16) {
        return table_thumb[insn16 >> 8 & 0xFF].instance(insn16);
    }
}

