/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import jpcsp.filesystems.umdiso.AbstractFileSectorDevice;

public class ISOFileSectorDevice
extends AbstractFileSectorDevice {
    public ISOFileSectorDevice(RandomAccessFile fileAccess) {
        super(fileAccess);
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        if (this.fileAccess == null) {
            return;
        }
        this.fileAccess.seek(2048L * (long)sectorNumber);
        int length = this.fileAccess.read(buffer, offset, 2048);
        if (length < 2048) {
            Arrays.fill(buffer, length, 2048, (byte)0);
        }
    }

    @Override
    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        if (this.fileAccess == null) {
            return 0;
        }
        this.fileAccess.seek(2048L * (long)sectorNumber);
        int length = this.fileAccess.read(buffer, offset, numberSectors * 2048);
        int lastSectorGap = length % 2048;
        if (lastSectorGap > 0) {
            Arrays.fill(buffer, length, length + lastSectorGap, (byte)0);
            length += lastSectorGap;
        }
        return length / 2048;
    }

    @Override
    public void writeSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        this.writeSectors(sectorNumber, 1, buffer, offset);
    }

    @Override
    public void writeSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        if (this.fileAccess == null) {
            return;
        }
        this.fileAccess.seek(2048L * (long)sectorNumber);
        this.fileAccess.write(buffer, offset, numberSectors * 2048);
    }
}

