/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXUndefined;

public class VSMXArray
extends VSMXObject {
    private static final String className = "Array";
    private int length;

    public VSMXArray(VSMXInterpreter interpreter) {
        super(interpreter, className);
    }

    public VSMXArray(VSMXInterpreter interpreter, int size) {
        super(interpreter, className);
        if (size > 0) {
            this.length = size;
            for (int i = 0; i < size; ++i) {
                this.create(i);
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    private void create(int index) {
        super.setPropertyValue(Integer.toString(index), (VSMXBaseObject)VSMXUndefined.singleton);
    }

    private void delete(int index) {
        super.deletePropertyValue(Integer.toString(index));
    }

    private void updateLength(int index) {
        if (index >= this.length) {
            for (int i = this.length; i <= index; ++i) {
                this.create(i);
            }
            this.length = index + 1;
        }
    }

    @Override
    public VSMXBaseObject getPropertyValue(String name) {
        if ("length".equals(name)) {
            return new VSMXNumber(this.interpreter, this.length);
        }
        int index = VSMXArray.getIndex(name);
        if (index >= 0) {
            return this.getPropertyValue(index);
        }
        return super.getPropertyValue(name);
    }

    @Override
    public void setPropertyValue(String name, VSMXBaseObject value) {
        if ("length".equals(name)) {
            int newLength = value.getIntValue();
            if (newLength > this.length) {
                for (int i = this.length; i < newLength; ++i) {
                    this.create(i);
                }
            } else if (newLength < this.length) {
                for (int i = newLength; i < this.length; ++i) {
                    this.delete(i);
                }
            }
            return;
        }
        int index = VSMXArray.getIndex(name);
        if (index >= 0) {
            this.setPropertyValue(index, value);
        } else {
            super.setPropertyValue(name, value);
        }
    }

    @Override
    public void deletePropertyValue(String name) {
        if ("length".equals(name)) {
            return;
        }
        int index = VSMXArray.getIndex(name);
        if (index >= 0) {
            this.deletePropertyValue(index);
        } else {
            super.deletePropertyValue(name);
        }
    }

    @Override
    public VSMXBaseObject getPropertyValue(int index) {
        if (index < 0) {
            return VSMXUndefined.singleton;
        }
        this.updateLength(index);
        return super.getPropertyValue(Integer.toString(index));
    }

    @Override
    public void setPropertyValue(int index, VSMXBaseObject value) {
        if (index >= 0) {
            this.updateLength(index);
            super.setPropertyValue(Integer.toString(index), value);
        }
    }

    @Override
    public void deletePropertyValue(int index) {
        if (index >= 0) {
            if (index == this.length - 1) {
                this.delete(index);
                this.length = index;
            } else if (index < this.length) {
                this.create(index);
            }
        }
    }

    @Override
    public boolean hasPropertyValue(String name) {
        if ("length".equals(name)) {
            return true;
        }
        return super.hasPropertyValue(name);
    }

    @Override
    public boolean getBooleanValue() {
        return this.length > 0;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("[length=%d", this.length));
        this.toString(s);
        s.append("]");
        return s.toString();
    }

    @Override
    public boolean equals(VSMXBaseObject value) {
        if (value instanceof VSMXArray && this.getLength() == 0 && ((VSMXArray)value).getLength() == 0) {
            return true;
        }
        return super.equals(value);
    }
}

