/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jpcsp.graphics.RE.software.IRenderer;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.Utilities;

public class RendererExecutor {
    private static final int numberThreads = 1;
    private static RendererExecutor instance;
    private final LinkedBlockingQueue<IRenderer> renderersQueue = new LinkedBlockingQueue();
    private volatile boolean ended;
    private volatile int numberThreadsRendering;
    private final Object numberThreadsRenderingLock = new Object();

    public static RendererExecutor getInstance() {
        if (instance == null) {
            instance = new RendererExecutor();
        }
        return instance;
    }

    private RendererExecutor() {
        for (int i = 0; i < 1; ++i) {
            ThreadRenderer thread = new ThreadRenderer();
            thread.setName(String.format("Thread SoftwareRenderer #%d", i + 1));
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static void exit() {
        if (instance != null) {
            RendererExecutor.instance.ended = true;
        }
    }

    public void render(IRenderer renderer) {
        if (!VideoEngine.log.isTraceEnabled()) {
            renderer = renderer.duplicate();
            this.renderersQueue.add(renderer);
        } else {
            try {
                renderer.render();
            }
            catch (Exception e) {
                VideoEngine.log.error((Object)"Error while rendering", (Throwable)e);
            }
        }
    }

    public void waitForRenderingCompletion() {
        while (!this.renderersQueue.isEmpty() || this.numberThreadsRendering > 0) {
            Utilities.sleep(1, 0);
        }
    }

    private class ThreadRenderer
    extends Thread {
        private ThreadRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!RendererExecutor.this.ended) {
                IRenderer renderer = null;
                try {
                    renderer = (IRenderer)RendererExecutor.this.renderersQueue.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (renderer == null) continue;
                Object object = RendererExecutor.this.numberThreadsRenderingLock;
                synchronized (object) {
                    RendererExecutor.this.numberThreadsRendering++;
                }
                try {
                    renderer.render();
                }
                catch (Exception e) {
                    VideoEngine.log.error((Object)"Error while rendering", (Throwable)e);
                }
                object = RendererExecutor.this.numberThreadsRenderingLock;
                synchronized (object) {
                    RendererExecutor.this.numberThreadsRendering--;
                }
            }
        }
    }
}

