/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.log;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jpcsp.WindowPropSaver;
import jpcsp.log.LoggingOutputStream;
import jpcsp.log.TextPaneAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class LogWindow
extends JFrame {
    private static String confFile = "LogSettings.xml";
    private final String[] loglevels = new String[]{"ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "OFF"};
    private JButton btnClear;
    private JComboBox cmbLogLevel;
    private JLabel lblLevel;
    private JScrollPane scrollPane;
    private final JTextPane tpLog = new JTextPane();

    public LogWindow() {
        this.initComponents();
        TextPaneAppender textPaneAppender = (TextPaneAppender)Logger.getRootLogger().getAppender("JpcspAppender");
        if (textPaneAppender != null) {
            textPaneAppender.setTextPane(this.tpLog);
        }
        this.getLogLevelFromConfig();
        WindowPropSaver.loadWindowProperties(this);
    }

    public static void setConfXMLFile(String path) {
        confFile = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScreenMessages() {
        JTextPane jTextPane = this.tpLog;
        synchronized (jTextPane) {
            this.tpLog.setText("");
        }
    }

    private void getLogLevelFromConfig() {
        Logger rootLogger = Logger.getRootLogger();
        Level lvlConfig = rootLogger.getLevel();
        if (lvlConfig.equals((Object)Level.ALL)) {
            this.cmbLogLevel.setSelectedIndex(0);
        }
        if (lvlConfig.equals((Object)Level.TRACE)) {
            this.cmbLogLevel.setSelectedIndex(1);
        }
        if (lvlConfig.equals((Object)Level.DEBUG)) {
            this.cmbLogLevel.setSelectedIndex(2);
        }
        if (lvlConfig.equals((Object)Level.INFO)) {
            this.cmbLogLevel.setSelectedIndex(3);
        }
        if (lvlConfig.equals((Object)Level.WARN)) {
            this.cmbLogLevel.setSelectedIndex(4);
        }
        if (lvlConfig.equals((Object)Level.ERROR)) {
            this.cmbLogLevel.setSelectedIndex(5);
        }
        if (lvlConfig.equals((Object)Level.FATAL)) {
            this.cmbLogLevel.setSelectedIndex(6);
        }
        if (lvlConfig.equals((Object)Level.OFF)) {
            this.cmbLogLevel.setSelectedIndex(7);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setProperty("log4j.properties", confFile);
        DOMConfigurator.configure((String)confFile);
        System.setOut(new PrintStream(new LoggingOutputStream(Logger.getLogger((String)"sysout"), Level.INFO)));
        new LogWindow().setVisible(true);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.lblLevel = new JLabel();
        this.cmbLogLevel = new JComboBox();
        this.btnClear = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("LogWindow.title"));
        this.setMinimumSize(new Dimension(400, 120));
        this.scrollPane.setViewportView(this.tpLog);
        this.lblLevel.setText(bundle.getString("LogWindow.lblLevel.text"));
        this.cmbLogLevel.setModel(new DefaultComboBoxModel<String>(this.loglevels));
        this.cmbLogLevel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LogWindow.this.cmbLogLevelItemStateChanged(evt);
            }
        });
        this.btnClear.setText(bundle.getString("ClearButton.text"));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addGroup(layout.createSequentialGroup().addComponent(this.lblLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbLogLevel, 0, 309, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnClear))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 145, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLevel).addComponent(this.cmbLogLevel, -2, -1, -2)).addComponent(this.btnClear, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        this.pack();
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.clearScreenMessages();
    }

    private void cmbLogLevelItemStateChanged(ItemEvent evt) {
        Logger rootLogger = Logger.getRootLogger();
        if (evt.getStateChange() == 1) {
            if (evt.getItem().equals(this.loglevels[0])) {
                rootLogger.setLevel(Level.ALL);
            }
            if (evt.getItem().equals(this.loglevels[1])) {
                rootLogger.setLevel(Level.TRACE);
            }
            if (evt.getItem().equals(this.loglevels[2])) {
                rootLogger.setLevel(Level.DEBUG);
            }
            if (evt.getItem().equals(this.loglevels[3])) {
                rootLogger.setLevel(Level.INFO);
            }
            if (evt.getItem().equals(this.loglevels[4])) {
                rootLogger.setLevel(Level.WARN);
            }
            if (evt.getItem().equals(this.loglevels[5])) {
                rootLogger.setLevel(Level.ERROR);
            }
            if (evt.getItem().equals(this.loglevels[6])) {
                rootLogger.setLevel(Level.FATAL);
            }
            if (evt.getItem().equals(this.loglevels[7])) {
                rootLogger.setLevel(Level.OFF);
            }
        }
    }
}

