/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.util;

import jpcsp.Memory;
import jpcsp.media.codec.util.IBitReader;

public class BitReader
implements IBitReader {
    private final Memory mem;
    private int addr;
    private int initialAddr;
    private int initialSize;
    private int size;
    private int bits;
    private int value;
    private int direction;

    public BitReader(Memory mem, int addr, int size) {
        this.mem = mem;
        this.addr = addr;
        this.size = size;
        this.initialAddr = addr;
        this.initialSize = size;
        this.bits = 0;
        this.direction = 1;
    }

    @Override
    public boolean readBool() {
        return this.read1() != 0;
    }

    protected int nextAddr() {
        --this.size;
        return this.addr + this.direction;
    }

    protected int previousAddr() {
        ++this.size;
        return this.addr - this.direction;
    }

    @Override
    public int read1() {
        if (this.bits <= 0) {
            this.value = this.mem.read8(this.addr);
            this.addr = this.nextAddr();
            this.bits = 8;
        }
        int bit = this.value >> 7;
        --this.bits;
        this.value = this.value << 1 & 0xFF;
        return bit;
    }

    @Override
    public int read(int n) {
        int read;
        if (n <= this.bits) {
            read = this.value >> 8 - n;
            this.bits -= n;
            this.value = this.value << n & 0xFF;
        } else {
            read = 0;
            while (n > 0) {
                read = (read << 1) + this.read1();
                --n;
            }
        }
        return read;
    }

    public int readByte() {
        if (this.bits == 8) {
            this.bits = 0;
            return this.value;
        }
        if (this.bits > 0) {
            this.skip(this.bits);
        }
        int read = this.mem.read8(this.addr);
        this.addr = this.nextAddr();
        return read;
    }

    public int getBitsLeft() {
        return (this.size << 3) + this.bits;
    }

    public int getBytesRead() {
        int bytesRead = this.addr - this.initialAddr;
        if (this.bits == 8) {
            --bytesRead;
        }
        return bytesRead;
    }

    public int getBitsRead() {
        return (this.addr - this.initialAddr) * 8 - this.bits;
    }

    @Override
    public int peek(int n) {
        int read = this.read(n);
        this.skip(-n);
        return read;
    }

    @Override
    public void skip(int n) {
        this.bits -= n;
        if (n >= 0) {
            while (this.bits < 0) {
                this.addr = this.nextAddr();
                this.bits += 8;
            }
        } else {
            while (this.bits > 8) {
                this.addr = this.previousAddr();
                this.bits -= 8;
            }
        }
        if (this.bits > 0) {
            this.value = this.mem.read8(this.addr - this.direction);
            this.value = this.value << 8 - this.bits & 0xFF;
        }
    }

    public void seek(int n) {
        this.addr = this.initialAddr + n;
        this.size = this.initialSize - n;
        this.bits = 0;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.bits = 0;
    }

    public void byteAlign() {
        if (this.bits > 0 && this.bits < 8) {
            this.skip(this.bits);
        }
    }

    @Override
    public int getReadAddr() {
        if (this.bits == 8) {
            return this.addr - this.direction;
        }
        return this.addr;
    }

    public String toString() {
        return String.format("BitReader addr=0x%08X, bits=%d, size=0x%X, bits read %d", this.addr, this.bits, this.size, this.getBitsRead());
    }
}

