/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.TPointer8;
import jpcsp.Memory;
import jpcsp.memory.FastMemory;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class IntArrayMemory
extends Memory {
    private final int[] memory;
    private final int offset;
    private final int baseAddress;

    public IntArrayMemory(int[] memory) {
        this.memory = memory;
        this.offset = 0;
        this.baseAddress = 0;
    }

    public IntArrayMemory(int[] memory, int offset) {
        this.memory = memory;
        this.offset = offset;
        this.baseAddress = 0;
    }

    public IntArrayMemory(int[] memory, int offset, int baseAddress) {
        this.memory = memory;
        this.offset = offset;
        this.baseAddress = baseAddress & 0x1FFFFFFF;
    }

    public TPointer getPointer(int address) {
        return new IntArrayTPointer(this, address).forceNonNull();
    }

    public TPointer getPointer() {
        return this.getPointer(this.baseAddress);
    }

    public TPointer8 getPointer8(int address) {
        return new TPointer8(this, address).forceNonNull();
    }

    public TPointer8 getPointer8() {
        return this.getPointer8(this.baseAddress);
    }

    public TPointer16 getPointer16(int address) {
        return new TPointer16(this, address).forceNonNull();
    }

    public TPointer16 getPointer16() {
        return this.getPointer16(this.baseAddress);
    }

    public TPointer32 getPointer32(int address) {
        return new IntArrayTPointer32(this, address).forceNonNull();
    }

    public TPointer32 getPointer32() {
        return this.getPointer32(this.baseAddress);
    }

    public TPointer64 getPointer64(int address) {
        return new TPointer64(this, address).forceNonNull();
    }

    public TPointer64 getPointer64() {
        return this.getPointer64(this.baseAddress);
    }

    @Override
    public void Initialise() {
    }

    private int getOffset(int address) {
        return ((address & 0x1FFFFFFF) - this.baseAddress >> 2) + this.offset;
    }

    @Override
    public int read32(int address) {
        return this.memory[this.getOffset(address)];
    }

    @Override
    public int read16(int address) {
        int data = this.memory[this.getOffset(address)] >> FastMemory.memory16Shift[address & 2] & 0xFFFF;
        return data;
    }

    @Override
    public int read8(int address) {
        int data = this.memory[this.getOffset(address)] >> FastMemory.memory8Shift[address & 3] & 0xFF;
        return data;
    }

    @Override
    public void write32(int address, int value) {
        this.memory[this.getOffset((int)address)] = value;
    }

    @Override
    public void write16(int address, short value) {
        int memData;
        int index = address & 2;
        this.memory[this.getOffset((int)address)] = memData = this.memory[this.getOffset(address)] & FastMemory.memory16Mask[index] | (value & 0xFFFF) << FastMemory.memory16Shift[index];
    }

    @Override
    public void write8(int address, byte value) {
        int memData;
        int index = address & 3;
        this.memory[this.getOffset((int)address)] = memData = this.memory[this.getOffset(address)] & FastMemory.memory8Mask[index] | (value & 0xFF) << FastMemory.memory8Shift[index];
    }

    @Override
    public void memset(int address, byte data, int length) {
        for (int i = 0; i < length; ++i) {
            this.write8(address + i, data);
        }
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return null;
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        return null;
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        for (int i = 0; i < length; ++i) {
            this.write8(address + i, source.get(i));
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        log.error((Object)String.format("Unimplemented memcpy destination=0x%08X, source=0x%08X, length=0x%X, checkOverlap=%b", destination, source, length, checkOverlap));
    }

    public int getSize() {
        return this.memory.length - this.offset << 2;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        int size4 = stream.readInt();
        int length4 = Math.min(size4, this.memory.length - this.offset);
        stream.readInts(this.memory, this.offset, length4);
        if (length4 < size4) {
            stream.skipBytes(size4 - length4 << 2);
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        int size4 = this.memory.length - this.offset;
        stream.writeInt(size4);
        stream.writeInts(this.memory, this.offset, size4);
    }

    private static class IntArrayTPointer
    extends TPointer {
        public IntArrayTPointer(Memory memory, int address) {
            super(memory, address);
        }

        @Override
        public Memory getNewPointerMemory() {
            return Memory.getInstance();
        }
    }

    private static class IntArrayTPointer32
    extends TPointer32 {
        public IntArrayTPointer32(Memory memory, int address) {
            super(memory, address);
        }

        @Override
        public Memory getNewPointerMemory() {
            return Memory.getInstance();
        }
    }
}

