/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import jpcsp.network.RawSelectionKey;
import jpcsp.network.RawSelector;
import jpcsp.network.SelectableRawSocket;

public class RawChannel
extends SelectableChannel {
    private SelectableRawSocket socket = new SelectableRawSocket();
    private boolean blocking;
    Selector selector;
    RawSelectionKey selectionKey;

    public SelectableRawSocket socket() {
        return this.socket;
    }

    @Override
    public Object blockingLock() {
        return this.socket;
    }

    @Override
    public SelectableChannel configureBlocking(boolean block) throws IOException {
        this.blocking = block;
        return this;
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public boolean isRegistered() {
        return this.selector != null;
    }

    @Override
    public SelectionKey keyFor(Selector sel) {
        return this.selectionKey;
    }

    @Override
    public SelectorProvider provider() {
        return SelectorProvider.provider();
    }

    @Override
    public SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        if (sel instanceof RawSelector) {
            RawSelector rawSelector = (RawSelector)sel;
            this.selector = sel;
            this.selectionKey = new RawSelectionKey(this, rawSelector);
            this.selectionKey.attach(att);
            this.selectionKey.interestOps(ops);
            rawSelector.register(this.selectionKey);
        }
        return this.selectionKey;
    }

    @Override
    public int validOps() {
        return 5;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.socket.close();
    }

    public void onSelectorClosed() {
        this.selector = null;
        this.selectionKey = null;
    }
}

