/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.hardware.Wlan;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;
import jpcsp.network.proonline.ProOnlineServer;
import org.apache.log4j.Logger;

public class AutoDetectJpcsp {
    protected static Logger log = Logger.getLogger((String)"network");
    private static AutoDetectJpcsp instance = null;
    private ListenerThread listenerThread;
    private static final String deviceName = "Jpcsp";
    private DiscoverThread discoverThread;

    public static AutoDetectJpcsp getInstance() {
        if (instance == null) {
            instance = new AutoDetectJpcsp();
        }
        return instance;
    }

    private AutoDetectJpcsp() {
    }

    public void discoverOtherJpcspInBackground() {
        if (this.discoverThread == null) {
            this.discoverThread = new DiscoverThread();
            this.discoverThread.setName("Auto Detect Jpcsp Discover Thread");
            this.discoverThread.setDaemon(true);
            this.discoverThread.start();
        }
    }

    private boolean mustStartProOnlineServer() {
        InetAddress localInetAddress;
        if (!ProOnlineNetworkAdapter.isEnabled()) {
            return false;
        }
        String proOnlineMetaServer = ProOnlineNetworkAdapter.getMetaServer();
        if (proOnlineMetaServer.equalsIgnoreCase("localhost")) {
            return true;
        }
        return Wlan.hasLocalInetAddress() && proOnlineMetaServer.equalsIgnoreCase((localInetAddress = Wlan.getLocalInetAddress()).getHostName());
    }

    private void discover() {
        if (this.isOtherJpcspAvailable()) {
            log.debug((Object)String.format("Other Jpcsp is running", new Object[0]));
        } else {
            this.startDaemon();
            if (this.mustStartProOnlineServer()) {
                ProOnlineServer.getInstance().start();
            }
        }
    }

    private boolean isOtherJpcspAvailable() {
        boolean found = false;
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(2000);
            socket.setReuseAddress(true);
            String discoveryRequest = String.format("M-SEARCH * HTTP/1.1\r\nHOST: %s:%d\r\nST: %s\r\n\r\n", "239.255.255.250", 1900, deviceName);
            DatagramPacket packet = new DatagramPacket(discoveryRequest.getBytes(), discoveryRequest.length(), new InetSocketAddress("239.255.255.250", 1900));
            socket.send(packet);
            byte[] response = new byte[1536];
            DatagramPacket responsePacket = new DatagramPacket(response, response.length);
            socket.receive(responsePacket);
            if (responsePacket.getLength() > 0) {
                String reply = new String(responsePacket.getData(), responsePacket.getOffset(), responsePacket.getLength());
                log.debug((Object)String.format("Discovery %s: %s", deviceName, reply));
                Pattern p = Pattern.compile("^location: *(\\S+):(\\d+)$", 42);
                Matcher m = p.matcher(reply);
                if (m.find()) {
                    String address = m.group(1);
                    int port = Integer.parseInt(m.group(2));
                    log.info((Object)String.format("Found %s at location: address='%s', port=%d", deviceName, address, port));
                    if (address.equals(sceNetApctl.getLocalHostIP())) {
                        Modules.sceNetAdhocModule.setNetClientPortShift(port);
                        Modules.sceNetAdhocModule.setNetServerPortShift(0);
                        found = true;
                    }
                } else {
                    log.error((Object)String.format("Could not parse discovery response for %s: %s", deviceName, reply));
                }
            }
            socket.close();
        }
        catch (SocketTimeoutException e) {
            log.debug((Object)String.format("Timeout while discovering Jpcsp: %s", e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)"Discover Jpcsp", (Throwable)e);
        }
        return found;
    }

    public void startDaemon() {
        if (this.listenerThread == null) {
            this.listenerThread = new ListenerThread();
            this.listenerThread.setName("AutoDetectJpcsp - ListenerThread");
            this.listenerThread.setDaemon(true);
            this.listenerThread.start();
        }
    }

    public static void exit() {
        if (instance != null) {
            if (AutoDetectJpcsp.instance.listenerThread != null) {
                AutoDetectJpcsp.instance.listenerThread.exit();
                AutoDetectJpcsp.instance.listenerThread = null;
            }
            instance = null;
        }
    }

    private class ListenerThread
    extends Thread {
        private boolean exit = false;

        private ListenerThread() {
        }

        @Override
        public void run() {
            log.debug((Object)String.format("Starting AutoDetectJpcsp ListenerThread", new Object[0]));
            byte[] response = new byte[256];
            while (!this.exit) {
                try {
                    InetAddress listenAddress = InetAddress.getByName("239.255.255.250");
                    MulticastSocket socket = new MulticastSocket(1900);
                    socket.joinGroup(listenAddress);
                    while (!this.exit) {
                        DatagramPacket packet = new DatagramPacket(response, response.length);
                        socket.receive(packet);
                        this.processRequest(socket, new String(packet.getData(), packet.getOffset(), packet.getLength()), packet.getAddress(), packet.getPort());
                    }
                    socket.close();
                }
                catch (IOException e) {
                    log.error((Object)"ListenerThread", (Throwable)e);
                    this.exit();
                }
            }
        }

        private void processRequest(MulticastSocket socket, String request, InetAddress address, int port) throws IOException {
            log.debug((Object)String.format("Received '%s' from %s:%d", request, address, port));
            Pattern p = Pattern.compile("SEARCH +\\* +.*^ST: *Jpcsp$.*", 42);
            Matcher m = p.matcher(request);
            if (m.find()) {
                StringBuilder response = new StringBuilder();
                int netServerPortShift = Modules.sceNetAdhocModule.getRealPortFromServerPort(0);
                if (netServerPortShift == 0) {
                    netServerPortShift = 100;
                    Modules.sceNetAdhocModule.setNetServerPortShift(netServerPortShift);
                    Modules.sceNetAdhocModule.setNetClientPortShift(0);
                }
                response.append(String.format("Location: %s:%d", sceNetApctl.getLocalHostIP(), netServerPortShift));
                log.debug((Object)String.format("Sending response '%s' to %s:%d", response, address, port));
                DatagramPacket packet = new DatagramPacket(response.toString().getBytes(), response.length(), address, port);
                socket.send(packet);
            }
        }

        public void exit() {
            this.exit = true;
        }
    }

    private class DiscoverThread
    extends Thread {
        private DiscoverThread() {
        }

        @Override
        public void run() {
            AutoDetectJpcsp.this.discover();
        }
    }
}

