/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

public class DurationStatistics
implements Comparable<DurationStatistics> {
    public static final boolean collectStatistics = false;
    public String name;
    public long cumulatedTimeMillis;
    public long numberCalls;
    private long startTimeMillis;
    private long maxTimeMillis;

    public DurationStatistics() {
        this.reset();
    }

    public DurationStatistics(String name) {
        this.name = name;
        this.reset();
    }

    public void start() {
    }

    public void end() {
    }

    public long getDurationMillis() {
        return System.currentTimeMillis() - this.startTimeMillis;
    }

    public void add(DurationStatistics durationStatistics) {
        this.cumulatedTimeMillis += durationStatistics.cumulatedTimeMillis;
        this.numberCalls += durationStatistics.numberCalls;
        this.maxTimeMillis = Math.max(this.maxTimeMillis, durationStatistics.maxTimeMillis);
    }

    public void reset() {
        this.cumulatedTimeMillis = 0L;
        this.numberCalls = 0L;
        this.startTimeMillis = 0L;
        this.maxTimeMillis = 0L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.name != null) {
            result.append(this.name);
            result.append(": ");
        }
        result.append("Statistics disabled");
        return result.toString();
    }

    @Override
    public int compareTo(DurationStatistics o) {
        if (this.cumulatedTimeMillis < o.cumulatedTimeMillis) {
            return 1;
        }
        if (this.cumulatedTimeMillis > o.cumulatedTimeMillis) {
            return -1;
        }
        if (this.numberCalls < o.numberCalls) {
            return 1;
        }
        if (this.numberCalls > o.numberCalls) {
            return -1;
        }
        return 0;
    }
}

