/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import jpcsp.Emulator;
import org.apache.log4j.Logger;

public class Tlzrc {
    protected static Logger log = Emulator.log;

    private static int u8(byte[] a, int offset) {
        return a[offset] & 0xFF;
    }

    private static int rc_getbyte(LzrcDecode rc) {
        if (rc.in_ptr == rc.in_len) {
            log.error((Object)"End of input!");
            return 0;
        }
        return Tlzrc.u8(rc.input, rc.in_ptr++);
    }

    private static void rc_putbyte(LzrcDecode rc, byte b) {
        if (rc.out_ptr == rc.out_len) {
            log.error((Object)"Output overflow!");
            return;
        }
        rc.output[rc.out_ptr++] = b;
    }

    private static void rc_init(LzrcDecode rc, byte[] out, int out_len, byte[] in, int in_len) {
        rc.input = in;
        rc.in_len = in_len;
        rc.in_ptr = 0;
        rc.output = out;
        rc.out_len = out_len;
        rc.out_ptr = 0;
        rc.range = -1;
        rc.lc = Tlzrc.rc_getbyte(rc);
        rc.code = Tlzrc.rc_getbyte(rc) << 24 | Tlzrc.rc_getbyte(rc) << 16 | Tlzrc.rc_getbyte(rc) << 8 | Tlzrc.rc_getbyte(rc);
        for (int i = 0; i < rc.bm_values.length; ++i) {
            rc.bm_values[i] = -128;
        }
    }

    private static void normalize(LzrcDecode rc) {
        if (rc.range >= 0 && rc.range < 0x1000000) {
            rc.range <<= 8;
            rc.code = rc.code << 8 | Tlzrc.rc_getbyte(rc);
        }
    }

    private static int rc_bit(LzrcDecode rc, byte[] probs, int offset) {
        Tlzrc.normalize(rc);
        long bound = (long)(rc.range >>> 8) * (long)Tlzrc.u8(probs, offset);
        int n = offset;
        probs[n] = (byte)(probs[n] - (Tlzrc.u8(probs, offset) >> 3));
        if (((long)rc.code & 0xFFFFFFFFL) < bound) {
            rc.range = (int)(bound & 0xFFFFFFFFL);
            int n2 = offset;
            probs[n2] = (byte)(probs[n2] + 31);
            return 1;
        }
        rc.code = (int)((long)rc.code - bound);
        rc.range = (int)((long)rc.range - bound);
        return 0;
    }

    private static int rc_bittree(LzrcDecode rc, byte[] probs, int offset, int limit) {
        int number = 1;
        while ((number = number << 1 | Tlzrc.rc_bit(rc, probs, offset + number)) < limit) {
        }
        return number;
    }

    private static int rc_number(LzrcDecode rc, byte[] prob, int offset, int n) {
        int number = 1;
        if (n > 3) {
            number = number << 1 | Tlzrc.rc_bit(rc, prob, offset + 3);
            if (n > 4) {
                number = number << 1 | Tlzrc.rc_bit(rc, prob, offset + 3);
                if (n > 5) {
                    Tlzrc.normalize(rc);
                    for (int i = 0; i < n - 5; ++i) {
                        rc.range >>>= 1;
                        number <<= 1;
                        if (((long)rc.code & 0xFFFFFFFFL) < ((long)rc.range & 0xFFFFFFFFL)) {
                            ++number;
                            continue;
                        }
                        rc.code -= rc.range;
                    }
                }
            }
        }
        if (n > 0) {
            number = number << 1 | Tlzrc.rc_bit(rc, prob, offset);
            if (n > 1) {
                number = number << 1 | Tlzrc.rc_bit(rc, prob, offset + 1);
                if (n > 2) {
                    number = number << 1 | Tlzrc.rc_bit(rc, prob, offset + 2);
                }
            }
        }
        return number;
    }

    public static int lzrc_decompress(byte[] out, int out_len, byte[] in, int in_len) {
        LzrcDecode rc = new LzrcDecode();
        Tlzrc.rc_init(rc, out, out_len, in, in_len);
        if ((rc.lc & 0x80) != 0) {
            System.arraycopy(rc.input, 5, rc.output, 0, rc.code);
            return rc.code;
        }
        int rc_state = 0;
        int last_byte = 0;
        while (true) {
            int match_step;
            int bit;
            if ((bit = Tlzrc.rc_bit(rc, rc.bm_values, rc.bm_match(rc_state, match_step = 0))) == 0) {
                if (rc_state > 0) {
                    --rc_state;
                }
                int b = Tlzrc.rc_bittree(rc, rc.bm_values, rc.bm_literal(last_byte >> rc.lc & 7, 0), 256);
                Tlzrc.rc_putbyte(rc, (byte)(b -= 256));
            } else {
                int match_dist;
                int match_len;
                int len_bits = 0;
                for (int i = 0; i < 7 && (bit = Tlzrc.rc_bit(rc, rc.bm_values, rc.bm_match(rc_state, ++match_step))) != 0; ++i) {
                    ++len_bits;
                }
                if (len_bits == 0) {
                    match_len = 1;
                } else {
                    int len_state = (len_bits - 1 << 2) + (rc.out_ptr << len_bits - 1 & 3);
                    match_len = Tlzrc.rc_number(rc, rc.bm_values, rc.bm_len(rc_state, len_state), len_bits);
                    if (match_len == 255) {
                        return rc.out_ptr;
                    }
                }
                int dist_state = 0;
                int limit = 8;
                if (match_len > 2) {
                    dist_state += 7;
                    limit = 44;
                }
                int dist_bits = Tlzrc.rc_bittree(rc, rc.bm_values, rc.bm_dist_bits(len_bits, dist_state), limit);
                if ((match_dist = (dist_bits -= limit) > 0 ? Tlzrc.rc_number(rc, rc.bm_values, rc.bm_dist(dist_bits, 0), dist_bits) : 1) > rc.out_ptr || match_dist < 0) {
                    log.error((Object)String.format("match_dist out of range! 0x%08X", match_dist));
                    return -1;
                }
                int match_src = rc.out_ptr - match_dist;
                for (int i = 0; i < match_len + 1; ++i) {
                    Tlzrc.rc_putbyte(rc, rc.output[match_src++]);
                }
                rc_state = 6 + (rc.out_ptr + 1 & 1);
            }
            last_byte = rc.output[rc.out_ptr - 1];
        }
    }

    private static class LzrcDecode {
        byte[] input;
        int in_ptr;
        int in_len;
        byte[] output;
        int out_ptr;
        int out_len;
        int range;
        int code;
        int lc;
        byte[] bm_values = new byte[2816];

        private LzrcDecode() {
        }

        public int bm_literal(int i, int j) {
            return i * 256 + j;
        }

        public int bm_dist_bits(int i, int j) {
            return 2048 + i * 39 + j;
        }

        public int bm_dist(int i, int j) {
            return 2360 + i * 8 + j;
        }

        public int bm_match(int i, int j) {
            return 2504 + i * 8 + j;
        }

        public int bm_len(int i, int j) {
            return 2568 + i * 31 + j;
        }
    }
}

