/*
 * Decompiled with CFR 0.152.
 */
package libkirk;

import java.util.Arrays;
import libkirk.BN;
import libkirk.KirkEngine;
import libkirk.Utilities;

public class EC {
    public static final int ELT_SIZE = 20;
    public static final int BIGNUMBER_SIZE = 21;
    private static final byte[] ec_p = new byte[20];
    private static final byte[] ec_a = new byte[20];
    private static final byte[] ec_b = new byte[20];
    private static final byte[] ec_N = new byte[21];
    private static final ECPoint ec_G = new ECPoint();
    private static final ECPoint ec_Q = new ECPoint();
    private static final byte[] ec_k = new byte[21];

    public static void hex_dump(String str, byte[] buf, int size) {
        EC.hex_dump(str, buf, 0, size);
    }

    public static void hex_dump(String str, byte[] buf, int offset, int size) {
        if (Utilities.log.isDebugEnabled()) {
            Utilities.log.debug((Object)String.format("%s: %s", str, jpcsp.util.Utilities.getMemoryDump(buf, offset, size)));
        }
    }

    public static void elt_copy(byte[] d, byte[] a) {
        EC.elt_copy(d, 0, a, 0);
    }

    public static void elt_copy(byte[] d, int offsetDst, byte[] a, int offsetSrc) {
        System.arraycopy(a, offsetSrc, d, offsetDst, 20);
    }

    public static void elt_zero(byte[] d) {
        EC.elt_zero(d, 0);
    }

    public static void elt_zero(byte[] d, int offsetDst) {
        Arrays.fill(d, offsetDst, offsetDst + 20, (byte)0);
    }

    public static boolean elt_is_zero(byte[] d) {
        return EC.elt_is_zero(d, 0);
    }

    public static boolean elt_is_zero(byte[] d, int offsetDst) {
        for (int i = 0; i < 20; ++i) {
            if (d[offsetDst + i] == 0) continue;
            return false;
        }
        return true;
    }

    public static void elt_add(byte[] d, byte[] a, byte[] b) {
        EC.elt_add(d, 0, a, 0, b, 0);
    }

    public static void elt_add(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2) {
        BN.bn_add(d, offsetDst, a, offset1, b, offset2, ec_p, 0, 20);
    }

    public static void elt_sub(byte[] d, byte[] a, byte[] b) {
        EC.elt_sub(d, 0, a, 0, b, 0);
    }

    public static void elt_sub(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2) {
        BN.bn_sub(d, offsetDst, a, offset1, b, offset2, ec_p, 0, 20);
    }

    public static void elt_mul(byte[] d, byte[] a, byte[] b) {
        EC.elt_mul(d, 0, a, 0, b, 0);
    }

    public static void elt_mul(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2) {
        BN.bn_mon_mul(d, offsetDst, a, offset1, b, offset2, ec_p, 0, 20);
    }

    public static void elt_square(byte[] d, byte[] a) {
        EC.elt_square(d, 0, a, 0);
    }

    public static void elt_square(byte[] d, int offsetDst, byte[] a, int offset1) {
        EC.elt_mul(d, offsetDst, a, offset1, a, offset1);
    }

    public static void elt_inv(byte[] d, byte[] a) {
        EC.elt_inv(d, 0, a, 0);
    }

    public static void elt_inv(byte[] d, int offsetDst, byte[] a, int offset1) {
        byte[] s = new byte[20];
        EC.elt_copy(s, 0, a, offset1);
        BN.bn_mon_inv(d, offsetDst, s, 0, ec_p, 0, 20);
    }

    public static void point_to_mon(ECPoint p) {
        BN.bn_to_mon(p.x, 0, ec_p, 0, 20);
        BN.bn_to_mon(p.y, 0, ec_p, 0, 20);
    }

    public static void point_from_mon(ECPoint p) {
        BN.bn_from_mon(p.x, 0, ec_p, 0, 20);
        BN.bn_from_mon(p.y, 0, ec_p, 0, 20);
    }

    public static void point_zero(ECPoint p) {
        EC.elt_zero(p.x, 0);
        EC.elt_zero(p.y, 0);
    }

    public static boolean point_is_zero(ECPoint p) {
        return EC.elt_is_zero(p.x, 0) && EC.elt_is_zero(p.y, 0);
    }

    public static void point_double(ECPoint r, ECPoint p) {
        byte[] s = new byte[20];
        byte[] t = new byte[20];
        ECPoint pp = new ECPoint(p);
        byte[] px = pp.x;
        byte[] py = pp.y;
        byte[] rx = r.x;
        byte[] ry = r.y;
        if (EC.elt_is_zero(py)) {
            EC.point_zero(r);
            return;
        }
        EC.elt_square(t, px);
        EC.elt_add(s, t, t);
        EC.elt_add(s, s, t);
        EC.elt_add(s, s, ec_a);
        EC.elt_add(t, py, py);
        EC.elt_inv(t, t);
        EC.elt_mul(s, s, t);
        EC.elt_square(rx, s);
        EC.elt_add(t, px, px);
        EC.elt_sub(rx, rx, t);
        EC.elt_sub(t, px, rx);
        EC.elt_mul(ry, s, t);
        EC.elt_sub(ry, ry, py);
    }

    public static void point_add(ECPoint r, ECPoint p, ECPoint q) {
        byte[] s = new byte[20];
        byte[] t = new byte[20];
        byte[] u = new byte[20];
        ECPoint pp = new ECPoint(p);
        ECPoint qq = new ECPoint(q);
        byte[] px = pp.x;
        byte[] py = pp.y;
        byte[] qx = qq.x;
        byte[] qy = qq.y;
        byte[] rx = r.x;
        byte[] ry = r.y;
        if (EC.point_is_zero(pp)) {
            EC.elt_copy(rx, qx);
            EC.elt_copy(ry, qy);
            return;
        }
        if (EC.point_is_zero(qq)) {
            EC.elt_copy(rx, px);
            EC.elt_copy(ry, py);
            return;
        }
        EC.elt_sub(u, qx, px);
        if (EC.elt_is_zero(u)) {
            EC.elt_sub(u, qy, py);
            if (EC.elt_is_zero(u)) {
                EC.point_double(r, pp);
            } else {
                EC.point_zero(r);
            }
            return;
        }
        EC.elt_inv(t, u);
        EC.elt_sub(u, qy, py);
        EC.elt_mul(s, t, u);
        EC.elt_square(rx, s);
        EC.elt_add(t, px, qx);
        EC.elt_sub(rx, rx, t);
        EC.elt_sub(t, px, rx);
        EC.elt_mul(ry, s, t);
        EC.elt_sub(ry, ry, py);
    }

    public static void point_mul(ECPoint d, byte[] a, ECPoint b) {
        EC.point_mul(d, a, 0, b);
    }

    public static void point_mul(ECPoint d, byte[] a, int offset, ECPoint b) {
        EC.point_zero(d);
        for (int i = 0; i < 21; ++i) {
            for (int mask = 128; mask != 0; mask >>= 1) {
                EC.point_double(d, d);
                if ((Utilities.u8(a, offset + i) & mask) == 0) continue;
                EC.point_add(d, d, b);
            }
        }
    }

    public static void generate_ecdsa(byte[] outR, byte[] outS, byte[] k, byte[] hash) {
        EC.generate_ecdsa(outR, 0, outS, 0, k, 0, hash, 0);
    }

    public static void generate_ecdsa(byte[] outR, int outRoffset, byte[] outS, int outSoffset, byte[] k, int koffset, byte[] hash, int hashoffset) {
        byte[] e = new byte[21];
        byte[] kk = new byte[21];
        byte[] m = new byte[21];
        byte[] R = new byte[21];
        byte[] S = new byte[21];
        byte[] minv = new byte[21];
        ECPoint mG = new ECPoint();
        System.arraycopy(hash, hashoffset, e, 1, 20);
        BN.bn_reduce(e, ec_N, 21);
        KirkEngine.kirk_CMD14(m, 1, 20);
        EC.point_mul(mG, m, ec_G);
        EC.point_from_mon(mG);
        EC.elt_copy(R, 1, mG.x, 0);
        BN.bn_copy(kk, k, 21);
        BN.bn_reduce(kk, ec_N, 21);
        BN.bn_to_mon(m, ec_N, 21);
        BN.bn_to_mon(e, ec_N, 21);
        BN.bn_to_mon(R, ec_N, 21);
        BN.bn_to_mon(kk, ec_N, 21);
        BN.bn_mon_mul(S, R, kk, ec_N, 21);
        BN.bn_add(kk, S, e, ec_N, 21);
        BN.bn_mon_inv(minv, m, ec_N, 21);
        BN.bn_mon_mul(S, minv, kk, ec_N, 21);
        BN.bn_from_mon(R, ec_N, 21);
        BN.bn_from_mon(S, ec_N, 21);
        System.arraycopy(R, 1, outR, outRoffset, 20);
        System.arraycopy(S, 1, outS, outSoffset, 20);
    }

    public static boolean check_ecdsa(ECPoint Q, byte[] inR, byte[] inS, byte[] hash) {
        return EC.check_ecdsa(Q, inR, 0, inS, 0, hash, 0);
    }

    public static boolean check_ecdsa(ECPoint Q, byte[] inR, int inRoffset, byte[] inS, int inSoffset, byte[] hash, int hashoffset) {
        byte[] Sinv = new byte[21];
        byte[] e = new byte[21];
        byte[] R = new byte[21];
        byte[] S = new byte[21];
        byte[] w1 = new byte[21];
        byte[] w2 = new byte[21];
        byte[] rr = new byte[21];
        ECPoint r1 = new ECPoint();
        ECPoint r2 = new ECPoint();
        System.arraycopy(hash, hashoffset, e, 1, 20);
        BN.bn_reduce(e, ec_N, 21);
        System.arraycopy(inR, inRoffset, R, 1, 20);
        BN.bn_reduce(R, ec_N, 21);
        System.arraycopy(inS, inSoffset, S, 1, 20);
        BN.bn_reduce(S, ec_N, 21);
        BN.bn_to_mon(R, ec_N, 21);
        BN.bn_to_mon(S, ec_N, 21);
        BN.bn_to_mon(e, ec_N, 21);
        BN.bn_mon_inv(Sinv, S, ec_N, 21);
        BN.bn_mon_mul(w1, e, Sinv, ec_N, 21);
        BN.bn_mon_mul(w2, R, Sinv, ec_N, 21);
        BN.bn_from_mon(w1, ec_N, 21);
        BN.bn_from_mon(w2, ec_N, 21);
        EC.point_mul(r1, w1, ec_G);
        EC.point_mul(r2, w2, Q);
        EC.point_add(r1, r1, r2);
        EC.point_from_mon(r1);
        System.arraycopy(r1.x, 0, rr, 1, 20);
        BN.bn_reduce(rr, ec_N, 21);
        BN.bn_from_mon(R, ec_N, 21);
        BN.bn_from_mon(S, ec_N, 21);
        return BN.bn_compare(rr, R, 21) == 0;
    }

    public static void ec_priv_to_pub(byte[] k, KirkEngine.ECDSA_POINT Q) {
        EC.ec_priv_to_pub(k, 0, Q);
    }

    public static void ec_priv_to_pub(byte[] k, int koffset, KirkEngine.ECDSA_POINT Q) {
        ECPoint ec_temp = new ECPoint();
        BN.bn_to_mon(k, koffset, ec_N, 0, 21);
        EC.point_mul(ec_temp, k, koffset, ec_G);
        EC.point_from_mon(ec_temp);
        Utilities.memcpy(Q.x, ec_temp.x, 20);
        Utilities.memcpy(Q.y, ec_temp.y, 20);
    }

    public static void ec_pub_mult(byte[] k, byte[] Q) {
        EC.ec_pub_mult(k, 0, Q, 0);
    }

    public static void ec_pub_mult(byte[] k, byte[] Q, int Qoffset) {
        EC.ec_pub_mult(k, 0, Q, Qoffset);
    }

    public static void ec_pub_mult(byte[] k, int koffset, byte[] Q, int Qoffset) {
        ECPoint ec_temp = new ECPoint();
        EC.point_mul(ec_temp, k, koffset, ec_Q);
        EC.point_from_mon(ec_temp);
        System.arraycopy(ec_temp.x, 0, Q, Qoffset + 0, 20);
        System.arraycopy(ec_temp.y, 0, Q, Qoffset + 20, 20);
    }

    public static int ecdsa_set_curve(byte[] p, byte[] a, byte[] b, byte[] N, byte[] Gx, byte[] Gy) {
        return EC.ecdsa_set_curve(p, 0, a, 0, b, 0, N, 0, Gx, 0, Gy, 0);
    }

    public static int ecdsa_set_curve(byte[] p, int poffset, byte[] a, int offset1, byte[] b, int offset2, byte[] N, int Noffset, byte[] Gx, int Gxoffset, byte[] Gy, int Gyoffset) {
        System.arraycopy(p, poffset, ec_p, 0, 20);
        System.arraycopy(a, offset1, ec_a, 0, 20);
        System.arraycopy(b, offset2, ec_b, 0, 20);
        System.arraycopy(N, Noffset, ec_N, 0, 21);
        BN.bn_to_mon(ec_a, ec_p, 20);
        BN.bn_to_mon(ec_b, ec_p, 20);
        System.arraycopy(Gx, Gxoffset, EC.ec_G.x, 0, 20);
        System.arraycopy(Gy, Gyoffset, EC.ec_G.y, 0, 20);
        EC.point_to_mon(ec_G);
        return 0;
    }

    public static void ecdsa_set_pub(KirkEngine.ECDSA_POINT Q) {
        System.arraycopy(Q.x, 0, EC.ec_Q.x, 0, 20);
        System.arraycopy(Q.y, 0, EC.ec_Q.y, 0, 20);
        EC.point_to_mon(ec_Q);
    }

    public static void ecdsa_set_pub(byte[] Q) {
        EC.ecdsa_set_pub(Q, 0);
    }

    public static void ecdsa_set_pub(byte[] Q, int Qoffset) {
        System.arraycopy(Q, Qoffset, EC.ec_Q.x, 0, 20);
        System.arraycopy(Q, Qoffset + 20, EC.ec_Q.y, 0, 20);
        EC.point_to_mon(ec_Q);
    }

    public static void ecdsa_set_priv(byte[] ink) {
        EC.ecdsa_set_priv(ink, 0);
    }

    public static void ecdsa_set_priv(byte[] ink, int inkoffset) {
        byte[] k = new byte[21];
        System.arraycopy(ink, inkoffset, k, 1, 20);
        BN.bn_reduce(k, ec_N, 21);
        System.arraycopy(k, 0, ec_k, 0, 21);
    }

    public static boolean ecdsa_verify(byte[] hash, byte[] R, byte[] S) {
        return EC.ecdsa_verify(hash, 0, R, 0, S, 0);
    }

    public static boolean ecdsa_verify(byte[] hash, int hashoffset, byte[] R, int Roffset, byte[] S, int Soffset) {
        return EC.check_ecdsa(ec_Q, R, Roffset, S, Soffset, hash, hashoffset);
    }

    public static void ecdsa_sign(byte[] hash, byte[] R, byte[] S) {
        EC.ecdsa_sign(hash, 0, R, 0, S, 0);
    }

    public static void ecdsa_sign(byte[] hash, int hashoffset, byte[] R, int Roffset, byte[] S, int Soffset) {
        EC.generate_ecdsa(R, Roffset, S, Soffset, ec_k, 0, hash, hashoffset);
    }

    public static boolean point_is_on_curve(byte[] p, int offset) {
        byte[] s = new byte[20];
        byte[] t = new byte[20];
        byte[] x = new byte[20];
        byte[] y = new byte[20];
        System.arraycopy(p, offset, x, 0, 20);
        System.arraycopy(p, offset + 20, y, 0, 20);
        EC.elt_square(t, x);
        EC.elt_mul(s, t, x);
        EC.elt_mul(t, x, ec_a);
        EC.elt_add(s, s, t);
        EC.elt_add(s, s, ec_b);
        EC.elt_square(t, y);
        EC.elt_sub(s, s, t);
        EC.hex_dump("S", s, 20);
        EC.hex_dump("T", t, 20);
        return EC.elt_is_zero(s);
    }

    public static void dump_ecc() {
        EC.hex_dump("P", ec_p, 20);
        EC.hex_dump("a", ec_a, 20);
        EC.hex_dump("b", ec_b, 20);
        EC.hex_dump("N", ec_N, 21);
        EC.hex_dump("Gx", EC.ec_G.x, 20);
        EC.hex_dump("Gy", EC.ec_G.y, 20);
    }

    public static class ECPoint {
        public final byte[] x = new byte[20];
        public final byte[] y = new byte[20];

        public ECPoint() {
        }

        public ECPoint(ECPoint p) {
            System.arraycopy(p.x, 0, this.x, 0, 20);
            System.arraycopy(p.y, 0, this.y, 0, 20);
        }
    }
}

