/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class XertoUtils {
    private static Color BASE_COLOR;
    private static Color CONTROL_COLOR;
    private static Color LIGHT_CONTROL_COLOR;
    private static Color MID_CONTROL_COLOR;
    private static Color CONTROL_VERY_LIGHT_SHADOW_COLOR;
    private static Color CONTROL_LIGHT_SHADOW_COLOR;
    private static Color CONTROL_MID_SHADOW_COLOR;
    private static Color CONTROL_DARK_SHADOW_COLOR;
    private static Color SELECTION_COLOR;
    private static Color INACTIVE_CAPTION_COLOR;
    private static Color SELECTED_TAB_BACKGROUND_COLOR;
    private static Color TAB_FORGROUND_COLOR;
    private static Color FRAME_ACTIVE_TITLE_TOP_COLOR;
    private static Color FRAME_ACTIVE_TITLE_BOTTOM_COLOR;
    private static Color FRAME_INACTIVE_TITLE_TOP_COLOR;
    private static Color FRAME_INACTIVE_TITLE_BOTTOM_COLOR;
    public static final double RATIO1 = 0.67;
    public static final double RATIO2 = 0.78;
    public static final double RATIO3 = 0.86;
    static final Color DARK_GREEN;
    static final Color DARK_MAGENTA;

    public static void updateColors() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        BASE_COLOR = uIDefaults.getColor("activeCaption");
        CONTROL_COLOR = uIDefaults.getColor("control");
        INACTIVE_CAPTION_COLOR = uIDefaults.getColor("inactiveCaption");
        LIGHT_CONTROL_COLOR = uIDefaults.getColor("MenuItem.background");
        float[] fArray = Color.RGBtoHSB(CONTROL_COLOR.getRed(), CONTROL_COLOR.getGreen(), CONTROL_COLOR.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(BASE_COLOR.getRed(), BASE_COLOR.getGreen(), BASE_COLOR.getBlue(), null);
        MID_CONTROL_COLOR = Color.getHSBColor(fArray[0], Math.max(fArray[1] - 0.05f, 0.0f), fArray[2] < 0.95f ? fArray[2] + 0.05f : 0.98f);
        SELECTED_TAB_BACKGROUND_COLOR = Color.getHSBColor(fArray[0], fArray[1], fArray[1] == 0.0f ? 0.75f : 0.85f);
        TAB_FORGROUND_COLOR = Color.getHSBColor(fArray[0], (double)fArray[1] > 0.01 ? 0.45f : fArray[0], 0.2f);
        CONTROL_VERY_LIGHT_SHADOW_COLOR = Color.getHSBColor(fArray[0], fArray[1], fArray[2] - 0.02f);
        CONTROL_LIGHT_SHADOW_COLOR = Color.getHSBColor(fArray[0], fArray[1], fArray[2] - 0.06f);
        CONTROL_MID_SHADOW_COLOR = Color.getHSBColor(fArray[0], fArray[1], fArray[2] - 0.16f);
        CONTROL_DARK_SHADOW_COLOR = Color.getHSBColor(fArray[0], fArray[1], fArray[2] - 0.32f);
        SELECTION_COLOR = Color.getHSBColor(fArray2[0], (double)fArray2[1] > 0.01 ? 0.45f : fArray2[0], 0.8f);
        FRAME_ACTIVE_TITLE_TOP_COLOR = Color.getHSBColor(fArray2[0], (double)fArray2[1] > 0.01 ? 0.3f : fArray2[0], 0.9f);
        FRAME_ACTIVE_TITLE_BOTTOM_COLOR = Color.getHSBColor(fArray2[0], (double)fArray2[1] > 0.01 ? 0.45f : fArray2[0], 0.7f);
        FRAME_INACTIVE_TITLE_TOP_COLOR = Color.getHSBColor(fArray[0], fArray[1], 0.75f);
        FRAME_INACTIVE_TITLE_BOTTOM_COLOR = Color.getHSBColor(fArray[0], fArray[1], 0.5f);
    }

    public static Color getBaseColor() {
        return BASE_COLOR;
    }

    public static Color getInActiveCaptionColor() {
        return INACTIVE_CAPTION_COLOR;
    }

    public static Color getControlColor() {
        return CONTROL_COLOR;
    }

    public static Color getMidControlColor() {
        return MID_CONTROL_COLOR;
    }

    public static Color getLightControlColor() {
        return LIGHT_CONTROL_COLOR;
    }

    public static Color getSelectedTabBackgroundColor() {
        return SELECTED_TAB_BACKGROUND_COLOR;
    }

    public static Color getTabForgroundColor() {
        return TAB_FORGROUND_COLOR;
    }

    public static Color getControlVeryLightShadowColor() {
        return CONTROL_VERY_LIGHT_SHADOW_COLOR;
    }

    public static Color getControlLightShadowColor() {
        return CONTROL_LIGHT_SHADOW_COLOR;
    }

    public static Color getControlMidShadowColor() {
        return CONTROL_MID_SHADOW_COLOR;
    }

    public static Color getControlDarkShadowColor() {
        return CONTROL_DARK_SHADOW_COLOR;
    }

    public static Color getSelectionColor() {
        return SELECTION_COLOR;
    }

    public static Color getApplicationFrameBackgroundColor() {
        return XertoUtils.getControlColor();
    }

    public static Color getFrameBorderColor() {
        return UIDefaultsLookup.getColor("controlShadow");
    }

    public static Color getFrameActiveTitleTopColor() {
        return FRAME_ACTIVE_TITLE_TOP_COLOR;
    }

    public static Color getFrameActiveTitleBottomColor() {
        return FRAME_ACTIVE_TITLE_BOTTOM_COLOR;
    }

    public static Color getFrameInactiveTitleTopColor() {
        return FRAME_INACTIVE_TITLE_TOP_COLOR;
    }

    public static Color getFrameInactiveTitleBottomColor() {
        return FRAME_INACTIVE_TITLE_BOTTOM_COLOR;
    }

    public static Color getLighterColor(Color color) {
        int n = XertoUtils.getLighterColor(color.getRed());
        int n2 = XertoUtils.getLighterColor(color.getGreen());
        int n3 = XertoUtils.getLighterColor(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static int getLighterColor(int n) {
        return (int)((double)n * 36.0 / 255.0 + 219.5);
    }

    public static Color getMenuSelectionColor(Color color) {
        int n = XertoUtils.getMenuSelectionValue(color.getRed());
        int n2 = XertoUtils.getMenuSelectionValue(color.getGreen());
        int n3 = XertoUtils.getMenuSelectionValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static int getMenuSelectionValue(int n) {
        return (int)((double)n * 76.0 / 255.0 + 179.5);
    }

    public static Color getMenuBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        int n = XertoUtils.getMenuValue(color.getRed());
        int n2 = XertoUtils.getMenuValue(color.getGreen());
        int n3 = XertoUtils.getMenuValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static int getMenuValue(int n) {
        return (int)((double)n * 36.0 / 255.0 + 219.5);
    }

    public static Color getToolBarBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        int n = XertoUtils.getToolBarValue(color.getRed());
        int n2 = XertoUtils.getToolBarValue(color.getGreen());
        int n3 = XertoUtils.getToolBarValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static int getToolBarValue(int n) {
        return n * 215 / 255 + 40;
    }

    public static Color getGripperForegroundColor(Color color) {
        int n = XertoUtils.getGripperValue(color.getRed());
        int n2 = XertoUtils.getGripperValue(color.getGreen());
        int n3 = XertoUtils.getGripperValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static int getGripperValue(int n) {
        if (n == 255) {
            return 0;
        }
        if (n >= 0 && n <= 64) {
            return n * 33 / 64 + 123;
        }
        return (n - 65) * 157 / 189 + 33;
    }

    public static Color getDefaultBackgroundColor(Color color) {
        Color color2;
        if (color.getRed() == 212 && color.getGreen() == 208 && color.getBlue() == 200) {
            color2 = new Color(247, 243, 233);
        } else if (color.getRed() == 236 && color.getGreen() == 233 && color.getBlue() == 216) {
            color2 = new Color(255, 251, 233);
        } else {
            int n = color.getRed() + 35;
            int n2 = color.getGreen() + 35;
            int n3 = color.getBlue() + 35;
            if (n >= 255) {
                n = 255;
            }
            if (n2 >= 255) {
                n2 = 255;
            }
            if (n3 >= 255) {
                n3 = 255;
            }
            color2 = new Color(n, n2, n3);
        }
        return color2;
    }

    public static int getLightColor(int n, double d) {
        return (int)((double)(255 - n) * d + (double)n);
    }

    public static Color getLighterColor(Color color, double d) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        int n = XertoUtils.getLightColor(color.getRed(), d);
        int n2 = XertoUtils.getLightColor(color.getGreen(), d) + 1;
        int n3 = XertoUtils.getLightColor(color.getBlue(), d);
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static Color getHighlightColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        fArray[1] = fArray[1] - 0.07f;
        if (fArray[1] < 0.0f) {
            fArray[1] = 0.0f;
        }
        fArray[2] = fArray[2] + 0.04f;
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public static Color getEmBaseColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        fArray[1] = fArray[1] + 0.1f;
        if (fArray[1] > 1.0f) {
            fArray[1] = 1.0f;
        }
        fArray[2] = fArray[2] - 0.1f;
        if (fArray[2] < 0.0f) {
            fArray[2] = 0.0f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public static Color getTextColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return (double)fArray[2] > 0.53 ? UIDefaultsLookup.getColor("controlText") : Color.WHITE;
    }

    public static Color getSelectedAndFocusedButtonColor(Color color) {
        return XertoUtils.getLighterColor(color, 0.67);
    }

    public static Color getFocusedButtonColor(Color color) {
        return XertoUtils.getLighterColor(color, 0.78);
    }

    public static Color getSelectedButtonColor(Color color) {
        return XertoUtils.getLighterColor(color, 0.86);
    }

    static {
        XertoUtils.updateColors();
        DARK_GREEN = new Color(0, 128, 0);
        DARK_MAGENTA = new Color(128, 0, 128);
    }
}

