/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JideSplitButton
extends JideMenu
implements ButtonStyle,
ComponentStateSupport {
    private static final String uiClassID = "JideSplitButtonUI";
    private int _buttonStyle = 0;
    private boolean _alwaysDropdown = false;
    public static final String PROPERTY_ALWAYS_DROPDOWN = "alwaysDropdown";
    public static final String ACTION_PROPERTY_SPLIT_BUTTON_ENABLED = "JideSplitButtonEnabled";
    private Color _defaultForeground;
    private Color _rolloverBackground;
    private Color _selectedBackground;
    private Color _pressedBackground;
    private Color _rolloverForeground;
    private Color _selectedForeground;
    private Color _pressedForeground;

    public JideSplitButton() {
        this.initComponent();
    }

    public JideSplitButton(String string) {
        super(string);
        this.initComponent();
    }

    public JideSplitButton(String string, Icon icon) {
        super(string);
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Icon icon) {
        super("");
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Action action) {
        super(action);
        this.initComponent();
    }

    protected void initComponent() {
        this.setModel(new DefaultSplitButtonModel());
        if (this.getAction() != null) {
            this.configurePropertiesFromAction(this.getAction());
        }
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isButtonSelected() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonSelected();
    }

    public void setButtonSelected(boolean bl) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonSelected(bl);
        }
    }

    public boolean isButtonEnabled() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonEnabled();
    }

    public void setButtonEnabled(boolean bl) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonEnabled(bl);
        }
    }

    public int getButtonStyle() {
        return this._buttonStyle;
    }

    public void setButtonStyle(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, and FLAT_STYLE are supported");
        }
        if (n == this._buttonStyle) {
            return;
        }
        int n2 = this._buttonStyle;
        this._buttonStyle = n;
        this.firePropertyChange("buttonStyle", n2, this._buttonStyle);
    }

    public boolean isAlwaysDropdown() {
        return this._alwaysDropdown;
    }

    public void setAlwaysDropdown(boolean bl) {
        if (this._alwaysDropdown != bl) {
            boolean bl2 = this._alwaysDropdown;
            this._alwaysDropdown = bl;
            this.firePropertyChange(PROPERTY_ALWAYS_DROPDOWN, bl2, bl);
        }
    }

    public void setText(String string) {
        Boolean bl = (Boolean)this.getClientProperty("hideActionText");
        if (bl == null || Boolean.FALSE.equals(bl)) {
            super.setText(string);
        }
    }

    public Color getDefaultForeground() {
        return this._defaultForeground;
    }

    public void setDefaultForeground(Color color) {
        this._defaultForeground = color;
    }

    private Color getRolloverBackground() {
        return this._rolloverBackground;
    }

    private void setRolloverBackground(Color color) {
        this._rolloverBackground = color;
    }

    private Color getSelectedBackground() {
        return this._selectedBackground;
    }

    private void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    private Color getPressedBackground() {
        return this._pressedBackground;
    }

    private void setPressedBackground(Color color) {
        this._pressedBackground = color;
    }

    private Color getRolloverForeground() {
        return this._rolloverForeground;
    }

    private void setRolloverForeground(Color color) {
        this._rolloverForeground = color;
    }

    private Color getSelectedForeground() {
        return this._selectedForeground;
    }

    private void setSelectedForeground(Color color) {
        this._selectedForeground = color;
    }

    private Color getPressedForeground() {
        return this._pressedForeground;
    }

    private void setPressedForeground(Color color) {
        this._pressedForeground = color;
    }

    public Color getBackgroundOfState(int n) {
        switch (n) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.getRolloverBackground();
            }
            case 3: {
                return this.getSelectedBackground();
            }
            case 1: {
                return this.getPressedBackground();
            }
        }
        return null;
    }

    public void setBackgroundOfState(int n, Color color) {
        switch (n) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.setRolloverBackground(color);
                break;
            }
            case 3: {
                this.setSelectedBackground(color);
                break;
            }
            case 1: {
                this.setPressedBackground(color);
            }
        }
    }

    public Color getForegroundOfState(int n) {
        switch (n) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.getRolloverForeground();
            }
            case 3: {
                return this.getSelectedForeground();
            }
            case 1: {
                return this.getPressedForeground();
            }
        }
        return null;
    }

    public void setForegroundOfState(int n, Color color) {
        switch (n) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.setRolloverForeground(color);
                break;
            }
            case 3: {
                this.setSelectedForeground(color);
                break;
            }
            case 1: {
                this.setPressedForeground(color);
            }
        }
    }

    public void doClick() {
        Action action = this.getActionMap().get("pressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void doClickOnMenu() {
        Action action = this.getActionMap().get("downPressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        this.setIconFromAction(action);
    }

    protected void setIconFromAction(Action action) {
        Icon icon = null;
        if (action != null) {
            Icon icon2 = icon = SystemInfo.isJdk6Above() ? (Icon)action.getValue("SwingLargeIconKey") : null;
            if (icon == null) {
                icon = (Icon)action.getValue("SmallIcon");
            }
        }
        this.setIcon(icon);
    }

    protected void actionPropertyChanged(Action action, String string) {
        super.actionPropertyChanged(action, string);
        if (ACTION_PROPERTY_SPLIT_BUTTON_ENABLED.equals(string)) {
            this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        } else if ("SmallIcon".equals(string)) {
            if (!SystemInfo.isJdk6Above() || action.getValue("SwingLargeIconKey") == null) {
                this.setIconFromAction(action);
            }
        } else if (SystemInfo.isJdk6Above() && "SwingLargeIconKey".equals(string)) {
            this.setIconFromAction(action);
        }
    }

    public static boolean isSplitButtonEnabled(Action action) {
        if (action == null) {
            return false;
        }
        Object object = action.getValue(ACTION_PROPERTY_SPLIT_BUTTON_ENABLED);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return action.isEnabled();
    }
}

