/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.util;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    protected volatile InputStream inputStream;
    private int count;
    private long byteCount;

    public CountingInputStream(InputStream is) {
        this.inputStream = is;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public int getCount() {
        return this.count;
    }

    public long resetByteCount() {
        this.byteCount = 0L;
        return this.byteCount;
    }

    public int resetCount() {
        this.count = 0;
        return this.count;
    }

    @Override
    public long skip(long length) throws IOException {
        long ret = this.inputStream.skip(length);
        this.byteCount += length;
        this.count = (int)((long)this.count + length);
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = this.inputStream.read();
        ++this.count;
        ++this.byteCount;
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int cnt = this.inputStream.read(b, 0, b.length);
        this.count += cnt;
        this.byteCount += (long)cnt;
        return cnt;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int cnt = this.inputStream.read(b, off, len);
        this.count += cnt;
        this.byteCount += (long)cnt;
        return cnt;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

