/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class BufferedMemoryReader {
    private IMemoryReader memoryReader;
    private int readValue;
    private int index;

    public BufferedMemoryReader(int address) {
        this.memoryReader = MemoryReader.getMemoryReader(address, 4);
        this.init(address);
    }

    public BufferedMemoryReader(int address, int length) {
        this.memoryReader = MemoryReader.getMemoryReader(address, length, 4);
        this.init(address);
    }

    private void init(int address) {
        this.index = address & 3;
        if (this.index > 0) {
            this.readValue = this.memoryReader.readNext();
        }
    }

    public int readNext32() {
        this.index = 0;
        return this.memoryReader.readNext();
    }

    public void skipNext32(int count) {
        this.index = 0;
        this.memoryReader.skip(count);
    }

    public void skipNext32() {
        this.skipNext32(1);
    }

    public int readNext16() {
        if (this.index == 0 || this.index == 3) {
            this.index = 2;
            this.readValue = this.memoryReader.readNext();
            return this.readValue & 0xFFFF;
        }
        this.index = 0;
        return this.readValue >>> 16;
    }

    public void skipNext16() {
        if (this.index == 0 || this.index == 3) {
            this.index = 2;
            this.readValue = this.memoryReader.readNext();
        } else {
            this.index = 0;
        }
    }

    public int readNext8() {
        switch (this.index) {
            case 0: {
                this.readValue = this.memoryReader.readNext();
                this.index = 1;
                return this.readValue & 0xFF;
            }
            case 1: {
                this.index = 2;
                return this.readValue >> 8 & 0xFF;
            }
            case 2: {
                this.index = 3;
                return this.readValue >> 16 & 0xFF;
            }
        }
        this.index = 0;
        return this.readValue >>> 24;
    }

    public void skipNext8() {
        if (this.index == 0) {
            this.readValue = this.memoryReader.readNext();
            this.index = 1;
        } else {
            this.index = this.index == 3 ? 0 : ++this.index;
        }
    }

    public float readNextFloat() {
        this.index = 0;
        return Float.intBitsToFloat(this.memoryReader.readNext());
    }

    public void align16() {
        this.index = this.index + 1 & 0xFFFFFFFE;
    }

    public void align32() {
        this.index = 0;
    }
}

