/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan.threadx;

import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.wlan.threadx.TXBaseCall;
import jpcsp.util.Utilities;

public class TXInterruptControl
extends TXBaseCall {
    private static final int TX_INT_DISABLE = Utilities.setBit(0, 7);
    private static final int TX_INT_ENABLE = 0;

    @Override
    public void call(ARMProcessor processor, int imm) {
        int oldPosture;
        int newPosture = this.getParameterValue(processor, 0);
        int n = oldPosture = processor.isInterruptEnabled() ? 0 : TX_INT_DISABLE;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TXInterruptControl newPosture=0x%X, oldPosture=0x%X", newPosture, oldPosture));
        }
        if (Utilities.hasFlag(newPosture, TX_INT_DISABLE)) {
            processor.setInterruptDisabled();
        } else {
            processor.setInterruptEnabled();
        }
        this.returnToLr(processor, oldPosture);
    }
}

