/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.Memory;
import jpcsp.hardware.Wlan;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.network.proonline.ProOnlineAdhocMatchingEventMessage;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;

public class MatchingPacketFactory {
    public static final int ADHOC_MATCHING_PACKET_PING = 0;
    public static final int ADHOC_MATCHING_PACKET_HELLO = 1;
    public static final int ADHOC_MATCHING_PACKET_JOIN = 2;
    public static final int ADHOC_MATCHING_PACKET_ACCEPT = 3;
    public static final int ADHOC_MATCHING_PACKET_CANCEL = 4;
    public static final int ADHOC_MATCHING_PACKET_BULK = 5;
    public static final int ADHOC_MATCHING_PACKET_BULK_ABORT = 6;
    public static final int ADHOC_MATCHING_PACKET_BIRTH = 7;
    public static final int ADHOC_MATCHING_PACKET_DEATH = 8;
    public static final int ADHOC_MATCHING_PACKET_BYE = 9;

    public static ProOnlineAdhocMatchingEventMessage createPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, byte[] message, int length) {
        if (length > 0 && message != null && message.length > 0) {
            switch (message[0]) {
                case 0: {
                    return new MatchingPacketPing(matchingObject, message, length);
                }
                case 1: {
                    return new MatchingPacketHello(matchingObject, message, length);
                }
                case 2: {
                    return new MatchingPacketJoin(matchingObject, message, length);
                }
                case 3: {
                    return new MatchingPacketAccept(matchingObject, message, length);
                }
                case 4: {
                    return new MatchingPacketCancel(matchingObject, message, length);
                }
                case 5: {
                    return new MatchingPacketBulk(matchingObject, message, length);
                }
                case 9: {
                    return new MatchingPacketBye(matchingObject, message, length);
                }
                case 7: {
                    return new MatchingPacketBirth(matchingObject, message, length);
                }
            }
            ProOnlineNetworkAdapter.log.error((Object)String.format("MatchingPacketFactory.createPacket unimplemented packet opdate=%d", message[0]));
        }
        return null;
    }

    public static ProOnlineAdhocMatchingEventMessage createPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, int event) {
        switch (event) {
            case 100: {
                return new MatchingPacketPing(matchingObject);
            }
            case 1: {
                return new MatchingPacketHello(matchingObject);
            }
            case 2: {
                return new MatchingPacketJoin(matchingObject);
            }
            case 6: {
                return new MatchingPacketAccept(matchingObject);
            }
            case 5: {
                return new MatchingPacketCancel(matchingObject);
            }
            case 11: {
                return new MatchingPacketBulk(matchingObject);
            }
            case 10: {
                return new MatchingPacketBye(matchingObject);
            }
        }
        ProOnlineNetworkAdapter.log.error((Object)String.format("MatchingPacketFactory.createPacket unimplemented event=%d", event));
        return null;
    }

    public static ProOnlineAdhocMatchingEventMessage createPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, int event, int data, int dataLength, byte[] macAddress) {
        switch (event) {
            case 100: {
                return new MatchingPacketPing(matchingObject);
            }
            case 1: {
                return new MatchingPacketHello(matchingObject, data, dataLength, macAddress);
            }
            case 2: {
                return new MatchingPacketJoin(matchingObject, data, dataLength, macAddress);
            }
            case 6: {
                return new MatchingPacketAccept(matchingObject, data, dataLength, macAddress);
            }
            case 3: 
            case 5: {
                return new MatchingPacketCancel(matchingObject, data, dataLength, macAddress);
            }
            case 11: {
                return new MatchingPacketBulk(matchingObject, data, dataLength, macAddress);
            }
            case 10: {
                return new MatchingPacketBye(matchingObject);
            }
            case 7: {
                break;
            }
            case 12: {
                break;
            }
            default: {
                ProOnlineNetworkAdapter.log.error((Object)String.format("MatchingPacketFactory.createPacket unimplemented event=%d to %s", event, new pspNetMacAddress(macAddress)));
            }
        }
        return null;
    }

    public static ProOnlineAdhocMatchingEventMessage createBirthPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, byte[] toMacAddress, byte[] birthMacAddress) {
        return new MatchingPacketBirth(matchingObject, toMacAddress, birthMacAddress);
    }

    private static class MatchingPacketBirth
    extends ProOnlineAdhocMatchingEventMessage {
        public byte[] birthMacAddress;

        public MatchingPacketBirth(MatchingObject matchingObject, byte[] toMacAddress, byte[] birthMacAddress) {
            super(matchingObject, 101, 7, 0, 0, toMacAddress);
            this.birthMacAddress = new byte[6];
            System.arraycopy(birthMacAddress, 0, this.birthMacAddress, 0, this.birthMacAddress.length);
        }

        public MatchingPacketBirth(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 101, message, length);
        }

        @Override
        public byte[] getMessage() {
            byte[] message = new byte[this.getMessageLength()];
            this.offset = 0;
            this.addToBytes(message, (byte)this.getPacketOpcode());
            this.addToBytes(message, this.birthMacAddress);
            return message;
        }

        @Override
        public void setMessage(byte[] message, int length) {
            if (length >= this.getMessageLength()) {
                this.offset = 0;
                this.clearId();
                this.setPacketOpcode(this.copyByteFromBytes(message));
                this.birthMacAddress = new byte[6];
                this.copyFromBytes(message, this.birthMacAddress);
            }
        }

        @Override
        public int getMessageLength() {
            return 7;
        }

        @Override
        public void processOnReceive(int macAddr, int optData, int optLen) {
            pspNetMacAddress fromMacAddress = new pspNetMacAddress();
            fromMacAddress.read(Memory.getInstance(), macAddr);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("MatchingPacketBirth.processOnReceive fromMacAddress=%s, optData=0x%08X, optLen=0x%X, macAddress=%s", fromMacAddress, optData, optLen, new pspNetMacAddress(this.birthMacAddress)));
            }
            this.getMatchingObject().addMember(this.birthMacAddress);
            super.processOnReceive(macAddr, optData, optLen);
        }
    }

    private static class MatchingPacketBye
    extends MatchingPacketOpcode {
        public MatchingPacketBye(MatchingObject matchingObject) {
            super(matchingObject, 10, 9);
        }

        public MatchingPacketBye(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 10, message, length);
        }
    }

    private static class MatchingPacketBulk
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketBulk(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 11, 5, address, length, toMacAddress);
        }

        public MatchingPacketBulk(MatchingObject matchingObject) {
            super(matchingObject, 11, 5);
        }

        public MatchingPacketBulk(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 11, message, length);
        }
    }

    private static class MatchingPacketCancel
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketCancel(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 5, 4, address, length, toMacAddress);
        }

        public MatchingPacketCancel(MatchingObject matchingObject) {
            super(matchingObject, 5, 4);
        }

        public MatchingPacketCancel(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 5, message, length);
        }

        @Override
        public void processOnReceive(int macAddr, int optData, int optLen) {
            MatchingObject matchingObject = this.getMatchingObject();
            pspNetMacAddress macAddress = new pspNetMacAddress();
            macAddress.read(Memory.getInstance(), macAddr);
            switch (matchingObject.getMode()) {
                case 2: {
                    if (matchingObject.isPendingJoinRequest(macAddress)) {
                        this.setEvent(4);
                        break;
                    }
                    if (!matchingObject.isParent(macAddress)) break;
                    this.setEvent(3);
                    break;
                }
                case 1: {
                    if (matchingObject.isPendingJoinRequest(macAddress)) {
                        this.setEvent(5);
                        break;
                    }
                    this.setEvent(3);
                    break;
                }
                case 3: {
                    if (matchingObject.isPendingJoinRequest(macAddress)) {
                        this.setEvent(4);
                        break;
                    }
                    this.setEvent(3);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("MatchingPacketCancel.processOnReceive mode=%d, new event=%d", matchingObject.getMode(), this.getEvent()));
            }
            super.processOnReceive(macAddr, optData, optLen);
        }
    }

    private static class MatchingPacketAccept
    extends ProOnlineAdhocMatchingEventMessage {
        protected static final int HEADER_SIZE = 9;
        private List<byte[]> siblings;

        public MatchingPacketAccept(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 6, 3, address, length, toMacAddress);
        }

        public MatchingPacketAccept(MatchingObject matchingObject) {
            super(matchingObject, 6, 3);
        }

        public MatchingPacketAccept(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 6, message, length);
        }

        @Override
        public byte[] getMessage() {
            byte[] message = new byte[this.getMessageLength()];
            this.offset = 0;
            this.addToBytes(message, (byte)this.getPacketOpcode());
            this.addInt32ToBytes(message, this.getDataLength());
            int siblingCount = this.getSiblingCount();
            this.addInt32ToBytes(message, siblingCount);
            this.addToBytes(message, this.data);
            List<pspNetMacAddress> members = this.getMatchingObject().getMembers();
            int siblingIndex = 0;
            for (int memberIndex = 0; memberIndex < members.size(); ++memberIndex) {
                byte[] macAddress = members.get((int)memberIndex).macAddress;
                if (sceNetAdhoc.isMyMacAddress(macAddress) || sceNetAdhoc.isSameMacAddress(macAddress, this.getMatchingObject().getPendingJoinRequest())) continue;
                this.addToBytes(message, macAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending Sibling#%d: MAC %s", siblingIndex, sceNet.convertMacAddressToString(macAddress)));
                }
                ++siblingIndex;
            }
            return message;
        }

        @Override
        public void setMessage(byte[] message, int length) {
            if (length >= 9) {
                this.offset = 0;
                this.clearId();
                this.setPacketOpcode(this.copyByteFromBytes(message));
                int dataLength = this.copyInt32FromBytes(message);
                int siblingCount = this.copyInt32FromBytes(message);
                int restLength = length - 9 - siblingCount * 6;
                this.data = new byte[Math.min(dataLength, restLength)];
                this.copyFromBytes(message, this.data);
                this.siblings = new LinkedList<byte[]>();
                for (int siblingIndex = 0; siblingIndex < siblingCount; ++siblingIndex) {
                    byte[] mac = new byte[6];
                    this.copyFromBytes(message, mac);
                    this.siblings.add(mac);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Received Sibling#%d: MAC %s", siblingIndex, sceNet.convertMacAddressToString(mac)));
                }
            }
        }

        protected int getSiblingCount() {
            if (this.getMatchingObject().getMode() != 1) {
                return 0;
            }
            int memberCount = this.getMatchingObject().getMembers().size();
            int siblingCount = memberCount - 2;
            return Math.max(siblingCount, 0);
        }

        @Override
        public int getMessageLength() {
            return 9 + this.getDataLength() + this.getSiblingCount() * 6;
        }

        @Override
        public void processOnReceive(int macAddr, int optData, int optLen) {
            if (this.siblings != null) {
                MatchingObject matchingObject = this.getMatchingObject();
                pspNetMacAddress hostMacAddress = new pspNetMacAddress();
                hostMacAddress.read(Memory.getInstance(), macAddr);
                matchingObject.clearMembers();
                matchingObject.addMember(hostMacAddress.macAddress);
                for (byte[] sibling : this.siblings) {
                    matchingObject.addMember(sibling);
                }
                matchingObject.addMember(Wlan.getMacAddress());
            }
            DelayedEventCallback triggerEventComplete = new DelayedEventCallback(this.getMatchingObject(), 7, macAddr, optLen, optData);
            this.getMatchingObject().notifyCallbackEvent(this.getEvent(), macAddr, optLen, optData, triggerEventComplete);
        }

        @Override
        public void processOnSend(int macAddr, int optData, int optLen) {
            super.processOnSend(macAddr, optData, optLen);
            this.getMatchingObject().addCallbackEvent(7, macAddr, 0, 0);
        }
    }

    private static class MatchingPacketJoin
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketJoin(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 2, 2, address, length, toMacAddress);
        }

        public MatchingPacketJoin(MatchingObject matchingObject) {
            super(matchingObject, 2, 2);
        }

        public MatchingPacketJoin(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 2, message, length);
        }
    }

    private static class MatchingPacketHello
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketHello(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 1, 1, address, length, toMacAddress);
        }

        public MatchingPacketHello(MatchingObject matchingObject) {
            super(matchingObject, 1, 1);
        }

        public MatchingPacketHello(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 1, message, length);
        }
    }

    private static class MatchingPacketPing
    extends MatchingPacketOpcode {
        public MatchingPacketPing(MatchingObject matchingObject) {
            super(matchingObject, 100, 0);
        }

        public MatchingPacketPing(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 100, message, length);
        }
    }

    private static abstract class MatchingPacketOpcode
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketOpcode(MatchingObject matchingObject, int event, byte[] message, int length) {
            super(matchingObject, event, message, length);
        }

        public MatchingPacketOpcode(MatchingObject matchingObject, int event, int packetOpcode) {
            super(matchingObject, event, packetOpcode);
        }

        @Override
        public byte[] getMessage() {
            byte[] message = new byte[this.getMessageLength()];
            this.offset = 0;
            this.addToBytes(message, (byte)this.getPacketOpcode());
            return message;
        }

        @Override
        public void setMessage(byte[] message, int length) {
            if (length >= this.getMessageLength()) {
                this.offset = 0;
                this.clearId();
                this.setPacketOpcode(this.copyByteFromBytes(message));
            }
        }

        @Override
        public int getMessageLength() {
            return 1;
        }
    }

    private static class DelayedEventCallback
    implements IAction {
        private MatchingObject matchingObject;
        private int event;
        private int macAddr;
        private int optLen;
        private int optData;

        public DelayedEventCallback(MatchingObject matchingObject, int event, int macAddr, int optLen, int optData) {
            this.matchingObject = matchingObject;
            this.event = event;
            this.macAddr = macAddr;
            this.optLen = optLen;
            this.optData = optData;
        }

        @Override
        public void execute() {
            this.matchingObject.notifyCallbackEvent(this.event, this.macAddr, this.optLen, this.optData);
        }
    }
}

