/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jpcsp.util.LWJGLFixer;
import jpcsp.util.Utilities;

public class ExtractNandIPL {
    public static void main(String[] args) {
        String fileName = "ipl.bin";
        if (args != null && args.length >= 1) {
            fileName = args[0];
        }
        new ExtractNandIPL().extractNandIPL(fileName);
    }

    private void extractNandIPL(String fileName) {
        try {
            int iplEntry;
            RandomAccessFile nandIpl = new RandomAccessFile("nand.ipl.bin", "r");
            byte[] buffer = new byte[512];
            nandIpl.read(buffer);
            int[] iplTable = new int[256];
            int iplTableSize = 0;
            for (int i = 0; i < 512 && (iplEntry = Utilities.readUnaligned16(buffer, i)) != 0; i += 2) {
                iplTable[iplTableSize++] = iplEntry;
            }
            FileOutputStream os = new FileOutputStream(fileName);
            for (int i = 0; i < iplTableSize; ++i) {
                int length;
                nandIpl.seek((iplTable[i] * 32 - 128) * 512);
                for (int j = 0; j < 32 && (length = nandIpl.read(buffer)) == 512; ++j) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
            }
            nandIpl.close();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LWJGLFixer.fixOnce();
    }
}

