/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.externalge;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.util.DurationStatistics;
import jpcsp.util.NativeCpuInfo;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import sun.misc.Unsafe;

public class NativeUtils {
    public static Logger log = ExternalGE.log;
    private static boolean isInitialized = false;
    private static boolean isAvailable = false;
    private static Unsafe unsafe = null;
    private static boolean unsafeInitialized = false;
    private static long intArrayBaseOffset = 0L;
    private static long memoryIntAddress = 0L;
    private static Object[] arrayObject = new Object[]{null, 81985529216486895L, 0x1111111122222222L};
    private static long arrayObjectBaseOffset = 0L;
    private static int arrayObjectIndexScale = 0;
    private static int addressSize = 0;
    private static DurationStatistics coreInterpret = new DurationStatistics("coreInterpret");
    public static final int EVENT_GE_START_LIST = 0;
    public static final int EVENT_GE_FINISH_LIST = 1;
    public static final int EVENT_GE_ENQUEUE_LIST = 2;
    public static final int EVENT_GE_UPDATE_STALL_ADDR = 3;
    public static final int EVENT_GE_WAIT_FOR_LIST = 4;
    public static final int EVENT_DISPLAY_WAIT_VBLANK = 5;
    public static final int EVENT_DISPLAY_VBLANK = 6;
    public static final int INTR_STAT_SIGNAL = 1;
    public static final int INTR_STAT_END = 2;
    public static final int INTR_STAT_FINISH = 4;
    public static final int CTRL_ACTIVE = 1;

    public static void init() {
        if (!isInitialized) {
            LinkedList<String> libraries = new LinkedList<String>();
            if (NativeCpuInfo.isAvailable()) {
                NativeCpuInfo.init();
                if (NativeCpuInfo.hasAVX2()) {
                    libraries.add("software-ge-renderer-AVX2");
                }
                if (NativeCpuInfo.hasAVX()) {
                    libraries.add("software-ge-renderer-AVX");
                }
                if (NativeCpuInfo.hasSSE41()) {
                    libraries.add("software-ge-renderer-SSE41");
                }
                if (NativeCpuInfo.hasSSE3()) {
                    libraries.add("software-ge-renderer-SSE3");
                }
                if (NativeCpuInfo.hasSSE2()) {
                    libraries.add("software-ge-renderer-SSE2");
                }
            }
            libraries.add("software-ge-renderer");
            boolean libraryExisting = false;
            for (String library : libraries) {
                if (!Utilities.isSystemLibraryExisting(library)) continue;
                libraryExisting = true;
                try {
                    System.loadLibrary(library);
                    RuntimeContext.updateMemory();
                    NativeUtils.initNative();
                    log.info((Object)String.format("Loaded %s library", library));
                    isAvailable = true;
                }
                catch (UnsatisfiedLinkError e) {
                    log.error((Object)String.format("Could not load external software library %s: %s", library, e));
                    isAvailable = false;
                }
                break;
            }
            if (!libraryExisting) {
                log.error((Object)String.format("Missing external software library", new Object[0]));
            }
            isInitialized = true;
        }
    }

    public static void exit() {
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static void checkMemoryIntAddress() {
        long address = NativeUtils.getMemoryUnsafeAddr();
        if (address == 0L) {
            return;
        }
        int[] memoryInt = RuntimeContext.getMemoryInt();
        memoryInt[0] = 305419896;
        int x = unsafe.getInt(memoryIntAddress);
        if (x != memoryInt[0]) {
            log.error((Object)String.format("Non matching value 0x%08X - 0x%08X", x, memoryInt[0]));
        } else {
            log.info((Object)String.format("Matching value 0x%08X - 0x%08X", x, memoryInt[0]));
        }
        memoryInt[0] = 0;
    }

    public static long getMemoryUnsafeAddr() {
        return 0L;
    }

    public static void updateMemoryUnsafeAddr() {
        long address = NativeUtils.getMemoryUnsafeAddr();
        if (memoryIntAddress != address) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("memoryInt at 0x%X", address));
            }
            if (log.isInfoEnabled() && memoryIntAddress != 0L) {
                log.info((Object)String.format("memoryInt MOVED from 0x%X to 0x%X", memoryIntAddress, address));
            }
            memoryIntAddress = address;
            NativeUtils.setMemoryUnsafeAddr(memoryIntAddress);
        }
    }

    public static void setLogLevel() {
        NativeUtils.setLogLevel(log);
    }

    public static void setLogLevel(Logger log) {
        int level = 7;
        switch (log.getEffectiveLevel().toInt()) {
            case -2147483648: {
                level = 7;
                break;
            }
            case 5000: {
                level = 6;
                break;
            }
            case 10000: {
                level = 5;
                break;
            }
            case 20000: {
                level = 4;
                break;
            }
            case 30000: {
                level = 3;
                break;
            }
            case 40000: {
                level = 2;
                break;
            }
            case 50000: {
                level = 1;
                break;
            }
            case 0x7FFFFFFF: {
                level = 0;
            }
        }
        NativeUtils.setLogLevel(level);
    }

    public static boolean coreInterpretWithStatistics() {
        coreInterpret.start();
        boolean result = NativeUtils.coreInterpret();
        coreInterpret.end();
        return result;
    }

    public static boolean isCoreCtrlActive() {
        return (NativeUtils.getCoreCtrl() & 1) != 0;
    }

    public static native int initNative();

    public static native boolean coreInterpret();

    public static native int getCoreCtrl();

    public static native void setCoreCtrl(int var0);

    public static native void setCoreCtrlActive();

    public static native int getCoreStat();

    public static native void setCoreStat(int var0);

    public static native int getCoreMadr();

    public static native void setCoreMadr(int var0);

    public static native int getCoreSadr();

    public static native void setCoreSadr(int var0);

    public static native int getCoreIntrStat();

    public static native void setCoreIntrStat(int var0);

    public static native int getCoreInterrupt();

    public static native void setCoreInterrupt(int var0);

    public static native int getCoreCmdArray(int var0);

    public static native void setCoreCmdArray(int var0, int var1);

    public static native void interpretCoreCmd(int var0, int var1, int var2);

    public static native float getCoreMtxArray(int var0);

    public static native void setCoreMtxArray(int var0, float var1);

    public static native void setLogLevel(int var0);

    public static native void setMemoryUnsafeAddr(long var0);

    public static native void startEvent(int var0);

    public static native void stopEvent(int var0);

    public static native void notifyEvent(int var0);

    public static native void setRendererAsyncRendering(boolean var0);

    public static native int getRendererIndexCount();

    public static native void rendererRender(int var0);

    public static native void rendererTerminate();

    public static native void setDumpFrames(boolean var0);

    public static native void setDumpTextures(boolean var0);

    public static native void saveCoreContext(int var0);

    public static native void restoreCoreContext(int var0);

    public static native void setScreenScale(int var0);

    public static native ByteBuffer getScaledScreen(int var0, int var1, int var2, int var3);

    public static native void addVideoTexture(int var0, int var1, int var2);

    public static native void setMaxTextureSizeLog2(int var0);

    public static native void setDoubleTexture2DCoords(boolean var0);

    public static native void doTests();

    public static native int getCoreOadr();

    public static native void setCoreOadr(int var0);

    public static native int getCoreOadr1();

    public static native void setCoreOadr1(int var0);

    public static native int getCoreOadr2();

    public static native void setCoreOadr2(int var0);

    public static native int getCoreRadr1();

    public static native void setCoreRadr1(int var0);

    public static native int getCoreRadr2();

    public static native void setCoreRadr2(int var0);

    public static native int getCoreVadr();

    public static native void setCoreVadr(int var0);

    public static native int getCoreIadr();

    public static native void setCoreIadr(int var0);
}

