/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerNand;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerNandPage
extends MMIOHandlerBase {
    public static Logger log = MMIOHandlerNand.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS1 = -1074790400;
    public static final int BASE_ADDRESS2 = -1611661312;
    private static MMIOHandlerNandPage instance;
    private final int[] data = new int[128];
    private final int[] ecc = new int[4];

    public static MMIOHandlerNandPage getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerNandPage(-1074790400);
        }
        return instance;
    }

    private MMIOHandlerNandPage(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.data);
        stream.readInts(this.ecc);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.data);
        stream.writeInts(this.ecc);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.data, 0);
        Arrays.fill(this.ecc, 0);
    }

    public int[] getData() {
        return this.data;
    }

    public int[] getEcc() {
        return this.ecc;
    }

    @Override
    public int read32(int address) {
        int value;
        int localAddress = address - this.baseAddress & 0xFFFFF;
        switch (localAddress) {
            case 2048: {
                value = this.ecc[0];
                break;
            }
            case 2304: {
                value = this.ecc[1];
                break;
            }
            case 2308: {
                value = this.ecc[2];
                break;
            }
            case 2312: {
                value = this.ecc[3];
                break;
            }
            default: {
                value = localAddress >= 0 && localAddress < 512 ? this.data[localAddress >> 2] : super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        int localAddress = address - this.baseAddress & 0xFFFFF;
        switch (localAddress) {
            case 2048: {
                this.ecc[0] = value;
                break;
            }
            case 2304: {
                this.ecc[1] = value;
                break;
            }
            case 2308: {
                this.ecc[2] = value;
                break;
            }
            case 2312: {
                this.ecc[3] = value;
                break;
            }
            default: {
                if (localAddress >= 0 && localAddress < 512) {
                    this.data[localAddress >> 2] = value;
                    break;
                }
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

