/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class UmdBufferMerge {
    public static void main(String[] args) {
        File fileToc1 = new File("tmp/umdbuffer1.toc");
        File fileIso1 = new File("tmp/umdbuffer1.iso");
        File fileToc2 = new File("tmp/umdbuffer2.toc");
        File fileIso2 = new File("tmp/umdbuffer2.iso");
        File fileToc = new File("tmp/umdbuffer.toc");
        File fileIso = new File("tmp/umdbuffer.iso");
        try {
            FileOutputStream fosToc = new FileOutputStream(fileToc);
            FileOutputStream fosIso = new FileOutputStream(fileIso);
            FileInputStream fisToc1 = new FileInputStream(fileToc1);
            FileInputStream fisIso1 = new FileInputStream(fileIso1);
            FileInputStream fisToc2 = new FileInputStream(fileToc2);
            DataOutputStream toc = new DataOutputStream(fosToc);
            DataOutputStream iso = new DataOutputStream(fosIso);
            DataInputStream toc1 = new DataInputStream(fisToc1);
            DataInputStream iso1 = new DataInputStream(fisIso1);
            DataInputStream toc2 = new DataInputStream(fisToc2);
            RandomAccessFile iso2 = new RandomAccessFile(fileIso2, "r");
            int numSectors = toc1.readInt();
            int numSectorsMerge = toc2.readInt();
            toc.writeInt(Math.max(numSectors, numSectorsMerge));
            HashMap<Integer, Integer> tocHashMap = new HashMap<Integer, Integer>();
            int i = 4;
            while ((long)i < fileToc1.length()) {
                int sectorNumber = toc1.readInt();
                int bufferedSectorNumber = toc1.readInt();
                tocHashMap.put(sectorNumber, bufferedSectorNumber);
                toc.writeInt(sectorNumber);
                toc.writeInt(bufferedSectorNumber);
                i += 8;
            }
            byte[] buffer = new byte[2048];
            int i2 = 0;
            while ((long)i2 < fileIso1.length()) {
                iso1.readFully(buffer);
                iso.write(buffer);
                i2 += buffer.length;
            }
            int nextFreeBufferedSectorNumber = (int)(fileIso1.length() / 2048L);
            int i3 = 4;
            while ((long)i3 < fileToc2.length()) {
                int sectorNumber = toc2.readInt();
                int bufferedSectorNumber = toc2.readInt();
                if (!tocHashMap.containsKey(sectorNumber)) {
                    iso2.seek((long)bufferedSectorNumber * 2048L);
                    iso2.readFully(buffer);
                    iso.write(buffer);
                    toc.writeInt(sectorNumber);
                    toc.writeInt(nextFreeBufferedSectorNumber);
                    tocHashMap.put(sectorNumber, nextFreeBufferedSectorNumber);
                    ++nextFreeBufferedSectorNumber;
                }
                i3 += 8;
            }
            fosToc.close();
            fosIso.close();
            fisToc1.close();
            fisIso1.close();
            fisToc2.close();
            iso2.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

