/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.Random;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import org.apache.log4j.Logger;

public class sceSfmt19937
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSfmt19937");
    protected static final int PSP_SFMT19937_LENGTH = 156;
    private HashMap<TPointer, sfmt19937Ctx> ctxMap = new HashMap();

    @HLEFunction(nid=370855602, version=500)
    public int sceSfmt19937InitGenRand(TPointer sfmtctx, int seed) {
        sfmt19937Ctx ctx = new sfmt19937Ctx(sfmtctx, seed);
        this.ctxMap.put(sfmtctx, ctx);
        return 0;
    }

    @HLEFunction(nid=-581280404, version=500)
    public int sceSfmt19937InitByArray(TPointer sfmtctx, TPointer seeds, int seedsLength) {
        int[] s = new int[seedsLength];
        for (int i = 0; i < seedsLength; ++i) {
            s[i] = seeds.getValue32();
        }
        sfmt19937Ctx ctx = new sfmt19937Ctx(sfmtctx, s);
        this.ctxMap.put(sfmtctx, ctx);
        return 0;
    }

    @HLEFunction(nid=-1287657655, version=500)
    public int sceSfmt19937GenRand32(TPointer sfmtctx) {
        int result = 0;
        if (this.ctxMap.containsKey(sfmtctx)) {
            sfmt19937Ctx ctx = this.ctxMap.get(sfmtctx);
            ctx.generate();
            result = ctx.getNextRand();
        }
        return result;
    }

    @HLEFunction(nid=-710107239, version=500)
    public long sceSfmt19937GenRand64(TPointer sfmtctx) {
        long result = 0L;
        if (this.ctxMap.containsKey(sfmtctx)) {
            sfmt19937Ctx ctx = this.ctxMap.get(sfmtctx);
            ctx.generate();
            result = ctx.getNextRand64();
        }
        return result;
    }

    @HLEFunction(nid=-620602374, version=500)
    public int sceSfmt19937FillArray32(TPointer sfmtctx, TPointer array, int arrayLength) {
        if (this.ctxMap.containsKey(sfmtctx)) {
            sfmt19937Ctx ctx = this.ctxMap.get(sfmtctx);
            ctx.generate();
            for (int i = 0; i < arrayLength; ++i) {
                array.setValue32(i, ctx.getNextRand());
            }
        }
        return 0;
    }

    @HLEFunction(nid=-299288380, version=500)
    public int sceSfmt19937FillArray64(TPointer sfmtctx, TPointer array, int arrayLength) {
        if (this.ctxMap.containsKey(sfmtctx)) {
            sfmt19937Ctx ctx = this.ctxMap.get(sfmtctx);
            ctx.generate();
            for (int i = 0; i < arrayLength; ++i) {
                array.setValue64(i, ctx.getNextRand64());
            }
        }
        return 0;
    }

    private static class sfmt19937Ctx {
        private int index = 0;
        private int indexPos = 0;
        private int[][] sfmt = new int[156][4];
        private TPointer addr;
        private int seed;
        private int[] seedArray;

        public sfmt19937Ctx(TPointer ctxAddr, int seed) {
            this.addr = ctxAddr;
            this.seed = seed;
        }

        public sfmt19937Ctx(TPointer ctxAddr, int[] seeds) {
            this.addr = ctxAddr;
            this.seedArray = seeds;
        }

        private void generate() {
            if (this.seedArray != null) {
                this.seed = this.seedArray[0];
            }
            this.addr.setValue32(this.index);
            Random rand = new Random(this.seed);
            for (int i = 0; i < 156; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.sfmt[i][j] = rand.nextInt();
                    this.addr.setValue32(this.sfmt[i][j]);
                }
            }
        }

        private int getNextRand() {
            int r = this.sfmt[this.index][this.indexPos];
            if (this.indexPos + 1 < 4) {
                ++this.indexPos;
            } else {
                this.indexPos = 0;
                ++this.index;
            }
            return r;
        }

        private long getNextRand64() {
            long r1 = this.getNextRand();
            long r2 = this.getNextRand();
            return r1 << 32 | r2;
        }
    }
}

