/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import jpcsp.util.Constants;
import jpcsp.util.Utilities;

public class PSF {
    private int psfOffset;
    private int size;
    private boolean sizeDirty;
    private boolean tablesDirty;
    private int ident;
    private int version;
    private int keyTableOffset;
    private int valueTableOffset;
    private int indexEntryCount;
    private LinkedList<PSFKeyValuePair> pairList;
    public static final int PSF_IDENT = 1179865088;
    public static final int PSF_DATA_TYPE_BINARY = 0;
    public static final int PSF_DATA_TYPE_STRING = 2;
    public static final int PSF_DATA_TYPE_INT32 = 4;

    public PSF(int psfOffset) {
        this.psfOffset = psfOffset;
        this.size = 0;
        this.sizeDirty = true;
        this.tablesDirty = true;
        this.ident = 1179865088;
        this.version = 257;
        this.pairList = new LinkedList();
    }

    public PSF() {
        this(0);
    }

    public void read(ByteBuffer f) throws IOException {
        this.psfOffset = f.position();
        this.ident = Utilities.readUWord(f);
        if (this.ident != 1179865088) {
            System.out.println("Not a valid PSF file (ident=" + String.format("%08X", this.ident) + ")");
            return;
        }
        this.version = Utilities.readUWord(f);
        this.keyTableOffset = Utilities.readUWord(f);
        this.valueTableOffset = Utilities.readUWord(f);
        this.indexEntryCount = Utilities.readUWord(f);
        for (int i = 0; i < this.indexEntryCount; ++i) {
            PSFKeyValuePair pair = new PSFKeyValuePair();
            pair.read(f);
            this.pairList.add(pair);
        }
        block6: for (PSFKeyValuePair pair : this.pairList) {
            f.position(this.psfOffset + this.keyTableOffset + pair.keyOffset);
            pair.key = Utilities.readStringZ(f);
            f.position(this.psfOffset + this.valueTableOffset + pair.valueOffset);
            switch (pair.dataType) {
                case 0: {
                    byte[] data = new byte[pair.dataSize];
                    f.get(data);
                    pair.data = data;
                    continue block6;
                }
                case 2: {
                    byte[] s = new byte[pair.dataSize];
                    f.get(s);
                    pair.data = new String(s, 0, s[s.length - 1] == 0 ? s.length - 1 : s.length, Constants.charset);
                    continue block6;
                }
                case 4: {
                    pair.data = Utilities.readUWord(f);
                    continue block6;
                }
            }
            System.out.println(String.format("offset=%08X key='%s' unhandled data type %d [len=%d]", this.keyTableOffset + pair.keyOffset, pair.key, pair.dataType, pair.dataSize));
        }
        this.sizeDirty = true;
        this.tablesDirty = false;
        this.calculateSize();
    }

    public void write(RandomAccessFile output) throws IOException {
        byte[] buffer = new byte[this.size()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.write(byteBuffer);
        output.write(buffer);
        output.setLength(buffer.length);
    }

    public void write(ByteBuffer f) {
        if (this.indexEntryCount != this.pairList.size()) {
            throw new RuntimeException("incremental size and actual size do not match! " + this.indexEntryCount + "/" + this.pairList.size());
        }
        if (this.tablesDirty) {
            this.calculateTables();
        }
        Utilities.writeWord(f, this.ident);
        Utilities.writeWord(f, this.version);
        Utilities.writeWord(f, this.keyTableOffset);
        Utilities.writeWord(f, this.valueTableOffset);
        Utilities.writeWord(f, this.indexEntryCount);
        for (PSFKeyValuePair pair : this.pairList) {
            pair.write(f);
        }
        block6: for (PSFKeyValuePair pair : this.pairList) {
            f.position(this.keyTableOffset + pair.keyOffset);
            Utilities.writeStringZ(f, pair.key);
            f.position(this.valueTableOffset + pair.valueOffset);
            switch (pair.dataType) {
                case 0: {
                    f.put((byte[])pair.data);
                    continue block6;
                }
                case 2: {
                    String s = (String)pair.data;
                    f.put(s.getBytes(Constants.charset));
                    Utilities.writeByte(f, 0);
                    continue block6;
                }
                case 4: {
                    Utilities.writeWord(f, (Integer)pair.data);
                    continue block6;
                }
            }
            System.out.println("not writing unhandled data type " + pair.dataType);
        }
    }

    public Object get(String key) {
        for (PSFKeyValuePair pair : this.pairList) {
            if (!pair.key.equals(key)) continue;
            return pair.data;
        }
        return null;
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return (String)obj;
        }
        return null;
    }

    public String getPrintableString(String key) {
        char c;
        String rawString = this.getString(key);
        if (rawString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rawString.length() && (c = rawString.charAt(i)) != '\u0000' && c != '\n'; ++i) {
            sb.append(rawString.charAt(i));
        }
        return sb.toString();
    }

    public int getNumeric(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return (Integer)obj;
        }
        return 0;
    }

    public void put(String key, byte[] data) {
        PSFKeyValuePair pair = new PSFKeyValuePair(key, 0, data.length, data);
        this.pairList.add(pair);
        this.sizeDirty = true;
        this.tablesDirty = true;
        ++this.indexEntryCount;
    }

    public void put(String key, String data, int rawlen) {
        byte[] b = data.getBytes(Constants.charset);
        PSFKeyValuePair pair = new PSFKeyValuePair(key, 2, b.length + 1, rawlen, data);
        this.pairList.add(pair);
        this.sizeDirty = true;
        this.tablesDirty = true;
        ++this.indexEntryCount;
    }

    public void put(String key, String data) {
        byte[] b = data.getBytes(Constants.charset);
        int rawlen = b.length + 1;
        this.put(key, data, rawlen + 3 & 0xFFFFFFFC);
    }

    public void put(String key, int data) {
        PSFKeyValuePair pair = new PSFKeyValuePair(key, 4, 4, data);
        this.pairList.add(pair);
        this.sizeDirty = true;
        this.tablesDirty = true;
        ++this.indexEntryCount;
    }

    private void calculateTables() {
        this.tablesDirty = false;
        this.valueTableOffset = this.keyTableOffset = 20 + this.indexEntryCount * 16;
        for (PSFKeyValuePair pair : this.pairList) {
            this.valueTableOffset += pair.key.length() + 1;
        }
        this.valueTableOffset = this.valueTableOffset + 3 & 0xFFFFFFFC;
        int keyRunningOffset = 0;
        int valueRunningOffset = 0;
        for (PSFKeyValuePair pair : this.pairList) {
            pair.keyOffset = keyRunningOffset;
            keyRunningOffset += pair.key.length() + 1;
            pair.valueOffset = valueRunningOffset;
            valueRunningOffset += pair.dataSizePadded;
        }
    }

    private void calculateSize() {
        this.sizeDirty = false;
        this.size = 0;
        if (this.tablesDirty) {
            this.calculateTables();
        }
        for (PSFKeyValuePair pair : this.pairList) {
            int keyHighBound = this.keyTableOffset + pair.keyOffset + pair.key.length() + 1;
            int valueHighBound = this.valueTableOffset + pair.valueOffset + pair.dataSizePadded;
            if (keyHighBound > this.size) {
                this.size = keyHighBound;
            }
            if (valueHighBound <= this.size) continue;
            this.size = valueHighBound;
        }
    }

    public int size() {
        if (this.sizeDirty) {
            this.calculateSize();
        }
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PSFKeyValuePair pair : this.pairList) {
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(pair.toString());
        }
        if (this.isLikelyHomebrew()) {
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append("This is likely a homebrew");
        }
        return sb.toString();
    }

    private boolean safeEquals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public boolean isLikelyHomebrew() {
        boolean homebrew = false;
        String disc_version = this.getString("DISC_VERSION");
        String disc_id = this.getString("DISC_ID");
        String category = this.getString("CATEGORY");
        Integer bootable = (Integer)this.get("BOOTABLE");
        Integer region = (Integer)this.get("REGION");
        String psp_system_ver = this.getString("PSP_SYSTEM_VER");
        Integer parental_level = (Integer)this.get("PARENTAL_LEVEL");
        Integer ref_one = new Integer(1);
        Integer ref_region = new Integer(32768);
        if (this.safeEquals(disc_version, "1.00") && this.safeEquals(disc_id, "UCJS10041") && this.safeEquals(category, "MG") && this.safeEquals(bootable, ref_one) && this.safeEquals(region, ref_region) && this.safeEquals(psp_system_ver, "1.00") && this.safeEquals(parental_level, ref_one)) {
            if (this.indexEntryCount == 8) {
                homebrew = true;
            } else if (this.indexEntryCount == 9 && this.safeEquals(this.get("MEMSIZE"), ref_one)) {
                homebrew = true;
            }
        } else if (this.indexEntryCount == 4 && this.safeEquals(category, "MG") && this.safeEquals(bootable, ref_one) && this.safeEquals(region, ref_region)) {
            homebrew = true;
        }
        return homebrew;
    }

    public static class PSFKeyValuePair {
        public int keyOffset;
        public int unknown1;
        public int dataType;
        public int dataSize;
        public int dataSizePadded;
        public int valueOffset;
        public String key;
        public Object data;

        public PSFKeyValuePair() {
            this(null, 0, 0, null);
        }

        public PSFKeyValuePair(String key, int dataType, int dataSize, Object data) {
            this(key, dataType, dataSize, dataSize + 3 & 0xFFFFFFFC, data);
        }

        public PSFKeyValuePair(String key, int dataType, int dataSize, int dataSizePadded, Object data) {
            this.key = key;
            this.dataType = dataType;
            this.dataSize = dataSize;
            this.dataSizePadded = dataSizePadded;
            this.data = data;
            this.unknown1 = 4;
        }

        public void read(ByteBuffer f) throws IOException {
            this.keyOffset = Utilities.readUHalf(f);
            this.unknown1 = Utilities.readUByte(f);
            this.dataType = Utilities.readUByte(f);
            this.dataSize = Utilities.readUWord(f);
            this.dataSizePadded = Utilities.readUWord(f);
            this.valueOffset = Utilities.readUWord(f);
        }

        public void write(ByteBuffer f) {
            Utilities.writeHalf(f, this.keyOffset);
            Utilities.writeByte(f, this.unknown1);
            Utilities.writeByte(f, this.dataType);
            Utilities.writeWord(f, this.dataSize);
            Utilities.writeWord(f, this.dataSizePadded);
            Utilities.writeWord(f, this.valueOffset);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key + " = " + this.data);
            return sb.toString();
        }
    }
}

