/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteUtil {
    public static ByteBuffer toByteBuffer(byte[] data) {
        return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] toByteArray(ByteBuffer data) {
        byte[] out = new byte[data.limit()];
        for (int n = 0; n < out.length; ++n) {
            out[n] = data.get(n);
        }
        return out;
    }

    public static byte[] toByteArray(int ... in) {
        byte[] out = new byte[in.length];
        for (int n = 0; n < in.length; ++n) {
            out[n] = (byte)in[n];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(ByteBuffer buffer, int offset, int len) {
        byte[] out = new byte[len];
        int oldPos = buffer.position();
        try {
            buffer.position(offset);
            buffer.get(out);
        }
        finally {
            buffer.position(oldPos);
        }
        return out;
    }
}

